/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.jetbrains.cidr.lang.psi.OCExceptionSpecificationKind;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCExceptionSpecificationInfo {
    private static final OCExceptionSpecificationInfo NONE = new OCExceptionSpecificationInfo(OCExceptionSpecificationKind.None, null, null);
    private static final OCExceptionSpecificationInfo DYNAMIC_NONE = new OCExceptionSpecificationInfo(OCExceptionSpecificationKind.DynamicNone, null, null);
    private static final OCExceptionSpecificationInfo BASIC_NOEXCEPT = new OCExceptionSpecificationInfo(OCExceptionSpecificationKind.BasicNoexcept, null, null);
    private static final OCExceptionSpecificationInfo MS_ANY = new OCExceptionSpecificationInfo(OCExceptionSpecificationKind.MSAny, null, null);
    private OCExceptionSpecificationKind mySpecificationKind;
    private OCExpressionSymbol myNoexceptExpression;
    private List<OCType> myThrowTypes;

    @NotNull
    public static OCExceptionSpecificationInfo createForNone() {
        return NONE;
    }

    @NotNull
    public static OCExceptionSpecificationInfo createForDynamicNone() {
        return DYNAMIC_NONE;
    }

    @NotNull
    public static OCExceptionSpecificationInfo createForBasicNoexcept() {
        return BASIC_NOEXCEPT;
    }

    @NotNull
    public static OCExceptionSpecificationInfo createForMsAny() {
        return MS_ANY;
    }

    @NotNull
    public static OCExceptionSpecificationInfo createForComputedNoexcept(@NotNull OCExpressionSymbol noexceptExpression) {
        return new OCExceptionSpecificationInfo(OCExceptionSpecificationKind.ComputedNoexcept, noexceptExpression, null);
    }

    @NotNull
    public static OCExceptionSpecificationInfo createForDynamic(@NotNull List<OCType> throwTypes) {
        return new OCExceptionSpecificationInfo(OCExceptionSpecificationKind.Dynamic, null, throwTypes);
    }

    public OCExceptionSpecificationInfo() {
    }

    private OCExceptionSpecificationInfo(@NotNull OCExceptionSpecificationKind specificationKind, @Nullable OCExpressionSymbol noexceptExpression, @Nullable List<OCType> throwTypes) {
        this.mySpecificationKind = specificationKind;
        this.myNoexceptExpression = noexceptExpression;
        this.myThrowTypes = throwTypes;
    }

    @NotNull
    public OCExceptionSpecificationKind getSpecificationKind() {
        return this.mySpecificationKind;
    }

    public OCExpressionSymbol getNoexceptExpression() {
        return this.myNoexceptExpression;
    }

    public List<OCType> getThrowTypes() {
        return this.myThrowTypes;
    }
}

