/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCaseStatement;
import com.jetbrains.cidr.lang.psi.OCDoWhileStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCElementsRange
implements Comparable<OCElementsRange> {
    public static final TokenSet NON_IMPORTANT_TOKENS = TokenSet.orSet((TokenSet[])new TokenSet[]{OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET, OCElementTypes.DIRECTIVES, OCTokenTypes.DIRECTIVES, TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.LBRACE, OCTokenTypes.RBRACE})});
    protected PsiElement myFirstElement;
    protected PsiElement myLastElement;
    protected boolean myContainsCompositeElement;

    public OCElementsRange(@NotNull PsiElement firstElement, @NotNull PsiElement lastElement) {
        this.myFirstElement = firstElement;
        this.myLastElement = lastElement;
    }

    public OCElementsRange(@NotNull OCElementsRange range) {
        this.myFirstElement = range.myFirstElement;
        this.myLastElement = range.myLastElement;
        this.myContainsCompositeElement = range.myContainsCompositeElement;
    }

    @NotNull
    public PsiElement getFirstElement() {
        return this.myFirstElement;
    }

    public void setFirstElement(@NotNull PsiElement myFirstElement) {
        this.myFirstElement = myFirstElement;
    }

    @NotNull
    public PsiElement getLastElement() {
        return this.myLastElement;
    }

    public void setLastElement(@NotNull PsiElement myLastElement) {
        this.myLastElement = myLastElement;
    }

    @NotNull
    public TextRange getTextRange() {
        int startOffset = OCElementUtil.getRangeWithMacros(this.myFirstElement).getStartOffset();
        int endOffset = OCElementUtil.getRangeWithMacros(this.myLastElement).getEndOffset();
        if (endOffset < startOffset) {
            endOffset = startOffset;
        }
        return new TextRange(startOffset, endOffset);
    }

    public int getStartOffset() {
        return this.myFirstElement.getTextRange().getStartOffset();
    }

    public int getEndOffset() {
        return this.myLastElement.getTextRange().getEndOffset();
    }

    public String getText() {
        TextRange range = this.getTextRange();
        return range.substring(this.myFirstElement.getContainingFile().getText());
    }

    public PsiFile getFile() {
        return this.myFirstElement.getContainingFile();
    }

    public boolean isValid() {
        return !(this.myFirstElement instanceof OCMacroForeignLeafElement) && !(this.myLastElement instanceof OCMacroForeignLeafElement);
    }

    public boolean containsCompositeElement() {
        return this.myContainsCompositeElement;
    }

    public void setContainsCompositeElement(boolean containsCompositeElement) {
        this.myContainsCompositeElement = containsCompositeElement;
    }

    private OCElementsRange merge(OCElementsRange range) {
        OCElementsRange merged = new OCElementsRange(this.myFirstElement, this.getEndOffset() < range.getEndOffset() ? range.myLastElement : this.myLastElement);
        merged.myContainsCompositeElement = this.myContainsCompositeElement | range.myContainsCompositeElement;
        return merged;
    }

    @Nullable
    public OCElementsRange trim(TokenSet elementsToRemove) {
        PsiElement firstChild = PsiTreeUtil.firstChild((PsiElement)this.myFirstElement);
        PsiElement lastChild = PsiTreeUtil.lastChild((PsiElement)this.myLastElement);
        boolean wasTrimmed = false;
        PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)firstChild, (PsiElement)lastChild);
        while (firstChild != lastChild && firstChild != null && OCElementsRange.isTrimmedElement(elementsToRemove, firstChild, commonParent)) {
            firstChild = PsiTreeUtil.nextLeaf((PsiElement)firstChild);
            wasTrimmed = true;
        }
        while (firstChild != lastChild && lastChild != null && OCElementsRange.isTrimmedElement(elementsToRemove, lastChild, commonParent)) {
            lastChild = PsiTreeUtil.prevLeaf((PsiElement)lastChild);
            wasTrimmed = true;
        }
        if (firstChild == lastChild && OCElementsRange.isTrimmedElement(elementsToRemove, firstChild, commonParent)) {
            return null;
        }
        if (wasTrimmed && firstChild != null && lastChild != null) {
            return new OCElementsRange(firstChild, lastChild);
        }
        return this;
    }

    private static boolean isEmptyBody(@Nullable PsiElement body) {
        if (body == null) {
            return true;
        }
        TokenSet semicolonAndWhitespace = TokenSet.orSet((TokenSet[])new TokenSet[]{OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET, TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.SEMICOLON})});
        return OCElementUtil.getElementType(OCElementUtil.getNextLeaf(body.getFirstChild(), semicolonAndWhitespace)) == OCTokenTypes.RBRACE;
    }

    public OCElementsRange expand() {
        TokenSet prevSet = TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.IF_KEYWORD, OCTokenTypes.WHILE_KEYWORD, OCTokenTypes.DO_KEYWORD, OCTokenTypes.SWITCH_KEYWORD, OCTokenTypes.LPAR});
        OCElementsRange range = this;
        while (true) {
            PsiElement block;
            PsiElement prev = OCElementUtil.getPrevNonWhitespaceCommentLeaf(range.myFirstElement);
            PsiElement next = OCElementUtil.getNextNonWhitespaceCommentLeaf(range.myLastElement);
            PsiElement statement2 = PsiTreeUtil.getParentOfType((PsiElement)range.myFirstElement, OCStatement.class);
            if (prevSet.contains(OCElementUtil.getElementType(prev)) && (OCElementUtil.getElementType(prev) != OCTokenTypes.LPAR || !(prev.getParent() instanceof OCDoWhileStatement) || OCElementsRange.isEmptyBody(((OCDoWhileStatement)prev.getParent()).getBody())) || OCElementUtil.getElementType(prev) == OCTokenTypes.COLON && prev.getParent() instanceof OCCaseStatement) {
                range = new OCElementsRange(prev.getParent(), prev.getParent());
                range.setContainsCompositeElement(true);
                continue;
            }
            if (statement2 != null && statement2.getFirstChild() == range.myFirstElement && OCElementUtil.getElementType(next) == OCTokenTypes.SEMICOLON) {
                range = new OCElementsRange(range.myFirstElement, next.getParent());
                range.setContainsCompositeElement(true);
                continue;
            }
            if (OCElementUtil.getElementType(prev) != OCTokenTypes.LBRACE || OCElementUtil.getElementType(next) != OCTokenTypes.RBRACE || !((block = prev.getParent()).getParent() instanceof OCBlockStatement) && !(block.getParent() instanceof OCDoWhileStatement)) break;
            range = new OCElementsRange(block, block);
            range.setContainsCompositeElement(true);
        }
        return range;
    }

    public static List<OCElementsRange> mergeRanges(List<OCElementsRange> ranges, boolean trim) {
        Collections.sort(ranges);
        ArrayList<OCElementsRange> resultRanges = new ArrayList<OCElementsRange>();
        OCElementsRange curRange = null;
        TokenSet trimSet = NON_IMPORTANT_TOKENS;
        for (OCElementsRange range : ranges) {
            PsiElement nextLeaf;
            if (range == null) continue;
            PsiElement psiElement = nextLeaf = curRange != null ? OCElementUtil.getNextNonWhitespaceCommentLeaf(curRange.myLastElement) : null;
            if (nextLeaf != null && nextLeaf.getTextOffset() >= range.getStartOffset()) {
                curRange = curRange.merge(range).expand();
                continue;
            }
            if (curRange != null && curRange.isValid() && curRange.containsCompositeElement()) {
                OCElementsRange trimmed;
                OCElementsRange oCElementsRange = trimmed = trim ? curRange.trim(trimSet) : curRange;
                if (trimmed != null) {
                    resultRanges.add(trimmed.expand());
                }
            }
            curRange = new OCElementsRange(range);
        }
        if (curRange != null && curRange.isValid() && curRange.containsCompositeElement()) {
            OCElementsRange trimmed;
            OCElementsRange oCElementsRange = trimmed = trim ? curRange.trim(trimSet) : curRange;
            if (trimmed != null) {
                resultRanges.add(trimmed.expand());
            }
        }
        return resultRanges;
    }

    private static boolean isTrimmedElement(TokenSet elementsToRemove, PsiElement element, PsiElement commonParent) {
        while (element != commonParent) {
            if (elementsToRemove.contains(OCElementUtil.getElementType(element))) {
                return true;
            }
            element = element.getParent();
        }
        return false;
    }

    public boolean isEmpty() {
        PsiElement curElement = this.myFirstElement;
        while (curElement != null && curElement.getTextRange().getStartOffset() < this.myLastElement.getTextRange().getEndOffset()) {
            IElementType elementType = OCElementUtil.getElementType(curElement);
            if (elementType != OCTokenTypes.LBRACE && elementType != OCTokenTypes.RBRACE && !OCElementUtil.isElementEmpty(curElement)) {
                return false;
            }
            curElement = PsiTreeUtil.nextLeaf((PsiElement)curElement, (boolean)true);
        }
        return true;
    }

    @Override
    public int compareTo(OCElementsRange o) {
        return this.getStartOffset() - o.getStartOffset();
    }

    public Iterable<PsiElement> getElements() {
        return new Iterable<PsiElement>(){

            @Override
            public Iterator<PsiElement> iterator() {
                return new Iterator<PsiElement>(){
                    PsiElement nextElem;
                    {
                        this.nextElem = OCElementsRange.this.myFirstElement;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.nextElem != null;
                    }

                    @Override
                    public PsiElement next() {
                        ASTNode next;
                        PsiElement curElem = this.nextElem;
                        if (this.nextElem == null) {
                            throw new NoSuchElementException();
                        }
                        this.nextElem = this.nextElem != OCElementsRange.this.myLastElement ? ((next = this.nextElem.getNode().getTreeNext()) != null ? next.getPsi() : null) : null;
                        return curElem;
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
    }
}

