/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.codeStyle.IndentHelper;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCConditionalExpression;
import com.jetbrains.cidr.lang.psi.OCConstructorFieldInitializer;
import com.jetbrains.cidr.lang.psi.OCConstructorInitializationList;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCEnum;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCInstanceVariablesList;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCPropertyAttributesList;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSynthesizePropertiesList;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.psi.impl.OCCodeFragmentImpl;
import com.jetbrains.cidr.lang.psi.impl.OCUDLiteralExpressionImpl;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbolImpl;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.visitors.names.OCTypeNameVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCElementFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.cidr.lang.util.OCElementFactory");

    private OCElementFactory() {
    }

    @NotNull
    public static OCDeclarationStatement declarationStatement(String name, OCType type, @Nullable OCExpression initializer, PsiElement context2) {
        return OCElementFactory.declarationStatement(null, name, type, initializer, null, null, context2);
    }

    @NotNull
    public static OCDeclaration declaration(String name, OCType type, @Nullable OCExpression initializer, PsiElement context2) {
        return OCElementFactory.declarationStatement(null, name, type, initializer, null, null, context2).getDeclaration();
    }

    @NotNull
    public static OCDeclaration declaration(@Nullable String modifier, String name, OCType type, PsiElement context2) {
        return OCElementFactory.declarationStatement(modifier, name, type, null, null, null, context2).getDeclaration();
    }

    @NotNull
    public static OCDeclarationStatement declarationStatement(@Nullable String modifier, String name, OCType type, @Nullable OCExpression initializer, @Nullable OCCompoundInitializer initializerList, @Nullable OCArgumentList argumentList, @NotNull PsiElement context2) {
        String declText = OCElementFactory.declarationText(modifier != null ? Collections.singletonList(modifier) : Collections.emptyList(), name, type, initializer != null ? "0" : null, context2, null, false);
        if (initializer == null) {
            if (initializerList != null) {
                declText = declText + "{}";
            } else if (argumentList != null) {
                declText = declText + "(0)";
            }
        }
        OCDeclarationStatement statement2 = (OCDeclarationStatement)OCElementFactory.statementFromText(declText, context2, true);
        OCDeclarator declarator = statement2.getDeclaration().getDeclarators().get(0);
        if (initializer != null) {
            OCChangeUtil.replaceHandlingMacros(declarator.getInitializer(), initializer);
        } else if (initializerList != null) {
            OCChangeUtil.replaceHandlingMacros(declarator.getInitializerList(), initializerList);
        } else if (argumentList != null) {
            OCChangeUtil.replaceHandlingMacros(declarator.getArgumentList(), argumentList);
        }
        return statement2;
    }

    @NotNull
    public static OCDeclaration declarationFromText(String text, PsiElement context2) {
        return (OCDeclaration)OCElementFactory.topLevelDeclarationFromText(text + ";", context2);
    }

    @NotNull
    public static OCDeclaration declarationFromText(String text, PsiElement context2, boolean reformat) {
        return (OCDeclaration)OCElementFactory.topLevelDeclarationFromText(text + ";", context2, reformat);
    }

    @NotNull
    public static String declarationText(String name, OCType type, @NotNull PsiElement context2) {
        return OCElementFactory.declarationText(Collections.emptyList(), name, type, null, context2, null, false);
    }

    @NotNull
    public static String declarationText(String name, OCType type, String typeNameHint, @Nullable String initializerText, @NotNull PsiElement context2) {
        return OCElementFactory.declarationText(Collections.emptyList(), name, type, initializerText, context2, typeNameHint, false);
    }

    @NotNull
    public static OCDeclaration declarationByNameAndType(String name, OCType type, PsiElement context2) {
        return OCElementFactory.declarationStatement(name, type, null, context2).getDeclaration();
    }

    @NotNull
    public static OCParameterDeclaration paramDeclarationFromText(String text, @NotNull PsiElement context2) {
        return ((OCFunctionDefinition)OCElementFactory.topLevelDeclarationFromText("void f(" + text + "){}", context2)).getParameterList().getParameterDeclarations().get(0);
    }

    @NotNull
    public static OCParameterDeclaration paramDeclarationByNameAndType(String name, OCType type, @Nullable OCExpression defaultValue, PsiElement context2) {
        OCParameterDeclaration paramDeclaration = OCElementFactory.paramDeclarationFromText(OCElementFactory.declarationText(Collections.emptyList(), name, type, defaultValue != null ? "0" : null, context2, null, false), context2);
        if (defaultValue != null) {
            OCChangeUtil.replaceHandlingMacros(paramDeclaration.getDeclarator().getInitializer(), defaultValue);
        }
        return paramDeclaration;
    }

    @NotNull
    public static OCProperty propertyDeclaration(String name, OCType type, PsiElement context2) {
        return OCElementFactory.propertyDeclaration(name, type, context2, null, false);
    }

    @NotNull
    public static OCProperty propertyDeclaration(String name, OCType type, PsiElement context2, @Nullable OCPropertySymbol.PropertySemantics semantics, boolean readonly) {
        return OCElementFactory.propertyDeclaration(name, type, context2, semantics, readonly, null);
    }

    @NotNull
    public static OCProperty propertyDeclaration(String name, OCType type, PsiElement context2, @Nullable OCPropertySymbol.PropertySemantics semantics, boolean readonly, @Nullable String additionalAttributes) {
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)context2.getContainingFile(), OCCodeStyleSettings.class);
        return OCElementFactory.propertyDeclaration(name, type, context2, semantics, settings == null || settings.PROPERTY_NONATOMIC, readonly, additionalAttributes);
    }

    @NotNull
    public static OCProperty propertyDeclaration(String name, OCType type, PsiElement context2, @Nullable OCPropertySymbol.PropertySemantics semantics, boolean nonatomic, boolean readonly, @Nullable String additionalAttributes) {
        ArrayList<String> attributes = new ArrayList<String>();
        if (nonatomic) {
            attributes.add("nonatomic");
        }
        if (readonly) {
            attributes.add("readonly");
        }
        if (semantics == null && type.isPointerToObjectCompatible()) {
            semantics = OCPropertySymbolImpl.getDefaultSemanticsForType(type, context2);
        }
        if (semantics == OCPropertySymbol.PropertySemantics.ASSIGN) {
            attributes.add("assign");
        } else if (semantics == OCPropertySymbol.PropertySemantics.WEAK) {
            attributes.add("weak");
        } else if (type.isPointerToObjectCompatible() && !readonly) {
            if (semantics == OCPropertySymbol.PropertySemantics.STRONG) {
                attributes.add("strong");
            } else if (semantics == OCPropertySymbol.PropertySemantics.RETAIN) {
                attributes.add("retain");
            } else if (semantics == OCPropertySymbol.PropertySemantics.COPY) {
                attributes.add("copy");
            }
        }
        StringBuilder attributesText = new StringBuilder();
        if (!attributes.isEmpty()) {
            attributesText.append('(');
            attributesText.append(StringUtil.join(attributes, (String)","));
            attributesText.append(')');
        }
        if (!StringUtil.isEmpty((String)additionalAttributes)) {
            if (attributesText.length() > 0) {
                attributesText.append(' ');
            }
            attributesText.append(additionalAttributes);
            attributesText.append(' ');
        }
        String text = "@interface c @property " + attributesText + OCElementFactory.declarationText(Collections.emptyList(), name, type, null, context2, null, true) + "; @end";
        return ((OCInterface)OCElementFactory.topLevelDeclarationFromText(text, context2, true)).getProperties().get(0);
    }

    @NotNull
    public static OCDeclaration enumConst(String name, PsiElement context2) {
        return ((OCEnum)OCElementFactory.typeElementFromText("enum { " + name + "}", context2).getFirstChild()).getFields().get(0);
    }

    @NotNull
    public static OCExpression booleanConstant(boolean value, @NotNull OCResolveContext context2) {
        String constant = OCIntType.getAppropriateBool(context2.isObjc()).getValue(value, context2);
        return (OCExpression)PsiTreeUtil.getChildOfType((PsiElement)OCElementFactory.expressionCodeFragment(constant, context2.getProject(), context2.getElement(), false, false), OCExpression.class);
    }

    @NotNull
    public static OCSendMessageExpression sendMessageExpression(List<String> paramStubs, PsiElement context2) {
        StringBuilder text = new StringBuilder("[ 0 ");
        for (String paramStub : paramStubs) {
            text.append(paramStub).append(' ');
        }
        text.append("]");
        return (OCSendMessageExpression)OCElementFactory.expressionFromText(text.toString(), context2);
    }

    @NotNull
    public static OCCallExpression callExpression(@Nullable String functionName, List<String> paramStubs, PsiElement context2) {
        if (functionName == null || functionName.isEmpty()) {
            functionName = "__empty";
        }
        StringBuilder text = new StringBuilder(functionName);
        text.append('(');
        boolean isFirst = true;
        for (String paramStub : paramStubs) {
            if (!isFirst) {
                text.append(',');
            }
            text.append(paramStub);
            isFirst = false;
        }
        text.append(')');
        return (OCCallExpression)OCElementFactory.expressionFromText(text.toString(), context2);
    }

    @NotNull
    public static OCInterface interfaceByName(String name, PsiElement context2) {
        return (OCInterface)OCElementFactory.topLevelDeclarationFromText("@interface " + name + " @end", context2, true);
    }

    @NotNull
    public static OCMethod methodFromText(String text, PsiElement context2, boolean reformat) {
        return ((OCInterface)OCElementFactory.topLevelDeclarationFromText("@interface i " + text + " @end", context2, reformat)).getMethods().get(0);
    }

    @NotNull
    public static OCDefineDirective macroDeclarationFromText(String name, String defaultValue, PsiFile file2) {
        return (OCDefineDirective)OCElementFactory.topLevelDeclarationFromText("#define " + name + " " + defaultValue, (PsiElement)file2);
    }

    @NotNull
    public static OCMethod methodFromSignature(@NotNull String signature, @NotNull PsiElement context2, boolean needBody, boolean reformat) {
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)context2.getContainingFile(), OCCodeStyleSettings.class);
        String semicolon = settings != null && settings.SEMICOLON_AFTER_METHOD_SIGNATURE ? ";" : "";
        return OCElementFactory.methodFromText(signature + (needBody ? semicolon + "{\n}" : ";"), context2, reformat);
    }

    @NotNull
    public static OCUnaryExpression unaryExpression(PsiElement operand, OCElementType operator) {
        OCUnaryExpression expression = (OCUnaryExpression)OCElementFactory.expressionFromText(operator.getName() + " a", operand, false);
        OCChangeUtil.replaceHandlingMacros(expression.getOperand(), operand);
        return expression;
    }

    @NotNull
    public static PsiElement createUDLSuffux(String name, PsiElement context2) {
        OCUDLiteralExpressionImpl expression = (OCUDLiteralExpressionImpl)OCElementFactory.expressionFromText("\"\"" + name, context2, false);
        return expression.getNameIdentifier();
    }

    @NotNull
    public static OCBinaryExpression binaryExpression(PsiElement leftOperand, PsiElement rightOperand, OCElementType operator) {
        OCBinaryExpression expression = (OCBinaryExpression)OCElementFactory.expressionFromText("a " + operator.getName() + " b", leftOperand, false);
        OCChangeUtil.replaceHandlingMacros(expression.getLeft(), leftOperand);
        OCChangeUtil.replaceHandlingMacros(expression.getRight(), rightOperand);
        return expression;
    }

    @NotNull
    public static OCConditionalExpression conditionalExpression(@NotNull OCExpression condition, @NotNull OCExpression thenExpression, @NotNull OCExpression elseExpression) {
        OCConditionalExpression conditionalExpression = (OCConditionalExpression)OCElementFactory.expressionFromText("1 ? 2 : 3", condition);
        OCParenthesesUtils.replaceExpressionAndRemoveAppendParentheses(conditionalExpression.getCondition(), condition);
        OCParenthesesUtils.replaceExpressionAndRemoveAppendParentheses(conditionalExpression.getPositiveExpression(false), thenExpression);
        OCParenthesesUtils.replaceExpressionAndRemoveAppendParentheses(conditionalExpression.getNegativeExpression(), elseExpression);
        return conditionalExpression;
    }

    @NotNull
    public static PsiElement binaryOperatorFromText(String operator, PsiElement context2) {
        return ((OCBinaryExpression)OCElementFactory.expressionFromText("a" + operator + "b", context2)).getOperationSignNode().getPsi();
    }

    @NotNull
    public static ASTNode typeModifierFromText(String modifier, PsiElement context2) {
        return OCElementFactory.typeElementFromText(modifier + " int", context2).getNode().getFirstChildNode();
    }

    @NotNull
    public static PsiElement ivarScopeSpecifier(OCVisibility scope, PsiElement context2) {
        OCInstanceVariablesList clazz = ((OCInterface)OCElementFactory.topLevelDeclarationFromText("@interface c { @" + (Object)((Object)scope) + "} #end", context2)).getInstanceVariablesList();
        for (PsiElement kid = clazz.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
            if (OCVisibility.getVisibilityFromElement(kid) != scope) continue;
            return kid;
        }
        return null;
    }

    @NotNull
    public static OCInstanceVariablesList instanceVariableList(PsiElement context2) {
        return ((OCInterface)OCElementFactory.topLevelDeclarationFromText("@interface c {} @end", context2)).getInstanceVariablesList();
    }

    @NotNull
    public static OCDeclaration constructorFromText(String text, PsiElement context2) {
        return OCElementFactory.constructorFromText(text, context2, false);
    }

    @NotNull
    public static OCDeclaration constructorFromText(String text, PsiElement context2, boolean reformat) {
        String name = text.substring(0, text.indexOf(40));
        OCTypeElement type = OCElementFactory.typeElementFromTextOrNull("struct " + name + " { " + text + ";}", context2, reformat);
        OCStruct struct = (OCStruct)type.getFirstChild();
        return (OCDeclaration)PsiTreeUtil.getChildOfType((PsiElement)struct, OCFunctionDeclaration.class);
    }

    @NotNull
    public static OCConstructorInitializationList constructorInitializationList(OCElement context2) {
        OCFunctionDefinition constructor = (OCFunctionDefinition)OCElementFactory.constructorFromText("XXX() : y(1) {}", context2);
        OCConstructorInitializationList list = constructor.getConstructorInitializationList();
        OCChangeUtil.delete(list.getInitializers().get(0));
        return list;
    }

    @NotNull
    public static OCConstructorFieldInitializer constructorFieldInitializerFromText(String text, PsiElement context2) {
        OCFunctionDefinition constructor = (OCFunctionDefinition)OCElementFactory.constructorFromText("XXX() : " + text + "{}", context2);
        OCConstructorInitializationList list = constructor.getConstructorInitializationList();
        return list.getInitializers().get(0);
    }

    @NotNull
    public static OCPropertyAttributesList propertyAttributeList(OCPropertySymbol.PropertyAttribute attribute, @Nullable String value, PsiElement context2) {
        String text = "@interface c @property (" + attribute.getTokenName() + (value != null ? "=" + value : "") + ") int x; @end";
        return ((OCInterface)OCElementFactory.topLevelDeclarationFromText(text, context2, true)).getProperties().get(0).getPropertyAttributesList();
    }

    @NotNull
    public static OCSynthesizePropertiesList synthesizeList(String myKeyword, String property, @Nullable String ivar, PsiElement context2) {
        String text = "@implementation i " + myKeyword + " " + property + (ivar != null ? "=" + ivar : "") + "; @end";
        ASTNode node2 = OCElementFactory.topLevelDeclarationFromText(text, context2, true).getNode();
        return (OCSynthesizePropertiesList)node2.findChildByType((IElementType)OCElementTypes.SYNTHESIZED_PROPERTIES_LIST).getPsi(OCSynthesizePropertiesList.class);
    }

    @NotNull
    public static OCSynthesizeProperty synthesize(String property, @Nullable String ivar, PsiElement context2) {
        String text = "@implementation i @synthesize " + property + (ivar != null ? "=" + ivar : "") + "; @end";
        ASTNode node2 = OCElementFactory.topLevelDeclarationFromText(text, context2, true).getNode();
        return ((OCSynthesizePropertiesList)node2.findChildByType((IElementType)OCElementTypes.SYNTHESIZED_PROPERTIES_LIST).getPsi(OCSynthesizePropertiesList.class)).getProperties().get(0);
    }

    @NotNull
    private static String declaratorText(String name, OCType type, @NotNull PsiElement context2, boolean eraseARCAttributes) {
        if ("<unnamed>".equals(name)) {
            name = "";
        }
        OCResolveContext resolveContext = OCResolveContext.forPsi(context2);
        if (type.getAliasName() == null) {
            if (type instanceof OCArrayType) {
                OCArrayType arrayType = (OCArrayType)type;
                int length = arrayType.getLength(resolveContext);
                if (name.startsWith("*")) {
                    name = "(" + name + ")";
                }
                return OCElementFactory.declaratorText(name + " [" + (arrayType.hasLength() ? Integer.valueOf(length) : "") + "]", arrayType.getRefType(), context2, eraseARCAttributes);
            }
            if (type instanceof OCPointerType) {
                OCPointerType pointerType = (OCPointerType)type;
                if (!(pointerType.getRefType() instanceof OCIdType)) {
                    name = (type instanceof OCBlockPointerType ? "^" : "*") + (pointerType.isConst() ? " const " : "") + (pointerType.isVolatile() ? " volatile " : "") + name;
                }
                return (!eraseARCAttributes && pointerType.getARCAttribute() != null ? pointerType.getARCAttribute().getTokenName() + " " : "") + OCElementFactory.declaratorText(name, pointerType.getRefType(), context2, eraseARCAttributes);
            }
            if (type instanceof OCFunctionType) {
                OCFunctionType funType = (OCFunctionType)type;
                StringBuilder b = new StringBuilder();
                b.append(funType.getReturnType().getBestNameInContext(resolveContext));
                b.append(" (").append(name).append(")");
                b.append(OCTypeNameVisitor.getFunctionSignature(resolveContext, funType, "", false, null));
                return b.toString();
            }
        }
        return type.getBestNameInContext(resolveContext) + " " + name;
    }

    @NotNull
    public static String declarationText(@NotNull List<String> modifiers, String name, OCType type, @Nullable String initializerText, @NotNull PsiElement context2, @Nullable String typeNameHint, boolean eraseARCAttributes) {
        if (type instanceof OCFunctionType && type.getAliasName() == null) {
            type = OCPointerType.to(type);
        }
        if (type == null) {
            return "";
        }
        boolean isUnnamed = "<unnamed>".equals(name) || name.isEmpty();
        StringBuilder b = new StringBuilder();
        for (String modifier : modifiers) {
            b.append(modifier).append(' ');
        }
        OCResolveContext resolveContext = OCResolveContext.forPsi(context2);
        if (type instanceof OCPointerType && type.getAliasName() == null) {
            b.append(OCElementFactory.declaratorText(name, type, context2, eraseARCAttributes));
        } else {
            if (type instanceof OCUnknownType) {
                b.append(resolveContext.isObjc() ? "id" : "int");
            } else {
                b.append(type.getBestNameInContext(resolveContext));
            }
            if (!isUnnamed) {
                b.append(' ').append(name);
            }
        }
        String declarationText = b.toString();
        if (typeNameHint != null && OCCodeInsightUtil.isSimpleDeclaration(b.toString(), name) && modifiers.isEmpty() && type.equalsAfterResolving(typeNameHint, resolveContext)) {
            declarationText = isUnnamed ? typeNameHint : typeNameHint + " " + name;
        }
        if (initializerText != null) {
            return declarationText + '=' + initializerText;
        }
        return declarationText;
    }

    @NotNull
    public static PsiElement createIdentifier(@NotNull String name, @NotNull PsiElement context2) {
        List<OCDeclarator> declarators;
        OCCodeFragment fragment = OCElementFactory.codeFragment("int " + name, context2.getProject(), context2, false, false);
        OCDeclaration declaration = (OCDeclaration)PsiTreeUtil.getChildOfType((PsiElement)fragment, OCElement.class);
        List<OCDeclarator> list = declarators = declaration != null ? declaration.getDeclarators() : null;
        if (declarators == null || declarators.isEmpty()) {
            LOG.error("Bad identifier name " + name);
        }
        return declarators.get(0).getNameIdentifier();
    }

    @NotNull
    public static OCMacroForeignLeafElement createMacroForeignIdentifier(@NotNull String name, @NotNull OCMacroForeignLeafElement sample) {
        List<OCDeclarator> declarators;
        OCCodeFragment fragment = OCElementFactory.codeFragment("#define M(x) x\nint M(" + name + ")", sample.getProject(), null, false, false);
        OCDeclaration declaration = (OCDeclaration)PsiTreeUtil.getChildOfType((PsiElement)fragment, OCDeclaration.class);
        List<OCDeclarator> list = declarators = declaration != null ? declaration.getDeclarators() : null;
        if (declarators == null || declarators.isEmpty()) {
            LOG.error("Bad identifier name " + name);
        }
        OCMacroForeignLeafElement identifier = (OCMacroForeignLeafElement)declarators.get(0).getNameIdentifier();
        identifier.copyFromElement(sample);
        return identifier;
    }

    @Nullable
    public static OCCppNamespaceQualifier createNamespaceQualifier(OCQualifiedName name, PsiElement context2) {
        String nameText = name.getFullName(OCResolveContext.forPsi(context2));
        if (!nameText.isEmpty()) {
            OCStruct struct = (OCStruct)OCElementFactory.declarationFromText("struct " + nameText + "::XXXX {}", context2, true).getTypeElement().getFirstChild();
            return struct.getNamespaceQualifier();
        }
        return null;
    }

    @NotNull
    public static ASTNode createColon2x(PsiElement context2) {
        OCStruct struct = (OCStruct)OCElementFactory.declarationFromText("struct A::B{}", context2).getTypeElement().getFirstChild();
        return struct.getNode().findChildByType((IElementType)OCTokenTypes.COLON2X);
    }

    @NotNull
    public static PsiElement topLevelDeclarationFromText(@NotNull String text, @NotNull PsiElement context2) {
        return OCElementFactory.topLevelDeclarationFromText(text, context2, false);
    }

    @NotNull
    public static PsiElement topLevelDeclarationFromText(@NotNull String text, @NotNull PsiElement context2, boolean reformat) {
        OCCodeFragment element = OCElementFactory.codeFragment(text, context2.getProject(), context2, false, reformat);
        PsiElement child = element.getFirstChild();
        while (child instanceof PsiWhiteSpace || child instanceof PsiComment || child instanceof OCMacroCall) {
            child = child.getNextSibling();
        }
        return child;
    }

    @NotNull
    public static OCTypeElement typeElementFromText(@NotNull String text, @NotNull PsiElement context2) {
        return OCElementFactory.typeElementFromTextOrNull(text, context2, true);
    }

    @Nullable
    public static OCTypeElement typeElementFromTextOrNull(@NotNull String text, @NotNull PsiElement context2, boolean formatToCodestyle) {
        return (OCTypeElement)PsiTreeUtil.getChildOfType((PsiElement)OCElementFactory.typeCodeFragment(text, context2.getProject(), context2, false, formatToCodestyle), OCTypeElement.class);
    }

    @Nullable
    public static OCReferenceElement referenceElementFromText(@NotNull String name, @NotNull PsiElement context2, boolean formatToCodestyle) {
        return (OCReferenceElement)PsiTreeUtil.getChildOfType((PsiElement)OCElementFactory.expressionFromText(name, context2, formatToCodestyle), OCReferenceElement.class);
    }

    @Nullable
    public static OCExpression expressionFromText(@NotNull String text, @NotNull PsiElement context2) {
        return OCElementFactory.expressionFromText(text, context2, false);
    }

    @Nullable
    public static OCExpression expressionFromText(@NotNull String text, @NotNull PsiElement context2, boolean reformat) {
        return (OCExpression)PsiTreeUtil.getChildOfType((PsiElement)OCElementFactory.expressionCodeFragment(text, context2.getProject(), context2, false, reformat), OCExpression.class);
    }

    public static OCStatement statementFromText(@NotNull String text, @NotNull PsiElement context2) {
        return OCElementFactory.statementFromText(text, context2, false);
    }

    public static OCStatement statementFromText(@NotNull String text, @NotNull PsiElement context2, boolean reformat) {
        text = "void _______dummy(){" + text + ";}";
        OCCodeFragment element = OCElementFactory.codeFragment(text, context2.getProject(), context2, false, reformat);
        element = PsiTreeUtil.getChildOfType((PsiElement)element, OCFunctionDefinition.class);
        element = PsiTreeUtil.getChildOfType((PsiElement)element, OCBlockStatement.class);
        return (OCStatement)PsiTreeUtil.getChildOfType((PsiElement)element, OCStatement.class);
    }

    @NotNull
    public static OCCodeFragment codeFragment(@NonNls @NotNull String text, @NotNull Project project2, @Nullable PsiElement context2, boolean physical, boolean reformat) {
        return OCElementFactory.codeFragment(text, project2, context2, OCTokenTypes.OC_FILE, physical, reformat);
    }

    @NotNull
    public static OCCodeFragment expressionCodeFragment(@NotNull String text, @NotNull Project project2, @Nullable PsiElement context2, boolean physical, boolean formatToCodestyle) {
        return OCElementFactory.codeFragment(text, project2, context2, OCElementTypes.EXPRESSION_CODE_FRAGMENT, physical, formatToCodestyle);
    }

    @NotNull
    public static OCCodeFragment expressionCodeFragment(@NotNull CharSequence text, @NotNull Project project2, @Nullable PsiElement context2, boolean physical, boolean formatToCodestyle, OCLanguageKind kind) {
        return OCElementFactory.codeFragment(text, project2, context2, OCElementTypes.EXPRESSION_CODE_FRAGMENT, physical, formatToCodestyle, kind);
    }

    @NotNull
    public static OCCodeFragment expressionCodeFragmentCpp(@NotNull String text, @NotNull Project project2, @Nullable PsiElement context2, boolean physical, boolean formatToCodestyle) {
        return OCElementFactory.codeFragment(text, project2, context2, OCElementTypes.EXPRESSION_CODE_FRAGMENT, physical, formatToCodestyle, OCElementFactory.getLanguageKindFromContext(context2));
    }

    @NotNull
    public static OCCodeFragment expressionOrStatementsCodeFragment(@NotNull String text, @NotNull Project project2, @Nullable PsiElement context2, boolean physical, boolean formatToCodestyle) {
        return OCElementFactory.codeFragment(text, project2, context2, OCElementTypes.EXPRESSION_OR_STATEMENTS_CODE_FRAGMENT, physical, formatToCodestyle);
    }

    @NotNull
    public static OCCodeFragment typeCodeFragment(@NotNull String text, @NotNull PsiElement context2) {
        return OCElementFactory.typeCodeFragment(text, context2.getProject(), context2, true, false);
    }

    @NotNull
    public static OCCodeFragment typeCodeFragment(@NotNull String text, @NotNull Project project2, @Nullable PsiElement context2, boolean physical, boolean formatToCodestyle) {
        return OCElementFactory.codeFragment(text, project2, context2, OCElementTypes.TYPE_CODE_FRAGMENT, physical, formatToCodestyle);
    }

    @NotNull
    public static OCCodeFragment qualifiedIdCodeFragment(@NotNull String text, @NotNull PsiElement context2) {
        return OCElementFactory.codeFragment(text, context2.getProject(), context2, OCElementTypes.QUALIFIED_ID_CODE_FRAGMENT, true, false);
    }

    public static OCCodeFragment getTypeCodeFragmentInWriteAction(String text, @NotNull Project project2, @Nullable PsiElement context2) {
        return (OCCodeFragment)WriteCommandAction.writeCommandAction((Project)project2).compute(() -> OCElementFactory.typeCodeFragment(text, project2, context2, true, true));
    }

    @NotNull
    public static OCCodeFragment codeFragment(@NotNull String text, @NotNull Project project2, @Nullable PsiElement context2, @NotNull IFileElementType type, boolean physical, boolean formatToCodestyle) {
        return OCElementFactory.codeFragment(text, project2, context2, type, physical, formatToCodestyle, OCElementFactory.getLanguageKindFromContext(context2));
    }

    @NotNull
    public static OCLanguageKind getLanguageKindFromContext(@Nullable PsiElement context2) {
        PsiFile file2;
        if (context2 != null && (file2 = context2.getContainingFile()) instanceof OCFile) {
            OCLanguageKind kind = ((OCFile)file2).getKind();
            return CLanguageKind.find(kind.isObjC(), kind.isCpp(), kind.isCuda());
        }
        return CLanguageKind.maxLanguage();
    }

    @NotNull
    public static OCCodeFragment codeFragment(@NotNull CharSequence text, @NotNull Project project2, @Nullable PsiElement context2, @NotNull IFileElementType type, boolean physical, boolean formatToCodestyle, @NotNull OCLanguageKind kind) {
        if (context2 == null && formatToCodestyle) {
            OCLog.LOG.warn("Formatting of code fragment without context is deprecated!");
        }
        OCCodeFragmentImpl fragment = new OCCodeFragmentImpl(project2, kind, text, physical, (IElementType)type);
        if (context2 != null && context2.isValid()) {
            fragment.setContext(context2);
        }
        Application app = ApplicationManager.getApplication();
        if (formatToCodestyle) {
            if (app.isWriteAccessAllowed() || !physical) {
                PostprocessReformattingAspect.getInstance((Project)project2).disablePostprocessFormattingInside(() -> CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)fragment));
            } else {
                LOG.error("Write access is required");
            }
        }
        return fragment;
    }

    @NotNull
    public static PsiElement create(@NotNull OCElementType type, @NotNull PsiElement context2) {
        OCCodeFragment fragment = OCElementFactory.codeFragment(type.getName(), context2.getProject(), context2, true, false);
        return PsiTreeUtil.findChildOfType((PsiElement)fragment, LeafPsiElement.class);
    }

    @NotNull
    public static PsiElement spaceFromText(@NotNull PsiElement context2) {
        return OCElementUtil.getAllChildren(OCElementFactory.topLevelDeclarationFromText("CIDR_RULE_ZZZ1 CIDR_RULE_ZZZ2", context2)).get(1);
    }

    @NotNull
    public static PsiElement newlineFromText(@NotNull PsiElement context2) {
        return OCElementUtil.getAllChildren(OCElementFactory.topLevelDeclarationFromText("CIDR_RULE_ZZZ1\nCIDR_RULE_ZZZ2", context2)).get(1);
    }

    public static void initIndentFromContext(@NotNull PsiElement oldElement, @NotNull PsiElement newElement) {
        PsiFile context2 = oldElement.getContainingFile();
        CodeEditUtil.setOldIndentation((TreeElement)((TreeElement)newElement.getNode()), (int)IndentHelper.getInstance().getIndent(context2, oldElement.getNode()));
    }

    @NotNull
    public static OCBlockStatement surroundByBraces(@NotNull PsiElement element) {
        if (element instanceof OCBlockStatement) {
            return (OCBlockStatement)element;
        }
        OCBlockStatement blockStatement = (OCBlockStatement)OCElementFactory.statementFromText("{}", element);
        OCChangeUtil.addAfter(blockStatement, element, blockStatement.getOpeningBrace());
        return blockStatement;
    }

    @NotNull
    public static PsiElement createLeaf(@NotNull PsiManager manager2, @NotNull OCElementType type) {
        return Factory.createSingleLeafElement((IElementType)type, (CharSequence)type.getName(), (int)0, (int)type.getName().length(), null, (PsiManager)manager2).getPsi();
    }
}

