/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.Queue;
import com.jetbrains.cidr.lang.dfa.OCControlFlowBuilder;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCNode;
import com.jetbrains.cidr.lang.dfa.OCUnreachableCodeFinder;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCControlFlowUtil {
    private OCControlFlowUtil() {
    }

    public static boolean isNodeReachableFrom(@NotNull OCNode fromNode, @NotNull OCNode toNode, boolean allowBackwardJumps) {
        Queue nodesToProcess = new Queue(8);
        HashSet<OCNode> processedNodes = new HashSet<OCNode>();
        nodesToProcess.addLast((Object)fromNode);
        processedNodes.add(fromNode);
        while (!nodesToProcess.isEmpty()) {
            OCNode node2 = (OCNode)nodesToProcess.pullFirst();
            List<OCNode> jumpTargets = node2.getJumpTargets();
            if (jumpTargets == null) continue;
            for (OCNode jumpTarget : jumpTargets) {
                if (!allowBackwardJumps && OCControlFlowUtil.isBackwardJump(node2, jumpTarget) || processedNodes.contains(jumpTarget)) continue;
                processedNodes.add(jumpTarget);
                nodesToProcess.addLast((Object)jumpTarget);
            }
        }
        return processedNodes.contains(toNode);
    }

    public static boolean isBackwardJump(@NotNull OCNode fromNode, @NotNull OCNode toNode) {
        int fromNodeEndOffset = fromNode.getEndOffset();
        int toNodeEndOffset = toNode.getEndOffset();
        return fromNodeEndOffset != -1 && toNodeEndOffset != -1 && toNodeEndOffset < fromNodeEndOffset;
    }

    @NotNull
    public static OCNode getSignificantNode(@NotNull OCNode node2) {
        while (node2.getRange() == null && node2.getJumpTargets() != null && node2.getJumpTargets().size() == 1) {
            node2 = node2.getJumpTargets().get(0);
        }
        return node2;
    }

    @Nullable
    public static PsiElement getFirstPsiElement(@NotNull OCNode node2) {
        OCElementsRange elementsRange = node2.getRange();
        if (elementsRange == null) {
            return null;
        }
        PsiElement psiElementToJump = elementsRange.getFirstElement();
        while (psiElementToJump instanceof OCMacroCall) {
            psiElementToJump = psiElementToJump.getNextSibling();
        }
        if (psiElementToJump != null && !(psiElementToJump instanceof OCStatement)) {
            psiElementToJump = PsiTreeUtil.getParentOfType((PsiElement)psiElementToJump, OCStatement.class);
        }
        return psiElementToJump;
    }

    @Nullable
    public static OCNode findNodeForElement(@NotNull OCControlFlowGraph controlFlowGraph, @NotNull OCElement element) {
        TextRange textRange = element.getTextRange();
        List<OCNode> nodes = controlFlowGraph.getNodes();
        for (OCNode node2 : nodes) {
            OCElementsRange range = node2.getRange();
            if (range == null || !range.getTextRange().intersectsStrict(textRange)) continue;
            return node2;
        }
        return null;
    }

    public static boolean isUnreachable(@NotNull OCControlFlowGraph controlFlowGraph, @NotNull PsiElement elementToCheck) {
        OCUnreachableCodeFinder unreachableCodeFinder = new OCUnreachableCodeFinder(controlFlowGraph);
        unreachableCodeFinder.process();
        TextRange textRangeToCheck = elementToCheck.getTextRange();
        return unreachableCodeFinder.getUnreachableRanges(false).stream().anyMatch(unreachableElementsRange -> unreachableElementsRange.getTextRange().intersectsStrict(textRangeToCheck));
    }

    @NotNull
    public static OCControlFlowGraph buildControlFlowGraph(@NotNull OCCallable callable) {
        return OCControlFlowUtil.buildControlFlowGraph(callable, callable);
    }

    @NotNull
    public static OCControlFlowGraph buildControlFlowGraph(@NotNull PsiElement element, @NotNull OCCallable callable) {
        OCControlFlowGraph controlFlowGraph = new OCControlFlowGraph(callable, null);
        OCControlFlowBuilder controlFlowBuilder = new OCControlFlowBuilder(null, controlFlowGraph, null, false);
        controlFlowBuilder.processFirstCodeFragment(element);
        return controlFlowGraph;
    }
}

