/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.util.containers.MostlySingularMultiMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;

public final class OCConcurrentMostlySingularMultiUniqueMapBuilder<T> {
    @NotNull
    private final Map<String, Object> myMap = new ConcurrentHashMap<String, Object>();
    @NotNull
    private final Set<T> myAllValues;

    public OCConcurrentMostlySingularMultiUniqueMapBuilder(int capacity, @NotNull TObjectHashingStrategy<T> strategy2) {
        this.myAllValues = ConcurrentCollectionFactory.createConcurrentSet((int)capacity, strategy2);
    }

    public OCConcurrentMostlySingularMultiUniqueMapBuilder(@NotNull TObjectHashingStrategy<T> strategy2) {
        this.myAllValues = ConcurrentCollectionFactory.createConcurrentSet(strategy2);
    }

    public boolean addIfAbsent(@NotNull String key, @NotNull T value) {
        if (this.myAllValues.add(value)) {
            MyMostlySingularMultiMap.add(this.myMap, key, value);
            return true;
        }
        return false;
    }

    @NotNull
    public MostlySingularMultiMap<String, T> build() {
        return MyMostlySingularMultiMap.createCompacted(this.myMap);
    }

    @NotNull
    public static <T> OCConcurrentMostlySingularMultiUniqueMapBuilder<T> createBuilder(@NotNull TObjectHashingStrategy<T> strategy2) {
        return new OCConcurrentMostlySingularMultiUniqueMapBuilder<T>(strategy2);
    }

    private static final class MyMostlySingularMultiMap<T>
    extends MostlySingularMultiMap<String, T> {
        private static final BiFunction<Object, Object, Object> myRemappingFunction = (current, value) -> {
            if (current instanceof MostlySingularMultiMap.ValueList) {
                return current;
            }
            MostlySingularMultiMap.ValueList newList = new MostlySingularMultiMap.ValueList();
            newList.add(current);
            return newList;
        };

        private MyMostlySingularMultiMap() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static <T> void add(@NotNull Map<String, Object> map2, @NotNull String key, @NotNull T value) {
            MostlySingularMultiMap.ValueList newList;
            Object newValue = map2.merge(key, value, myRemappingFunction);
            if (newValue == value) {
                return;
            }
            MostlySingularMultiMap.ValueList valueList = newList = (MostlySingularMultiMap.ValueList)newValue;
            synchronized (valueList) {
                newList.add(value);
            }
        }

        @NotNull
        private static <T> MostlySingularMultiMap<String, T> createCompacted(@NotNull Map<String, Object> sourceMap) {
            if (sourceMap.isEmpty()) {
                return MyMostlySingularMultiMap.emptyMap();
            }
            MyMostlySingularMultiMap<T> compactMap = new MyMostlySingularMultiMap<T>();
            for (Map.Entry<String, Object> entry : sourceMap.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (value instanceof MostlySingularMultiMap.ValueList) {
                    ((MostlySingularMultiMap.ValueList)value).trimToSize();
                }
                compactMap.myMap.put(key, value);
            }
            return compactMap;
        }
    }
}

