/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.ide.util.EditorHelper;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCMacroRange;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCClassDeclarationBase;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCCppNewExpression;
import com.jetbrains.cidr.lang.psi.OCCppTypeidExpression;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDirective;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCGenericSelectionExpression;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCLocalScopeable;
import com.jetbrains.cidr.lang.psi.OCLoopStatement;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMacroCallArgument;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCPostfixExpression;
import com.jetbrains.cidr.lang.psi.OCPrefixExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSizeofExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCStatementExpression;
import com.jetbrains.cidr.lang.psi.OCSwitchStatement;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCExprValueCategory;
import com.jetbrains.cidr.lang.resolve.OCResolveOverloadsUtil;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCThisSelfSuperSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.symbols.symtable.SymbolTableProvider;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCBracedInitListType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCValueCategoryHolder;
import com.jetbrains.cidr.lang.types.visitors.OCArgumentDepLookupAccumulator;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCLValueUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCodeInsightUtil {
    private static final Map<OCElementType, OCElementType> oppositeOperators = ContainerUtil.newHashMap((Pair)new Pair((Object)OCTokenTypes.EQEQ, (Object)OCTokenTypes.EXCLEQ), (Pair[])new Pair[]{new Pair((Object)OCTokenTypes.EXCLEQ, (Object)OCTokenTypes.EQEQ), new Pair((Object)OCTokenTypes.LT, (Object)OCTokenTypes.GTEQ), new Pair((Object)OCTokenTypes.LTEQ, (Object)OCTokenTypes.GT), new Pair((Object)OCTokenTypes.GT, (Object)OCTokenTypes.LTEQ), new Pair((Object)OCTokenTypes.GTEQ, (Object)OCTokenTypes.LT)});
    private static final Map<OCElementType, OCElementType> flippedOperators = ContainerUtil.newHashMap((Pair)new Pair((Object)OCTokenTypes.ANDAND, (Object)OCTokenTypes.ANDAND), (Pair[])new Pair[]{new Pair((Object)OCTokenTypes.OROR, (Object)OCTokenTypes.OROR), new Pair((Object)OCTokenTypes.EQEQ, (Object)OCTokenTypes.EQEQ), new Pair((Object)OCTokenTypes.EXCLEQ, (Object)OCTokenTypes.EXCLEQ), new Pair((Object)OCTokenTypes.GTEQ, (Object)OCTokenTypes.LTEQ), new Pair((Object)OCTokenTypes.LTEQ, (Object)OCTokenTypes.GTEQ), new Pair((Object)OCTokenTypes.GT, (Object)OCTokenTypes.LT), new Pair((Object)OCTokenTypes.LT, (Object)OCTokenTypes.GT)});
    private static final Map<OCElementType, OCElementType> inversedLogicalOperators = ContainerUtil.newHashMap((Pair)new Pair((Object)OCTokenTypes.ANDAND, (Object)OCTokenTypes.OROR), (Pair[])new Pair[]{new Pair((Object)OCTokenTypes.OROR, (Object)OCTokenTypes.ANDAND), new Pair((Object)OCTokenTypes.OR, (Object)OCTokenTypes.AND), new Pair((Object)OCTokenTypes.AND, (Object)OCTokenTypes.OR)});
    private static final String MAX_LENGTH_KEY = "cidr.max.intellisense.file.length";

    private OCCodeInsightUtil() {
    }

    public static boolean isInPlainOldC(@Nullable PsiElement element) {
        if (element != null && element.isValid() && element.getContainingFile() instanceof OCFile) {
            return !((OCFile)element.getContainingFile()).isCpp();
        }
        return false;
    }

    public static boolean isInObjC(@Nullable PsiElement element) {
        if (element != null && element.isValid() && element.getContainingFile() instanceof OCFile) {
            return ((OCFile)element.getContainingFile()).getKind().isObjC();
        }
        return false;
    }

    public static boolean isInPlainOldC(@Nullable PsiFile file2, @Nullable OCInclusionContext context2) {
        if (context2 != null) {
            return !context2.getLanguageKind().isCpp();
        }
        if (file2 != null) {
            return OCCodeInsightUtil.isInPlainOldC((PsiElement)file2);
        }
        return true;
    }

    @Contract(value="null->false")
    public static boolean isValid(@Nullable PsiElement element) {
        if (element == null || !element.isValid()) {
            return false;
        }
        if (!OCSearchScope.isInProjectSources(element)) {
            return false;
        }
        OCMacroRange rangeInMacroCall = OCElementUtil.getRangeInMacroCall(element);
        if (rangeInMacroCall == null) {
            return true;
        }
        PsiElement prevLeaf = PsiTreeUtil.prevLeaf((PsiElement)element);
        PsiElement nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)element);
        PsiElement firstChild = PsiTreeUtil.firstChild((PsiElement)element);
        if (!(firstChild instanceof OCMacroForeignLeafElement)) {
            return false;
        }
        String macroName = ((OCMacroForeignLeafElement)firstChild).getMacroName();
        if (prevLeaf instanceof PsiErrorElement || nextLeaf instanceof PsiErrorElement) {
            return false;
        }
        if (prevLeaf instanceof OCMacroForeignLeafElement && Objects.equals(((OCMacroForeignLeafElement)prevLeaf).getMacroName(), macroName)) {
            return false;
        }
        return !(nextLeaf instanceof OCMacroForeignLeafElement) || !Objects.equals(((OCMacroForeignLeafElement)nextLeaf).getMacroName(), macroName);
    }

    @Nullable
    public static OCClassSymbol getClassInFile(OCFile file2) {
        final String fileName = FileUtilRt.getNameWithoutExtension((String)file2.getName());
        final OCClassSymbol[] result2 = new OCClassSymbol[]{null};
        file2.accept(new OCRecursiveVisitor(){

            @Override
            public void visitClassDeclaration(OCClassDeclaration dcl) {
                if (result2[0] == null || Objects.equals(dcl.getName(), fileName) && (!Objects.equals(result2[0].getName(), fileName) || dcl.getCategory() == null)) {
                    result2[0] = dcl.getSymbol();
                }
            }
        });
        return result2[0];
    }

    @Nullable
    public static OCExpression findExpressionAtRange(PsiFile file2, int startOffset, int endOffset) {
        return OCCodeInsightUtil.findElementAtRange(file2, startOffset, endOffset, OCExpression.class, true);
    }

    @Nullable
    public static <E extends PsiElement> E findElementAtRange(PsiFile file2, TextRange range, Class<E> elementClass, boolean requireExactRange) {
        return OCCodeInsightUtil.findElementAtRange(file2, range.getStartOffset(), range.getEndOffset(), elementClass, requireExactRange);
    }

    @Nullable
    public static <E extends PsiElement> E findElementAtRange(PsiFile file2, int startOffset, int endOffset, Class<E> elementClass, boolean requireExactRange) {
        PsiElement nameIdentifier;
        TextRange nodeRange;
        PsiElement parent;
        PsiElement node2 = file2.findElementAt(startOffset);
        while (node2 != null) {
            TextRange range = node2.getTextRange();
            if (range == null) {
                return null;
            }
            if (range.containsRange(startOffset, endOffset)) break;
            if (node2 instanceof OCMacroCall) {
                if ((node2 = ((OCMacroCall)node2).getExpansionExpression()) == null || range.getStartOffset() != startOffset) continue;
                startOffset = node2.getTextRange().getStartOffset();
                continue;
            }
            node2 = node2.getParent();
        }
        if ((parent = PsiTreeUtil.getNonStrictParentOfType((PsiElement)node2, (Class[])new Class[]{elementClass, OCMacroCall.class})) != null) {
            node2 = parent;
        }
        TextRange textRange = nodeRange = node2 != null ? node2.getTextRange() : null;
        if (node2 instanceof OCMacroCall) {
            node2 = ((OCMacroCall)node2).getExpansionExpression();
        }
        if (node2 instanceof OCMacroCallArgument && node2.getChildren().length >= 1) {
            node2 = node2.getChildren()[0];
        }
        if (elementClass.equals(OCExpression.class) && node2 instanceof OCExpressionStatement) {
            node2 = ((OCExpressionStatement)node2).getExpression();
            nodeRange = node2.getTextRange();
        }
        if (elementClass.equals(OCDeclarator.class) && node2 instanceof OCDeclarator && (nameIdentifier = ((OCDeclarator)node2).getNameIdentifier()) != null && nameIdentifier.getTextRange().equalsToRange(startOffset, endOffset)) {
            requireExactRange = false;
        }
        if (requireExactRange && nodeRange != null && !nodeRange.equalsToRange(startOffset, endOffset)) {
            return null;
        }
        return (E)(elementClass.isInstance(node2) ? node2 : null);
    }

    public static PsiElement @Nullable [] findStatementsAtRange(PsiFile file2, int startOffset, int endOffset, boolean requireExactRange) {
        PsiElement nextSibling;
        PsiElement lastItem;
        PsiElement element1 = file2.findElementAt(startOffset);
        PsiElement element2 = file2.findElementAt(endOffset - 1);
        if (element1 instanceof PsiWhiteSpace) {
            startOffset = element1.getTextRange().getEndOffset();
            element1 = file2.findElementAt(startOffset);
        }
        if (element2 instanceof PsiWhiteSpace) {
            endOffset = element2.getTextRange().getStartOffset();
            element2 = file2.findElementAt(endOffset - 1);
        }
        if (OCElementUtil.getElementType(element2) == OCTokenTypes.EOL_COMMENT && element1 != element2) {
            if ((element2 = element2.getNextSibling()) == null || element2.getTextRange() == null) {
                return null;
            }
            endOffset = element2.getTextRange().getEndOffset();
        }
        if (element1 == null || element2 == null) {
            return null;
        }
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
        if (parent == null) {
            return null;
        }
        while (!(parent instanceof OCBlockStatement) && !(parent instanceof OCCodeFragment)) {
            if (parent instanceof OCStatement) {
                parent = parent.getParent();
                break;
            }
            if (parent == null || parent instanceof OCFile) {
                return null;
            }
            parent = parent.getParent();
        }
        if (!parent.equals(element1)) {
            while (!parent.equals(element1.getParent())) {
                element1 = element1.getParent();
            }
        }
        if (requireExactRange && startOffset != element1.getTextRange().getStartOffset()) {
            return null;
        }
        if (!parent.equals(element2)) {
            while (!parent.equals(element2.getParent())) {
                element2 = element2.getParent();
            }
        }
        if (requireExactRange && endOffset != element2.getTextRange().getEndOffset() && (endOffset + 1 != element2.getTextRange().getEndOffset() || file2.getText().charAt(endOffset) != ';')) {
            return null;
        }
        if (parent instanceof OCBlockStatement && (requireExactRange ? parent.getFirstChild() == element1 && parent.getLastChild() == element2 : parent.getFirstChild() == element1 || parent.getLastChild() == element2)) {
            PsiElement[] psiElementArray;
            if (parent.getParent() instanceof OCCallable) {
                psiElementArray = null;
            } else {
                PsiElement[] psiElementArray2 = new PsiElement[1];
                psiElementArray = psiElementArray2;
                psiElementArray2[0] = parent;
            }
            return psiElementArray;
        }
        ArrayList<PsiElement> array = new ArrayList<PsiElement>();
        if (element2 instanceof OCMacroCall) {
            PsiElement nextSibling2 = element2.getNextSibling();
            element2 = nextSibling2 != null ? nextSibling2 : element2;
        }
        boolean flag = false;
        for (PsiElement child : OCElementUtil.getAllChildren(parent)) {
            if (child.equals(element1)) {
                flag = true;
            }
            if (flag && !(child instanceof OCMacroCall)) {
                array.add(child);
            }
            if (!child.equals(element2)) continue;
            break;
        }
        if ((lastItem = (PsiElement)ContainerUtil.getLastItem(array)) instanceof OCDirective && (nextSibling = lastItem.getNextSibling()) != null && OCElementUtil.isWhitespace(nextSibling)) {
            array.add(nextSibling);
        }
        for (PsiElement element : array) {
            if (element instanceof OCStatement || !OCElementUtil.isElementSignificant(element)) continue;
            return null;
        }
        return PsiUtilCore.toPsiElementArray(array);
    }

    public static <E extends PsiElement> List<E> findElementOccurrences(@Nullable PsiElement scope, @NotNull E element) {
        ArrayList<E> answer = new ArrayList<E>();
        if (!PsiTreeUtil.isAncestor((PsiElement)scope, element, (boolean)false)) {
            answer.add(element);
        }
        if (element instanceof OCExpression && OCElementUtil.getRangeInMacroCall(element) == null) {
            element = OCParenthesesUtils.diveIntoParentheses((OCExpression)element);
        }
        if (scope != null) {
            OCCodeInsightUtil.addOccurrencesIn(element, OCElementUtil.getElementType(element), scope, answer);
        }
        return answer;
    }

    private static <E extends PsiElement> void addOccurrencesIn(E element, IElementType elementType, PsiElement scope, List<E> answer) {
        if (OCElementUtil.getElementType(scope) == elementType && OCElementUtil.areElementsEquivalent(element, scope, false)) {
            if (scope instanceof OCExpression) {
                scope = OCParenthesesUtils.topmostParenthesized((OCExpression)scope);
            }
            answer.add(scope);
        } else {
            for (PsiElement c : scope.getChildren()) {
                OCCodeInsightUtil.addOccurrencesIn(element, elementType, c, answer);
            }
        }
    }

    public static boolean isLValue(OCExpression expr) {
        return OCLValueUtil.isLValue(expr);
    }

    public static boolean isAssignmentLHS(OCExpression expr) {
        return OCLValueUtil.isAssignmentLHS(expr);
    }

    public static boolean hasSideEffects(@NotNull PsiElement element) {
        final Ref result2 = Ref.create((Object)false);
        element.accept((PsiElementVisitor)new OCRecursiveVisitor(){

            @Override
            public void visitPrefixExpression(OCPrefixExpression expression) {
                if (expression.getOperationSign() == OCTokenTypes.PLUSPLUS || expression.getOperationSign() == OCTokenTypes.MINUSMINUS) {
                    result2.set((Object)true);
                } else {
                    super.visitPrefixExpression(expression);
                }
            }

            @Override
            public void visitPostfixExpression(OCPostfixExpression expression) {
                if (expression.getOperationSign() == OCTokenTypes.PLUSPLUS || expression.getOperationSign() == OCTokenTypes.MINUSMINUS) {
                    result2.set((Object)true);
                } else {
                    super.visitPostfixExpression(expression);
                }
            }

            @Override
            public void visitAssignmentExpression(OCAssignmentExpression expression) {
                result2.set((Object)true);
            }

            @Override
            public void visitCallExpression(OCCallExpression expression) {
                result2.set((Object)true);
            }

            @Override
            public void visitSendMessageExpression(OCSendMessageExpression expression) {
                result2.set((Object)true);
            }

            @Override
            public void visitBlockExpression(OCBlockExpression blockExpression) {
                result2.set((Object)true);
            }

            @Override
            public void visitLambdaExpression(OCLambdaExpression lambdaExpression) {
                result2.set((Object)true);
            }

            @Override
            public void visitStatementExpression(OCStatementExpression statementExpression) {
                result2.set((Object)true);
            }

            @Override
            public void visitCppNewExpression(OCCppNewExpression expression) {
                result2.set((Object)true);
            }
        });
        return (Boolean)result2.get();
    }

    public static <E extends PsiElement> void collectElements(PsiFile file2, Editor editor, int offset, Class<E> elementClass, List<? super E> elements) {
        Document document2 = editor.getDocument();
        CharSequence text = document2.getCharsSequence();
        int correctedOffset = offset;
        int textLength = document2.getTextLength();
        if (offset >= textLength) {
            correctedOffset = textLength - 1;
        } else if (!Character.isJavaIdentifierPart(text.charAt(offset))) {
            --correctedOffset;
        }
        if (correctedOffset < 0) {
            correctedOffset = offset;
        } else if (!Character.isJavaIdentifierPart(text.charAt(correctedOffset))) {
            if (text.charAt(correctedOffset) == ';') {
                --correctedOffset;
            }
            if (text.charAt(correctedOffset) != ')') {
                correctedOffset = offset;
            }
        }
        PsiElement elementAtCaret = file2.findElementAt(correctedOffset);
        PsiElement context2 = OCCodeInsightUtil.getElementOrMacroCall(elementAtCaret, elementClass);
        while (context2 != null) {
            PsiElement element;
            if (!elementClass.isInstance(context2)) {
                if (!(context2 instanceof OCMacroCall)) break;
                if (elementClass.equals(OCExpression.class) && (element = ((OCMacroCall)context2).getExpansionExpression()) != null) {
                    elements.add(element);
                }
                context2 = OCCodeInsightUtil.getElementOrMacroCall(context2, elementClass);
                continue;
            }
            element = context2;
            if (!(elements.contains(element) || element instanceof OCParenthesizedExpression || element instanceof OCAssignmentExpression || element instanceof OCExpression && ((OCExpression)element).getResolvedType().isVoid() || element instanceof OCReferenceExpression && ((OCReferenceExpression)element).getResolvedType() instanceof OCObjectType)) {
                elements.add(element);
            }
            context2 = OCCodeInsightUtil.getElementOrMacroCall(context2, elementClass);
        }
    }

    @Nullable
    private static <E extends PsiElement> PsiElement getElementOrMacroCall(PsiElement context2, Class<E> elementClass) {
        return PsiTreeUtil.getContextOfType((PsiElement)context2, (Class[])new Class[]{elementClass, OCMacroCall.class});
    }

    public static boolean isUniqueInScope(@Nullable OCSymbolKind symbolKind, String name, @Nullable PsiElement scope, @NotNull Project project2) {
        return OCCodeInsightUtil.resolveNameInScope(symbolKind, name, null, scope, project2) == null;
    }

    public static OCSymbol resolveNameInScope(final @Nullable OCSymbolKind symbolKind, final String name, final @Nullable String categoryName, @Nullable PsiElement scope, @NotNull Project project2) {
        CommonProcessors.FindFirstProcessor<OCSymbol> processor2 = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol symbol) {
                if (symbol.isSynthetic()) {
                    return false;
                }
                if (categoryName != null && symbol instanceof OCClassSymbol && !categoryName.equals(((OCClassSymbol)symbol).getCategoryName())) {
                    return false;
                }
                return symbolKind == null || OCResolveUtil.isDuplicate(symbolKind, symbol.getKind());
            }
        };
        if (scope == null) {
            OCGlobalProjectSymbolsCache.processTopLevelSymbols(project2, (Processor<? super OCSymbol>)processor2, name);
        } else {
            OCResolveUtil.processSymbols(name, scope, (Processor<OCSymbol>)processor2);
        }
        if (processor2.isFound()) {
            return (OCSymbol)processor2.getFoundValue();
        }
        PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)scope, (Class[])new Class[]{OCLocalScopeable.class, OCFile.class, OCBlockExpression.class, OCLambdaExpression.class});
        if (element == null || element instanceof OCBlockExpression || element instanceof OCLambdaExpression || symbolKind == OCSymbolKind.PARAMETER && !(element instanceof OCCallable)) {
            return null;
        }
        element.accept((PsiElementVisitor)new OCRecursiveVisitor((CommonProcessors.FindFirstProcessor)processor2, scope){
            final /* synthetic */ CommonProcessors.FindFirstProcessor val$processor;
            final /* synthetic */ PsiElement val$scope;
            {
                this.val$processor = findFirstProcessor;
                this.val$scope = psiElement;
            }

            @Override
            public void visitSymbolDeclarator(OCSymbolDeclarator declarator) {
                String symbolName;
                Object symbol = declarator.getSymbol();
                if (symbol != null && name.equals(symbolName = symbol.getName())) {
                    this.val$processor.process(symbol);
                }
            }

            @Override
            public void visitBlockStatement(OCBlockStatement stmt) {
                if (OCSymbolOffsetUtil.getComplexOffset(this.val$scope) < OCSymbolOffsetUtil.getComplexRange(stmt).getEndOffset()) {
                    super.visitBlockStatement(stmt);
                }
            }
        });
        return (OCSymbol)processor2.getFoundValue();
    }

    @Nullable
    public static Editor openInEditor(@NotNull PsiElement element) {
        PsiFile file2 = element.getContainingFile();
        if (file2 == null) {
            return null;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        Project project2 = element.getProject();
        int offset = element instanceof PsiFile ? -1 : element.getTextOffset();
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project2, virtualFile, offset);
        return FileEditorManager.getInstance((Project)project2).openTextEditor(descriptor, true);
    }

    public static boolean showCallableInEditorAndSelectBody(@NotNull PsiFile file2, @NotNull Segment segment, @NotNull Condition<? super OCBlockStatement> condition) {
        class MyVisitor
        extends OCRecursiveVisitor {
            public boolean found;
            private final TextRange myRange;
            final /* synthetic */ Condition val$condition;

            MyVisitor(TextRange textRange) {
                this.val$condition = textRange;
                super(range);
                this.found = false;
                this.myRange = range;
            }

            @Override
            public void visitElement(@NotNull PsiElement element) {
                if (!this.found) {
                    OCBlockStatement body;
                    if (!this.myRange.intersectsStrict(element.getTextRange())) {
                        return;
                    }
                    OCCallable callable = (OCCallable)PsiTreeUtil.getContextOfType((PsiElement)element, (boolean)false, (Class[])new Class[]{OCCallable.class});
                    if (callable != null && (body = callable.getBody()) != null && this.val$condition.value((Object)body)) {
                        this.found = true;
                        Editor editor = OCCodeInsightUtil.openInEditor(body);
                        if (editor != null) {
                            OCCodeInsightUtil.selectBody(editor, body);
                        }
                    }
                }
                super.visitElement(element);
            }
        }
        MyVisitor visitor = new MyVisitor(TextRange.create((Segment)segment), condition);
        file2.accept((PsiElementVisitor)visitor);
        return visitor.found;
    }

    public static void selectBody(Editor editor, OCBlockStatement body) {
        if (body == null) {
            return;
        }
        ASTNode firstNode = body.getNode().getFirstChildNode().getTreeNext();
        ASTNode lastNode = body.getNode().getLastChildNode().getTreePrev();
        while (OCTokenTypes.WHITESPACES.contains(firstNode.getElementType())) {
            firstNode = firstNode.getTreeNext();
        }
        while (OCTokenTypes.WHITESPACES.contains(lastNode.getElementType())) {
            lastNode = lastNode.getTreePrev();
        }
        if (firstNode != body.getNode().getLastChildNode()) {
            OCCodeInsightUtil.selectRange(editor, firstNode.getStartOffset(), lastNode.getTextRange().getEndOffset());
        } else {
            OCCodeInsightUtil.selectRange(editor, body.getTextOffset() + 1, body.getTextOffset() + 1);
        }
    }

    public static void selectElement(PsiElement element) {
        if (element == null) {
            return;
        }
        Editor editor = EditorHelper.openInEditor((PsiElement)element);
        if (editor != null) {
            OCCodeInsightUtil.selectRange(editor, element.getTextRange().getStartOffset(), element.getTextRange().getEndOffset());
        }
    }

    public static void selectRange(Editor editor, int startOffset, int endOffset) {
        editor.getCaretModel().moveToOffset(startOffset);
        editor.getSelectionModel().setSelection(startOffset, endOffset);
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
    }

    public static String getClassNameWithCategory(String className, String categoryName) {
        if (categoryName == null) {
            return className;
        }
        StringBuilder builder2 = new StringBuilder(className.length() + categoryName.length() + 3);
        builder2.append(className).append(" + ").append(categoryName.isEmpty() ? "()" : categoryName);
        return builder2.toString();
    }

    @Nullable
    public static OCClassDeclaration getPrivateCategory(OCClassDeclarationBase declaration) {
        for (PsiElement child : declaration.getContainingFile().getChildren()) {
            if (!(child instanceof OCClassDeclaration)) continue;
            OCClassDeclaration category = (OCClassDeclaration)child;
            if (!declaration.getName().equals(category.getName()) || !"".equals(category.getCategory())) continue;
            return category;
        }
        return null;
    }

    @NotNull
    public static Pair<MemberBeginEndSearchResult, OCType> getReturnTypeOfBeginEndPair(OCExpression expr, @NotNull OCStructType structType, @NotNull OCFile file2) {
        OCResolveContext context2 = OCResolveContext.forPsi(file2);
        CVQualifiers cvQualifiers = OCCodeInsightUtil.getCVQualifiers(expr, structType);
        OCType leftType = structType.cloneWithAddedCVQualifiers(cvQualifiers, file2.getProject());
        Collection<OCSymbol> beginSymbols = structType.collectMethods("begin", context2);
        OCSymbol beginSymbol = OCResolveOverloadsUtil.resolveOverloads(beginSymbols, new OCArgumentsList(Collections.emptyList(), null), leftType, null, null, true, true, context2, expr);
        Collection<OCSymbol> endSymbols = structType.collectMethods("end", context2);
        OCSymbol endSymbol = OCResolveOverloadsUtil.resolveOverloads(endSymbols, new OCArgumentsList(Collections.emptyList(), null), leftType, null, null, true, true, context2, expr);
        if (beginSymbol == null && endSymbol == null) {
            return Pair.create((Object)((Object)MemberBeginEndSearchResult.NONE), null);
        }
        if (beginSymbol == null || endSymbol == null) {
            return Pair.create((Object)((Object)MemberBeginEndSearchResult.INVALID), null);
        }
        assert (beginSymbol instanceof OCFunctionSymbol);
        OCType beginReturnType = beginSymbol.getEffectiveType(context2.getProject()).resolve(context2);
        assert (endSymbol instanceof OCFunctionSymbol);
        OCType endReturnType = beginSymbol.getEffectiveType(context2.getProject()).resolve(context2);
        if (endReturnType.equals(beginReturnType, context2)) {
            return Pair.create((Object)((Object)MemberBeginEndSearchResult.OK), (Object)beginReturnType);
        }
        return Pair.create((Object)((Object)MemberBeginEndSearchResult.NONE), null);
    }

    public static boolean isCodeInsightAvailable(@NotNull VirtualFile file2, @NotNull Project project2) {
        long textLength = file2.getLength();
        if (textLength < 0L) {
            return false;
        }
        if (textLength <= (long)OCCodeInsightUtil.getMaxFileLength()) {
            return true;
        }
        return OCCodeInsightUtil.isLibraryFile(project2, file2);
    }

    private static boolean isKnownSignificantLongFile(@NotNull VirtualFile virtualFile) {
        return StringUtil.startsWithIgnoreCase((String)virtualFile.getName(), (String)"catch.h");
    }

    public static boolean isCodeInsightAvailable(@NotNull PsiFile file2) {
        long textLength = file2.getViewProvider().getVirtualFile().getLength();
        if (textLength < 0L) {
            return false;
        }
        if (textLength <= (long)OCCodeInsightUtil.getMaxFileLength()) {
            return true;
        }
        return OCCodeInsightUtil.isLibraryFile(file2.getProject(), OCInclusionContextUtil.getVirtualFile(file2));
    }

    protected static boolean isLibraryFile(@NotNull Project project2, @NotNull VirtualFile virtualFile) {
        return OCCodeInsightUtil.isKnownSignificantLongFile(virtualFile) || ProjectScope.getLibrariesScope((Project)project2).contains(virtualFile);
    }

    public static boolean isCodeInsightAvailable(int fileLength, boolean isLibraryFile) {
        return fileLength >= 0 && (isLibraryFile || fileLength <= OCCodeInsightUtil.getMaxFileLength());
    }

    public static boolean isPreProcessable(@NotNull VirtualFile file2, @NotNull Project project2) {
        SymbolTableProvider provider2 = SymbolTableProvider.findProvider(project2, file2);
        return provider2 != null && provider2.shouldPreProcess();
    }

    public static int getMaxFileLength() {
        return Registry.intValue((String)MAX_LENGTH_KEY, (int)500000);
    }

    public static void setMaxFileLength(int newValue) {
        if (newValue > 0) {
            Registry.get((String)MAX_LENGTH_KEY).setValue(newValue);
        }
    }

    public static void resetMaxFileLength() {
        Registry.get((String)MAX_LENGTH_KEY).resetToDefault();
    }

    public static boolean isNonStaticFieldAccess(@NotNull OCDeclaratorSymbol symbol, @NotNull OCStructSymbol parent, @NotNull OCExpression expression) {
        return !symbol.isFriendOrStatic() && !symbol.isMutable() && OCCodeInsightUtil.isMemberAccess(symbol, parent, expression);
    }

    public static boolean isMemberAccess(@NotNull OCSymbolWithQualifiedName symbol, @NotNull OCStructSymbol parent, @NotNull OCExpression expression) {
        if (symbol instanceof OCThisSelfSuperSymbol) {
            return true;
        }
        if (!(symbol instanceof OCFunctionSymbol) && symbol.getKind() != OCSymbolKind.STRUCT_FIELD) {
            return false;
        }
        OCResolveContext context2 = OCResolveContext.forPsi(expression);
        OCSymbolWithQualifiedName memberParent = symbol.getResolvedOwner(context2);
        if (!(memberParent instanceof OCStructSymbol) || !((OCStructSymbol)memberParent).isAncestor(parent, context2)) {
            return false;
        }
        return expression instanceof OCReferenceExpression || expression instanceof OCQualifiedExpression && ((OCQualifiedExpression)expression).getQualifier() instanceof OCReferenceExpression && ((OCReferenceExpression)((OCQualifiedExpression)expression).getQualifier()).isCppThis();
    }

    @Nullable
    public static CVQualifiers getOuterFunctionCVQualifiers(@NotNull OCDeclaratorSymbol symbol, @NotNull OCExpression expression, @Nullable Ref<? super OCFunctionSymbol> functionSymbolRef) {
        OCSymbolWithQualifiedName parent;
        OCFunctionSymbol functionSymbol;
        OCFunctionDefinition function = (OCFunctionDefinition)PsiTreeUtil.getParentOfType((PsiElement)expression, OCFunctionDefinition.class);
        OCFunctionSymbol oCFunctionSymbol = functionSymbol = function != null ? function.getSymbol() : null;
        if (functionSymbolRef != null) {
            functionSymbolRef.set((Object)functionSymbol);
        }
        if (functionSymbol != null && (parent = functionSymbol.getResolvedOwner(OCResolveContext.forPsi(expression))) instanceof OCStructSymbol && OCCodeInsightUtil.isNonStaticFieldAccess(symbol, (OCStructSymbol)parent, expression)) {
            return functionSymbol.getType().getCVQualifiers();
        }
        return null;
    }

    @NotNull
    public static CVQualifiers getCVQualifiers(OCExpression expression, OCType type) {
        boolean considerOuterFunction = type instanceof OCStructType;
        CVQualifiers modifiers = type.getTerminalType().getCVQualifiers();
        if (considerOuterFunction && expression instanceof OCReferenceExpression) {
            CVQualifiers functionCVQualifiers;
            OCSymbol symbol = ((OCReferenceExpression)expression).resolveToSymbol();
            CVQualifiers cVQualifiers = functionCVQualifiers = symbol instanceof OCDeclaratorSymbol ? OCCodeInsightUtil.getOuterFunctionCVQualifiers((OCDeclaratorSymbol)symbol, expression, null) : null;
            if (functionCVQualifiers != null) {
                modifiers = modifiers.or(functionCVQualifiers);
            }
        }
        return modifiers;
    }

    @NotNull
    public static String getPrettyNameFromClassName(@NotNull Class<?> clazz) {
        String className = clazz.getSimpleName();
        if (clazz.isAnonymousClass()) {
            className = clazz.getSuperclass().getSimpleName();
        }
        return OCCodeInsightUtil.getPrettyNameFromClassName(className);
    }

    @NotNull
    public static String getPrettyNameFromClassName(@NotNull String className) {
        StringBuilder result2 = new StringBuilder();
        className = StringUtil.trimStart((String)className, (String)"OC");
        className = StringUtil.trimEnd((String)className, (String)"Inspection");
        className = StringUtil.trimEnd((String)className, (String)"IntentionAction");
        for (String word : StringUtil.findMatches((String)className, (Pattern)Pattern.compile("([A-Z][a-z]*)"))) {
            if (result2.length() > 0) {
                result2.append(' ').append(StringUtil.decapitalize((String)word));
                continue;
            }
            result2.append(word);
        }
        return result2.toString();
    }

    public static boolean isLikeNull(@Nullable String literal) {
        return literal != null && ("nil".equals(literal) || "NULL".equals(literal) || "nullptr".equals(literal));
    }

    public static boolean isStdInitializerListType(OCType type, @NotNull OCResolveContext context2) {
        if (OCCompilerFeaturesHelper.supportsInitializerLists(context2.getFile()) && type instanceof OCStructType) {
            OCStructSymbol symbol = ((OCStructType)type).getSymbol();
            OCQualifiedName name = symbol.getResolvedQualifiedNameWithoutArguments(context2);
            return name != null && name.getFullName(context2).equals("::std::initializer_list");
        }
        return false;
    }

    @Nullable
    public static OCType getStdInitializerListTemplateParameter(OCType type, @NotNull OCResolveContext context2) {
        OCStructSymbol paramTypeSymbol;
        if (OCCodeInsightUtil.isStdInitializerListType(type, context2) && (paramTypeSymbol = ((OCStructType)type).getSymbol()).getTemplateParameters().size() == 1) {
            OCTypeParameterSymbol parameterSymbol = paramTypeSymbol.getTemplateParameters().get(0);
            OCTypeArgument paramSubstitution = paramTypeSymbol.getSubstitution().getSubstitutionFor(parameterSymbol);
            if (paramSubstitution instanceof OCType) {
                return (OCType)paramSubstitution;
            }
        }
        return null;
    }

    public static boolean isSimpleDeclaration(String declarationText, String name) {
        return "<unnamed>".equals(name) || declarationText.endsWith(name);
    }

    @Nullable
    public static OCType getCollectionElementType(@NotNull OCExpression expr, OCType type) {
        OCFile file2 = expr.getContainingOCFile();
        OCResolveContext context2 = OCResolveContext.forPsi(expr);
        if (type instanceof OCCppReferenceType) {
            type = ((OCCppReferenceType)type).getRefType();
        }
        OCType iteratorType = null;
        if (type instanceof OCArrayType) {
            iteratorType = type;
        } else {
            if (type instanceof OCBracedInitListType && expr instanceof OCCompoundInitializer) {
                List<OCExpression> initializers = ((OCCompoundInitializer)expr).getInitializerExpressions();
                if (initializers.isEmpty()) {
                    return null;
                }
                return initializers.get(0).getResolvedType(context2).cloneWithConstModifier(context2.getProject());
            }
            Pair<MemberBeginEndSearchResult, OCType> result2 = type instanceof OCStructType ? OCCodeInsightUtil.getReturnTypeOfBeginEndPair(expr, (OCStructType)type, file2) : Pair.create((Object)((Object)MemberBeginEndSearchResult.NONE), null);
            switch ((MemberBeginEndSearchResult)((Object)result2.getFirst())) {
                case NONE: {
                    OCSymbol begin = OCCodeInsightUtil.getGlobalBeginOrEnd("begin", type, expr, file2, context2);
                    OCSymbol end = OCCodeInsightUtil.getGlobalBeginOrEnd("end", type, expr, file2, context2);
                    if (begin != null && end != null) {
                        OCType endReturnType;
                        assert (begin instanceof OCFunctionSymbol);
                        assert (end instanceof OCFunctionSymbol);
                        OCType beginReturnType = begin.getEffectiveType(context2.getProject()).resolve(context2);
                        if (beginReturnType.equals(endReturnType = end.getEffectiveType(context2.getProject()).resolve(context2), context2)) {
                            iteratorType = beginReturnType;
                        }
                    }
                }
                case INVALID: {
                    break;
                }
                case OK: {
                    iteratorType = (OCType)result2.getSecond();
                }
            }
        }
        return OCCodeInsightUtil.getDereferencedType(expr, iteratorType);
    }

    @Nullable
    private static OCSymbol getGlobalBeginOrEnd(@NotNull String methodName, @NotNull OCType type, @NotNull OCExpression expr, @NotNull OCFile file2, @NotNull OCResolveContext context2) {
        OCQualifiedName beginName = OCQualifiedName.interned(methodName);
        List<OCSymbol> symbols = new ArrayList<OCSymbol>(OCSymbolReference.getDummyGlobalReference(beginName).resolveToSymbols(OCResolveContext.forPsi(file2)));
        symbols = ContainerUtil.filter(symbols, symbol -> symbol instanceof OCFunctionSymbol);
        List<OCType> argTypes = Collections.singletonList(type);
        Collection<OCSymbol> symbolsWithADL = OCArgumentDepLookupAccumulator.doArgDepLookup(symbols, argTypes, Collections.singletonList(expr), beginName, context2);
        OCArgumentsList<OCValueCategoryHolder> arguments = new OCArgumentsList<OCValueCategoryHolder>(argTypes, Collections.singletonList(new OCValueCategoryHolder(type, OCExprValueCategory.LValue)));
        return OCResolveOverloadsUtil.resolveOverloads(symbolsWithADL, arguments, null, null, null, true, true, context2, expr);
    }

    @Nullable
    public static OCType getDereferencedType(@NotNull OCExpression expr, @Nullable OCType iteratorType) {
        if (iteratorType instanceof OCPointerType) {
            return ((OCPointerType)iteratorType).getRefType();
        }
        if (iteratorType instanceof OCStructType) {
            OCFunctionSymbol operator = OCOperatorReference.resolveOperator("*", OCOperatorReference.OperatorPlacement.PREFIX, expr, (OCStructType)iteratorType);
            return operator != null ? operator.getEffectiveType(expr).resolve(expr) : null;
        }
        if (iteratorType instanceof OCMagicType) {
            return new OCMagicType();
        }
        return null;
    }

    public static boolean isUnnamed(OCDeclaratorSymbol field) {
        OCType fieldType = field.getType();
        return fieldType instanceof OCStructType && ((OCStructType)fieldType).isUnnamed();
    }

    @Nullable
    public static OCElementType getOppositeOperator(@NotNull OCElementType operator) {
        return oppositeOperators.get((Object)operator);
    }

    @Nullable
    public static OCElementType getFlippedOperator(@NotNull OCElementType operator) {
        return flippedOperators.get((Object)operator);
    }

    @Nullable
    public static OCElementType getInversedLogicalOperator(@NotNull OCElementType operator) {
        return inversedLogicalOperators.get((Object)operator);
    }

    public static boolean insideLoopHeader(@NotNull PsiElement element) {
        OCLoopStatement parent = (OCLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)element, OCLoopStatement.class);
        if (parent instanceof OCForeachStatement) {
            OCForeachStatement foreachStatement = (OCForeachStatement)parent;
            return PsiTreeUtil.isAncestor((PsiElement)foreachStatement.getVariableDeclaration(), (PsiElement)element, (boolean)false);
        }
        if (parent instanceof OCForStatement) {
            OCForStatement forStatement = (OCForStatement)parent;
            return PsiTreeUtil.isAncestor((PsiElement)forStatement.getInitializer(), (PsiElement)element, (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)forStatement.getCondition(), (PsiElement)element, (boolean)false);
        }
        if (parent != null) {
            return PsiTreeUtil.isAncestor((PsiElement)parent.getCondition(), (PsiElement)element, (boolean)false);
        }
        return false;
    }

    public static boolean insideConditionalHeader(@NotNull PsiElement element) {
        OCStatement parent = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{OCIfStatement.class, OCSwitchStatement.class});
        if (parent instanceof OCIfStatement) {
            OCIfStatement ifStatement = (OCIfStatement)parent;
            return PsiTreeUtil.isAncestor((PsiElement)ifStatement.getCondition(), (PsiElement)element, (boolean)false);
        }
        if (parent instanceof OCSwitchStatement) {
            OCSwitchStatement switchStatement = (OCSwitchStatement)parent;
            return PsiTreeUtil.isAncestor((PsiElement)switchStatement.getExpression(), (PsiElement)element, (boolean)false);
        }
        return false;
    }

    public static Set<PsiNamedElement> collectDeclarators(@NotNull PsiElement element) {
        final HashSet<PsiNamedElement> declarators = new HashSet<PsiNamedElement>();
        element.accept((PsiElementVisitor)new OCRecursiveVisitor(){

            @Override
            public void visitDeclarator(OCDeclarator declarator) {
                super.visitDeclarator(declarator);
                if (declarator.getSymbol() != null && !declarator.getSymbol().isUnnamed()) {
                    declarators.add(declarator);
                }
            }

            @Override
            public void visitMethodSelectorPart(OCMethodSelectorPart part) {
                if (part.getSymbol() != null && !((OCDeclaratorSymbol)part.getSymbol()).isUnnamed()) {
                    declarators.add(part);
                }
            }
        });
        return declarators;
    }

    public static List<PsiElement> getReferences(@NotNull PsiNamedElement declarator) {
        return ContainerUtil.mapNotNull((Collection)ReferencesSearch.search((PsiElement)declarator, (SearchScope)declarator.getUseScope()).findAll(), PsiReference::getElement);
    }

    public static void renameDeclaratorAndUsages(@NotNull PsiNamedElement declarator, @NotNull String newDeclaratorName, @Nullable List<? extends PsiElement> usages) {
        if (newDeclaratorName.equals(declarator.getName())) {
            return;
        }
        if (usages != null) {
            for (PsiElement psiElement : usages) {
                if (!(psiElement instanceof OCReferenceElement) || OCElementUtil.isPartOfMacroSubstitution(psiElement)) continue;
                ((OCReferenceElement)psiElement).setNameOfIdentifier(newDeclaratorName);
            }
        }
        declarator.setName(newDeclaratorName);
    }

    public static boolean isOverloadedOperatorUsage(@NotNull OCExpression expression) {
        PsiReference reference = expression.getReference();
        return reference instanceof OCOperatorReference && !((OCOperatorReference)reference).resolveToSymbolsViaClang().isEmpty();
    }

    public static boolean isStaticallyEvaluated(@NotNull PsiElement element) {
        for (PsiElement parent = element.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof OCSizeofExpression || parent instanceof OCCppTypeidExpression || parent instanceof OCGenericSelectionExpression) {
                return true;
            }
            if (parent instanceof OCCppNamespaceQualifier && OCCodeInsightUtil.hasAnyChildOfType(parent, OCTokenTypes.DECLTYPE_CPP_KEYWORD)) {
                return true;
            }
            if (!(parent instanceof OCTypeElement) || !OCCodeInsightUtil.hasAnyChildOfType(parent, OCTokenTypes.TYPEOF_KEYWORD, OCTokenTypes.DECLTYPE_CPP_KEYWORD)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasAnyChildOfType(PsiElement parent, IElementType ... types) {
        return Arrays.stream(parent.getNode().getChildren(null)).map(OCElementUtil::getElementType).anyMatch(elementType -> {
            for (IElementType type : types) {
                if (type != elementType) continue;
                return true;
            }
            return false;
        });
    }

    static class CancelException
    extends RuntimeException {
        private final OCSymbolDeclarator myDeclarator;

        CancelException(OCSymbolDeclarator declarator) {
            this.myDeclarator = declarator;
        }

        public OCSymbolDeclarator getDeclarator() {
            return this.myDeclarator;
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    public static enum MemberBeginEndSearchResult {
        NONE,
        INVALID,
        OK;

    }
}

