/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.application.options.CodeStyle;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.FilteredQuery;
import com.intellij.util.Query;
import com.jetbrains.cidr.lang.generate.OCCppGeneratedQualifiedFunctionKt;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.search.OCFunctionAncestorsQuery;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.ComplexTextRange;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolAttribute;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterTypeSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCBooleanTypeVisitor;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCallableUtil {
    public static final String IMPLEMENTED_METHOD_TEMPLATE_NAME = "OC Implemented Method Body.m";
    public static final String OVERRIDDEN_METHOD_TEMPLATE_NAME = "OC Overridden Method Body.m";
    private static final String OVERRIDDEN_INIT_METHOD_TEMPLATE_NAME = "OC Overridden InitWith Method Body.m";
    private static final String OVERRIDDEN_IS_EQUAL_METHOD_TEMPLATE_NAME = "OC Overridden IsEqual Method Body.m";
    public static final String OVERRIDDEN_DESCRIPTION_TEMPLATE_NAME1 = "OC Overridden Description Body 1.m";
    public static final String OVERRIDDEN_DESCRIPTION_TEMPLATE_NAME2 = "OC Overridden Description Body 2.m";
    public static final String OVERRIDDEN_DESCRIPTION_TEMPLATE_NAME3 = "OC Overridden Description Body 3.m";
    public static final String OVERRIDDEN_COPY_TEMPLATE_NAME1 = "OC Overridden CopyWithZone Body 1.m";
    public static final String OVERRIDDEN_COPY_TEMPLATE_NAME2 = "OC Overridden CopyWithZone Body 2.m";
    public static final String OVERRIDDEN_COPY_TEMPLATE_NAME3 = "OC Overridden CopyWithZone Body 3.m";
    private static final String PROPERTY_GETTER_TEMPLATE_NAME = "OC Property Getter Body.m";
    private static final String PROPERTY_SETTER_TEMPLATE_NAME = "OC Property Setter Body.m";
    private static final String CPP_IMPLEMENTED_FUNCTION_TEMPLATE_NAME = "C++ Implemented Function Body.cc";
    private static final String CPP_OVERRIDDEN_FUNCTION_TEMPLATE_NAME = "C++ Overridden Function Body.cc";
    private static final String CONTAINING_CLASS_TEMPLATE_PROPERTY = "CONTAINING_CLASS";
    private static final String RETURN_TYPE_TEMPLATE_PROPERTY = "RETURN_TYPE";
    private static final String DEFAULT_RETURN_VALUE_TEMPLATE_PROPERTY = "DEFAULT_RETURN_VALUE";
    private static final String CALL_SUPER_TEMPLATE_PROPERTY = "CALL_SUPER";
    private static final String CUSTOM_CODE_TEMPLATE_PROPERTY = "CUSTOM_CODE";
    public static final String IVAR_IS_AVAILABLE_TEMPLATE_PROPERTY = "IVAR_IS_AVAILABLE";
    private static final String IVAR_TEMPLATE_PROPERTY = "IVAR";
    private static final String PARAM_TEMPLATE_PROPERTY = "PARAM";
    private static final String SETTER_SEMANTICS_TEMPLATE_PROPERTY = "SETTER_SEMANTICS";

    private OCCallableUtil() {
    }

    public static String methodText(@NotNull OCMethodSymbol baseMethod, String customCode, @NotNull PsiElement context2) {
        return OCCallableUtil.methodText(baseMethod, null, OCCallableUtil.methodSignature(baseMethod, context2, OCResolveContext.forPsi(context2)), customCode, context2);
    }

    public static String methodFromTemplate(@NotNull OCMethodSymbol baseMethod, String customTemplate, PsiElement context2, @Nullable Map<String, String> customProperties, @NotNull Project project2) {
        OCResolveContext resolveContext = context2 != null ? OCResolveContext.forPsi(context2) : OCResolveContext.forSymbol(baseMethod, project2);
        OCType returnType = baseMethod.getReturnType(resolveContext.getProject()).resolve(resolveContext);
        return OCCallableUtil.methodText(baseMethod, returnType, customTemplate, OCCallableUtil.methodSignature(baseMethod, context2, resolveContext), "", context2, customProperties);
    }

    public static String methodFromTemplate(@NotNull OCMethodSymbol baseMethod, String customTemplate, String customCode, @NotNull PsiElement context2) {
        return OCCallableUtil.methodText(baseMethod, customTemplate, OCCallableUtil.methodSignature(baseMethod, context2, OCResolveContext.forPsi(context2)), customCode, context2);
    }

    public static String methodWithSignature(@NotNull OCType returnType, String signature, PsiElement context2) {
        return OCCallableUtil.methodText(null, returnType, IMPLEMENTED_METHOD_TEMPLATE_NAME, signature, "", context2, null);
    }

    public static String functionWithSignature(@NotNull OCType returnType, String signature, @NotNull PsiElement context2) {
        StringBuilder answer = new StringBuilder();
        answer.append(signature).append("{\n ");
        FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance((Project)context2.getProject());
        FileTemplate bodyTemplate = fileTemplateManager.getCodeTemplate(CPP_IMPLEMENTED_FUNCTION_TEMPLATE_NAME);
        Properties templateProperties = new Properties(FileTemplateManager.getInstance((Project)context2.getProject()).getDefaultProperties());
        OCResolveContext resolveContext = OCResolveContext.forPsi(context2);
        OCType resolved = returnType.resolve(resolveContext);
        templateProperties.setProperty(RETURN_TYPE_TEMPLATE_PROPERTY, resolved.getBestNameInContext(resolveContext));
        templateProperties.setProperty(DEFAULT_RETURN_VALUE_TEMPLATE_PROPERTY, resolved.getDefaultValue(resolveContext));
        try {
            answer.append(bodyTemplate.getText(templateProperties));
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Unable to load template for file template '%s'!", fileTemplateManager.internalTemplateToSubject(CPP_IMPLEMENTED_FUNCTION_TEMPLATE_NAME)), e);
        }
        answer.append("\n}\n");
        return answer.toString();
    }

    public static String methodWithSignature(@NotNull OCMethodSymbol baseMethod, String signature, String customCode, @NotNull PsiElement context2) {
        return OCCallableUtil.methodText(baseMethod, null, signature, customCode, context2);
    }

    public static String methodText(@NotNull OCMethodSymbol baseMethod, String customTemplate, String signature, String customCode, @NotNull PsiElement context2) {
        OCType returnType = baseMethod.getReturnType(context2.getProject()).resolve(OCResolveContext.forSymbol(baseMethod, context2.getProject()));
        return OCCallableUtil.methodText(baseMethod, returnType, customTemplate, signature, customCode, context2, null);
    }

    public static String methodText(@NotNull String signature, @NotNull String body, @NotNull PsiElement context2) {
        StringBuilder answer = new StringBuilder();
        answer.append(signature);
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)context2.getContainingFile(), OCCodeStyleSettings.class);
        if (settings.SEMICOLON_AFTER_METHOD_SIGNATURE) {
            answer.append(";");
        }
        answer.append("{\n ");
        answer.append(body);
        answer.append("\n}\n");
        return answer.toString();
    }

    private static String methodText(@Nullable OCMethodSymbol baseMethod, @NotNull OCType returnType, @Nullable String customTemplate, String signature, String customCode, @NotNull PsiElement context2, @Nullable Map<String, String> customProperties) {
        StringBuilder answer = new StringBuilder();
        answer.append(signature);
        Project project2 = context2.getProject();
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)context2.getContainingFile(), OCCodeStyleSettings.class);
        if (settings.SEMICOLON_AFTER_METHOD_SIGNATURE) {
            answer.append(";");
        }
        answer.append("{\n ");
        FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance((Project)project2);
        OCPropertySymbol property = baseMethod != null ? baseMethod.getGeneratedFromProperty() : null;
        OCInstanceVariableSymbol ivar = property != null ? property.getAssociatedIvar(project2) : null;
        OCClassDeclaration parentClass = (OCClassDeclaration)PsiTreeUtil.getContextOfType((PsiElement)context2, OCClassDeclaration.class, (boolean)false);
        String templateName = property != null && ivar != null ? (baseMethod.isSetter(OCResolveContext.forPsi(context2)) ? PROPERTY_SETTER_TEMPLATE_NAME : PROPERTY_GETTER_TEMPLATE_NAME) : (customTemplate != null && customTemplate != OVERRIDDEN_METHOD_TEMPLATE_NAME ? customTemplate : (baseMethod != null && OCElementUtil.startsWithWord(baseMethod.getName(), "init") ? OVERRIDDEN_INIT_METHOD_TEMPLATE_NAME : (baseMethod != null && baseMethod.getName().equals("isEqual:") ? OVERRIDDEN_IS_EQUAL_METHOD_TEMPLATE_NAME : (baseMethod != null && baseMethod.getName().equals("description") ? OVERRIDDEN_DESCRIPTION_TEMPLATE_NAME2 : (baseMethod != null && baseMethod.getName().equals("copyWithZone:") ? OVERRIDDEN_COPY_TEMPLATE_NAME2 : (customTemplate != null ? customTemplate : OVERRIDDEN_METHOD_TEMPLATE_NAME))))));
        FileTemplate bodyTemplate = fileTemplateManager.getCodeTemplate(templateName);
        Properties templateProperties = new Properties(FileTemplateManager.getInstance((Project)project2).getDefaultProperties());
        if (customProperties != null) {
            for (Map.Entry<String, String> entry : customProperties.entrySet()) {
                templateProperties.setProperty(entry.getKey(), entry.getValue());
            }
        }
        OCResolveContext resolveContext = OCResolveContext.forPsi(context2);
        templateProperties.setProperty(CONTAINING_CLASS_TEMPLATE_PROPERTY, parentClass != null ? parentClass.getName() : "");
        templateProperties.setProperty(RETURN_TYPE_TEMPLATE_PROPERTY, returnType.getBestNameInContext(resolveContext));
        templateProperties.setProperty(DEFAULT_RETURN_VALUE_TEMPLATE_PROPERTY, returnType.getDefaultValue(resolveContext));
        templateProperties.setProperty(CALL_SUPER_TEMPLATE_PROPERTY, OCCallableUtil.getCallSuperText(baseMethod, context2));
        templateProperties.setProperty(CUSTOM_CODE_TEMPLATE_PROPERTY, customCode != null ? customCode : "");
        boolean arcEnabled = OCCompilerFeaturesHelper.isArcEnabled(context2.getContainingFile());
        if (property != null && ivar != null) {
            OCDeclaratorSymbol parameter;
            templateProperties.setProperty(IVAR_TEMPLATE_PROPERTY, ivar.getName());
            if (baseMethod.isSetter(resolveContext) && (parameter = baseMethod.getSelectors().get(0).getParameter()) != null) {
                templateProperties.setProperty(PARAM_TEMPLATE_PROPERTY, OCNameSuggester.suggestUniqueName(parameter, context2, project2));
            }
            if (property.hasAttribute(OCPropertySymbol.PropertyAttribute.COPY)) {
                templateProperties.setProperty(SETTER_SEMANTICS_TEMPLATE_PROPERTY, arcEnabled ? "copyArc" : "copy");
            } else if (property.hasAttribute(OCPropertySymbol.PropertyAttribute.RETAIN) && !arcEnabled) {
                templateProperties.setProperty(SETTER_SEMANTICS_TEMPLATE_PROPERTY, "retain");
            } else {
                templateProperties.setProperty(SETTER_SEMANTICS_TEMPLATE_PROPERTY, "assign");
            }
        }
        try {
            if (baseMethod == null || !baseMethod.getName().equals("dealloc") || !arcEnabled) {
                answer.append(bodyTemplate.getText(templateProperties));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Unable to load template for file template '%s'!", fileTemplateManager.internalTemplateToSubject(templateName)), e);
        }
        answer.append("\n}\n");
        return answer.toString();
    }

    @NotNull
    private static String fillFunctionBodyTemplate(@NotNull OCFunctionSymbol function, @Nullable OCFunctionSymbol overridingFunction, @NotNull PsiElement context2) {
        FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance((Project)context2.getProject());
        String templateName = overridingFunction != null ? CPP_OVERRIDDEN_FUNCTION_TEMPLATE_NAME : CPP_IMPLEMENTED_FUNCTION_TEMPLATE_NAME;
        FileTemplate bodyTemplate = fileTemplateManager.getCodeTemplate(templateName);
        OCResolveContext resolveContext = OCResolveContext.forPsi(context2);
        OCType returnType = function.getEffectiveResolvedType(resolveContext);
        if (function.isCppConstructor() || function.isCppDestructor()) {
            returnType = OCVoidType.instance();
        }
        Properties templateProperties = new Properties(FileTemplateManager.getInstance((Project)context2.getProject()).getDefaultProperties());
        templateProperties.setProperty(RETURN_TYPE_TEMPLATE_PROPERTY, returnType.getBestNameInContext(resolveContext));
        templateProperties.setProperty(DEFAULT_RETURN_VALUE_TEMPLATE_PROPERTY, returnType.getDefaultValue(resolveContext));
        if (overridingFunction != null) {
            templateProperties.setProperty(CALL_SUPER_TEMPLATE_PROPERTY, overridingFunction.getVisibility() != OCVisibility.PRIVATE ? OCCallableUtil.getBaseCallText(function, overridingFunction) : "");
        }
        try {
            return bodyTemplate.getText(templateProperties);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Unable to load template for file template '%s'!", fileTemplateManager.internalTemplateToSubject(templateName)), e);
        }
    }

    private static String getAdHocParameterName(String methodName, boolean isFirstParameter) {
        if (methodName.startsWith("isEqual") && isFirstParameter) {
            return "other";
        }
        if (methodName.equals("encodeWithCoder:") || methodName.equals("initWithCoder:")) {
            return "coder";
        }
        return null;
    }

    private static String getCallSuperText(@Nullable OCMethodSymbol baseMethod, @NotNull PsiElement context2) {
        if (baseMethod == null) {
            return "";
        }
        StringBuilder callSuper = new StringBuilder();
        callSuper.append("[super ");
        boolean first = true;
        for (OCMethodSymbol.SelectorPartSymbol part : baseMethod.getSelectors()) {
            if (!first) {
                callSuper.append(' ');
            }
            callSuper.append(part.getSelectorName()).append(' ');
            OCDeclaratorSymbol param = part.getParameter();
            if (param != null) {
                String parameterName = OCCallableUtil.getAdHocParameterName(baseMethod.getName(), first);
                if (parameterName != null) {
                    callSuper.append(parameterName);
                } else {
                    callSuper.append(OCNameSuggester.suggestUniqueName(param, context2, context2.getProject()));
                }
            }
            first = false;
        }
        callSuper.append("]");
        return callSuper.toString();
    }

    @NotNull
    private static String getBaseCallText(@NotNull OCFunctionSymbol override, @NotNull OCFunctionSymbol baseToCall) {
        if (baseToCall.isCppConstructor() || baseToCall.isCppDestructor()) {
            return "";
        }
        return baseToCall.getParent().getName() + "::" + OCCallableUtil.getBaseCallExpression(override, baseToCall);
    }

    @NotNull
    private static String getBaseCallExpression(@NotNull OCFunctionSymbol override, @NotNull OCFunctionSymbol baseToCall) {
        OCDeclaratorSymbol param;
        OCType type;
        StringBuilder callSuper = new StringBuilder();
        callSuper.append(baseToCall.getName()).append("(");
        boolean first = true;
        Iterator<OCDeclaratorSymbol> iterator2 = override.getParameterSymbols().iterator();
        while (iterator2.hasNext() && !((type = (param = iterator2.next()).getType()) instanceof OCEllipsisType) && !(type instanceof OCVoidType)) {
            if (!first) {
                callSuper.append(",");
            }
            callSuper.append(param.getName());
            first = false;
        }
        callSuper.append(")");
        return callSuper.toString();
    }

    @NotNull
    public static String methodSignature(OCMethodSymbol method, PsiElement context2, @NotNull OCResolveContext resolveContext) {
        if (context2 != null) {
            resolveContext = OCResolveContext.forPsi(context2);
        }
        StringBuilder answer = new StringBuilder();
        answer.append(method.isStatic() ? (char)'+' : '-');
        answer.append('(');
        Project project2 = resolveContext.getProject();
        if (method.getReturnType(project2).isVoid() && method.hasAttribute("ibaction")) {
            answer.append("IBAction");
        } else {
            answer.append(method.getReturnType(project2).getBestNameInContext(resolveContext, OCElementUtil.getReturnTypeText(method, project2)));
        }
        answer.append(')');
        boolean first = true;
        for (OCMethodSymbol.SelectorPartSymbol part : method.getSelectors()) {
            if (!first) {
                answer.append(' ');
            }
            answer.append(part.getSelectorName());
            OCDeclaratorSymbol param = part.getParameter();
            if (param != null) {
                OCType type = param.getType();
                answer.append('(').append(type.getBestNameInContext(resolveContext)).append(')');
                String parameterName = OCCallableUtil.getAdHocParameterName(method.getName(), first);
                if (parameterName != null) {
                    answer.append(parameterName);
                } else {
                    answer.append(OCNameSuggester.suggestUniqueName(param, context2, resolveContext.getProject()));
                }
            }
            first = false;
        }
        if (method.isVararg()) {
            answer.append(",...");
        }
        return answer.toString();
    }

    @NotNull
    public static String getFunctionTemplateHeader(@NotNull OCType type, final @NotNull OCResolveContext context2) {
        final ArrayList typeParameters = new ArrayList();
        type.resolve(context2).accept(new OCBooleanTypeVisitor(){

            @Override
            public Boolean visitTypeParameterType(OCTypeParameterType type) {
                PsiElement sibling;
                OCTypeParameterTypeSymbol symbol = (OCTypeParameterTypeSymbol)type.getSymbol();
                ComplexTextRange scope = symbol.getContainingFile() != null ? symbol.getScope() : null;
                OCFunctionDeclaration function = (OCFunctionDeclaration)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context2.getElement(), (Class[])new Class[]{OCFunctionDeclaration.class});
                PsiElement psiElement = sibling = function != null ? function.getPrevSibling() : null;
                if (sibling == null && function != null) {
                    sibling = function.getNextSibling();
                }
                if (sibling == null || scope == null || !scope.contains(OCSymbolOffsetUtil.getComplexOffset(sibling))) {
                    typeParameters.add(type.getSymbol());
                }
                return false;
            }

            @Override
            public Boolean visitStructType(OCStructType type) {
                for (OCTypeArgument typeArgument : type.getSymbol().getSubstitution().getSubstitutedTypes()) {
                    if (!(typeArgument instanceof OCType)) continue;
                    ((OCType)typeArgument).accept(this);
                }
                return false;
            }
        });
        if (!typeParameters.isEmpty()) {
            return OCCppGeneratedQualifiedFunctionKt.makeTemplateHeader(typeParameters, context2);
        }
        return "";
    }

    @NotNull
    public static String defaultFunctionBody(@NotNull OCFunctionSymbol function, @Nullable OCFunctionSymbol baseToCall, @NotNull PsiElement context2) {
        StringBuilder answer = new StringBuilder();
        if (function.isCppConstructor() && baseToCall != null) {
            answer.append(':');
            answer.append(OCCallableUtil.getBaseCallExpression(function, baseToCall));
        }
        answer.append("{\n");
        answer.append(OCCallableUtil.fillFunctionBodyTemplate(function, baseToCall, context2));
        answer.append("\n}");
        return answer.toString();
    }

    public static String getOverridingFunctionName(OCFunctionSymbol member, OCSymbolWithQualifiedName parent) {
        String newName = parent != null && member.isCppConstructor() ? parent.getName() : (parent != null && member.isCppDestructor() ? "~" + parent.getName() : member.getName());
        return newName;
    }

    @NotNull
    public static OCFunctionSymbol createOverridingFunction(@NotNull OCFunctionSymbol base, @NotNull OCNamespaceSymbol newParent, @NotNull PsiElement context2, @Nullable OCVisibility visibility, boolean insertOverride, boolean insertVirtual) {
        int newAttributes = base.getFunctionAttributes();
        int newProperties = base.getFunctionProperties();
        newProperties &= ~OCFunctionSymbol.Property.IS_PURE_VIRTUAL.getMask();
        newAttributes = insertVirtual && !base.isCppConstructor() ? (newAttributes |= OCSymbolAttribute.VIRTUAL.getMask()) : (newAttributes &= ~OCSymbolAttribute.VIRTUAL.getMask());
        newAttributes = insertOverride && !base.isCppConstructor() ? (newAttributes |= OCSymbolAttribute.OVERRIDE.getMask()) : (newAttributes &= ~OCSymbolAttribute.OVERRIDE.getMask());
        List<OCDeclaratorSymbol> oldParamSymbols = base.getParameterSymbols();
        ArrayList<String> createdNames = new ArrayList<String>();
        OCResolveContext resolveContext = OCResolveContext.forPsi(context2);
        for (OCDeclaratorSymbol param : oldParamSymbols) {
            Collection<String> suggestedNames;
            OCType type = param.getType();
            String paramName = param.isUnnamed() && !(type instanceof OCEllipsisType) && !(type instanceof OCVoidType) ? ((suggestedNames = OCNameSuggester.suggestForType(OCSymbolKind.PARAMETER, type, context2, "", createdNames, resolveContext)).isEmpty() ? "param" : suggestedNames.iterator().next()) : param.getName();
            createdNames.add(paramName);
        }
        return new OCFunctionSymbol(null, Long.MAX_VALUE, newParent, OCQualifiedName.with(null, OCCallableUtil.getOverridingFunctionName(base, newParent)), base.getTemplateParameters(), base.getTemplateSpecialization(), newProperties, newAttributes, base.getAttributes(), base.getType().cloneWithParameterNames(createdNames), base.getDefaultValues(), base.getKind(), visibility);
    }

    @Nullable
    public static OCFunctionSymbol getDefaultBaseToCall(OCFunctionSymbol function, @NotNull Project project2) {
        return function.isCppDestructor() || function.isCppConstructor() && function.getType().hasNoParameters() ? null : (OCFunctionSymbol)new FilteredQuery((Query)new OCFunctionAncestorsQuery(function, false, false, true, project2), symbol -> !symbol.isPureVirtual()).findFirst();
    }

    public static boolean isParameterNameEmpty(@NotNull String paramName) {
        return paramName.isEmpty() || paramName.equals("<unnamed>");
    }

    public static boolean resolveIsVirtual(@NotNull OCFunctionSymbol symbol, Project project2) {
        return symbol.isVirtual() || symbol.isOverride() || symbol.isFinal() || OCFunctionAncestorsQuery.findFirstVirtual(symbol, false, project2) != null;
    }

    public static boolean hasVoidReturnType(@NotNull OCCallable callable, @NotNull OCResolveContext resolveContext) {
        return callable.getReturnType().resolve(resolveContext).isVoid();
    }

    public static boolean isNoReturn(@Nullable OCCallable callable) {
        if (callable instanceof OCFunctionDeclaration) {
            OCSymbol symbol = callable.getSymbol();
            return symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isNoReturn();
        }
        return false;
    }
}

