/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.resolve.OCDeductionCandidateSymbol;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithArguments;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithSubstitution;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCAliasUsingSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbolImpl;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterValueSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCCallExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCNoexceptExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCReferenceExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCSizeofExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbolImpl;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCExpressionTypeArgument;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCReferenceTypeBuilder;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.visitors.OCBooleanTypeVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCMultiTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCNonPrimitiveTypeCloneVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCSimpleTypeSubstitution;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCTypeSubstitution
implements Serializable,
DeepEqual.Equality {
    public static final OCSimpleTypeSubstitution ID = new OCSimpleTypeSubstitution(OCTypeUtils.newTypeParameterMap());

    public abstract OCType substitute(@NotNull OCType var1, boolean var2, @NotNull OCResolveContext var3);

    public abstract OCTypeArgument getSubstitutionFor(@NotNull OCTypeParameterSymbol var1);

    public abstract Collection<OCTypeArgument> getSubstitutedTypes();

    public abstract boolean processSubstitutions(Processor<Map.Entry<OCTypeParameterSymbol, OCTypeArgument>> var1);

    public abstract boolean hasSubstitutionForName(@NotNull String var1);

    public boolean isEmpty() {
        return this == ID;
    }

    public OCType substitute(@NotNull OCType type, @NotNull OCResolveContext context2) {
        return this.substitute(type, false, context2);
    }

    public OCType substitute(@NotNull OCType type) {
        if (this == ID) {
            return type;
        }
        return this.substitute(type, false, OCResolveContext.emptyContextWithoutProject());
    }

    public static OCTypeSubstitution compose(@NotNull OCTypeSubstitution a, @NotNull OCTypeSubstitution b) {
        return OCTypeSubstitution.compose(a, b, false);
    }

    public static OCTypeSubstitution compose(@NotNull OCTypeSubstitution a, @NotNull OCTypeSubstitution b, boolean overwriteSubstitution) {
        if (a == ID) {
            return b;
        }
        if (b == ID) {
            return a;
        }
        if (a.equals(b)) {
            return a;
        }
        TObjectHashingStrategy<OCSimpleTypeSubstitution> strategy2 = new TObjectHashingStrategy<OCSimpleTypeSubstitution>(){

            public int computeHashCode(OCSimpleTypeSubstitution object) {
                return object.hashCode();
            }

            public boolean equals(OCSimpleTypeSubstitution o1, OCSimpleTypeSubstitution o2) {
                return o1.equals(o2);
            }
        };
        THashSet oldSubsts = new THashSet((TObjectHashingStrategy)strategy2);
        THashSet newSubsts = new THashSet((TObjectHashingStrategy)strategy2);
        HashMap<OCTypeParameterSymbol, OCSimpleTypeSubstitution> map2 = new HashMap<OCTypeParameterSymbol, OCSimpleTypeSubstitution>();
        if (a instanceof OCMultiTypeSubstitution) {
            oldSubsts.addAll(((OCMultiTypeSubstitution)a).getSubstitutions());
        } else {
            oldSubsts.add((OCSimpleTypeSubstitution)a);
        }
        if (b instanceof OCMultiTypeSubstitution) {
            newSubsts.addAll(((OCMultiTypeSubstitution)b).getSubstitutions());
        } else {
            newSubsts.add((OCSimpleTypeSubstitution)b);
        }
        for (OCSimpleTypeSubstitution substitution2 : oldSubsts) {
            for (OCTypeParameterSymbol typeParam : substitution2.getTypeParameters()) {
                map2.put(typeParam, substitution2);
            }
        }
        for (OCSimpleTypeSubstitution substitution2 : newSubsts) {
            if (oldSubsts.contains(substitution2)) continue;
            if (overwriteSubstitution) {
                oldSubsts.add(substitution2);
                for (OCTypeParameterSymbol typeParam : substitution2.getTypeParameters()) {
                    OCSimpleTypeSubstitution oldSubst = (OCSimpleTypeSubstitution)map2.get(typeParam);
                    if (oldSubst == null) continue;
                    Map<OCTypeParameterSymbol, OCTypeArgument> substMap = oldSubst.getSubstitutions();
                    oldSubsts.remove(oldSubst);
                    if (substMap.size() <= 1) continue;
                    map2.remove(typeParam);
                    HashMap<OCTypeParameterSymbol, OCTypeArgument> newSubstMap = new HashMap<OCTypeParameterSymbol, OCTypeArgument>(substMap);
                    newSubstMap.remove(typeParam);
                    OCSimpleTypeSubstitution newSubst = new OCSimpleTypeSubstitution(newSubstMap);
                    oldSubsts.add(newSubst);
                    for (OCTypeParameterSymbol typeParameter : newSubst.getTypeParameters()) {
                        map2.put(typeParameter, newSubst);
                    }
                }
                continue;
            }
            if (ContainerUtil.intersects(substitution2.getTypeParameters(), map2.keySet())) continue;
            oldSubsts.add(substitution2);
        }
        return new OCMultiTypeSubstitution(new ArrayList<OCSimpleTypeSubstitution>((Collection<OCSimpleTypeSubstitution>)oldSubsts));
    }

    public boolean dependsOn(@Nullable OCSymbolReference reference, @NotNull OCResolveContext context2) {
        if (reference instanceof OCSymbolReference.GlobalReference) {
            OCSymbolReference.GlobalReference globalReference = (OCSymbolReference.GlobalReference)reference;
            boolean useContextInDepends = !context2.dontUseSymbolContextsInDepends() && !"std".equals(globalReference.getQualifiedName().getLeftmostQualifier());
            return useContextInDepends && this.dependsOn(globalReference.getSymbolContext(), context2) || this.dependsOn(globalReference.getQualifiedName(), context2);
        }
        return true;
    }

    public boolean dependsOn(@NotNull OCQualifiedName name, @NotNull OCResolveContext context2) {
        String string;
        if (name instanceof OCQualifiedNameWithArguments) {
            for (OCTypeArgument argument : ((OCQualifiedNameWithArguments)name).getArguments()) {
                if (!this.dependsOn(argument, context2)) continue;
                return true;
            }
        }
        if ((string = name.getName()) != null && !this.processSubstitutions((Processor<Map.Entry<OCTypeParameterSymbol, OCTypeArgument>>)((Processor)e -> !string.equals(((OCTypeParameterSymbol)e.getKey()).getName())))) {
            return true;
        }
        return name.getQualifier() != null && this.dependsOn(name.getQualifier(), context2);
    }

    public boolean dependsOn(@Nullable OCTypeArgument argument, final @NotNull OCResolveContext context2) {
        if (argument instanceof OCExpressionTypeArgument) {
            return this.dependsOn(((OCExpressionTypeArgument)argument).getSymbol(), context2);
        }
        if (argument instanceof OCType) {
            return ((OCType)argument).accept(new OCBooleanTypeVisitor(){

                @Override
                public Boolean visitReferenceType(OCReferenceType type) {
                    return OCTypeSubstitution.this.dependsOn(type.getReference(context2), context2) || type.getSubstitution().dependsOn(OCTypeSubstitution.this, context2);
                }

                @Override
                public Boolean visitStructType(OCStructType type) {
                    return OCTypeSubstitution.this.dependsOn(type.getSymbol(), context2);
                }

                @Override
                public Boolean visitObjectType(OCObjectType type) {
                    return OCTypeSubstitution.this.dependsOn(type.getClassSymbol(), context2);
                }

                @Override
                public Boolean visitTypeParameterType(OCTypeParameterType type) {
                    return OCTypeSubstitution.this.dependsOn(type.getSymbol(), context2);
                }

                @Override
                public Boolean visitAutoType(OCAutoType type) {
                    return OCTypeSubstitution.this.dependsOn(type.getExpressionSymbol(), context2) || OCTypeSubstitution.this.dependsOn(type.getSubstitution(), context2);
                }

                @Override
                public Boolean visitArrayType(OCArrayType type) {
                    return OCTypeSubstitution.this.dependsOn(type.getLengthSymbol(), context2) || OCTypeSubstitution.this.dependsOn(type.getSubstitution(), context2);
                }
            });
        }
        return false;
    }

    public boolean dependsOn(@Nullable OCSymbol symbol, final @NotNull OCResolveContext context2) {
        if (this == ID || symbol == null || symbol.getKind() == OCSymbolKind.NAMESPACE) {
            return false;
        }
        OCSymbol parent = symbol;
        if (symbol instanceof OCExpressionSymbol) {
            return ((OCExpressionSymbol)symbol).evaluate(new OCExpressionEvaluator.CachingEvaluator<Boolean>(context2){

                @Override
                @Nullable
                public Boolean evalInteger(Number value) {
                    return false;
                }

                @Override
                @Nullable
                public Boolean evalBool(Boolean value) {
                    return false;
                }

                @Override
                @Nullable
                public Boolean evalDefault(OCExpression psi) {
                    return false;
                }

                @Override
                @Nullable
                public Boolean evalBinary(OCElementType t, @Nullable Boolean l, @Nullable Boolean r) {
                    return l == Boolean.TRUE || r == Boolean.TRUE;
                }

                @Override
                @Nullable
                public Boolean evalUnary(OCElementType t, @Nullable Boolean arg) {
                    return arg;
                }

                @Override
                @Nullable
                public Boolean evalConditional(Boolean condition, @Nullable Supplier<Boolean> l, @Nullable Supplier<Boolean> r) {
                    return condition == Boolean.TRUE || l.get() == Boolean.TRUE || r.get() == Boolean.TRUE;
                }

                @Override
                @Nullable
                public Boolean evalCast(OCType type, Boolean operand) {
                    return operand == Boolean.TRUE || OCTypeSubstitution.this.dependsOn(type, context2);
                }

                @Override
                @Nullable
                public Boolean evalCall(OCCallExpressionSymbol symbol) {
                    if (symbol.getCalleeSymbol().evaluate(this) == Boolean.TRUE) {
                        return true;
                    }
                    for (OCExpressionSymbol argSymbol : symbol.getArguments()) {
                        if (argSymbol.evaluate(this) != Boolean.TRUE) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                @Nullable
                public Boolean evalReference(OCReferenceExpressionSymbol symbol) {
                    return OCTypeSubstitution.this.dependsOn(symbol.getReference(), context2);
                }

                @Override
                @Nullable
                public Boolean evalSizeof(OCSizeofExpressionSymbol symbol) {
                    OCExpressionSymbol operand = symbol.getExpressionOperand();
                    return operand != null && operand.evaluate(this) == Boolean.TRUE || OCTypeSubstitution.this.dependsOn(symbol.getTypeOperand(), context2);
                }

                @Override
                @Nullable
                public Boolean evalNoexcept(OCNoexceptExpressionSymbol noexceptExpr) {
                    OCExpressionSymbol operand = noexceptExpr.getExpressionOperand();
                    return operand.evaluate(this) == Boolean.TRUE;
                }
            }) == Boolean.TRUE;
        }
        if (symbol instanceof OCTypeParameterSymbol) {
            boolean prev = context2.dontUseSymbolContextsInDepends();
            context2.setDontUseSymbolContextsInDepends(true);
            boolean depends = this.getSubstitutionFor((OCTypeParameterSymbol)symbol) != null || this.dependsOn((OCTypeArgument)((OCTypeParameterSymbol)symbol).getDefaultValue(), context2);
            context2.setDontUseSymbolContextsInDepends(prev);
            return depends;
        }
        while (parent instanceof OCSymbolWithParent) {
            if (parent instanceof OCSymbolWithSubstitution) {
                // empty if block
            }
            if (parent instanceof OCTemplateSymbol) {
                for (OCTypeParameterSymbol param : ((OCTemplateSymbol)parent).getTemplateParameters()) {
                    OCTypeArgument argument = ((OCSymbolWithSubstitution)((Object)parent)).getSubstitution().getSubstitutionFor(param);
                    Object defaultValue = param.getDefaultValue();
                    if (argument == null && this.getSubstitutionFor(param) != null || this.dependsOn(argument, context2)) {
                        return true;
                    }
                    if (defaultValue == null) continue;
                    boolean prev = context2.dontUseSymbolContextsInDepends();
                    context2.setDontUseSymbolContextsInDepends(true);
                    boolean depends = this.dependsOn((OCTypeArgument)defaultValue, context2);
                    context2.setDontUseSymbolContextsInDepends(prev);
                    if (!depends) continue;
                    return true;
                }
            }
            parent = ((OCSymbolWithParent)parent).getParent();
        }
        return false;
    }

    public boolean dependsOn(@NotNull Collection<Object> list, @NotNull OCResolveContext context2) {
        for (Object object : list) {
            if (!this.dependsOn(object, context2)) continue;
            return true;
        }
        return false;
    }

    public boolean dependsOn(@Nullable Object object, @NotNull OCResolveContext context2) {
        if (object instanceof OCSymbolReference) {
            return this.dependsOn((OCSymbolReference)object, context2);
        }
        if (object instanceof OCQualifiedName) {
            return this.dependsOn((OCQualifiedName)object, context2);
        }
        if (object instanceof OCTypeArgument) {
            return this.dependsOn((OCTypeArgument)object, context2);
        }
        if (object instanceof OCSymbol) {
            return this.dependsOn((OCSymbol)object, context2);
        }
        if (object instanceof Collection) {
            return this.dependsOn((Collection)object, context2);
        }
        if (object instanceof OCSimpleTypeSubstitution) {
            return this.dependsOn(((OCSimpleTypeSubstitution)object).getSubstitutedTypes(), context2);
        }
        if (object != null) {
            throw new IllegalArgumentException(object.getClass().getName());
        }
        return false;
    }

    protected boolean dependsOn(@NotNull OCTypeSubstitution substitution2, @NotNull OCResolveContext context2) {
        for (OCTypeArgument argument : substitution2.getSubstitutedTypes()) {
            if (!this.dependsOn(argument, context2)) continue;
            return true;
        }
        return false;
    }

    public OCTypeSubstitution getMinimalDependentSubstitution(Object reference, @NotNull OCResolveContext context2) {
        return this.dependsOn(reference, context2) ? this : ID;
    }

    @Contract(value="null->null; !null->!null")
    public <T extends OCSymbol> T substitute(@Nullable T symbol) {
        if (symbol == null || this == ID) {
            return symbol;
        }
        return this.substitute(symbol, null, false);
    }

    @Contract(value="null,_->null; !null,_->!null")
    public <T extends OCSymbol> T substitute(@Nullable T symbol, @NotNull OCResolveContext context2) {
        return this.substitute(symbol, null, false, context2);
    }

    @Contract(value="null,_,_->null; !null,_,_->!null")
    public <T extends OCSymbol> T substitute(@Nullable T symbol, @Nullable OCSymbolWithQualifiedName parent, boolean overwriteSubstitution) {
        if (symbol == null || this == ID) {
            return symbol;
        }
        return this.substitute(symbol, parent, overwriteSubstitution, OCResolveContext.emptyContextWithoutProject());
    }

    @Contract(value="null,_,_,_->null; !null,_,_,_->!null")
    public <T extends OCSymbol> T substitute(@Nullable T symbol, @Nullable OCSymbolWithQualifiedName parent, boolean overwriteSubstitution, @NotNull OCResolveContext context2) {
        if (symbol == null || this == ID || !this.dependsOn(symbol, context2)) {
            return symbol;
        }
        OCTypeSubstitution substitution2 = this.getMinimalDependentSubstitution(symbol, context2);
        if (symbol instanceof OCSymbolWithSubstitution) {
            substitution2 = OCTypeSubstitution.compose(((OCSymbolWithSubstitution)((Object)symbol)).getSubstitution(), substitution2, overwriteSubstitution);
        }
        if (parent == null && symbol instanceof OCSymbolWithParent) {
            OCSymbol parentSymbol = ((OCSymbolWithParent)symbol).getParent();
            parent = this.substitute((OCSymbolWithQualifiedName)parentSymbol, context2);
        }
        return OCTypeSubstitution.cloneWithSubstitution(symbol, substitution2, parent);
    }

    @Contract(value="null,_,_->null; !null,_,_->!null")
    public static <T extends OCSymbol> T cloneWithSubstitution(@Nullable T symbol, @NotNull OCTypeSubstitution substitution2, @Nullable OCSymbolWithQualifiedName parent) {
        if (symbol instanceof OCTypeParameterValueSymbol) {
            return (T)new OCTypeParameterValueSymbol((OCTypeParameterValueSymbol)symbol, substitution2);
        }
        if (symbol instanceof OCStructSymbol) {
            return (T)new OCStructSymbol((OCStructSymbol)symbol, substitution2, parent);
        }
        if (symbol instanceof OCDeductionCandidateSymbol) {
            return (T)new OCDeductionCandidateSymbol((OCDeductionCandidateSymbol)symbol, substitution2, parent);
        }
        if (symbol instanceof OCFunctionSymbol) {
            return (T)new OCFunctionSymbol((OCFunctionSymbol)symbol, substitution2, parent);
        }
        if (symbol instanceof OCDeclaratorSymbolImpl) {
            return (T)new OCDeclaratorSymbolImpl((OCDeclaratorSymbolImpl)symbol, substitution2, ((OCDeclaratorSymbolImpl)symbol).getQualifiedName(), parent);
        }
        if (symbol instanceof OCUsingSymbol) {
            return (T)new OCUsingSymbol((OCUsingSymbol)symbol, substitution2);
        }
        if (symbol instanceof OCAliasUsingSymbol) {
            return (T)new OCAliasUsingSymbol((OCAliasUsingSymbol)symbol, substitution2);
        }
        if (symbol instanceof OCInterfaceSymbolImpl) {
            return (T)new OCInterfaceSymbolImpl((OCInterfaceSymbolImpl)symbol, substitution2);
        }
        if (symbol instanceof OCMethodSymbolImpl) {
            return (T)new OCMethodSymbolImpl((OCMethodSymbolImpl)symbol, substitution2);
        }
        if (symbol instanceof OCPropertySymbolImpl) {
            return (T)new OCPropertySymbolImpl((OCPropertySymbolImpl)symbol, substitution2);
        }
        return symbol;
    }

    @NotNull
    public <T extends OCSymbol> List<T> substitute(List<T> symbols) {
        if (this == ID) {
            return symbols;
        }
        return this.substitute(symbols, OCResolveContext.emptyContextWithoutProject());
    }

    @NotNull
    public <T extends OCSymbol> List<T> substitute(List<T> symbols, @NotNull OCResolveContext context2) {
        if (this == ID) {
            return symbols;
        }
        ArrayList<OCSymbol> result2 = new ArrayList<OCSymbol>();
        for (OCSymbol symbol : symbols) {
            result2.add(this.substitute(symbol, context2));
        }
        return result2;
    }

    public boolean equals(Object o) {
        return DeepEqual.equalObjects(this, o);
    }

    @NotNull
    protected static OCReferenceType substituteReferenceType(@NotNull OCReferenceType type, @NotNull OCTypeSubstitution substitution2, boolean overwriteSubstitution, @NotNull OCResolveContext context2) {
        OCReferenceTypeBuilder typeBuilder = new OCReferenceTypeBuilder(type.getReference(context2));
        typeBuilder.setConstVolatile(type);
        typeBuilder.setProtocolNames(type.getProtocolNames());
        typeBuilder.setSubstitution(OCTypeSubstitution.compose(type.getSubstitution(), substitution2, overwriteSubstitution));
        typeBuilder.setFunctionParameterType(type.isFunctionParameterType());
        return typeBuilder.build();
    }

    protected static class TypeSubstituteVisitor
    extends OCNonPrimitiveTypeCloneVisitor {
        @NotNull
        private final OCTypeSubstitution mySubstitution;
        @NotNull
        private final OCResolveContext myContext;
        private final boolean myOverwriteSubstitution;

        TypeSubstituteVisitor(@NotNull OCTypeSubstitution substitution2, boolean overwriteSubstitution, @NotNull OCResolveContext context2) {
            this.mySubstitution = substitution2;
            this.myOverwriteSubstitution = overwriteSubstitution;
            this.myContext = context2;
        }

        @Override
        public OCType visitReferenceType(OCReferenceType type) {
            return OCTypeSubstitution.substituteReferenceType(type, this.mySubstitution, this.myOverwriteSubstitution, this.myContext);
        }

        @Override
        public OCType visitAutoType(OCAutoType type) {
            return new OCAutoType(type, this.mySubstitution);
        }

        @Override
        public OCType visitStructType(OCStructType type) {
            return new OCStructType(ContainerUtil.map(type.getStructs(), symbol -> this.mySubstitution.substitute(symbol, this.myContext)), type.getTypedefName(), type.isConst(), type.isVolatile(), type.getArguments());
        }

        @Override
        public OCType visitArrayType(OCArrayType type) {
            return new OCArrayType(type.getRefType().transformType(this), this.mySubstitution.substitute(type.getLengthSymbol(), this.myContext), type.isConst(), type.isVolatile(), type.getARCAttribute(), OCTypeSubstitution.compose(type.getSubstitution(), this.mySubstitution, this.myOverwriteSubstitution));
        }
    }
}

