/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.types.CTypeId;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCNumericType
extends OCType {
    protected CTypeId myTypeId;

    public abstract int getRank(@NotNull OCResolveContext var1);

    public abstract boolean isSigned();

    public abstract boolean isComplex();

    public int getBits(@Nullable PsiElement element, @Nullable OCInclusionContext context2, @NotNull Project project2) {
        return this.getSizeInBytes(element == null ? null : element.getContainingFile(), context2, project2) * 8;
    }

    @NotNull
    public CTypeId getCTypeId() {
        return this.myTypeId;
    }

    public OCNumericType() {
    }

    public OCNumericType(boolean isConst, boolean isVolatile) {
        super(isConst, isVolatile);
    }

    @NotNull
    public abstract List<? extends OCNumericType> getBasicTypes();

    @Override
    @NotNull
    protected OCType doGetLeastCommonType(OCType type, @NotNull OCResolveContext context2) {
        if (type == null) {
            return OCUnknownType.INSTANCE;
        }
        if (type instanceof OCNumericType) {
            OCType result2;
            OCType oCType = result2 = this.getRank(context2) < ((OCNumericType)type).getRank(context2) ? type : this;
            if (this.isComplex() || ((OCNumericType)type).isComplex()) {
                return ((OCRealType)result2).cloneWithComplexModifier();
            }
            return result2;
        }
        if (type.isPointerCompatible(context2)) {
            return type;
        }
        if (type instanceof OCStructType && ((OCStructType)type).getKind() == OCSymbolKind.ENUM) {
            return this;
        }
        return OCUnknownType.INSTANCE;
    }

    @Override
    @Nullable
    public String getAliasName() {
        return this.myAliasName != null && this.myAliasName.contains("<") ? null : this.myAliasName;
    }

    @Override
    public boolean isNumberCompatible(@NotNull OCResolveContext context2) {
        return true;
    }

    @Override
    public boolean isScalar() {
        return true;
    }

    @Override
    public boolean isInstanceable() {
        return true;
    }

    @Override
    public int hashCode() {
        return this.baseHashCode() * 31 + this.myTypeId.hashCode();
    }
}

