/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import org.jetbrains.annotations.NotNull;

public class FileContentSnapshot {
    @NotNull
    private final CharSequence myText;
    private final Stamp myStamp;

    public FileContentSnapshot(@NotNull CharSequence text, long modificationStamp, boolean isPsi) {
        this.myText = text;
        this.myStamp = new Stamp(modificationStamp, isPsi);
    }

    @NotNull
    public CharSequence getText() {
        return this.myText;
    }

    public Stamp getStamp() {
        return this.myStamp;
    }

    @NotNull
    public static FileContentSnapshot get(@NotNull VirtualFile virtualFile, @NotNull Project project2) {
        PsiDocumentManager manager2;
        Document document2;
        PsiFile psiFile = OCInclusionContextUtil.findCachedPsiFile(virtualFile, project2);
        if (psiFile != null && (document2 = (manager2 = PsiDocumentManager.getInstance((Project)project2)).getCachedDocument(psiFile)) != null) {
            return new FileContentSnapshot(document2.getCharsSequence(), psiFile.getModificationStamp(), true);
        }
        long modificationStamp = virtualFile.getModificationStamp();
        if (virtualFile.getFileType().isBinary()) {
            return new FileContentSnapshot("", modificationStamp, false);
        }
        return new FileContentSnapshot(LoadTextUtil.loadText((VirtualFile)virtualFile), modificationStamp, false);
    }

    private static boolean isUpToDate(@NotNull Project project2, @NotNull VirtualFile file2, long stamp, boolean isPsi) {
        if (isPsi) {
            PsiFile psiFile = OCInclusionContextUtil.findCachedPsiFile(file2, project2);
            return psiFile != null && psiFile.getModificationStamp() == stamp;
        }
        return file2.getModificationStamp() == stamp;
    }

    public static class Stamp {
        private final long myStamp;
        private final boolean myIsPsi;

        public Stamp(long modificationStamp, boolean isPsi) {
            this.myStamp = modificationStamp;
            this.myIsPsi = isPsi;
        }

        public boolean isUpToDate(@NotNull Project project2, @NotNull VirtualFile file2) {
            return FileContentSnapshot.isUpToDate(project2, file2, this.myStamp, this.myIsPsi);
        }
    }
}

