/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.objc;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCIcons;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCSynthesizeSymbol;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCPropertySymbolImpl
extends OCMemberSymbolImpl
implements OCPropertySymbol {
    @NotNull
    private OCType myType;
    @Nullable
    private EnumSet<OCPropertySymbol.FlagAttribute> myFlagAttributes;
    @Nullable
    private EnumMap<OCPropertySymbol.ValueAttribute, String> myValueAttributes;
    private boolean myOptional;
    @NotNull
    private OCTypeSubstitution mySubstitution = OCTypeSubstitution.ID;

    public OCPropertySymbolImpl() {
    }

    public OCPropertySymbolImpl(VirtualFile file2, long offset, @NotNull String name, @NotNull List<String> attributes, @NotNull OCClassSymbol parent, @NotNull OCType type, boolean isOptional, @Nullable EnumSet<OCPropertySymbol.FlagAttribute> flagAttributes, @Nullable EnumMap<OCPropertySymbol.ValueAttribute, String> valueAttributes) {
        super(file2, offset, name, attributes, parent);
        this.myType = type;
        this.myOptional = isOptional;
        this.myValueAttributes = valueAttributes != null && !valueAttributes.isEmpty() ? valueAttributes : null;
        this.myFlagAttributes = flagAttributes != null && !flagAttributes.isEmpty() ? flagAttributes : null;
    }

    public OCPropertySymbolImpl(@NotNull OCPropertySymbolImpl origin, @NotNull OCTypeSubstitution substitution2) {
        this(origin.getContainingFile(), origin.getComplexOffset(), origin.getName(), origin.getAttributes(), origin.getParent(), origin.myType, origin.myOptional, origin.myFlagAttributes, origin.myValueAttributes);
        this.mySubstitution = substitution2;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCPropertySymbolImpl f = (OCPropertySymbolImpl)first;
        OCPropertySymbolImpl s = (OCPropertySymbolImpl)second;
        if (!Comparing.equal(f.myFlagAttributes, s.myFlagAttributes)) {
            return false;
        }
        if (!Comparing.equal(f.myValueAttributes, s.myValueAttributes)) {
            return false;
        }
        if (!c.equalObjects(f.mySubstitution, s.mySubstitution)) {
            return false;
        }
        return c.equalObjects(f.myType, s.myType);
    }

    @Override
    public void compact() {
        super.compact();
        this.myType.compact();
    }

    public static OCPropertySymbol.PropertySemantics getDefaultSemanticsForType(OCType type, PsiElement context2) {
        if ("NSString *".equals(type.getName()) || type instanceof OCBlockPointerType) {
            return OCPropertySymbol.PropertySemantics.COPY;
        }
        if (type.isPointerToObjectCompatible()) {
            return OCCompilerFeaturesHelper.isArcEnabled(context2.getContainingFile()) ? OCPropertySymbol.PropertySemantics.STRONG : OCPropertySymbol.PropertySemantics.RETAIN;
        }
        return OCPropertySymbol.PropertySemantics.ASSIGN;
    }

    @Nullable
    public static OCPropertySymbol.PropertyAttribute parseAttribute(@NotNull String string) {
        for (OCPropertySymbol.FlagAttribute flagAttribute : OCPropertySymbol.FlagAttribute.values()) {
            if (!string.equals(flagAttribute.getTokenName())) continue;
            return flagAttribute;
        }
        for (Enum enum_ : OCPropertySymbol.ValueAttribute.values()) {
            if (!string.equals(((OCPropertySymbol.ValueAttribute)enum_).getTokenName())) continue;
            return enum_;
        }
        return null;
    }

    @Override
    @NotNull
    public OCType getType() {
        return this.mySubstitution.substitute(this.myType);
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        return OCSymbolKind.PROPERTY;
    }

    @Override
    public boolean hasAttribute(@NotNull OCPropertySymbol.PropertyAttribute attribute) {
        return this.myFlagAttributes != null && this.myFlagAttributes.contains(attribute) || this.myValueAttributes != null && this.myValueAttributes.containsKey(attribute);
    }

    @Override
    @Nullable
    public String getAttributeValue(@NotNull OCPropertySymbol.ValueAttribute attribute) {
        return this.myValueAttributes != null ? this.myValueAttributes.get(attribute) : null;
    }

    @NotNull
    public static OCPropertySymbol.FlagAttribute getAttributeOfGroup(@NotNull OCPropertySymbol self, @NotNull OCPropertySymbol.FlagAttribute defaultAttribute, @NotNull OCType type, @NotNull PsiElement context2) {
        OCPropertySymbol.PropertyAttribute.Group group = defaultAttribute.getGroup();
        for (OCPropertySymbol.FlagAttribute attr : OCPropertySymbol.FlagAttribute.values()) {
            if (attr.getGroup() != group || !self.hasAttribute(attr)) continue;
            return attr;
        }
        if (group == OCPropertySymbol.PropertyAttribute.Group.ARC) {
            if (type.isPointerToObjectCompatible() && OCCompilerFeaturesHelper.isArcEnabled(context2.getContainingFile())) {
                return OCPropertySymbol.FlagAttribute.STRONG;
            }
            return OCPropertySymbol.FlagAttribute.ASSIGN;
        }
        return defaultAttribute;
    }

    @Override
    @Nullable
    public Icon getBaseIcon() {
        return OCIcons.getPropertyIcon(this.isStatic(), this.isOptional());
    }

    @Override
    public boolean isOptional() {
        return this.myOptional;
    }

    @Override
    @NotNull
    public OCTypeSubstitution getSubstitution() {
        return this.mySubstitution;
    }

    public static boolean processAccessorMethods(@NotNull OCPropertySymbol self, @NotNull Processor<? super OCMethodSymbol> processor2, boolean searchSubclasses, @NotNull Project project2) {
        OCCommonProcessors.OrderedProcessor<? super OCMethodSymbol> methodProcessor = new OCCommonProcessors.OrderedProcessor<OCMethodSymbol>(processor2, methodSymbol -> methodSymbol.isGetter(OCResolveContext.forSymbol(self, project2)), Conditions.alwaysTrue());
        self.getParent().processMembers(null, OCMethodSymbol.class, symbol -> {
            if (symbol.getGeneratedFromProperty() == self) {
                if (searchSubclasses) {
                    return OCSearchUtil.processMembersHierarchy(symbol, symbol1 -> {
                        if (symbol1.getGeneratedFromProperty() == null) {
                            return methodProcessor.process((OCMethodSymbol)symbol1);
                        }
                        return true;
                    }, false, true, project2);
                }
                OCMethodSymbol methAssociate = symbol.getAssociatedSymbol(project2);
                if (methAssociate != null) {
                    return methodProcessor.process(methAssociate);
                }
                return true;
            }
            return true;
        });
        return methodProcessor.finish();
    }

    public static boolean processSynthesizes(@NotNull OCPropertySymbol self, @NotNull Processor<? super OCSynthesizeSymbol> processor2, @NotNull Project project2) {
        OCImplementationSymbol implementation = self.getParent().getImplementation(project2);
        if (implementation == null) {
            return false;
        }
        return implementation.processMembers(OCSynthesizeSymbol.class, symbol -> !self.getName().equals(symbol.getName()) || processor2.process(symbol));
    }

    @Nullable
    public static OCInstanceVariableSymbol getAssociatedIvar(@NotNull OCPropertySymbol self, @NotNull Project project2) {
        CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
        self.processSynthesizes((Processor<? super OCSynthesizeSymbol>)finder, project2);
        if (!finder.isFound()) {
            if (OCCompilerFeaturesHelper.supportsAutosynthesis(self.getContainingOCFile(project2))) {
                String ivarName = OCNameSuggester.getClang4ImplicitIvarName(self.getName());
                CommonProcessors.FindFirstProcessor ivarFinder = new CommonProcessors.FindFirstProcessor();
                OCCommonProcessors.OrderedProcessor orderedProcessor = new OCCommonProcessors.OrderedProcessor(ivarFinder, (Condition<T>[])new Condition[]{symbol -> !symbol.isClang4ImplicitIvar(project2), Conditions.alwaysTrue()});
                self.getParent().processMembersInAllCategories(ivarName, OCInstanceVariableSymbol.class, orderedProcessor, false, project2);
                orderedProcessor.finish();
                return (OCInstanceVariableSymbol)ivarFinder.getFoundValue();
            }
            return null;
        }
        return ((OCSynthesizeSymbol)finder.getFoundValue()).getIvarSymbol(project2);
    }

    public static boolean hasAllAccessorsImplemented(final @NotNull OCPropertySymbol self, final boolean treatSynthesizeAsAccessors, @NotNull Project project2) {
        OCImplementationSymbol implementation = self.getParent().getImplementation(project2);
        if (implementation == null) {
            return false;
        }
        final String getter = self.getGetterName();
        final String setter = self.getSetterName();
        final OCResolveContext context2 = OCResolveContext.forSymbol(self, project2);
        return !implementation.processMembers(null, (Processor)new Processor<OCMemberSymbol>(){
            boolean wasGetter;
            boolean wasSetter;

            public boolean process(OCMemberSymbol symbol) {
                if (treatSynthesizeAsAccessors && symbol instanceof OCSynthesizeSymbol && self.getName().equals(symbol.getName())) {
                    return false;
                }
                if (symbol instanceof OCMethodSymbol) {
                    if (getter.equals(symbol.getName()) && ((OCMethodSymbol)symbol).isGetter(context2)) {
                        this.wasGetter = true;
                    }
                    if (setter.equals(symbol.getName()) && ((OCMethodSymbol)symbol).isSetter(context2)) {
                        this.wasSetter = true;
                    }
                    return !this.wasGetter || !self.isReadonly() && !this.wasSetter;
                }
                return true;
            }
        });
    }

    @Nullable
    public static OCPropertySymbol getAssociatedPropertyInPrivateCategory(@NotNull OCPropertySymbol self, @NotNull Project project2) {
        OCClassSymbol parent = self.getParent();
        if ("".equals(parent.getCategoryName())) {
            return null;
        }
        CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
        parent.processMembers("", self.getName(), OCPropertySymbol.class, finder, true, project2);
        return (OCPropertySymbol)finder.getFoundValue();
    }
}

