/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.expression;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.psi.impl.OCCppNewExpressionImpl;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNewExpressionSymbol
extends OCExpressionSymbol {
    private OCType myType;
    private int myArrayLengths;
    private List<OCExpressionSymbol> myArguments;
    private boolean myIsListInitialization;

    public OCNewExpressionSymbol() {
    }

    public OCNewExpressionSymbol(@Nullable VirtualFile file2, long offset, @NotNull OCType type, int arrayLengths, @NotNull List<OCExpressionSymbol> arguments, boolean isListInitialization) {
        super(file2, offset);
        this.myType = type;
        this.myArrayLengths = arrayLengths;
        this.myArguments = arguments;
        this.myIsListInitialization = isListInitialization;
    }

    @Override
    public void compact() {
        super.compact();
        this.myArguments = ContainerUtil.trimToSize(this.myArguments);
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCNewExpressionSymbol firstSymbol = (OCNewExpressionSymbol)first;
        OCNewExpressionSymbol secondSymbol = (OCNewExpressionSymbol)second;
        if (firstSymbol.myArrayLengths != secondSymbol.myArrayLengths) {
            return false;
        }
        if (!c.equalObjects(firstSymbol.myType, secondSymbol.myType)) {
            return false;
        }
        if (!c.equalObjects(firstSymbol.myArguments, secondSymbol.myArguments)) {
            return false;
        }
        return firstSymbol.myIsListInitialization == secondSymbol.myIsListInitialization;
    }

    @Override
    @Nullable
    public <T> T evaluate(@NotNull OCExpressionEvaluator.CachingEvaluator<T> evaluator) {
        return null;
    }

    @Override
    @NotNull
    public OCType getResolvedType(@NotNull OCResolveContext context2) {
        OCType resolved = this.myType.resolve(context2);
        OCArgumentsList<OCExpressionSymbol> arguments = OCArgumentsList.expandVariadicExpressions(this.myArguments, context2);
        return OCCppNewExpressionImpl.getNewExprType(resolved, arguments, this.myIsListInitialization, this.myArrayLengths, context2, this.getContainingFile(), this.getComplexOffset());
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return "new " + this.myType.getName();
    }
}

