/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.cpp;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCNamedSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCIncludeSymbol
extends OCNamedSymbol {
    @Nullable
    private transient VirtualFile myTargetFile;
    private byte myFlags;
    @NotNull
    private IncludePath myIncludePath;
    private int myEndOffset;
    @NotNull
    private List<String> myNamespace;

    public OCIncludeSymbol() {
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCIncludeSymbol f = (OCIncludeSymbol)first;
        OCIncludeSymbol s = (OCIncludeSymbol)second;
        if (f.myFlags != s.myFlags) {
            return false;
        }
        if (f.myEndOffset != s.myEndOffset) {
            return false;
        }
        if (!Comparing.equal((Object)f.myIncludePath, (Object)s.myIncludePath)) {
            return false;
        }
        if (!Comparing.equal((Object)f.myTargetFile, (Object)s.myTargetFile)) {
            return false;
        }
        return Comparing.equal(f.myNamespace, s.myNamespace);
    }

    public OCIncludeSymbol(@Nullable VirtualFile file2, long offset, @Nullable VirtualFile targetFile, @NotNull IncludePath path, boolean once, boolean next, int endOffset, @Nullable List<String> namespace, boolean isSymbolTableUsed) {
        super(file2, offset, path.getPath());
        this.myIncludePath = path;
        this.myTargetFile = targetFile;
        this.setFlag(Flag.ONCE, once);
        this.setFlag(Flag.NEXT, next);
        this.setFlag(Flag.SYM_TABLE_USED, isSymbolTableUsed);
        this.myEndOffset = endOffset;
        this.myNamespace = ContainerUtil.isEmpty(namespace) ? Collections.emptyList() : new ArrayList<String>(namespace);
    }

    @Nullable
    public VirtualFile getTargetFile() {
        return this.myTargetFile;
    }

    public void updateTargetFile(@Nullable VirtualFile targetFile) {
        this.myTargetFile = targetFile;
    }

    public boolean isOnce() {
        return this.getFlag(Flag.ONCE);
    }

    public boolean isNext() {
        return this.getFlag(Flag.NEXT);
    }

    public boolean isSymbolTableUsed() {
        return this.getFlag(Flag.SYM_TABLE_USED);
    }

    private boolean getFlag(@NotNull Flag flag) {
        return (this.myFlags & flag.getMask()) != 0;
    }

    private void setFlag(@NotNull Flag flag, boolean value) {
        if (value != this.getFlag(flag)) {
            this.myFlags = (byte)(this.myFlags ^ flag.getMask());
        }
    }

    public String getRelativePath() {
        return this.getName();
    }

    public String getLastPathComponent() {
        String path = this.getRelativePath();
        int idx = path.lastIndexOf(47);
        return idx >= 0 ? path.substring(idx + 1) : path;
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        return OCSymbolKind.IMPORT;
    }

    @NotNull
    public IncludePath getIncludePath() {
        return this.myIncludePath;
    }

    public int getEndOffset() {
        return this.myEndOffset;
    }

    public void enterNamespace(@NotNull OCInclusionContext ctx) {
        for (String name : this.myNamespace) {
            ctx.enterNamespace(name);
        }
    }

    public void exitNamespace(@NotNull OCInclusionContext ctx) {
        for (String ignore : this.myNamespace) {
            ctx.exitNamespace();
        }
    }

    public static class IncludePath {
        @NotNull
        private String myPath;
        private boolean myAngleBrackets;
        public static final IncludePath EMPTY = new EmptyIncludePath();

        public IncludePath() {
        }

        public IncludePath(@NotNull String path, boolean angleBrackets) {
            this.myPath = path;
            this.myAngleBrackets = angleBrackets;
        }

        public String toString() {
            return this.myAngleBrackets ? "<" + this.myPath + ">" : "\"" + this.myPath + "\"";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IncludePath)) {
                return false;
            }
            IncludePath path = (IncludePath)o;
            if (this.myAngleBrackets != path.myAngleBrackets) {
                return false;
            }
            return this.myPath.equals(path.myPath);
        }

        public int hashCode() {
            int result2 = this.myPath.hashCode();
            result2 = 31 * result2 + (this.myAngleBrackets ? 1 : 0);
            return result2;
        }

        @NotNull
        public String getPath() {
            return this.myPath;
        }

        public boolean isAngleBrackets() {
            return this.myAngleBrackets;
        }

        private static class EmptyIncludePath
        extends IncludePath {
            private EmptyIncludePath() {
                super("", false);
            }
        }
    }

    private static final class Flag
    extends Enum<Flag> {
        public static final /* enum */ Flag ONCE = new Flag();
        public static final /* enum */ Flag NEXT = new Flag();
        public static final /* enum */ Flag SYM_TABLE_USED = new Flag();
        private static final /* synthetic */ Flag[] $VALUES;

        public static Flag[] values() {
            return (Flag[])$VALUES.clone();
        }

        public static Flag valueOf(String name) {
            return Enum.valueOf(Flag.class, name);
        }

        byte getMask() {
            int idx = this.ordinal();
            assert (idx < 7);
            return (byte)(1 << idx);
        }

        static {
            $VALUES = new Flag[]{ONCE, NEXT, SYM_TABLE_USED};
        }
    }
}

