/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.settings;

import com.intellij.DynamicBundle;
import com.intellij.ide.fileTemplates.impl.FileTemplateHighlighter;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.LayeredLexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.psi.codeStyle.CodeStyleConfigurable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCNamingConventionRulesTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNamingConventionConfigurable
implements CodeStyleConfigurable {
    public static final String TAB_NAME = "Naming Convention";
    private JPanel myPanel;
    private JPanel myHeaderGuardPanel;
    private EditorTextField myHeaderGuardEditorTextField;
    private JLabel myHeaderGuardContextHelpLabel;
    private JPanel myNamingConventionTablePanel;
    @NotNull
    private final CodeStyleSettings mySettings;
    @NotNull
    private OCNamingConventionRulesTable myNamingConventionRulesTable;

    public OCNamingConventionConfigurable(@NotNull CodeStyleSettings settings) {
        this.mySettings = settings;
        this.$$$setupUI$$$();
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    public String getDisplayName() {
        return TAB_NAME;
    }

    @Nullable
    public JComponent createComponent() {
        return this.myPanel;
    }

    public boolean isModified() {
        OCCodeStyleSettings ocSettings = (OCCodeStyleSettings)this.mySettings.getCustomSettings(OCCodeStyleSettings.class);
        return !ocSettings.HEADER_GUARD_STYLE_PATTERN.equals(this.myHeaderGuardEditorTextField.getText()) || this.myNamingConventionRulesTable.isModified(ocSettings);
    }

    public void apply() throws ConfigurationException {
        this.apply(this.mySettings);
    }

    public void reset(@NotNull CodeStyleSettings settings) {
        OCCodeStyleSettings ocSettings = (OCCodeStyleSettings)settings.getCustomSettings(OCCodeStyleSettings.class);
        this.myHeaderGuardEditorTextField.setText(ocSettings.HEADER_GUARD_STYLE_PATTERN);
        this.myNamingConventionRulesTable.reset(ocSettings);
    }

    public void apply(@NotNull CodeStyleSettings settings) throws ConfigurationException {
        OCCodeStyleSettings ocSettings = (OCCodeStyleSettings)settings.getCustomSettings(OCCodeStyleSettings.class);
        ocSettings.HEADER_GUARD_STYLE_PATTERN = this.myHeaderGuardEditorTextField.getText();
        this.myNamingConventionRulesTable.apply(ocSettings);
        OCInspectionUtil.restartCodeAnalyzer();
    }

    private void createUIComponents() {
        this.myHeaderGuardEditorTextField = new HeaderGuardEditorTextField("${PROJECT_NAME}_${FILE_NAME}_${EXT}");
        this.myHeaderGuardContextHelpLabel = ContextHelpLabel.create((String)OCBundle.message("naming.convention.header.guard.style.help", new Object[0]));
        this.myNamingConventionRulesTable = new OCNamingConventionRulesTable();
        this.myNamingConventionTablePanel = new JPanel(new BorderLayout());
        this.myNamingConventionTablePanel.add((Component)this.myNamingConventionRulesTable.getComponent(), "Center");
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(5, 5, 5, 5), -1, -1, false, false));
        this.myHeaderGuardPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/OCInspectionsBundle", OCNamingConventionConfigurable.class).getString("configurable.naming.convention.header.guard.style"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        EditorTextField editorTextField = this.myHeaderGuardEditorTextField;
        jPanel.add((Component)editorTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JLabel jLabel2 = this.myHeaderGuardContextHelpLabel;
        jLabel2.setText("");
        jPanel.add((Component)jLabel2, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel3 = this.myNamingConventionTablePanel;
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setHorizontalAlignment(11);
        jBLabel.setHorizontalTextPosition(11);
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/OCInspectionsBundle", OCNamingConventionConfigurable.class).getString("configurable.naming.convention.several.rules.hint"));
        jPanel2.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static class HeaderGuardEditorTextField
    extends EditorTextField {
        HeaderGuardEditorTextField(@NotNull String text) {
            super(text);
        }

        protected EditorEx createEditor() {
            EditorEx editor = super.createEditor();
            EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
            editor.setHighlighter((EditorHighlighter)new LayeredLexerEditorHighlighter((SyntaxHighlighter)new FileTemplateHighlighter(), scheme));
            return editor;
        }
    }
}

