/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.settings;

import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.psi.codeStyle.CodeStyleConfigurable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCEnumComboOption;
import com.jetbrains.cidr.lang.settings.OCEnumGroupOption;
import com.jetbrains.cidr.lang.settings.OCOption;
import com.jetbrains.cidr.lang.util.OCDeclarationKind;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class OCGenerateCodeConfigurable
implements CodeStyleConfigurable {
    @NotNull
    private final CodeStyleSettings mySettings;
    private JCheckBox myRetainParametersBox;
    private JCheckBox myUseSettersBox;
    private JCheckBox myPutIvarsToImplementationBox;
    private JCheckBox mySemicolonAfterMethodSignatureBox;
    private JCheckBox myUseNSTypesInIntroduce;
    private JCheckBox myLineCommentOnFirstColumnCheckBox;
    private JCheckBox myLineCommentAddSpaceCheckBox;
    private JCheckBox myBlockCommentOnFirstColumnCheckBox;
    private JCheckBox myBlockCommentIndentCheckBox;
    private JCheckBox myBriefDocTagCheckBox;
    private EnumOption<OCCodeStyleSettings.DocTagPrefix> myLineTagPrefixEnumOption;
    private EnumOption<OCCodeStyleSettings.DocTagPrefix> myBlockTagPrefixEnumOption;
    private JPanel myIvarReleaseFormatComponent;
    private JPanel myGenerateIvarsForPropertiesComponent;
    private JPanel myTypeQualifiersPlacingComponent;
    private JTextField myIvarPrefixField;
    private JTextField myIvarSuffixField;
    private DefaultListModel<OCDeclarationKind> myFileDeclsOrder;
    private DefaultListModel<OCDeclarationKind> myClassDeclsOrder;
    private JCheckBox myAddGetterPrefixCheckBox;
    private JCheckBox myAddSetterPrefixCheckBox;
    private JCheckBox myGenerateAdditionalEqBox;
    private JCheckBox myGenerateAdditionalRelBox;
    private JCheckBox myInsertVirtualWithOverrideBox;
    private JCheckBox myUseModernCastsBox;
    private OCEnumComboOption<OCCodeStyleSettings.ReleaseStyle> myIvarReleaseFormatOption;
    private OCEnumComboOption<OCCodeStyleSettings.RememberedOption> myGenerateIvarsForPropertiesOption;
    private OCEnumGroupOption<OCCodeStyleSettings.Placement> myTypeQualifiersPlacingOption;
    private static final int VGAP_NEXT_SECTION = 13;
    private static final int VGAP_CHECKBOX_INDENT = 20;

    public OCGenerateCodeConfigurable(@NotNull CodeStyleSettings settings) {
        this.mySettings = settings;
    }

    @Nls
    public String getDisplayName() {
        return OCBundle.message("configurable.OCGenerateCodeConfigurable.display.name", new Object[0]);
    }

    public String getHelpTopic() {
        return "Code_Style_Code_Gen";
    }

    private void addGeneralComponent(JPanel optionsPanel, JPanel orderPanel) {
        this.myLineCommentOnFirstColumnCheckBox = new JCheckBox(ApplicationBundle.message((String)"checkbox.line.comment.at.first.column", (Object[])new Object[0]));
        this.myLineCommentAddSpaceCheckBox = new JCheckBox(ApplicationBundle.message((String)"checkbox.line.comment.add.space", (Object[])new Object[0]));
        this.myLineCommentOnFirstColumnCheckBox.addActionListener(e -> {
            if (this.myLineCommentOnFirstColumnCheckBox.isSelected()) {
                this.myLineCommentAddSpaceCheckBox.setSelected(false);
            }
            this.myLineCommentAddSpaceCheckBox.setEnabled(!this.myLineCommentOnFirstColumnCheckBox.isSelected());
        });
        this.myBlockCommentOnFirstColumnCheckBox = new JCheckBox(ApplicationBundle.message((String)"checkbox.block.comment.at.first.column", (Object[])new Object[0]));
        this.myBlockCommentIndentCheckBox = new JCheckBox(OCBundle.message("checkbox.block.comment.indent", new Object[0]));
        this.myFileDeclsOrder = new DefaultListModel();
        this.myTypeQualifiersPlacingOption = new OCEnumGroupOption<OCCodeStyleSettings.Placement>(OCBundle.message("generate.configurable.const.volatile.placement", new Object[0]), OCEnumGroupOption.Presentation.Line, (T[])OCCodeStyleSettings.Placement.values(), "const int x = 0", "int const x = 0");
        this.myTypeQualifiersPlacingComponent = this.myTypeQualifiersPlacingOption.createComponent();
        JPanel comments = new JPanel(new GridBagLayout());
        GridBag bag = new GridBag().setDefaultWeightX(1.0).setDefaultAnchor(17);
        comments.add((Component)this.myLineCommentOnFirstColumnCheckBox, bag.nextLine());
        comments.add((Component)this.myLineCommentAddSpaceCheckBox, bag.nextLine().insetLeft(20));
        comments.add((Component)this.myBlockCommentOnFirstColumnCheckBox, bag.nextLine());
        comments.add((Component)this.myBlockCommentIndentCheckBox, bag.nextLine());
        JPanel panel2 = new JPanel((LayoutManager)new VerticalFlowLayout());
        panel2.setBorder(IdeBorderFactory.createTitledBorder((String)ApplicationBundle.message((String)"title.general", (Object[])new Object[0])));
        panel2.add(comments);
        panel2.add(this.myTypeQualifiersPlacingComponent);
        optionsPanel.add(panel2);
        this.myFileDeclsOrder = new DefaultListModel<OCDeclarationKind>();
        orderPanel.add(OCGenerateCodeConfigurable.createDeclarationsOrderPanel(OCDeclarationKind.ourFileDeclarationKinds, this.myFileDeclsOrder, OCBundle.message("generate.configurable.top.level.declarations.order", new Object[0])));
    }

    private void addObjCComponent(JPanel optionsPanel, JPanel orderPanel) {
        this.myRetainParametersBox = new JCheckBox(OCBundle.message("generate.configurable.retain.parameters", new Object[0]));
        this.myUseSettersBox = new JCheckBox(OCBundle.message("generate.configurable.use.property.setters", new Object[0]));
        this.myPutIvarsToImplementationBox = new JCheckBox(OCBundle.message("generate.configurable.put.ivars", new Object[0]));
        this.mySemicolonAfterMethodSignatureBox = new JCheckBox(OCBundle.message("generate.configurable.semicolon.after.method", new Object[0]));
        this.myIvarReleaseFormatOption = new OCEnumComboOption<OCCodeStyleSettings.ReleaseStyle>(OCBundle.message("generate.configurable.ivars.release.style", new Object[0]), (T[])OCCodeStyleSettings.ReleaseStyle.values(), "[ivar release]", "[ivar release], ivar = nil", "property = nil");
        this.myGenerateIvarsForPropertiesOption = new OCEnumComboOption<OCCodeStyleSettings.RememberedOption>(OCBundle.message("generate.configurable.ivars.generation", new Object[0]), (T[])OCCodeStyleSettings.RememberedOption.values(), OCBundle.message("generate.configurable.ivars.generation.always", new Object[0]), OCBundle.message("generate.configurable.ivars.generation.never", new Object[0]), OCBundle.message("generate.configurable.ivars.generation.ask", new Object[0]));
        this.myUseNSTypesInIntroduce = new JCheckBox(OCBundle.message("generate.configurable.use.nsinteger.and.cgfloat", new Object[0]));
        this.myIvarPrefixField = new JTextField(5);
        this.myIvarSuffixField = new JTextField(5);
        this.myIvarReleaseFormatComponent = this.myIvarReleaseFormatOption.createComponent();
        this.myGenerateIvarsForPropertiesComponent = this.myGenerateIvarsForPropertiesOption.createComponent();
        JPanel panel2 = new JPanel((LayoutManager)new VerticalFlowLayout());
        panel2.setBorder(IdeBorderFactory.createTitledBorder((String)"Objective-C"));
        JPanel general = new JPanel(new GridBagLayout());
        GridBag bag = new GridBag().setDefaultWeightX(1.0).setDefaultAnchor(17);
        general.add((Component)new JLabel(OCBundle.message("generate.configurable.instance.variable.prefix", new Object[0])), bag.nextLine().next().weightx(0.0).insets(0, 0, 0, 10));
        general.add((Component)this.myIvarPrefixField, bag.next().fillCellNone());
        general.add((Component)new JLabel(OCBundle.message("generate.configurable.instance.variable.suffix", new Object[0])), bag.nextLine().next().weightx(0.0).insets(0, 0, 0, 10));
        general.add((Component)this.myIvarSuffixField, bag.next().fillCellNone());
        general.add((Component)this.myRetainParametersBox, bag.nextLine().next().coverLine().insets(13, -1, -1, -1));
        general.add((Component)this.myUseSettersBox, bag.nextLine().next().coverLine());
        general.add((Component)this.mySemicolonAfterMethodSignatureBox, bag.nextLine().next().coverLine());
        general.add((Component)this.myPutIvarsToImplementationBox, bag.nextLine().next().coverLine());
        general.add((Component)this.myUseNSTypesInIntroduce, bag.nextLine().next().coverLine());
        panel2.add(general);
        panel2.add(this.myIvarReleaseFormatComponent);
        panel2.add(this.myGenerateIvarsForPropertiesComponent);
        optionsPanel.add(panel2);
        this.myClassDeclsOrder = new DefaultListModel<OCDeclarationKind>();
        orderPanel.add(OCGenerateCodeConfigurable.createDeclarationsOrderPanel(OCDeclarationKind.ourClassDeclarationKinds, this.myClassDeclsOrder, "Objective-C class order"));
    }

    private void addCppComponent(JPanel optionsPanel) {
        this.myAddGetterPrefixCheckBox = new JCheckBox(OCBundle.message("generate.getter.add.prefix", new Object[0]));
        this.myAddSetterPrefixCheckBox = new JCheckBox(OCBundle.message("generate.setter.add.prefix", new Object[0]));
        this.myGenerateAdditionalEqBox = new JCheckBox(OCBundle.message("generate.comparison.operators.additional.eq.option.desc", new Object[0]));
        this.myGenerateAdditionalRelBox = new JCheckBox(OCBundle.message("generate.comparison.operators.additional.rel.option.desc", new Object[0]));
        this.myInsertVirtualWithOverrideBox = new JCheckBox(OCBundle.message("override.implement.cpp.action.insertVirtualWithOverride", new Object[0]));
        this.myUseModernCastsBox = new JCheckBox(OCBundle.message("intentions.insert.cast.use.modern", new Object[0]));
        JPanel panel2 = new JPanel((LayoutManager)new VerticalFlowLayout());
        panel2.setBorder(IdeBorderFactory.createTitledBorder((String)"C++"));
        JPanel general = new JPanel(new GridBagLayout());
        GridBag bag = new GridBag().setDefaultWeightX(1.0).setDefaultAnchor(17);
        general.add((Component)this.myAddGetterPrefixCheckBox, bag.nextLine().weightx(0.0).insets(0, 0, 0, 10));
        general.add((Component)this.myAddSetterPrefixCheckBox, bag.nextLine().weightx(0.0).insets(0, 0, 0, 10));
        general.add((Component)this.myGenerateAdditionalEqBox, bag.nextLine().next().coverLine().insets(13, -1, -1, -1));
        general.add((Component)this.myGenerateAdditionalRelBox, bag.nextLine().next().coverLine());
        general.add((Component)this.myInsertVirtualWithOverrideBox, bag.nextLine().next().coverLine().insets(13, -1, -1, -1));
        general.add((Component)this.myUseModernCastsBox, bag.nextLine().next().coverLine().insets(13, -1, -1, -1));
        panel2.add(general);
        optionsPanel.add(panel2);
    }

    private void addDocumentationComponent(JPanel optionsPanel) {
        JPanel panel2 = new JPanel((LayoutManager)new VerticalFlowLayout(false, false));
        panel2.setBorder(IdeBorderFactory.createTitledBorder((String)OCBundle.message("generate.configurable.documentation.title", new Object[0])));
        this.myBriefDocTagCheckBox = new JCheckBox(OCBundle.message("generate.configurable.add.brief.tag", new Object[0]));
        this.myLineTagPrefixEnumOption = new EnumOption<OCCodeStyleSettings.DocTagPrefix>(OCBundle.message("generate.configurable.tag.prefix.comments", new Object[0]), (T[])OCCodeStyleSettings.DocTagPrefix.values(), "@param", "\\param");
        this.myBlockTagPrefixEnumOption = new EnumOption<OCCodeStyleSettings.DocTagPrefix>(OCBundle.message("generate.configuralble.tag.prefix.block.comments", new Object[0]), (T[])OCCodeStyleSettings.DocTagPrefix.values(), "@param", "\\param");
        JPanel docCommentOptions = new JPanel(new GridBagLayout());
        GridBag bag = new GridBag().setDefaultWeightX(0.0).setDefaultAnchor(17);
        docCommentOptions.add((Component)this.myBriefDocTagCheckBox, bag.nextLine().next().insets(0, 0, 4, 0));
        docCommentOptions.add((Component)this.myLineTagPrefixEnumOption.getLabel(), bag.nextLine().next().insets(4, 0, 0, 10));
        for (JRadioButton button : this.myLineTagPrefixEnumOption.getButtons()) {
            docCommentOptions.add((Component)button, bag.next());
        }
        docCommentOptions.add((Component)this.myBlockTagPrefixEnumOption.getLabel(), bag.nextLine().next().insets(0, 0, 0, 10));
        for (JRadioButton button : this.myBlockTagPrefixEnumOption.getButtons()) {
            docCommentOptions.add((Component)button, bag.next());
        }
        panel2.add(docCommentOptions);
        optionsPanel.add(panel2);
    }

    public JComponent createComponent() {
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.setBorder((Border)JBUI.Borders.empty((int)0, (int)4));
        JPanel optionsPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
        JPanel orderPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
        this.addGeneralComponent(optionsPanel, orderPanel);
        if (OCLanguage.enableObjectiveCSettings()) {
            this.addObjCComponent(optionsPanel, orderPanel);
        }
        this.addCppComponent(optionsPanel);
        this.addDocumentationComponent(optionsPanel);
        panel2.add((Component)optionsPanel, "Center");
        panel2.add((Component)orderPanel, "East");
        JScrollPane scroll = ScrollPaneFactory.createScrollPane((Component)panel2);
        scroll.setHorizontalScrollBarPolicy(30);
        scroll.setVerticalScrollBarPolicy(20);
        scroll.setBorder(null);
        return scroll;
    }

    private static JPanel createDeclarationsOrderPanel(List<OCDeclarationKind> values, DefaultListModel<OCDeclarationKind> model, String title) {
        JBList list = new JBList(model);
        int width = 150;
        int height = 0;
        for (int i2 = 0; i2 < values.size(); ++i2) {
            Dimension eachSize = list.getCellRenderer().getListCellRendererComponent(list, values.get(i2), i2, true, true).getPreferredSize();
            width = Math.max(width, eachSize.width);
            height += eachSize.height;
        }
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JList)list);
        JPanel listPanel = decorator.disableAddAction().disableRemoveAction().setPreferredSize(new Dimension(width, height)).createPanel();
        listPanel.setBorder(IdeBorderFactory.createBorder());
        JPanel borderedPanel = new JPanel(new BorderLayout());
        borderedPanel.add(listPanel);
        borderedPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)title, (boolean)false));
        return borderedPanel;
    }

    public boolean isModified() {
        boolean isModified = this.isModifiedGeneralOptions();
        isModified |= this.isModifiedCppOptions();
        if (OCLanguage.enableObjectiveCSettings()) {
            isModified |= this.isModifiedObjCOptions();
        }
        return isModified |= this.isModifiedDocCommentOptions();
    }

    private boolean isModifiedCppOptions() {
        OCCodeStyleSettings ocSettings = (OCCodeStyleSettings)this.mySettings.getCustomSettings(OCCodeStyleSettings.class);
        boolean modified = OCGenerateCodeConfigurable.isModified(this.myAddGetterPrefixCheckBox, ocSettings.ADD_GETTER_PREFIX);
        modified |= OCGenerateCodeConfigurable.isModified(this.myAddSetterPrefixCheckBox, ocSettings.ADD_SETTER_PREFIX);
        modified |= OCGenerateCodeConfigurable.isModified(this.myGenerateAdditionalEqBox, ocSettings.GENERATE_ADDITIONAL_EQ_OPERATORS);
        modified |= OCGenerateCodeConfigurable.isModified(this.myGenerateAdditionalRelBox, ocSettings.GENERATE_ADDITIONAL_REL_OPERATORS);
        modified |= OCGenerateCodeConfigurable.isModified(this.myInsertVirtualWithOverrideBox, ocSettings.INSERT_VIRTUAL_WITH_OVERRIDE);
        return modified |= OCGenerateCodeConfigurable.isModified(this.myUseModernCastsBox, ocSettings.USE_MODERN_CASTS);
    }

    private boolean isModifiedObjCOptions() {
        OCCodeStyleSettings ocSettings = (OCCodeStyleSettings)this.mySettings.getCustomSettings(OCCodeStyleSettings.class);
        boolean modified = OCGenerateCodeConfigurable.isModified(this.myRetainParametersBox, ocSettings.RETAIN_OBJECT_PARAMETERS_IN_CONSTRUCTOR);
        modified |= OCGenerateCodeConfigurable.isModified(this.myUseSettersBox, ocSettings.USE_SETTERS_IN_CONSTRUCTOR);
        modified |= OCGenerateCodeConfigurable.isModified(this.myPutIvarsToImplementationBox, ocSettings.PUT_IVARS_TO_IMPLEMENTATION);
        modified |= OCGenerateCodeConfigurable.isModified(this.mySemicolonAfterMethodSignatureBox, ocSettings.SEMICOLON_AFTER_METHOD_SIGNATURE);
        modified |= OCGenerateCodeConfigurable.isModified(this.myUseNSTypesInIntroduce, ocSettings.INTRODUCE_USE_NS_TYPES);
        modified |= OCGenerateCodeConfigurable.isModified(this.myIvarReleaseFormatOption, this.myIvarReleaseFormatComponent, ocSettings.RELEASE_STYLE);
        modified |= OCGenerateCodeConfigurable.isModified(this.myGenerateIvarsForPropertiesOption, this.myGenerateIvarsForPropertiesComponent, ocSettings.GENERATE_INSTANCE_VARIABLES_FOR_PROPERTIES);
        modified |= this.isModified(this.myIvarPrefixField, ocSettings.IVARS_PREFIX);
        modified |= this.isModified(this.myIvarSuffixField, ocSettings.IVARS_SUFFIX);
        return modified |= OCGenerateCodeConfigurable.isModified(this.myClassDeclsOrder, ocSettings.CLASS_DECLARATIONS_ORDER);
    }

    private boolean isModifiedGeneralOptions() {
        CommonCodeStyleSettings ocCommonSettings = this.mySettings.getCommonSettings(OCLanguageUtils.getConfigLanguage());
        OCCodeStyleSettings ocSettings = (OCCodeStyleSettings)this.mySettings.getCustomSettings(OCCodeStyleSettings.class);
        boolean modified = OCGenerateCodeConfigurable.isModified(this.myLineCommentOnFirstColumnCheckBox, ocCommonSettings.LINE_COMMENT_AT_FIRST_COLUMN);
        modified |= OCGenerateCodeConfigurable.isModified(this.myLineCommentAddSpaceCheckBox, ocCommonSettings.LINE_COMMENT_ADD_SPACE);
        modified |= OCGenerateCodeConfigurable.isModified(this.myBlockCommentOnFirstColumnCheckBox, ocCommonSettings.BLOCK_COMMENT_AT_FIRST_COLUMN);
        modified |= OCGenerateCodeConfigurable.isModified(this.myBlockCommentIndentCheckBox, ocSettings.INDENT_BLOCK_COMMENT);
        modified |= OCGenerateCodeConfigurable.isModified(this.myFileDeclsOrder, ocSettings.FILE_DECLARATIONS_ORDER);
        return modified |= OCGenerateCodeConfigurable.isModified(this.myTypeQualifiersPlacingOption, this.myTypeQualifiersPlacingComponent, ocSettings.TYPE_QUALIFIERS_PLACEMENT);
    }

    private boolean isModifiedDocCommentOptions() {
        OCCodeStyleSettings ocSettings = (OCCodeStyleSettings)this.mySettings.getCustomSettings(OCCodeStyleSettings.class);
        boolean modified = OCGenerateCodeConfigurable.isModified(this.myBriefDocTagCheckBox, ocSettings.ADD_BRIEF_TAG);
        modified |= OCGenerateCodeConfigurable.isModified(this.myLineTagPrefixEnumOption, (Object)ocSettings.TAG_PREFIX_OF_LINE_COMMENT);
        return modified |= OCGenerateCodeConfigurable.isModified(this.myBlockTagPrefixEnumOption, (Object)ocSettings.TAG_PREFIX_OF_BLOCK_COMMENT);
    }

    public void apply() throws ConfigurationException {
        this.apply(this.mySettings);
    }

    public void apply(@NotNull CodeStyleSettings settings) throws ConfigurationException {
        this.applyGeneralOptions(settings);
        this.applyCppOptions(settings);
        if (OCLanguage.enableObjectiveCSettings()) {
            this.applyObjCOptions(settings);
        }
        this.applyDocCommentOptions(settings);
    }

    private void applyCppOptions(@NotNull CodeStyleSettings settings) {
        OCCodeStyleSettings ocSettings = (OCCodeStyleSettings)settings.getCustomSettings(OCCodeStyleSettings.class);
        ocSettings.ADD_GETTER_PREFIX = this.myAddGetterPrefixCheckBox.isSelected();
        ocSettings.ADD_SETTER_PREFIX = this.myAddSetterPrefixCheckBox.isSelected();
        ocSettings.GENERATE_ADDITIONAL_EQ_OPERATORS = this.myGenerateAdditionalEqBox.isSelected();
        ocSettings.GENERATE_ADDITIONAL_REL_OPERATORS = this.myGenerateAdditionalRelBox.isSelected();
        ocSettings.INSERT_VIRTUAL_WITH_OVERRIDE = this.myInsertVirtualWithOverrideBox.isSelected();
        ocSettings.USE_MODERN_CASTS = this.myUseModernCastsBox.isSelected();
    }

    private void applyObjCOptions(@NotNull CodeStyleSettings settings) {
        OCCodeStyleSettings ocSettings = (OCCodeStyleSettings)settings.getCustomSettings(OCCodeStyleSettings.class);
        ocSettings.RETAIN_OBJECT_PARAMETERS_IN_CONSTRUCTOR = this.myRetainParametersBox.isSelected();
        ocSettings.USE_SETTERS_IN_CONSTRUCTOR = this.myUseSettersBox.isSelected();
        ocSettings.PUT_IVARS_TO_IMPLEMENTATION = this.myPutIvarsToImplementationBox.isSelected();
        ocSettings.SEMICOLON_AFTER_METHOD_SIGNATURE = this.mySemicolonAfterMethodSignatureBox.isSelected();
        ocSettings.INTRODUCE_USE_NS_TYPES = this.myUseNSTypesInIntroduce.isSelected();
        ocSettings.RELEASE_STYLE = this.myIvarReleaseFormatOption.getSelectedValue(this.myIvarReleaseFormatComponent);
        ocSettings.GENERATE_INSTANCE_VARIABLES_FOR_PROPERTIES = this.myGenerateIvarsForPropertiesOption.getSelectedValue(this.myGenerateIvarsForPropertiesComponent);
        ocSettings.IVARS_PREFIX = this.myIvarPrefixField.getText().trim();
        ocSettings.IVARS_SUFFIX = this.myIvarSuffixField.getText().trim();
        ocSettings.CLASS_DECLARATIONS_ORDER = Arrays.asList(ArrayUtil.toObjectArray(OCDeclarationKind.class, (Object[])this.myClassDeclsOrder.toArray()));
    }

    private void applyGeneralOptions(@NotNull CodeStyleSettings settings) {
        CommonCodeStyleSettings ocCommonSettings = settings.getCommonSettings(OCLanguageUtils.getConfigLanguage());
        OCCodeStyleSettings ocSettings = (OCCodeStyleSettings)settings.getCustomSettings(OCCodeStyleSettings.class);
        ocCommonSettings.LINE_COMMENT_AT_FIRST_COLUMN = this.myLineCommentOnFirstColumnCheckBox.isSelected();
        ocCommonSettings.LINE_COMMENT_ADD_SPACE = this.myLineCommentAddSpaceCheckBox.isSelected();
        ocCommonSettings.BLOCK_COMMENT_AT_FIRST_COLUMN = this.myBlockCommentOnFirstColumnCheckBox.isSelected();
        ocSettings.INDENT_BLOCK_COMMENT = this.myBlockCommentIndentCheckBox.isSelected();
        ocSettings.FILE_DECLARATIONS_ORDER = Arrays.asList(ArrayUtil.toObjectArray(OCDeclarationKind.class, (Object[])this.myFileDeclsOrder.toArray()));
        ocSettings.TYPE_QUALIFIERS_PLACEMENT = this.myTypeQualifiersPlacingOption.getSelectedValue(this.myTypeQualifiersPlacingComponent);
    }

    private void applyDocCommentOptions(@NotNull CodeStyleSettings settings) {
        OCCodeStyleSettings ocSettings = (OCCodeStyleSettings)settings.getCustomSettings(OCCodeStyleSettings.class);
        ocSettings.ADD_BRIEF_TAG = this.myBriefDocTagCheckBox.isSelected();
        ocSettings.TAG_PREFIX_OF_LINE_COMMENT = this.myLineTagPrefixEnumOption.getSelected();
        ocSettings.TAG_PREFIX_OF_BLOCK_COMMENT = this.myBlockTagPrefixEnumOption.getSelected();
    }

    public static void customizeSettings(@NotNull CodeStyleSettingsCustomizable c) {
        c.showStandardOptions(new String[]{"LINE_COMMENT_AT_FIRST_COLUMN", "BLOCK_COMMENT_AT_FIRST_COLUMN", "LINE_COMMENT_ADD_SPACE"});
    }

    public void reset() {
        this.reset(this.mySettings);
    }

    public void reset(@NotNull CodeStyleSettings settings) {
        this.resetGeneralOptions(settings);
        this.resetCppOptions(settings);
        if (OCLanguage.enableObjectiveCSettings()) {
            this.resetObjCOptions(settings);
        }
        this.resetDocCommentOptions(settings);
    }

    private void resetCppOptions(@NotNull CodeStyleSettings settings) {
        OCCodeStyleSettings ocSettings = (OCCodeStyleSettings)settings.getCustomSettings(OCCodeStyleSettings.class);
        this.myAddGetterPrefixCheckBox.setSelected(ocSettings.ADD_GETTER_PREFIX);
        this.myAddSetterPrefixCheckBox.setSelected(ocSettings.ADD_SETTER_PREFIX);
        this.myGenerateAdditionalEqBox.setSelected(ocSettings.GENERATE_ADDITIONAL_EQ_OPERATORS);
        this.myGenerateAdditionalRelBox.setSelected(ocSettings.GENERATE_ADDITIONAL_REL_OPERATORS);
        this.myInsertVirtualWithOverrideBox.setSelected(ocSettings.INSERT_VIRTUAL_WITH_OVERRIDE);
        this.myUseModernCastsBox.setSelected(ocSettings.USE_MODERN_CASTS);
    }

    private void resetObjCOptions(@NotNull CodeStyleSettings settings) {
        OCCodeStyleSettings ocSettings = (OCCodeStyleSettings)settings.getCustomSettings(OCCodeStyleSettings.class);
        this.myRetainParametersBox.setSelected(ocSettings.RETAIN_OBJECT_PARAMETERS_IN_CONSTRUCTOR);
        this.myUseSettersBox.setSelected(ocSettings.USE_SETTERS_IN_CONSTRUCTOR);
        this.myPutIvarsToImplementationBox.setSelected(ocSettings.PUT_IVARS_TO_IMPLEMENTATION);
        this.mySemicolonAfterMethodSignatureBox.setSelected(ocSettings.SEMICOLON_AFTER_METHOD_SIGNATURE);
        this.myUseNSTypesInIntroduce.setSelected(ocSettings.INTRODUCE_USE_NS_TYPES);
        this.myIvarReleaseFormatOption.selectValue(this.myIvarReleaseFormatComponent, ocSettings.RELEASE_STYLE);
        this.myGenerateIvarsForPropertiesOption.selectValue(this.myGenerateIvarsForPropertiesComponent, ocSettings.GENERATE_INSTANCE_VARIABLES_FOR_PROPERTIES);
        this.myIvarPrefixField.setText(ocSettings.IVARS_PREFIX);
        this.myIvarSuffixField.setText(ocSettings.IVARS_SUFFIX);
        this.myClassDeclsOrder.removeAllElements();
        for (OCDeclarationKind kind : ocSettings.CLASS_DECLARATIONS_ORDER) {
            this.myClassDeclsOrder.addElement(kind);
        }
    }

    private void resetGeneralOptions(@NotNull CodeStyleSettings settings) {
        CommonCodeStyleSettings ocCommonSettings = settings.getCommonSettings(OCLanguageUtils.getConfigLanguage());
        OCCodeStyleSettings ocSettings = (OCCodeStyleSettings)settings.getCustomSettings(OCCodeStyleSettings.class);
        this.myLineCommentOnFirstColumnCheckBox.setSelected(ocCommonSettings.LINE_COMMENT_AT_FIRST_COLUMN);
        this.myLineCommentAddSpaceCheckBox.setSelected(ocCommonSettings.LINE_COMMENT_ADD_SPACE);
        this.myLineCommentAddSpaceCheckBox.setEnabled(!ocCommonSettings.LINE_COMMENT_AT_FIRST_COLUMN);
        this.myBlockCommentOnFirstColumnCheckBox.setSelected(ocCommonSettings.BLOCK_COMMENT_AT_FIRST_COLUMN);
        this.myBlockCommentIndentCheckBox.setSelected(ocSettings.INDENT_BLOCK_COMMENT);
        this.myTypeQualifiersPlacingOption.selectValue(this.myTypeQualifiersPlacingComponent, ocSettings.TYPE_QUALIFIERS_PLACEMENT);
        this.myFileDeclsOrder.removeAllElements();
        for (OCDeclarationKind kind : ocSettings.FILE_DECLARATIONS_ORDER) {
            this.myFileDeclsOrder.addElement(kind);
        }
    }

    private void resetDocCommentOptions(@NotNull CodeStyleSettings settings) {
        OCCodeStyleSettings ocSettings = (OCCodeStyleSettings)settings.getCustomSettings(OCCodeStyleSettings.class);
        this.myBriefDocTagCheckBox.setSelected(ocSettings.ADD_BRIEF_TAG);
        this.myLineTagPrefixEnumOption.selectedValue(ocSettings.TAG_PREFIX_OF_LINE_COMMENT);
        this.myBlockTagPrefixEnumOption.selectedValue(ocSettings.TAG_PREFIX_OF_BLOCK_COMMENT);
    }

    private static boolean isModified(JCheckBox checkBox, boolean value) {
        return checkBox.isSelected() != value;
    }

    private static <T, Comp extends JComponent> boolean isModified(OCOption<T, Comp> option, Comp component, T value) {
        return !option.getSelectedValue(component).equals(value);
    }

    private static boolean isModified(DefaultListModel model, List<OCDeclarationKind> order) {
        assert (model.size() == order.size());
        for (int i2 = 0; i2 < model.size(); ++i2) {
            if (model.elementAt(i2) == order.get(i2)) continue;
            return true;
        }
        return false;
    }

    private static boolean isModified(EnumOption<?> groupOption, Object val) {
        return groupOption.getSelected() != val;
    }

    private static class EnumOption<T> {
        private final T[] myValues;
        private final JLabel myLabel;
        private final List<JRadioButton> myButtons = new ArrayList<JRadioButton>();

        EnumOption(String groupName, T[] values, String ... choices) {
            assert (values.length == choices.length);
            this.myValues = values;
            this.myLabel = new JLabel(groupName + ":");
            ButtonGroup group = new ButtonGroup();
            for (String choice : choices) {
                JRadioButton button = new JRadioButton(choice);
                group.add(button);
                this.myButtons.add(button);
            }
        }

        public List<JRadioButton> getButtons() {
            return this.myButtons;
        }

        public JLabel getLabel() {
            return this.myLabel;
        }

        public T getSelected() {
            for (int i2 = 0; i2 < this.myButtons.size(); ++i2) {
                if (!this.myButtons.get(i2).isSelected()) continue;
                return this.myValues[i2];
            }
            return null;
        }

        public void selectedValue(T val) {
            for (int i2 = 0; i2 < this.myValues.length; ++i2) {
                if (this.myValues[i2] != val) continue;
                this.myButtons.get(i2).setSelected(true);
                break;
            }
        }
    }
}

