/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search.scopes;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.scope.packageSet.AbstractPackageSet;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ProjectSourcesScopeProvider
extends CustomScopesProviderEx {
    private List<NamedScope> myScopes = ContainerUtil.immutableList((Object[])new NamedScope[]{new SourceFilesScope(), new NonSourceFilesScope()});

    @NotNull
    public List<NamedScope> getCustomScopes() {
        return this.myScopes;
    }

    public static class NonSourceFilesScope
    extends NamedScope {
        public static final String NAME = "Project Non-Source Files";

        public NonSourceFilesScope() {
            super(NAME, AllIcons.Modules.ResourcesRoot, (PackageSet)new AbstractPackageSet(NAME){

                public boolean contains(@NotNull VirtualFile file2, NamedScopesHolder holder) {
                    return OCSearchScope.isInProjectNonSources(holder.getProject(), file2);
                }
            });
        }
    }

    public static class SourceFilesScope
    extends NamedScope {
        public static final String NAME = "Project Source Files";

        public SourceFilesScope() {
            super(NAME, AllIcons.Modules.SourceRoot, (PackageSet)new AbstractPackageSet(NAME){

                public boolean contains(@NotNull VirtualFile file2, NamedScopesHolder holder) {
                    return OCSearchScope.isInProjectSources(holder.getProject(), file2);
                }
            });
        }
    }
}

