/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search.constructors;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCType;
import org.jetbrains.annotations.NotNull;

public abstract class OCBaseConstructorReference
implements PsiReference {
    @NotNull
    protected final PsiElement myElement;
    @NotNull
    protected final OCSymbolDeclarator myField;
    @NotNull
    protected final OCFunctionSymbol myTargetConstructor;

    public OCBaseConstructorReference(@NotNull PsiElement element, @NotNull OCSymbolDeclarator field, @NotNull OCFunctionSymbol targetConstructor) {
        this.myElement = element;
        this.myField = field;
        this.myTargetConstructor = targetConstructor;
    }

    @NotNull
    public PsiElement getElement() {
        return this.myElement;
    }

    public PsiElement resolve() {
        return this.myTargetConstructor.locateDefinition(this.myElement.getProject());
    }

    @NotNull
    public OCFunctionSymbol getTargetConstructor() {
        return this.myTargetConstructor;
    }

    @NotNull
    public OCSymbolDeclarator getField() {
        return this.myField;
    }

    @NotNull
    public String getCanonicalText() {
        return this.myElement.getText();
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        return null;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        return null;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (!(element instanceof OCFunctionDeclaration)) {
            return false;
        }
        OCSymbolWithQualifiedName symbol = (OCSymbolWithQualifiedName)((OCFunctionDeclaration)element).getSymbol();
        if (Comparing.equal((Object)this.myTargetConstructor, (Object)symbol)) {
            return true;
        }
        if (symbol != null && symbol.isGlobal()) {
            OCQualifiedName symbolName;
            OCResolveContext context2 = OCResolveContext.forPsi(element);
            OCQualifiedName thisName = this.myTargetConstructor.getResolvedQualifiedName(context2);
            if (Comparing.equal((Object)thisName, (Object)(symbolName = symbol.getResolvedQualifiedName(context2)))) {
                OCType symbolType;
                OCType thisResolvedType;
                return !(symbol instanceof OCFunctionSymbol) || (thisResolvedType = this.myTargetConstructor.getResolvedType(context2)).equals(symbolType = symbol.getResolvedType(context2), context2);
            }
            return false;
        }
        return false;
    }

    public boolean isSoft() {
        return false;
    }
}

