/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.searches.DefinitionsScopedSearch;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.search.OCClassInheritorsSearch;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.search.OCStructInheritorsSearch;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCLocalizedStringSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCSynthesizeSymbol;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class OCDefinitionsSearch
extends QueryExecutorBase<PsiElement, DefinitionsScopedSearch.SearchParameters> {
    public void processQuery(@NotNull DefinitionsScopedSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiElement> consumer) {
        ReadAction.run(() -> {
            PsiElement subj = queryParameters.getElement();
            if (!(subj instanceof OCSymbolDeclarator)) {
                return;
            }
            Object symbol = ((OCSymbolDeclarator)subj).getSymbol();
            if (symbol == null) {
                return;
            }
            if (subj instanceof OCMethod || subj instanceof OCDeclarator && subj.getParent() instanceof OCFunctionDeclaration) {
                Project project2 = subj.getProject();
                OCSymbol selfDefinitionSymbol = symbol.getDefinitionSymbol(project2);
                OCDefinitionsSearch.consume(consumer, selfDefinitionSymbol, project2);
                OCSearchUtil.processMembersHierarchy((OCSymbolWithParent)symbol, symbol1 -> !symbol1.isDefinition() && symbol1.getDefinitionSymbol(project2) != null || symbol1 == selfDefinitionSymbol || OCDefinitionsSearch.consume(consumer, symbol1, project2), false, true, false, project2);
            } else {
                OCDefinitionsSearch.processSymbolDefinition(symbol, consumer, subj.getProject());
            }
        });
    }

    private static void processSymbolDefinition(@NotNull OCSymbol symbol, Processor<? super PsiElement> consumer, @NotNull Project project2) {
        if (symbol instanceof OCPropertySymbol) {
            if (((OCPropertySymbol)symbol).processAccessorMethods((Processor<? super OCMethodSymbol>)((Processor)accessor -> OCDefinitionsSearch.consume(consumer, accessor, project2)), true, project2)) {
                ((OCPropertySymbol)symbol).processSynthesizes((Processor<? super OCSynthesizeSymbol>)((Processor)synthesize -> OCDefinitionsSearch.consume(consumer, synthesize, project2)), project2);
            }
            return;
        }
        if (symbol instanceof OCClassSymbol) {
            if (symbol.processSameSymbols((Processor<OCSymbol>)((Processor)curSymbol -> {
                if (curSymbol.equals(symbol) || curSymbol.isPredeclaration()) {
                    return true;
                }
                if (curSymbol instanceof OCInterfaceSymbol && ((OCInterfaceSymbol)curSymbol).getImplementation(((OCInterfaceSymbol)curSymbol).getCategoryName(), project2) != null) {
                    return true;
                }
                return OCDefinitionsSearch.consume(consumer, curSymbol, project2);
            }), project2)) {
                OCClassInheritorsSearch.search((OCClassSymbol)symbol, project2).forEach(symbol12 -> OCDefinitionsSearch.consume(consumer, symbol12, project2));
            }
            return;
        }
        if (symbol instanceof OCStructSymbol) {
            PsiElement element = symbol.locateDefinition(project2);
            if (element != null) {
                Query<OCStructSymbol> query = OCStructInheritorsSearch.search((OCStructSymbol)symbol, element);
                query.forEach(s -> OCDefinitionsSearch.consume(consumer, s, project2));
            }
            OCSearchUtil.getRelatedSymbols((OCStructSymbol)symbol, project2).forEach(s -> OCDefinitionsSearch.consume(consumer, s, project2));
        }
        if (symbol instanceof OCLocalizedStringSymbol) {
            symbol.processSameSymbols((Processor<OCSymbol>)((Processor)symbol1 -> {
                OCDefinitionsSearch.consume(consumer, symbol1, project2);
                return true;
            }), project2);
        }
    }

    @Contract(value="_, null, _ -> true")
    private static boolean consume(Processor<? super PsiElement> consumer, OCSymbol subj, @NotNull Project project2) {
        if (subj == null) {
            return true;
        }
        PsiElement psi = subj.locateDefinition(project2);
        if (psi != null) {
            return consumer.process((Object)psi);
        }
        return true;
    }
}

