/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve.v2;

import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.visitors.OCTypeUnificationVisitor;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class TemplatesUtils {
    public static OCTemplateSymbol getMoreSpecializedTemplate(OCFunctionSymbol FT1, OCFunctionSymbol FT2, int argCount, @NotNull OCResolveContext context2) {
        boolean Variadic2;
        boolean Better2;
        boolean Better1 = TemplatesUtils.isAtLeastAsSpecializedAs(FT1, FT2, argCount, context2);
        if (Better1 != (Better2 = TemplatesUtils.isAtLeastAsSpecializedAs(FT2, FT1, argCount, context2))) {
            return Better1 ? FT1 : FT2;
        }
        if (!Better1 && !Better2) {
            return null;
        }
        boolean Variadic1 = FT1.isVariadicTemplate();
        if (Variadic1 != (Variadic2 = FT2.isVariadicTemplate())) {
            return Variadic1 ? FT2 : FT1;
        }
        return null;
    }

    public static boolean isAtLeastAsSpecializedAs(@NotNull OCFunctionSymbol FT1, @NotNull OCFunctionSymbol FT2, int argCount, @NotNull OCResolveContext context2) {
        assert (FT1.isTemplateSymbol() && FT2.isTemplateSymbol());
        Map<OCTypeParameterSymbol, OCTypeArgument> map2 = OCTypeUtils.newTypeParameterMap();
        OCType t1 = FT1.getTypeWithoutSubstitution().resolve(context2);
        OCType t2 = FT2.getTypeWithoutSubstitution().resolve(context2);
        OCTypeUnificationVisitor visitor = new OCTypeUnificationVisitor(false, false, false, false, true, t1, null, map2, null, context2);
        visitor.setRelevantFunctionArgumentsCount(argCount);
        return visitor.unify(t2, t1).isUnified();
    }
}

