/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.unwrap;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCEmptyStatement;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.psi.OCLoopStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.refactoring.unwrap.OCUnwrapper;
import org.jetbrains.annotations.NotNull;

public class OCForUnwrapper
extends OCUnwrapper {
    public OCForUnwrapper() {
        super(CodeInsightBundle.message((String)"unwrap.for", (Object[])new Object[0]));
    }

    public boolean isApplicableTo(@NotNull PsiElement e) {
        return e instanceof OCForStatement || e instanceof OCForeachStatement;
    }

    protected void doUnwrap(PsiElement element, OCUnwrapper.Context context2) {
        boolean addNewLine = false;
        if (element instanceof OCForStatement) {
            addNewLine = this.unwrapInitializer((OCForStatement)element, context2);
        }
        this.unwrapBody((OCLoopStatement)element, addNewLine, context2);
        context2.delete(element);
    }

    private boolean unwrapInitializer(OCForStatement forStmt, OCUnwrapper.Context context2) {
        OCStatement init = forStmt.getInitializer();
        if (init != null) {
            context2.extractFromBlockOrSingleStatement(init, forStmt);
            OCStatement next = init;
            while (true) {
                if (context2.isWhiteSpace(next = next.getNextSibling())) {
                    context2.extractWhitespace(next, forStmt);
                    continue;
                }
                if (PsiUtilCore.getElementType((PsiElement)next) != OCTokenTypes.BLOCK_COMMENT) break;
                context2.extractElement(next, forStmt);
            }
            if (PsiUtilCore.getElementType((PsiElement)next) == OCTokenTypes.SEMICOLON) {
                context2.extractElement(next, forStmt);
            }
            return true;
        }
        return false;
    }

    private void unwrapBody(OCLoopStatement loopStmt, boolean addNewLine, OCUnwrapper.Context context2) {
        OCStatement body = loopStmt.getBody();
        if (body != null) {
            if (addNewLine && !(body instanceof OCEmptyStatement)) {
                context2.addNewLineBefore(loopStmt);
            }
            context2.extractFromBlockOrSingleStatement(body, loopStmt);
        }
    }
}

