/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.unwrap;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.refactoring.unwrap.OCElseUnwrapperBase;
import com.jetbrains.cidr.lang.refactoring.unwrap.OCUnwrapper;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCElseRemover
extends OCElseUnwrapperBase {
    public OCElseRemover() {
        super(CodeInsightBundle.message((String)"remove.else", (Object[])new Object[0]));
    }

    public PsiElement collectAffectedElements(@NotNull PsiElement e, @NotNull List<PsiElement> toExtract) {
        super.collectAffectedElements(e, toExtract);
        return ((OCIfStatement)e.getParent()).getElseBranch();
    }

    @Override
    protected void doUnwrapElse(OCStatement branch, OCUnwrapper.Context context2) throws IncorrectOperationException {
        if (this.isElseIfBranch(branch)) {
            this.deleteSelectedElseIf((OCIfStatement)branch, context2);
        } else {
            this.deleteLastElseOrElseIf(branch, context2);
        }
    }

    private void deleteSelectedElseIf(OCIfStatement selectedBranch, OCUnwrapper.Context context2) throws IncorrectOperationException {
        OCIfStatement parentIf = (OCIfStatement)selectedBranch.getParent();
        OCStatement childElse = selectedBranch.getElseBranch();
        if (childElse == null) {
            this.deleteLastElseOrElseIf(selectedBranch, context2);
            return;
        }
        context2.setElseBranch(parentIf, childElse);
    }

    private void deleteLastElseOrElseIf(OCStatement branch, OCUnwrapper.Context context2) {
        assert (!(branch instanceof OCIfStatement) || ((OCIfStatement)branch).getElseBranch() == null);
        context2.delete(branch);
    }
}

