/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.rename;

import com.intellij.application.options.CodeStyle;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.parser.OCMacroRange;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCategoryName;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCLocalizedString;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCPropertyAttribute;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.impl.OCFileReference;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.OCRenameProcessorExtension;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureActionHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandler;
import com.jetbrains.cidr.lang.refactoring.rename.OCForeignUsagesRenameProcessor;
import com.jetbrains.cidr.lang.refactoring.rename.OCRenameUtil;
import com.jetbrains.cidr.lang.search.OCElementInMacroSubstitutionReferenceSearch;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeductionGuideSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCCompatibilityAliasSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCNamesValidator;
import com.jetbrains.cidr.lang.util.OCScopeInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCRenameProcessor
extends RenamePsiElementProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        return element instanceof OCElement && element instanceof PsiNamedElement || element instanceof OCReferenceElement && element.getParent() instanceof OCSynthesizeProperty || element instanceof OCLocalizedString;
    }

    public void prepareRenaming(@NotNull PsiElement element, final @NotNull String newName, final @NotNull Map<PsiElement, String> allRenames, final @NotNull SearchScope scope) {
        OCClassDeclaration clazz;
        FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.rename");
        OCSymbol symbol = OCRenameUtil.getSymbolToRename(element);
        final Project project2 = element.getProject();
        final PsiFile refFile = element.getContainingFile();
        if (symbol != null) {
            OCStructSymbol struct;
            if (symbol instanceof OCStructSymbol) {
                OCRenameProcessor.prepareStruct(element, (OCStructSymbol)symbol, newName, allRenames, project2);
            } else if (!(symbol instanceof OCClassSymbol)) {
                symbol.processSameSymbols((Processor<OCSymbol>)((Processor)symbol12 -> {
                    OCRenameProcessor.addSymbol(newName, allRenames, symbol12, project2);
                    return true;
                }), project2);
            }
            if (symbol instanceof OCSymbolWithParent) {
                OCSearchUtil.processMembersHierarchy((OCSymbolWithParent)symbol, symbol1 -> {
                    OCRenameProcessor.addSymbol(newName, allRenames, symbol1, project2);
                    return true;
                }, false, true, project2);
            }
            if (symbol instanceof OCFunctionSymbol && symbol.getKind().isConstructorOrDestructor()) {
                OCSymbolWithQualifiedName owner = ((OCFunctionSymbol)symbol).getResolvedOwner(OCResolveContext.forPsi(element));
                if (owner instanceof OCStructSymbol) {
                    OCRenameProcessor.addSymbol(newName, allRenames, owner, project2);
                    OCRenameProcessor.prepareStruct(element, (OCStructSymbol)owner, newName, allRenames, project2);
                }
            } else if (symbol instanceof OCDeductionGuideSymbol && (struct = ((OCDeductionGuideSymbol)symbol).getResolvedTemplateId(OCResolveContext.forPsi(element))) != null) {
                OCRenameProcessor.addSymbol(newName, allRenames, struct, project2);
                OCRenameProcessor.prepareStruct(element, struct, newName, allRenames, project2);
            }
            symbol = symbol.getDefinitionSymbol(project2);
            if (symbol != null) {
                element = symbol.locateDefinition(project2);
                OCRenameProcessor.processAssociatedSymbols(symbol, new AssociatedElementsProcessor(){

                    @Override
                    public boolean processIvar(OCInstanceVariableSymbol ivar, OCPropertySymbol fromProperty) {
                        OCRenameProcessor.this.prepareInstanceVariable(newName, allRenames, fromProperty, ivar, refFile);
                        return true;
                    }

                    @Override
                    public boolean processPropertyAccessors(OCPropertySymbol property) {
                        OCRenameProcessor.preparePropertyAccessors(newName, allRenames, property, project2);
                        return true;
                    }

                    @Override
                    public boolean processProperty(OCPropertySymbol property, OCSymbol fromSymbol) {
                        OCRenameProcessor.this.prepareProperty(newName, allRenames, fromSymbol, property, refFile);
                        return true;
                    }

                    @Override
                    public boolean processClassAlias(OCClassSymbol clazz, OCCompatibilityAliasSymbol alias) {
                        OCRenameProcessor.prepareClassAlias(newName, allRenames, clazz, alias, refFile);
                        return true;
                    }

                    @Override
                    public boolean processClass(OCCompatibilityAliasSymbol alias, OCClassSymbol clazz) {
                        OCRenameProcessor.prepareClass(newName, allRenames, alias, clazz, scope, project2);
                        return true;
                    }
                }, scope, project2);
            }
        }
        if (element instanceof OCFile) {
            OCRenameProcessor.prepareFile((OCFile)element, newName, allRenames, scope, project2);
        } else if (element instanceof OCClassDeclaration) {
            clazz = (OCClassDeclaration)element;
            String category = clazz.getCategory();
            OCRenameProcessor.prepareClass(clazz.getName(), category, category != null ? newName + "+" + category : newName, allRenames, scope, element instanceof OCProtocol, project2);
        } else if (element instanceof OCCategoryName) {
            clazz = (OCClassDeclaration)element.getParent();
            OCRenameProcessor.prepareClass(clazz.getName(), clazz.getCategory(), clazz.getName() + "+" + newName, allRenames, scope, false, project2);
        }
        Iterator<PsiElement> iterator2 = allRenames.keySet().iterator();
        while (iterator2.hasNext()) {
            PsiElement e = iterator2.next();
            if (OCSearchScope.isInProjectSources(e) && !OCElementUtil.hasSyntheticIdentifier(e)) continue;
            iterator2.remove();
        }
    }

    private static void addSymbol(String newName, Map<PsiElement, String> allRenames, OCSymbol symbol, Project project2) {
        PsiElement element;
        if (symbol != null && (element = symbol.locateDefinition(project2)) != null) {
            allRenames.put(element, newName);
        }
    }

    public static void processAssociatedSymbols(OCSymbol symbol, AssociatedElementsProcessor processor2, SearchScope scope, Project project2) {
        if (symbol instanceof OCPropertySymbol) {
            OCPropertySymbol property = (OCPropertySymbol)symbol;
            OCInstanceVariableSymbol ivar = property.getAssociatedIvar(project2);
            if (ivar != null && OCElementUtil.endsWithIgnoringFirstLetterCase(ivar.getName(), symbol.getName())) {
                ivar.processSameSymbols((Processor<OCSymbol>)((Processor)symbol14 -> processor2.processIvar((OCInstanceVariableSymbol)symbol14, property)), project2);
            }
            property.processSameSymbols((Processor<OCSymbol>)((Processor)symbol13 -> processor2.processPropertyAccessors((OCPropertySymbol)symbol13)), project2);
        } else if (symbol instanceof OCInstanceVariableSymbol) {
            OCInstanceVariableSymbol ivar = (OCInstanceVariableSymbol)symbol;
            OCPropertySymbol property = ivar.getAssociatedProperty(project2);
            if (property != null && OCElementUtil.endsWithIgnoringFirstLetterCase(symbol.getName(), property.getName())) {
                property.processSameSymbols((Processor<OCSymbol>)((Processor)symbol12 -> processor2.processProperty((OCPropertySymbol)symbol12, ivar)), project2);
            }
        } else if (symbol instanceof OCMethodSymbol) {
            OCPropertySymbol property = ((OCMethodSymbol)symbol).getGeneratedFromProperty();
            if (property == null) {
                OCMethodSymbol associatedSymbol = (OCMethodSymbol)symbol.getAssociatedSymbol(project2);
                OCPropertySymbol oCPropertySymbol = property = associatedSymbol != null ? associatedSymbol.getGeneratedFromProperty() : null;
            }
            if (property != null) {
                property.processSameSymbols((Processor<OCSymbol>)((Processor)property1 -> processor2.processProperty((OCPropertySymbol)property1, symbol)), project2);
            }
        } else if (symbol instanceof OCCompatibilityAliasSymbol) {
            OCClassSymbol clazz;
            OCCompatibilityAliasSymbol alias = (OCCompatibilityAliasSymbol)symbol;
            OCType type = alias.getResolvedType(OCResolveContext.forSymbol(alias, project2));
            if (type instanceof OCObjectType && (clazz = ((OCObjectType)type).getClassSymbol()) != null && OCElementUtil.endsWithIgnoringFirstLetterCase(clazz.getName(), alias.getName())) {
                processor2.processClass(alias, clazz);
            }
        } else if (symbol instanceof OCClassSymbol) {
            OCClassSymbol clazz = (OCClassSymbol)symbol;
            OCGlobalProjectSymbolsCache.processAliasNamesForType(project2, clazz.getName(), (Processor<String>)((Processor)s -> {
                OCGlobalProjectSymbolsCache.processTopLevelSymbols(project2, (Processor<? super OCSymbol>)((Processor)symbol1 -> {
                    if (symbol1 instanceof OCCompatibilityAliasSymbol && OCRenameProcessor.isInScope(symbol1, scope)) {
                        OCType type = symbol1.getResolvedType(OCResolveContext.forSymbol(symbol1, project2));
                        if (!(type instanceof OCObjectType)) {
                            return true;
                        }
                        OCClassSymbol classSymbol = ((OCObjectType)type).getClassSymbol();
                        if (classSymbol == null || !classSymbol.equals(clazz)) {
                            return true;
                        }
                        if (OCElementUtil.endsWithIgnoringFirstLetterCase(clazz.getName(), symbol1.getName()) && !processor2.processClassAlias(clazz, (OCCompatibilityAliasSymbol)symbol1)) {
                            return false;
                        }
                    }
                    return true;
                }), s);
                return true;
            }));
        }
    }

    private static boolean isInScope(OCSymbol symbol, SearchScope scope) {
        return !(scope instanceof LocalSearchScope) || ((LocalSearchScope)scope).isInScope(symbol.getContainingFile());
    }

    private void prepareInstanceVariable(String newName, Map<PsiElement, String> allRenames, OCPropertySymbol property, OCInstanceVariableSymbol ivar, @NotNull PsiFile refFile) {
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)refFile, OCCodeStyleSettings.class);
        String newIvarName = OCRenameProcessor.getNewIvarName(newName, ivar.getName(), property.getName());
        Project project2 = refFile.getProject();
        if (ivar.isClang4ImplicitIvar(refFile)) {
            allRenames.put(new OCSymbolHolderVirtualPsiElement(ivar, project2), newIvarName);
        } else if (settings.REFACTOR_PROPERTIES_AND_IVARS) {
            OCRenameProcessor.addSymbol(newIvarName, allRenames, ivar, project2);
        }
    }

    private static String getNewIvarName(String newPropName, String ivarName, String propName) {
        int prefixLength = ivarName.length() - propName.length();
        String suffix = newPropName;
        if (newPropName.length() > 0 && prefixLength < ivarName.length() && Character.isUpperCase(ivarName.charAt(prefixLength)) && (!Character.isUpperCase(propName.charAt(0)) || Character.isUpperCase(newPropName.charAt(0)) || prefixLength != 0 && Character.isLetter(ivarName.charAt(prefixLength - 1)))) {
            suffix = StringUtil.capitalize((String)suffix);
        }
        return ivarName.substring(0, prefixLength) + suffix;
    }

    private static void preparePropertyAccessors(String newName, Map<PsiElement, String> allRenames, OCPropertySymbol property, Project project2) {
        property.getParent().processMembers(OCMethodSymbol.class, symbol -> {
            if (symbol.getGeneratedFromProperty() == property) {
                OCResolveContext context2 = OCResolveContext.forSymbol(symbol, project2);
                if (symbol.isGetter(context2) && !property.hasAttribute(OCPropertySymbol.PropertyAttribute.GETTER)) {
                    allRenames.put(new OCSymbolHolderVirtualPsiElement((OCSymbol)symbol, project2), newName);
                } else if (symbol.isSetter(context2) && !property.hasAttribute(OCPropertySymbol.PropertyAttribute.SETTER)) {
                    allRenames.put(new OCSymbolHolderVirtualPsiElement((OCSymbol)symbol, project2), OCNameSuggester.getObjCSetterFromGetter(newName));
                }
            }
            return true;
        });
        property.processAccessorMethods((Processor<? super OCMethodSymbol>)((Processor)method -> {
            String oldName = method.getName();
            if (oldName.equals(property.getAttributeValue(OCPropertySymbol.PropertyAttribute.GETTER)) || oldName.equals(property.getAttributeValue(OCPropertySymbol.PropertyAttribute.SETTER) + ":")) {
                return true;
            }
            OCRenameProcessor.addSymbol(OCElementUtil.startsWithWord(oldName, "set") ? "set" + StringUtil.capitalize((String)newName) : newName, allRenames, method, project2);
            List<OCMethodSymbol.SelectorPartSymbol> selectors = method.getSelectors();
            OCDeclaratorSymbol parameter = selectors.get(0).getParameter();
            if (parameter != null && OCElementUtil.endsWithIgnoringFirstLetterCase(parameter.getName(), property.getName())) {
                OCRenameProcessor.addSymbol(OCRenameProcessor.getNewIvarName(newName, parameter.getName(), property.getName()), allRenames, parameter, project2);
            }
            return true;
        }), true, project2);
    }

    private void prepareProperty(String newName, Map<PsiElement, String> allRenames, OCSymbol fromSymbol, OCPropertySymbol property, @NotNull PsiFile refFile) {
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)refFile, OCCodeStyleSettings.class);
        Project project2 = refFile.getProject();
        if (fromSymbol instanceof OCInstanceVariableSymbol) {
            OCInstanceVariableSymbol ivar = (OCInstanceVariableSymbol)fromSymbol;
            if (settings.REFACTOR_PROPERTIES_AND_IVARS || ivar.isClang4ImplicitIvar(project2)) {
                String newPropertyName;
                String prefix = ivar.getName().substring(0, ivar.getName().length() - property.getName().length());
                if (newName.startsWith(prefix) && newName.length() > prefix.length()) {
                    newPropertyName = newName.substring(prefix.length());
                    if (Character.isLowerCase(property.getName().charAt(0))) {
                        newPropertyName = StringUtil.decapitalize((String)newPropertyName);
                    }
                } else {
                    newPropertyName = newName;
                }
                OCRenameProcessor.addSymbol(newPropertyName, allRenames, property, project2);
                OCRenameProcessor.preparePropertyAccessors(newPropertyName, allRenames, property, project2);
            }
        } else if (fromSymbol instanceof OCMethodSymbol) {
            OCMethodSymbol accessor = (OCMethodSymbol)fromSymbol;
            if (accessor.isSetter(OCResolveContext.forSymbol(accessor, project2))) {
                String getter = OCNameSuggester.getObjCGetterFromSetter(newName);
                newName = getter != null ? getter : newName;
            }
            OCRenameProcessor.addSymbol(newName, allRenames, property, project2);
            OCRenameProcessor.preparePropertyAccessors(newName, allRenames, property, project2);
        }
    }

    private static void prepareClassAlias(String newName, Map<PsiElement, String> allRenames, @NotNull OCClassSymbol clazz, OCCompatibilityAliasSymbol alias, @NotNull PsiFile refFile) {
        int endPrefixIndex = clazz.getName().length() - alias.getName().length();
        String prefix = clazz.getName().substring(0, endPrefixIndex);
        if (newName.startsWith(prefix) && newName.length() > prefix.length()) {
            OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)refFile, OCCodeStyleSettings.class);
            if (settings.REFACTOR_COMPATIBILITY_ALIASES_AND_CLASSES) {
                String newAliasName = newName.substring(prefix.length());
                OCRenameProcessor.addSymbol(newAliasName, allRenames, alias, refFile.getProject());
            }
        }
    }

    private static void prepareFile(OCFile file2, String newName, Map<PsiElement, String> allRenames, SearchScope scope, Project project2) {
        if (!FileUtilRt.extensionEquals((String)newName, (String)FileUtilRt.getExtension((String)file2.getName()))) {
            allRenames.put(file2, newName);
            return;
        }
        boolean renameSameNamedClass = OCRenameUtil.shouldRenameSameClassOrFileEntity(file2);
        if (renameSameNamedClass) {
            OCFile headerFile;
            OCFile oCFile = headerFile = file2.isHeader() ? file2 : file2.getAssociatedFileWithSameName();
            if (headerFile != null) {
                OCSymbol mainClass = headerFile.getSameNamedClass();
                String nameWithoutExtension = FileUtilRt.getNameWithoutExtension((String)newName);
                if (mainClass instanceof OCClassSymbol) {
                    OCRenameProcessor.prepareClass(mainClass.getName(), ((OCClassSymbol)mainClass).getCategoryName(), nameWithoutExtension, allRenames, scope, mainClass instanceof OCProtocolSymbol, project2);
                    return;
                }
                if (mainClass instanceof OCStructSymbol) {
                    OCRenameProcessor.prepareStruct(file2, (OCStructSymbol)mainClass, nameWithoutExtension, allRenames, project2);
                    return;
                }
            }
        }
        OCRenameProcessor.processAssociatedFiles(file2, newName, allRenames);
    }

    private static void processAssociatedFiles(OCFile file2, String newName, Map<PsiElement, String> allRenames) {
        allRenames.put(file2, newName);
        file2 = file2.getAssociatedFileWithSameName();
        if (file2 != null) {
            allRenames.put(file2, FileUtilRt.getNameWithoutExtension((String)newName) + '.' + FileUtilRt.getExtension((String)file2.getName()));
        }
    }

    private static void prepareStruct(PsiElement elementToRename, OCStructSymbol struct, String newName, Map<PsiElement, String> allRenames, Project project2) {
        OCResolveContext context2 = OCResolveContext.forSymbol(struct, project2);
        struct.processSameSymbols((Processor<OCSymbol>)((Processor)symbol -> {
            OCStructSymbol struct1 = (OCStructSymbol)symbol;
            OCRenameProcessor.addSymbol(newName, allRenames, struct1, project2);
            if (!struct1.isPredeclaration()) {
                Processor processor2 = symbol1 -> {
                    OCRenameProcessor.addSymbol(newName, allRenames, symbol1, project2);
                    return true;
                };
                struct1.processConstructors((Processor<? super OCFunctionSymbol>)processor2, true, context2);
                struct1.processDestructors((Processor<? super OCFunctionSymbol>)processor2, true, context2);
                struct1.processDeductionGuides((Processor<? super OCDeductionGuideSymbol>)processor2, context2);
            }
            return true;
        }), project2);
        OCFile file2 = struct.getContainingOCFile(project2);
        if (OCRenameUtil.shouldRenameSameClassOrFileEntity(elementToRename) && OCRenameUtil.symbolHasSameNameWithFile(struct.getName(), struct.getKind(), file2)) {
            OCRenameProcessor.processAssociatedFiles(file2, newName + '.' + FileUtilRt.getExtension((String)file2.getName()), allRenames);
        }
    }

    private static void prepareClass(String newName, Map<PsiElement, String> allRenames, OCCompatibilityAliasSymbol alias, OCClassSymbol clazz, SearchScope scope, Project project2) {
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getSettings((Project)project2).getCustomSettings(OCCodeStyleSettings.class);
        if (settings.REFACTOR_COMPATIBILITY_ALIASES_AND_CLASSES) {
            int endPrefixIndex = clazz.getName().length() - alias.getName().length();
            String prefix = clazz.getName().substring(0, endPrefixIndex);
            String newClassName = prefix + newName;
            String categoryName = clazz.getCategoryName();
            if (categoryName != null) {
                newClassName = newClassName + "+" + categoryName;
            }
            OCRenameProcessor.prepareClass(clazz.getName(), categoryName, newClassName, allRenames, scope, clazz instanceof OCProtocolSymbol, project2);
        }
    }

    private static void prepareClass(String oldClassName, String oldCategoryName, String newName, Map<PsiElement, String> allRenames, SearchScope scope, boolean isProtocol, Project project2) {
        int categoryIdx = newName.lastIndexOf(43);
        String newClassName = categoryIdx > 0 ? newName.substring(0, categoryIdx) : newName;
        OCGlobalProjectSymbolsCache.processTopLevelSymbols(project2, (Processor<? super OCSymbol>)((Processor)ocSymbol -> {
            if (ocSymbol instanceof OCClassSymbol && OCRenameProcessor.isInScope(ocSymbol, scope) && isProtocol == ocSymbol instanceof OCProtocolSymbol) {
                boolean sameCategory = Objects.equals(((OCClassSymbol)ocSymbol).getCategoryName(), oldCategoryName);
                if (!sameCategory && oldClassName.equals(newClassName)) {
                    return true;
                }
                PsiElement def = ocSymbol.locateDefinition(project2);
                if (def != null) {
                    if (sameCategory) {
                        allRenames.put(def, newName);
                    } else {
                        allRenames.put(def, newClassName);
                    }
                    PsiFile file2 = def.getContainingFile();
                    String fileName = file2.getName();
                    String name = FileUtilRt.getNameWithoutExtension((String)fileName);
                    int categoryIdx1 = name.lastIndexOf(43);
                    String category = null;
                    if (categoryIdx1 > 0) {
                        category = name.substring(categoryIdx1 + 1);
                        name = name.substring(0, categoryIdx1);
                    }
                    if (name.equals(oldClassName)) {
                        if (Objects.equals(oldCategoryName, category)) {
                            allRenames.put((PsiElement)file2, newName + "." + FileUtilRt.getExtension((String)fileName));
                        } else {
                            allRenames.put((PsiElement)file2, newClassName + fileName.substring(name.length()));
                        }
                    }
                }
            }
            return true;
        }), oldClassName);
    }

    private static boolean isSetter(OCMethod method) {
        return method.getSelector().endsWith(":");
    }

    private static boolean isSetter(OCSendMessageExpression call) {
        return call.getMessageSelector().endsWith(":");
    }

    private static boolean isSetter(OCPropertyAttribute attribute) {
        return "setter".equals(attribute.getName());
    }

    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element, @NotNull SearchScope searchScope, boolean searchInCommentsAndStrings) {
        Project project2 = element.getProject();
        PsiElement elementToSearch = element;
        OCMethodSymbol accessor = null;
        if (OCRenameProcessor.isAccessor(element)) {
            accessor = (OCMethodSymbol)((OCSymbolHolderVirtualPsiElement)element).getSymbol();
            elementToSearch = accessor.getGeneratedFromProperty().locateDefinition(project2);
        }
        if (elementToSearch == null) {
            return Collections.emptyList();
        }
        OCResolveContext context2 = OCResolveContext.forPsi(elementToSearch);
        if (elementToSearch instanceof OCClassDeclaration && ((OCClassDeclaration)elementToSearch).getCategoryElement() != null) {
            return Collections.emptyList();
        }
        Collection result2 = ReferencesSearch.search((ReferencesSearch.SearchParameters)new OCElementInMacroSubstitutionReferenceSearch.MySearchParameters(elementToSearch, searchScope, false, true)).findAll();
        Iterator itr = result2.iterator();
        while (itr.hasNext()) {
            PsiReference reference = (PsiReference)itr.next();
            PsiElement usage = reference.getElement();
            ProgressManager.checkCanceled();
            if (reference instanceof OCFileReference) {
                ((OCFileReference)reference).preprocessHeaderRootsAndActiveConfiguration();
            }
            if (usage instanceof OCSendMessageExpression) {
                if (accessor != null && accessor.isSetter(context2) == OCRenameProcessor.isSetter((OCSendMessageExpression)usage)) continue;
                itr.remove();
                continue;
            }
            if (usage instanceof OCMethod) {
                if (accessor != null && accessor.isSetter(context2) == OCRenameProcessor.isSetter((OCMethod)usage)) continue;
                itr.remove();
                continue;
            }
            if (usage instanceof OCPropertyAttribute) {
                if (accessor != null && accessor.isSetter(context2) == OCRenameProcessor.isSetter((OCPropertyAttribute)usage)) continue;
                itr.remove();
                continue;
            }
            if (accessor != null) {
                itr.remove();
                continue;
            }
            if (!(element instanceof OCDeclarator) || !(usage instanceof OCDeclarator)) continue;
            itr.remove();
        }
        return result2;
    }

    private static boolean isAccessor(PsiElement element) {
        return element instanceof OCSymbolHolderVirtualPsiElement && ((OCSymbolHolderVirtualPsiElement)element).getSymbol() instanceof OCMethodSymbol;
    }

    public void renameElement(@NotNull PsiElement element, @NotNull String newName, UsageInfo @NotNull [] usages, @Nullable RefactoringElementListener listener) throws IncorrectOperationException {
        Project project2 = element.getProject();
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)element.getContainingFile(), OCCodeStyleSettings.class);
        ArrayList<UsageInfo> normalUsages = new ArrayList<UsageInfo>();
        MultiMap usageByLanguage = ContainerUtil.groupBy(Arrays.asList(usages), usage -> {
            PsiElement psiElement = usage.getElement();
            return psiElement == null ? null : psiElement.getLanguage();
        });
        for (Language language : usageByLanguage.keySet()) {
            Collection languageInfos;
            if (OCForeignUsagesRenameProcessor.processAll(element, newName, language, languageInfos = usageByLanguage.get((Object)language))) continue;
            for (UsageInfo usage2 : languageInfos) {
                PsiElement refElement = usage2.getElement();
                if (refElement != null && OCElementUtil.isPartOfMacroSubstitution(refElement)) {
                    OCMacroRange macroRange = OCElementUtil.getRangeInMacroCall(refElement);
                    if (macroRange != null && !macroRange.mapsToArguments() && element instanceof PsiNamedElement) {
                        PsiElement macro;
                        String name = ((PsiNamedElement)element).getName();
                        OCMacroSymbol macroSymbol = macroRange.getMacroCall().resolveToSymbol();
                        PsiElement psiElement = macro = macroSymbol != null ? macroSymbol.locateDefinition(project2) : null;
                        if (macro instanceof OCDefineDirective) {
                            PsiElement macroNameId = ((OCDefineDirective)macro).getNameIdentifier();
                            for (ASTNode child : macro.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.IDENTIFIER}))) {
                                PsiElement psi = child.getPsi();
                                if (psi == macroNameId || !psi.getText().equals(name)) continue;
                                OCElementUtil.replaceWithIdentifier(psi, newName, refElement);
                            }
                        }
                    }
                    FileSymbolTablesCache.getInstance(project2).scheduleReparseFile((OCFile)element.getContainingFile());
                    continue;
                }
                if (!settings.REFACTOR_PROPERTIES_AND_IVARS && refElement != null && OCRenameProcessor.isSynthesizeWithoutIvar(refElement.getParent())) {
                    OCReferenceElement oldSynthezise = ((OCSynthesizeProperty)refElement.getParent()).getPropertyRef();
                    if (oldSynthezise == null) continue;
                    String propName = oldSynthezise.getName();
                    oldSynthezise.replace(OCElementFactory.synthesize(newName, propName, refElement));
                    continue;
                }
                normalUsages.add(usage2);
            }
        }
        super.renameElement(element, newName, normalUsages.toArray(UsageInfo.EMPTY_ARRAY), listener);
    }

    private static boolean isSynthesizeWithoutIvar(@Nullable PsiElement element) {
        return element instanceof OCSynthesizeProperty && ((OCSynthesizeProperty)element).getInstanceVariableRef() == null;
    }

    public void findExistingNameConflicts(@NotNull PsiElement element, @NotNull String newName, @NotNull MultiMap<PsiElement, String> conflicts) {
        OCSymbol symbol;
        Project project2 = element.getProject();
        OCSymbol duplicate = null;
        if (element instanceof OCCategoryName) {
            OCSymbol oCSymbol = symbol = (element = element.getParent()) instanceof OCSymbolDeclarator ? (OCSymbol)((OCSymbolDeclarator)element).getSymbol() : null;
            if (symbol instanceof OCClassSymbol) {
                duplicate = OCCodeInsightUtil.resolveNameInScope(symbol.getKind(), symbol.getName(), newName, null, project2);
            }
        } else {
            if (element instanceof OCFile) {
                if (!OCSearchUtil.getProjectVirtualFilesByName(project2, newName).isEmpty()) {
                    conflicts.putValue((Object)element, (Object)("File '" + newName + "' already exists in the project"));
                }
                return;
            }
            symbol = element instanceof OCSymbolDeclarator ? (OCSymbol)((OCSymbolDeclarator)element).getSymbol() : null;
            String categoryName = symbol instanceof OCClassSymbol ? ((OCClassSymbol)symbol).getCategoryName() : null;
            PsiElement scope = symbol instanceof OCClassSymbol ? null : element;
            duplicate = OCCodeInsightUtil.resolveNameInScope(symbol != null ? symbol.getKind() : null, newName, categoryName, scope, project2);
        }
        if (duplicate != null && (symbol == null || symbol.isGlobal() == duplicate.isGlobal())) {
            String scope = duplicate.isGlobal() ? duplicate.getContainingFile().getName() : "the scope";
            PsiElement definition = duplicate.locateDefinition(project2);
            if (definition != null) {
                conflicts.putValue((Object)definition, (Object)(duplicate.getNameWithKindUppercase(OCCompilationContext.create(element)) + " already exists in " + scope));
            }
        }
    }

    @Nullable
    public PsiElement substituteElementToRename(@NotNull PsiElement element, @Nullable Editor editor) {
        OCSymbolWithQualifiedName struct;
        OCSymbol symbol;
        PsiElement originalElement = element;
        if ((element = OCForeignUsagesRenameProcessor.substituteElement(element, editor)) instanceof OCClassDeclaration) {
            return element;
        }
        if (element instanceof OCDeclarator) {
            element = ((OCDeclarator)element).getExtendedContext();
        }
        if (element instanceof PsiNameIdentifierOwner) {
            element = OCElementUtil.substituteNamedElementToRename(element, false);
        }
        if (element instanceof OCFunctionDeclaration && (symbol = (OCSymbolWithQualifiedName)((OCFunctionDeclaration)element).getSymbol()) != null && symbol.getKind().isConstructorOrDestructor() && (struct = symbol.getResolvedOwner(OCResolveContext.forPsi(element))) instanceof OCStructSymbol) {
            return struct.locateDefinition(element.getProject());
        }
        if (OCRenameProcessor.isAccessor(element) || element instanceof OCCallable) {
            OCSymbol oCSymbol = symbol = element instanceof OCCallable ? ((OCCallable)element).getSymbol() : (OCMethodSymbol)((OCSymbolHolderVirtualPsiElement)element).getSymbol();
            if (symbol instanceof OCMethodSymbol) {
                OCPropertySymbol property;
                OCPropertySymbol oCPropertySymbol = property = (symbol = symbol.getAssociatedSymbol(element.getProject())) != null ? ((OCMethodSymbol)symbol).getGeneratedFromProperty() : null;
                if (property != null) {
                    return property.locateDefinition(element.getProject());
                }
            }
        }
        return super.substituteElementToRename(originalElement, editor);
    }

    public boolean isToSearchInComments(@NotNull PsiElement element) {
        return RefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_FILE;
    }

    public void setToSearchInComments(@NotNull PsiElement element, boolean enabled) {
        RefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_FILE = enabled;
    }

    public boolean isToSearchForTextOccurrences(@NotNull PsiElement element) {
        return !OCScopeInfo.isLocalDeclarator(element) && RefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_FILE;
    }

    public void setToSearchForTextOccurrences(@NotNull PsiElement element, boolean enabled) {
        RefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_FILE = enabled;
    }

    public PsiElement getElementToSearchInStringsAndComments(@NotNull PsiElement element) {
        if (element instanceof OCClassDeclaration && ((OCClassDeclaration)element).getCategoryElement() != null) {
            return null;
        }
        if (element instanceof OCFile) {
            return null;
        }
        return element;
    }

    @NotNull
    public static RenameUsages validateUsages(PsiNamedElement elementToRename, Ref<UsageInfo[]> refUsages) {
        for (RenamePsiElementProcessor processor2 : EP_NAME.getExtensionList()) {
            if (!(processor2 instanceof OCRenameProcessor)) continue;
            return OCRenameProcessor.doValidateUsages(elementToRename, refUsages);
        }
        return RenameUsages.CANCEL;
    }

    public static RenameUsages doValidateUsages(PsiNamedElement elementToRename, Ref<UsageInfo[]> refUsages) {
        int code;
        String message;
        OCRenameProcessor.filterNonCodeUsages(elementToRename, refUsages);
        String oldName = elementToRename.getName();
        int nonCodeUsages = 0;
        OCSymbol badMacro = null;
        for (UsageInfo usageInfo : (UsageInfo[])refUsages.get()) {
            if (usageInfo instanceof NonCodeUsageInfo) {
                ++nonCodeUsages;
                continue;
            }
            if (!(usageInfo.getReference() instanceof OCElementInMacroSubstitutionReferenceSearch.BadMacroSubstitutionReference)) continue;
            badMacro = ((OCElementInMacroSubstitutionReferenceSearch.BadMacroSubstitutionReference)usageInfo.getReference()).getMacroSymbol();
        }
        if (badMacro != null) {
            message = badMacro.getNameWithKindUppercase(OCCompilationContext.create((PsiElement)elementToRename)) + " has several usages with different mappings for \"" + oldName + "\". Rename may break the code. Would you like to proceed?";
            String[] options2 = new String[]{"Show usages", "Cancel", "Proceed"};
            code = Messages.showDialog((String)message, (String)RefactoringBundle.message((String)"rename.title"), (String[])options2, (int)0, (int)1, (Icon)Messages.getQuestionIcon(), null);
            if (code == 0) {
                return RenameUsages.SHOW_USAGES;
            }
            if (code == 1 || code == -1) {
                return RenameUsages.CANCEL;
            }
        }
        if (nonCodeUsages > 0 && !ApplicationManager.getApplication().isUnitTestMode()) {
            message = nonCodeUsages + " usage" + (nonCodeUsages > 1 ? "s were" : " was") + " found in comments and non-code files.\nWould you like to rename " + (nonCodeUsages > 1 ? "them" : "it") + "?";
            String[] options3 = new String[]{"Show Usages", "Cancel", "Rename Only Code Usages", "Rename All Usages"};
            code = Messages.showDialog((String)message, (String)RefactoringBundle.message((String)"rename.title"), (String[])options3, (int)0, (int)2, (Icon)Messages.getQuestionIcon(), null);
            if (code == 3) {
                return RenameUsages.RENAME;
            }
            if (code == 2) {
                refUsages.set((Object)ContainerUtil.filter((Object[])((Object[])refUsages.get()), info -> !(info instanceof NonCodeUsageInfo)).toArray(UsageInfo.EMPTY_ARRAY));
                return RenameUsages.RENAME;
            }
            if (code == 0) {
                return RenameUsages.SHOW_USAGES;
            }
            return RenameUsages.CANCEL;
        }
        return RenameUsages.RENAME;
    }

    private static void filterNonCodeUsages(@NotNull PsiNamedElement elementToRename, @NotNull Ref<UsageInfo[]> refUsages) {
        ArrayList<UsageInfo> filteredUsages = new ArrayList<UsageInfo>();
        for (UsageInfo usageInfo : (UsageInfo[])refUsages.get()) {
            if (usageInfo instanceof NonCodeUsageInfo) {
                if (OCRenameProcessor.skipNonCodeUsage(elementToRename, usageInfo)) continue;
                filteredUsages.add(usageInfo);
                continue;
            }
            filteredUsages.add(usageInfo);
        }
        refUsages.set((Object)filteredUsages.toArray(UsageInfo.EMPTY_ARRAY));
    }

    private static boolean skipNonCodeUsage(@NotNull PsiNamedElement elementToRename, @NotNull UsageInfo usageInfo) {
        PsiElement parent;
        PsiElement element = usageInfo.getElement();
        PsiElement psiElement = parent = element != null ? element.getParent() : null;
        if (parent instanceof OCLocalizedString) {
            return true;
        }
        if (element != null && parent instanceof OCLiteralExpression && elementToRename instanceof OCLocalizedString) {
            OCReferenceElement macro;
            OCMacroCall macroCall = (OCMacroCall)PsiTreeUtil.getParentOfType((PsiElement)parent, OCMacroCall.class);
            OCReferenceElement oCReferenceElement = macro = macroCall != null ? macroCall.getMacroReferenceElement() : null;
            if (macro != null && macro.getName().startsWith("NSLocalizedString")) {
                return true;
            }
        }
        for (OCRenameProcessorExtension each : OCRenameProcessorExtension.EP.getExtensionList()) {
            if (!each.skipNonCodeUsage(elementToRename, usageInfo)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public RenameDialog createRenameDialog(final @NotNull Project project2, final @NotNull PsiElement element, @Nullable PsiElement nameSuggestionContext, final @Nullable Editor editor) {
        PsiElement context2;
        PsiElement psiElement = context2 = element instanceof OCDeclarator ? ((OCDeclarator)element).getExtendedContext() : element;
        if (OCCodeInsightUtil.isInObjC(context2) && context2 instanceof OCMethod && !ApplicationManager.getApplication().isUnitTestMode()) {
            return new RenameDialog(project2, element, nameSuggestionContext, editor){

                public void show() {
                    OCChangeSignatureHandler handler = OCChangeSignatureActionHandler.getHandler((OCCallable)context2, context2);
                    if (!OCChangeSignatureActionHandler.checkVariableArguments(context2.getProject(), editor, handler)) {
                        handler.invoke();
                    }
                }
            };
        }
        return new RenameDialog(project2, element, nameSuggestionContext, editor){

            protected void doAction() {
                OCRenameUtil.askToRenameSameEntityIfNeed(element);
                super.doAction();
            }

            protected RenameProcessor createRenameProcessor(@NotNull String newName) {
                return new RenameProcessor(project2, element, newName, this.getRefactoringScope(), this.isSearchInComments(), this.isSearchInNonJavaFiles()){

                    public boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
                        if (element instanceof PsiNamedElement) {
                            OCRenameProcessor.filterNonCodeUsages((PsiNamedElement)element, (Ref<UsageInfo[]>)refUsages);
                        }
                        return super.preprocessUsages(refUsages);
                    }
                };
            }

            protected boolean areButtonsValid() {
                PsiElement psiElement = this.getPsiElement();
                if (psiElement.getContainingFile() instanceof OCFile) {
                    OCLanguageKind languageKind = ((OCFile)psiElement.getContainingFile()).getKind();
                    if (OCNamesValidator.isIdentifier(this.getNewName(), languageKind)) {
                        return true;
                    }
                }
                return super.areButtonsValid();
            }
        };
    }

    public static enum RenameUsages {
        RENAME,
        CANCEL,
        SHOW_USAGES;

    }

    static interface AssociatedElementsProcessor {
        public boolean processIvar(OCInstanceVariableSymbol var1, OCPropertySymbol var2);

        public boolean processPropertyAccessors(OCPropertySymbol var1);

        public boolean processProperty(OCPropertySymbol var1, OCSymbol var2);

        public boolean processClassAlias(OCClassSymbol var1, OCCompatibilityAliasSymbol var2);

        public boolean processClass(OCCompatibilityAliasSymbol var1, OCClassSymbol var2);
    }
}

