/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.move;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.refactoring.move.OCMemberInfo;
import com.jetbrains.cidr.lang.refactoring.move.OCMoveProcessor;
import com.jetbrains.cidr.lang.refactoring.move.OCTopLevelTarget;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCMoveTopLevelProcessor
extends OCMoveProcessor<PsiElement, OCSymbol, OCTopLevelTarget> {
    private final boolean myWrapNamespaceMode;

    protected OCMoveTopLevelProcessor(PsiElement source, String targetFileName, @Nullable OCFile targetFile, @Nullable PsiElement targetContext, @Nullable OCNamespaceSymbol targetNamespace, @NotNull String targetNamespaceName, List<OCMemberInfo> selectedMemberInfos, Boolean processStructMembers, boolean smartDefinitionsMode, boolean wrapNamespaceMode) {
        super(source, selectedMemberInfos, targetFileName, processStructMembers, smartDefinitionsMode);
        this.myWrapNamespaceMode = wrapNamespaceMode;
        if (targetFile != null) {
            this.addTarget(targetFile, targetNamespaceName, targetContext, targetNamespace, smartDefinitionsMode);
        }
    }

    @Override
    protected OCTopLevelTarget createTargetClass(OCFile sourceFile, OCFile mainTargetFile, String targetClassName, PsiElement targetContext, Set<VirtualFile> files, OCSymbol targetSymbol, OCSymbol sourceSymbol, Project project2, boolean smartDefinitionsMode) {
        OCFile associatedFile = mainTargetFile.getAssociatedFile();
        OCFile file2 = !smartDefinitionsMode ? mainTargetFile : (!mainTargetFile.isHeader() && associatedFile != null && associatedFile.isHeader() && !this.mySourceFile.equals(associatedFile) ? associatedFile : mainTargetFile);
        return new OCTopLevelTarget(sourceFile, file2, (OCNamespaceSymbol)targetSymbol, targetClassName, targetContext, files, project2, smartDefinitionsMode, this.myWrapNamespaceMode);
    }

    @Override
    protected void removeMember(@Nullable PsiElement element, OCSymbol symbol) {
        OCChangeUtil.delete(element);
    }
}

