/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.changeSignature.usages;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeInfo;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCParameterInfo;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCCallableDefinitionUsage;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;

public class OCMethodDefinitionUsage
extends OCCallableDefinitionUsage<OCMethod> {
    public OCMethodDefinitionUsage(@NotNull OCMethod element, boolean isInherited) {
        super(element, isInherited, false);
    }

    @Override
    public int getUsageRank() {
        return 0;
    }

    @Override
    public boolean processUsage(@NotNull OCChangeInfo changeInfo, @NotNull OCMethod method, @NotNull Project project2) {
        OCTypeElement typeElement;
        if (changeInfo.isParameterSetOrOrderChanged()) {
            return super.processUsage(changeInfo, method, project2);
        }
        if (changeInfo.isNameChanged() || changeInfo.isParameterTypesChanged()) {
            int paramIndex = 0;
            for (OCMethodSelectorPart parameter : method.getParameters()) {
                PsiElement selectorID = parameter.getSelectorIdentifier();
                PsiElement paramID = parameter.getParameter();
                OCTypeElement typeElement2 = parameter.getTypeElement();
                OCParameterInfo newParameterInfo = changeInfo.getNewParameters()[paramIndex++];
                if (selectorID != null) {
                    if (newParameterInfo.getSelector().isEmpty()) {
                        OCChangeUtil.delete(selectorID);
                    } else {
                        OCElementUtil.replaceWithIdentifier(selectorID, newParameterInfo.getSelector(), method);
                    }
                }
                if (paramID != null) {
                    OCElementUtil.replaceWithIdentifier(paramID, changeInfo.getNewParameterName(this.myInherited, method, newParameterInfo), method);
                }
                if (typeElement2 == null || !newParameterInfo.isTypeChanged(typeElement2.getTextWithMacros())) continue;
                OCChangeUtil.replaceHandlingMacros(typeElement2, OCElementFactory.typeElementFromText(newParameterInfo.getTypeText(), method));
            }
        }
        if (changeInfo.isReturnTypeChanged() && (typeElement = method.getReturnTypeElement()) != null) {
            OCChangeUtil.replaceHandlingMacros(typeElement, OCElementFactory.typeElementFromText(changeInfo.getNewReturnType(), method));
        }
        OCChangeUtil.reformatElementAfterInsertionIfNeed(method, method.getHeaderRange());
        return true;
    }
}

