/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.changeSignature.usages;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.quickfixes.OCChangeTypeIntentionAction;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeInfo;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureUsageProcessor;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCCallableDefinitionUsage;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;

public class OCFunctionDefinitionUsage
extends OCCallableDefinitionUsage<OCFunctionDeclaration> {
    public OCFunctionDefinitionUsage(@NotNull OCFunctionDeclaration element, boolean isInherited, boolean addInitializers) {
        super(element, isInherited, addInitializers);
    }

    @Override
    public boolean processUsage(@NotNull OCChangeInfo changeInfo, @NotNull OCFunctionDeclaration function, @NotNull Project project2) {
        OCParameterList parameterList;
        if (changeInfo.isParameterSetOrOrderChanged()) {
            return super.processUsage(changeInfo, function, project2);
        }
        if (changeInfo.isNameChanged()) {
            PsiElement nameIdentifier;
            OCDeclarator declarator = function.getDeclarator();
            PsiElement psiElement = nameIdentifier = declarator != null ? declarator.getNameIdentifier() : null;
            if (nameIdentifier != null) {
                OCElementUtil.replaceWithIdentifier(nameIdentifier, changeInfo.getNewName(), function);
            }
        }
        if (changeInfo.isParameterTypesChanged() || changeInfo.isParameterNamesChanged()) {
            OCChangeSignatureUsageProcessor.processParameters(changeInfo, function, function.getParameterList(), project2, this.myInherited);
        }
        PsiFile file2 = function.getContainingFile();
        if (changeInfo.isReturnTypeChanged() && !changeInfo.getOldMethodDescriptor().isConstructor()) {
            OCSymbolWithQualifiedName symbol = (OCSymbolWithQualifiedName)function.getSymbol();
            OCType newReturnType = OCElementFactory.typeElementFromText(changeInfo.getNewReturnType(), function).getType();
            if (symbol != null) {
                new OCChangeTypeIntentionAction((OCSymbol)symbol, newReturnType, true, OCCompilationContext.create(function)).invoke(project2, null, file2);
            }
        }
        if (changeInfo.isParameterSetOrOrderChanged() && (parameterList = function.getParameterList()) != null) {
            OCChangeUtil.reformatElementAfterInsertionIfNeed(parameterList);
        }
        return true;
    }
}

