/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.changeSignature;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.changeSignature.MethodDescriptor;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCCallableKind;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCParameterInfo;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCMethodDescriptor
implements MethodDescriptor<OCParameterInfo, Object> {
    @NotNull
    private final OCCallable myCallable;
    private final OCSymbol mySymbol;
    private final String myName;
    private boolean mySureIsConstructor;
    private boolean myChangeCallableKindPossible;
    private final List<OCParameterInfo> myParameters = new ArrayList<OCParameterInfo>();
    private final OCClassDeclaration myContainerClass;
    private final List<OCReferenceExpression> mySelfReferences = new ArrayList<OCReferenceExpression>();

    public OCMethodDescriptor(OCBlockExpression block) {
        this(block, "", block.getParameterList());
    }

    public OCMethodDescriptor(OCFunctionDeclaration function) {
        this(function, function.getSymbolName(), function.getParameterList());
    }

    public OCMethodDescriptor(@NotNull OCMethod method) {
        this.myCallable = method;
        this.mySymbol = method.getSymbol();
        this.myName = method.getSelector();
        this.myContainerClass = (OCClassDeclaration)PsiTreeUtil.getParentOfType((PsiElement)method, OCClassDeclaration.class);
        int index = 0;
        for (OCMethodSelectorPart part : method.getParameters()) {
            OCTypeElement typeElement = part.getTypeElement();
            OCType type = typeElement != null ? typeElement.getType() : null;
            OCParameterInfo parameterInfo = new OCParameterInfo(part.getSelectorPart(), part.getParameterName(), type, index++, method);
            if (typeElement != null) {
                parameterInfo.setTypeText(typeElement.getTextWithMacros());
            }
            this.myParameters.add(parameterInfo);
        }
        OCBlockStatement body = method.getBody();
        if (body != null) {
            body.accept(new OCRecursiveVisitor(){

                @Override
                public void visitReferenceExpression(OCReferenceExpression expression) {
                    if (expression.getSelfSuperToken() != null) {
                        OCMethodDescriptor.this.mySelfReferences.add(expression);
                    }
                }
            });
        }
    }

    private OCMethodDescriptor(@NotNull OCCallable callable, String name, OCParameterList parameterList) {
        this.myCallable = callable;
        this.mySymbol = callable.getSymbol();
        this.myName = name;
        this.myContainerClass = (OCClassDeclaration)PsiTreeUtil.getParentOfType((PsiElement)callable, OCClassDeclaration.class);
        if (parameterList == null) {
            return;
        }
        int index = 0;
        for (OCParameterDeclaration param : parameterList.getParameterDeclarations()) {
            OCDeclarator declarator = param.getDeclarator();
            if (declarator == null) continue;
            PsiElement nameIdentifier = declarator.getNameIdentifier();
            String paramName = nameIdentifier != null ? nameIdentifier.getText() : "";
            OCParameterInfo parameterInfo = new OCParameterInfo("", paramName, declarator.getType(), index++, callable);
            String typeText = OCElementUtil.getTypeTextWithModifiers(param);
            if (typeText != null) {
                parameterInfo.setTypeText(typeText);
            }
            if (declarator.getInitializer() != null) {
                parameterInfo.setInitializer(declarator.getInitializer());
            }
            parameterInfo.setEllipsisType(param.isEllipsis());
            this.myParameters.add(parameterInfo);
        }
    }

    @NotNull
    public static OCMethodDescriptor createMethodDescriptor(@NotNull OCCallable callable) {
        if (callable instanceof OCFunctionDeclaration) {
            return new OCMethodDescriptor((OCFunctionDeclaration)callable);
        }
        if (callable instanceof OCBlockExpression) {
            return new OCMethodDescriptor((OCBlockExpression)callable);
        }
        if (callable instanceof OCMethod) {
            return new OCMethodDescriptor((OCMethod)callable);
        }
        assert (false);
        return null;
    }

    public String getName() {
        return this.myName;
    }

    @NotNull
    public List<OCParameterInfo> getParameters() {
        ArrayList<OCParameterInfo> parameters = new ArrayList<OCParameterInfo>(this.myParameters.size());
        for (OCParameterInfo parameter : this.myParameters) {
            parameters.add(parameter.clone());
        }
        return parameters;
    }

    public OCParameterInfo getParameter(int index) {
        return this.myParameters.get(index).clone();
    }

    public int getParametersCount() {
        return this.myParameters.size();
    }

    public OCType getReturnType() {
        return this.myCallable.getReturnType();
    }

    public OCSymbol getMethodSymbol() {
        return this.mySymbol;
    }

    public boolean isConstructor() {
        return this.mySureIsConstructor || this.mySymbol != null && this.mySymbol.getKind().isConstructorOrDestructor();
    }

    public boolean isChangeCallableKindPossible() {
        return this.myChangeCallableKindPossible;
    }

    public void setChangeCallableKindPossible(boolean changeCallableKindPossible) {
        this.myChangeCallableKindPossible = changeCallableKindPossible;
    }

    public void setSureIsConstructor(boolean sureIsConstructor) {
        this.mySureIsConstructor = sureIsConstructor;
    }

    public String getReturnTypeText(PsiElement context2) {
        if (this.mySymbol instanceof OCMemberSymbol && this.myCallable.getReturnType().isVoid() && this.mySymbol.hasAttribute("ibaction")) {
            return "IBAction";
        }
        OCTypeElement returnTypeElement = this.myCallable.getReturnTypeElement();
        if (returnTypeElement == null) {
            return this.myCallable.getReturnType().getBestNameInContext((PsiElement)(context2 != null ? context2 : this.myCallable));
        }
        if (this.myCallable instanceof OCFunctionDeclaration) {
            return OCElementUtil.getTypeTextWithModifiers((OCFunctionDeclaration)this.myCallable);
        }
        return returnTypeElement.getTextWithMacros();
    }

    @NotNull
    public Object getVisibility() {
        return this.getCallableKind();
    }

    public List<OCReferenceExpression> getSelfReferences() {
        return this.mySelfReferences;
    }

    @NotNull
    public OCCallableKind getCallableKind() {
        if (this.myCallable instanceof OCMethod) {
            return OCCallableKind.METHOD;
        }
        if (this.myCallable instanceof OCFunctionDeclaration) {
            return OCCallableKind.FUNCTION;
        }
        if (this.myCallable instanceof OCBlockExpression) {
            return OCCallableKind.BLOCK;
        }
        if (this.myCallable instanceof OCLambdaExpression) {
            return OCCallableKind.LAMBDA;
        }
        assert (false);
        return null;
    }

    public OCClassDeclaration getContainerClass() {
        return this.myContainerClass;
    }

    @NotNull
    public OCCallable getMethod() {
        return this.myCallable;
    }

    public boolean canChangeVisibility() {
        return true;
    }

    public boolean canChangeParameters() {
        return true;
    }

    @NotNull
    public MethodDescriptor.ReadWriteOption canChangeReturnType() {
        return this.isConstructor() ? MethodDescriptor.ReadWriteOption.None : MethodDescriptor.ReadWriteOption.ReadWrite;
    }

    public boolean canChangeName() {
        return true;
    }
}

