/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.changeSignature;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.refactoring.changeSignature.ParameterTableModelItemBase;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCCallableKind;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeInfo;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureProcessor;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCGeneratedInfo;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCMethodDescriptor;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCParameterInfo;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCParameterTableModel;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OCChangeSignatureHandlerImpl
implements OCChangeSignatureHandler {
    protected OCParameterTableModel myParametersTableModel;
    protected OCMethodDescriptor myMethod;
    private String myName;
    protected String myReturnTypeText;
    protected OCType myReturnType;
    protected OCCallableKind myCallableKind;
    protected OCChangeInfo myChangeInfo;
    protected boolean myChangeUsages = true;
    protected boolean myChangeAncestors;
    protected OCGeneratedInfo myGeneratedInfo;
    protected String myTitle;
    protected String myHelpId;
    @NotNull
    private PsiElement myContext;

    OCChangeSignatureHandlerImpl(OCParameterTableModel parametersTableModel, OCMethodDescriptor methodDescriptor, @NotNull PsiElement context2) {
        this.myParametersTableModel = parametersTableModel;
        this.myMethod = methodDescriptor;
        this.myName = this.myMethod.getName();
        this.myReturnType = this.myMethod.getReturnType();
        this.myReturnTypeText = this.myMethod.getReturnTypeText(context2);
        this.myCallableKind = this.myMethod.getCallableKind();
        this.myContext = context2;
        this.myGeneratedInfo = new OCGeneratedInfo(context2.getProject());
    }

    OCChangeSignatureHandlerImpl(OCMethodDescriptor methodDescriptor, @NotNull PsiElement context2) {
        String selector;
        OCParameterInfo firstParam;
        OCCallable method = methodDescriptor.getMethod();
        this.myMethod = methodDescriptor;
        this.myName = this.myMethod.getName();
        this.myReturnType = this.myMethod.getReturnType();
        this.myReturnTypeText = this.myMethod.getReturnTypeText(context2);
        this.myCallableKind = this.myMethod.getCallableKind();
        this.myParametersTableModel = new OCParameterTableModel(context2, method instanceof OCMethod);
        this.myParametersTableModel.setParameterInfos(methodDescriptor.getParameters());
        this.myContext = context2;
        this.myGeneratedInfo = new OCGeneratedInfo(context2.getProject());
        if (ApplicationManager.getApplication().isUnitTestMode() && (firstParam = this.getFirstParameter()) != null && (selector = firstParam.getSelector()) != null && selector.startsWith("_")) {
            this.renameSelector(0, selector.substring(1));
            this.myName = this.myName.substring(1);
        }
    }

    @Override
    public OCParameterInfo addParameter(String name, OCType type, int oldIndex) {
        return this.addParameter("", name, type, oldIndex, false);
    }

    @Override
    public OCParameterInfo addParameter(String selector, String name, OCType type, int oldIndex, boolean isReferenceMode) {
        return this.addParameter(selector, name, type, oldIndex, isReferenceMode, null);
    }

    @Override
    public OCParameterInfo addParameter(String selector, String name, OCType type, int oldIndex, boolean isReferenceMode, @Nullable String defaultArgumentValue) {
        return this.insertParameter(selector, name, type, null, -1, oldIndex, isReferenceMode, defaultArgumentValue);
    }

    @Override
    public OCParameterInfo insertParameter(String selector, String name, OCType type, int index, int oldIndex, boolean isReferenceMode) {
        return this.insertParameter(selector, name, type, null, index, oldIndex, isReferenceMode);
    }

    @Override
    public OCParameterInfo insertParameter(String selector, String name, OCType type, String typeText, int index, int oldIndex, boolean isReferenceMode) {
        return this.insertParameter(selector, name, type, typeText, index, oldIndex, isReferenceMode, null);
    }

    @Override
    public OCParameterInfo insertParameter(String selector, String name, OCType type, String typeText, int index, int oldIndex, boolean isReferenceMode, @Nullable String defaultArgumentValue) {
        OCParameterInfo result2;
        OCParameterInfo firstParam;
        if (this.isMethod() && (firstParam = this.getFirstParameter()) != null && firstParam.getName().isEmpty()) {
            selector = firstParam.getSelector();
            this.myParametersTableModel.removeRow(0);
        }
        OCParameterInfo oCParameterInfo = result2 = typeText == null ? new OCParameterInfo(selector, name, type, oldIndex, this.myContext) : new OCParameterInfo(selector, name, type, typeText, oldIndex, this.myContext);
        if (defaultArgumentValue != null) {
            result2.setDefaultValue(defaultArgumentValue);
        }
        result2.setReferenceMode(isReferenceMode);
        if (index == -1) {
            this.myParametersTableModel.addLastRow(result2);
        } else {
            this.myParametersTableModel.addRow(result2, index);
        }
        return result2;
    }

    @Override
    public OCParameterInfo insertParameter(String name, OCType type, int index) {
        return this.insertParameter("", name, type, index, -1, false);
    }

    @Override
    public void removeParameter(int index) {
        this.removeParameter(index, true);
    }

    private void removeParameter(int index, boolean mergeFirstSelector) {
        if (this.isMethod()) {
            OCParameterInfo firstParam = this.getFirstParameter();
            if (this.myParametersTableModel.getRowCount() == 1 && firstParam != null && !firstParam.getSelector().isEmpty()) {
                String selector = firstParam.getSelector();
                this.myParametersTableModel.removeRow(index, mergeFirstSelector);
                this.addParameter(selector, "", null, -1, false);
                return;
            }
        }
        this.myParametersTableModel.removeRow(index, mergeFirstSelector);
    }

    @Override
    public void removeParameter(String name, boolean mergeFirstSelector) {
        int rowIndex = 0;
        for (ParameterTableModelItemBase item : this.myParametersTableModel.getItems()) {
            if (((OCParameterInfo)item.parameter).getName().equals(name)) {
                this.removeParameter(rowIndex, mergeFirstSelector);
                return;
            }
            ++rowIndex;
        }
        assert (false) : "Could not find parameter: " + name;
    }

    @Override
    public void exchangeParameters(int i1, int i2) {
        this.myParametersTableModel.exchangeRows(i1, i2);
    }

    @Override
    public void renameSelector(int index, String newName) {
        ((OCParameterInfo)((ParameterTableModelItemBase)this.myParametersTableModel.getItems().get((int)index)).parameter).setSelector(newName);
        this.myName = this.calculateMethodName();
    }

    @Override
    public void setName(String name) {
        this.myName = name;
        OCParameterInfo firstParam = this.getFirstParameter();
        if (this.isMethod()) {
            if (firstParam == null) {
                this.addParameter(name, "", null, -1, false);
            } else {
                this.renameSelector(0, name);
            }
        } else if (firstParam != null && !firstParam.getSelector().isEmpty()) {
            this.myParametersTableModel.removeRow(0);
        }
    }

    @Override
    public void setReturnType(OCType returnType) {
        this.myReturnType = returnType;
        this.myReturnTypeText = returnType.getBestNameInContext(this.myContext);
    }

    @Override
    public void setParentClass(OCSymbol parent, boolean allowChangeCategories, List<? extends OCClassSymbol> auxParents) {
        this.getGeneratedInfo().setMethodParent(parent, allowChangeCategories, auxParents);
    }

    @Override
    public void setChangeParentClassPossible(boolean possible) {
    }

    @Override
    public void setNameVisible(boolean visible) {
    }

    @Override
    public void setChangeUsages(boolean change) {
        this.myChangeUsages = change;
    }

    @Override
    public void setChangeAncestors(boolean change) {
        this.myChangeAncestors = change;
    }

    @Override
    public OCGeneratedInfo getGeneratedInfo() {
        return this.myGeneratedInfo;
    }

    @Override
    public void invoke() {
        this.createRefactoringProcessor().run();
    }

    @Override
    public void invokeSynchronously() {
        this.createRefactoringProcessor().runSynchronously();
    }

    @Override
    public void setTitle(String title) {
        this.myTitle = title;
    }

    @Override
    public void setHelpId(String helpId) {
        this.myHelpId = helpId;
    }

    @Override
    public String getNewSignature(boolean addInitializers) {
        return this.calculateSignature(null, false, addInitializers);
    }

    @Override
    public void setCallableKind(OCCallableKind callableKind) {
        boolean isMethod;
        this.myCallableKind = callableKind;
        OCParameterInfo firstParam = this.getFirstParameter();
        boolean bl = isMethod = callableKind == OCCallableKind.METHOD;
        if (firstParam != null && firstParam.isSelfParameter() && isMethod) {
            this.myParametersTableModel.removeRow(0);
        }
        if (isMethod && this.myMethod.getMethod() instanceof OCFunctionDeclaration) {
            this.setName(this.myMethod.getName());
        } else if (!isMethod && this.myMethod.getMethod() instanceof OCMethod && this.myParametersTableModel.getRowCount() == 1 && firstParam != null && firstParam.getName().isEmpty()) {
            this.myParametersTableModel.removeRow(0);
        }
        if (!(isMethod || this.myMethod.getSelfReferences().isEmpty() || firstParam != null && firstParam.isSelfParameter())) {
            this.addSelfParameter(this.myMethod.getContainerClass().getName());
        }
    }

    @Override
    public void addSelfParameter(String parentClassName) {
        OCType type = OCReferenceType.resolvedFromText(parentClassName, this.myMethod.getMethod());
        type = OCPointerType.to(type);
        OCParameterInfo parameterInfo = new OCParameterInfo("", "_self", type, -1, this.myContext);
        parameterInfo.setSelfParameter(true);
        this.myParametersTableModel.addFirstRow(parameterInfo);
    }

    @Nullable
    private OCParameterInfo getFirstParameter() {
        int rowCount = this.myParametersTableModel.getRowCount();
        return rowCount > 0 ? (OCParameterInfo)((ParameterTableModelItemBase)this.myParametersTableModel.getRowValue((int)0)).parameter : null;
    }

    @Override
    public List<OCParameterInfo> getParameters() {
        ArrayList<OCParameterInfo> result2 = new ArrayList<OCParameterInfo>(this.myParametersTableModel.getRowCount());
        for (ParameterTableModelItemBase item : this.myParametersTableModel.getItems()) {
            ((OCParameterInfo)item.parameter).setType(OCElementUtil.getType((PsiElement)item.typeCodeFragment));
            ((OCParameterInfo)item.parameter).setTypeText(OCElementUtil.getTextWithMacros((PsiElement)item.typeCodeFragment));
            result2.add((OCParameterInfo)item.parameter);
        }
        return result2;
    }

    OCType getReturnType() {
        return this.myReturnType;
    }

    String getReturnTypeText() {
        return this.myReturnTypeText;
    }

    String getMethodName() {
        String name = this.myName;
        if (this.myMethod.getMethod() instanceof OCBlockExpression) {
            return "block";
        }
        if (this.isFunction()) {
            return name.indexOf(58) == -1 ? name : name.substring(0, name.indexOf(58));
        }
        return name;
    }

    String calculateMethodName() {
        StringBuilder result2 = new StringBuilder();
        List items = this.myParametersTableModel.getItems();
        for (ParameterTableModelItemBase item : items) {
            result2.append(((OCParameterInfo)item.parameter).getSelector());
            if (items.size() == 1 && ((OCParameterInfo)item.parameter).getName().isEmpty()) break;
            result2.append(':');
        }
        return result2.toString();
    }

    @Nullable
    OCClassDeclaration getContainerClass() {
        return this.myCallableKind == OCCallableKind.METHOD ? this.myMethod.getContainerClass() : null;
    }

    OCChangeSignatureProcessor createRefactoringProcessor() {
        return new OCChangeSignatureProcessor(this.myMethod.getMethod().getProject(), this.getCallableKind(), this.myMethod.getMethod(), this.evaluateChangeInfo(), this.myTitle);
    }

    @Override
    public OCChangeInfo getChangeInfo() {
        if (this.myChangeInfo == null) {
            this.evaluateChangeInfo();
        }
        return this.myChangeInfo;
    }

    private OCChangeInfo evaluateChangeInfo() {
        List<OCParameterInfo> parameters = this.getParameters();
        this.myChangeInfo = new OCChangeInfo(this.myContext, this.myMethod, this.getMethodName(), parameters.toArray(new OCParameterInfo[0]), this.getReturnTypeText(), this.getContainerClass(), this.getCallableKind(), this.calculateSignature(null, false, true), this.calculateSignature(null, false, false), this.myChangeUsages, this.myChangeAncestors, this.myGeneratedInfo){

            @Override
            public String getNewInheritedSignature(OCCallable oldCallable, boolean addInitializers) {
                return OCChangeSignatureHandlerImpl.this.calculateSignature(oldCallable, false, addInitializers);
            }
        };
        return this.myChangeInfo;
    }

    OCCallableKind getCallableKind() {
        return this.myCallableKind;
    }

    @Override
    public List<OCCallable> getNewCallables() {
        return this.myChangeInfo != null ? this.myChangeInfo.getNewMethods() : Collections.emptyList();
    }

    String calculateSignature(@Nullable OCCallable oldCallable, boolean newlines, boolean addInitializers) {
        OCCallable context2;
        StringBuilder result2 = new StringBuilder();
        List params = this.myParametersTableModel.getItems();
        OCCallable method = this.myMethod.getMethod();
        OCCallable oCCallable = context2 = oldCallable != null ? oldCallable : this.myContext;
        if (this.isMethod()) {
            boolean isInstance = method instanceof OCMethod && ((OCMethod)method).isInstanceMethod();
            result2.append(isInstance ? (char)'-' : '+');
            result2.append('(');
            result2.append(this.getReturnTypeText());
            result2.append(')');
            boolean isFirstParam = true;
            for (ParameterTableModelItemBase item : params) {
                result2.append(isFirstParam || !newlines ? (char)' ' : '\n');
                isFirstParam = false;
                OCParameterInfo parameter = (OCParameterInfo)item.parameter;
                result2.append(parameter.getSelector());
                if (parameter.getName().isEmpty()) break;
                result2.append(": (");
                result2.append(OCElementUtil.getTextWithMacros((PsiElement)item.typeCodeFragment));
                result2.append(") ");
                if (oldCallable != null) {
                    result2.append(this.myChangeInfo.getNewParameterName(true, oldCallable, parameter));
                    continue;
                }
                result2.append(parameter.getName());
            }
            OCMethod psi = OCElementFactory.methodFromSignature(result2.toString(), context2, false, false);
            CodeStyleManager.getInstance((Project)context2.getProject()).reformat((PsiElement)psi);
            String text = psi.getTextWithMacros();
            return text.substring(0, text.length() - 1);
        }
        StringBuilder paramsBuilder = this.buildParams(this.myChangeInfo, params, oldCallable, context2, oldCallable != null, newlines, addInitializers);
        if (this.isFunction()) {
            String methodName = this.getMethodName();
            if (methodName.isEmpty()) {
                methodName = "unnamed";
            }
            String methodFullName = methodName;
            List<String> modifiers = Collections.emptyList();
            if (method instanceof OCFunctionDeclaration) {
                OCFunctionDeclaration function = (OCFunctionDeclaration)method;
                OCSymbolWithQualifiedName methodSymbol = (OCSymbolWithQualifiedName)function.getSymbol();
                OCResolveContext resolveContext = OCResolveContext.forPsi(context2);
                if (this.myGeneratedInfo.isStatic() || function.isStatic() || methodSymbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)methodSymbol).resolveIsStatic(resolveContext)) {
                    modifiers = Collections.singletonList("static");
                }
                if (function.isOperator() && methodSymbol != null) {
                    methodFullName = methodSymbol.getName();
                } else if (function.getNamespaceQualifier() != null) {
                    methodFullName = OCElementUtil.getTextWithMacros(function.getNamespaceQualifier()) + "::" + methodName;
                }
                OCFunctionType type = function.getFunctionType();
                if (type != null) {
                    result2.append(OCCallableUtil.getFunctionTemplateHeader(type, resolveContext));
                }
            }
            if (this.myMethod.isConstructor()) {
                result2.append(methodFullName);
            } else {
                result2.append(OCElementFactory.declarationText(modifiers, methodFullName, this.getReturnType(), null, context2, this.getReturnTypeText(), false));
            }
            result2.insert(result2.lastIndexOf(methodName) + methodName.length(), paramsBuilder);
            result2.append(";");
            OCDeclaration psi = this.myMethod.isConstructor() ? OCElementFactory.constructorFromText(result2.toString(), context2) : OCElementFactory.topLevelDeclarationFromText(result2.toString(), context2);
            CodeStyleManager.getInstance((Project)context2.getProject()).reformat((PsiElement)psi);
            result2.setLength(0);
            result2.append(OCElementUtil.getTextWithMacros(psi));
            if (result2.charAt(result2.length() - 1) == ';') {
                result2.setLength(result2.length() - 1);
            }
        } else if (this.isBlock()) {
            result2.append('^');
            if (!"void".equals(this.getReturnTypeText())) {
                result2.append(this.getReturnTypeText());
            }
            result2.append((CharSequence)paramsBuilder);
            OCExpression psi = OCElementFactory.expressionFromText(result2.toString(), context2, false);
            CodeStyleManager.getInstance((Project)context2.getProject()).reformat((PsiElement)psi);
            result2.setLength(0);
            result2.append(OCElementUtil.getTextWithMacros(psi));
        }
        if (method instanceof OCFunctionDeclaration) {
            ((OCFunctionDeclaration)method).getCVQualifiers().appendCVQualifiers(result2);
        }
        if (this.isBlock()) {
            result2.append("{...}");
        }
        return result2.toString();
    }

    private StringBuilder buildParams(@Nullable OCChangeInfo changeInfo, @NotNull List<ParameterTableModelItemBase<OCParameterInfo>> params, @Nullable OCCallable oldFunction, @NotNull PsiElement context2, boolean isInherited, boolean newlines, boolean addInitializers) {
        boolean isFirstParam = true;
        int index = 0;
        StringBuilder paramsBuilder = new StringBuilder();
        if (params.size() > 0 || this.isFunction()) {
            paramsBuilder.append('(');
        }
        for (ParameterTableModelItemBase<OCParameterInfo> param : params) {
            String name = changeInfo != null && oldFunction != null ? changeInfo.getNewParameterName(isInherited, oldFunction, (OCParameterInfo)param.parameter) : ((OCParameterInfo)param.parameter).getName();
            PsiCodeFragment type = param.typeCodeFragment;
            String typeText = OCElementUtil.getTextWithMacros((PsiElement)type);
            if (name.isEmpty() && typeText.isEmpty()) continue;
            if (!isFirstParam) {
                paramsBuilder.append(",").append(newlines ? (char)'\n' : ' ');
            }
            if (typeText.equals("...")) {
                paramsBuilder.append("...");
            } else {
                int oldIndex = ((OCParameterInfo)param.parameter).getOldIndex();
                OCExpression initializer = ((OCParameterInfo)param.parameter).getInitializer();
                if (!addInitializers || oldFunction instanceof OCFunctionDeclaration && oldIndex >= 0 && oldIndex < oldFunction.getParameters().size() && ((OCDeclarator)oldFunction.getParameters().get(oldIndex)).getInitializer() == null) {
                    initializer = null;
                }
                String initializerText = initializer != null ? initializer.getTextWithMacros() : null;
                paramsBuilder.append(OCElementFactory.declarationText(name, OCElementUtil.getType((PsiElement)type), typeText, initializerText, context2));
            }
            isFirstParam = false;
            ++index;
        }
        if (params.size() > 0 || this.isFunction()) {
            paramsBuilder.append(')');
        }
        return paramsBuilder;
    }

    boolean isBlock() {
        return OCCallableKind.BLOCK == this.getCallableKind();
    }

    boolean isFunction() {
        return OCCallableKind.FUNCTION == this.getCallableKind();
    }

    boolean isMethod() {
        return OCCallableKind.METHOD == this.getCallableKind();
    }

    boolean isMethodGenerated() {
        return this.myMethod.getMethod().getContainingFile() instanceof OCCodeFragment;
    }

    OCCallableKind getOriginalCallableKind() {
        return this.myMethod.getCallableKind();
    }

    @Override
    public OCMethodDescriptor getMethodDescriptor() {
        return this.myMethod;
    }

    @Override
    public void setRefactorButtonText(String text) {
    }
}

