/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;

public class OCReuseDeclarationIntentionAction
extends OCSymbolQuickFix<OCSymbol> {
    private String myIntentionName;

    public OCReuseDeclarationIntentionAction(@NotNull OCSymbol symbol, String intentionName, @NotNull Project project2) {
        super(project2, symbol);
        this.myIntentionName = intentionName;
    }

    @Override
    protected String getTextInternal() {
        return this.myIntentionName;
    }

    @NotNull
    public String getFamilyName() {
        return OCBundle.message("intentions.reuse.declaration", new Object[0]);
    }

    @Override
    protected void invoke(@NotNull Project project2, Editor editor) {
        OCDeclarator declarator = (OCDeclarator)this.mySymbol.locateDefinition(project2);
        if (!OCCodeInsightUtil.isValid(declarator)) {
            return;
        }
        if (declarator.getInitializer() != null) {
            OCExpressionStatement assignment = OCElementUtil.getTextWithMacros(declarator.getParent()).endsWith(";") ? (OCExpressionStatement)OCElementFactory.statementFromText(declarator.getName() + "=b;", declarator) : (OCExpressionStatement)((OCForStatement)OCElementFactory.statementFromText("for(" + declarator.getName() + "=b;;);", declarator)).getInitializer();
            OCAssignmentExpression expr = (OCAssignmentExpression)assignment.getExpression();
            OCChangeUtil.replaceHandlingMacros(expr.getSourceExpression(), declarator.getInitializer());
            OCDeclaration declaration = (OCDeclaration)declarator.getParent();
            PsiElement parent = declaration.getParent();
            if (!(parent instanceof OCDeclarationStatement)) {
                return;
            }
            parent.getParent().addAfter((PsiElement)assignment, parent);
        }
        if (declarator.getParent().getParent() instanceof OCForeachStatement) {
            OCExpression expression = OCElementFactory.expressionFromText(declarator.getName(), declarator);
            OCChangeUtil.replaceHandlingMacros(declarator.getParent(), expression);
        } else {
            OCChangeUtil.delete(declarator);
        }
    }
}

