/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.intentions.OCDeclareMethodInInterfaceIntentionAction;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDeclareMethodInTargetInterfaceAction
extends OCDeclareMethodInInterfaceIntentionAction {
    private final OCClassSymbol myReceiverClass;
    private final OCMethodSymbol myTarget;
    private final Project myProject;

    public OCDeclareMethodInTargetInterfaceAction(OCClassSymbol receiverClass, OCMethodSymbol target, Project project2) {
        this.myReceiverClass = receiverClass;
        this.myTarget = target;
        this.myProject = project2;
    }

    @Override
    @NotNull
    public String getText() {
        return OCBundle.message("intentions.declare.method.in", this.myReceiverClass.getNameWithKindLowercase(OCCompilationContext.create(this.myReceiverClass, this.myProject)));
    }

    @Override
    protected OCClassSymbol getParent(@NotNull Project project2, @Nullable Editor editor, @NotNull PsiFile file2) {
        return this.myReceiverClass;
    }

    @Override
    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return OCSearchScope.isInProjectSources(this.myTarget, project2);
    }

    @Override
    protected OCMethodSymbol locateCandidate(@NotNull Project project2, Editor editor, PsiFile file2) {
        return this.myTarget;
    }
}

