/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.daemon.OCConstantExpressionVisitor;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureActionHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCParameterInfo;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class OCChangeFunctionSignatureIntentionAction
extends OCSymbolQuickFix<OCSymbol> {
    private final List<OCType> myParameterTypes;
    private final List<OCExpression> myArguments;
    private String myText;

    public OCChangeFunctionSignatureIntentionAction(@NotNull OCFunctionSymbol functionSymbol, @NotNull OCFunctionType newType, @NotNull List<OCExpression> arguments, @NotNull OCResolveContext context2, @NotNull PsiElement psiContext) {
        super(context2.getProject(), functionSymbol);
        OCParameterList parameterList;
        this.myParameterTypes = new ArrayList<OCType>(newType.getParameterTypes(true));
        this.myArguments = arguments;
        PsiElement declarator = this.mySymbol.locateDefinition(context2.getProject());
        if (declarator instanceof OCDeclarator && (parameterList = ((OCDeclarator)declarator).getParameterList()) != null) {
            List<OCParameterDeclaration> parameterDeclarations = parameterList.getParameterDeclarations();
            for (int i2 = 0; i2 < parameterDeclarations.size() && i2 < this.myParameterTypes.size(); ++i2) {
                OCDeclarator paramDecl = parameterDeclarations.get(i2).getDeclarator();
                if (paramDecl == null) continue;
                OCType type = paramDecl.getResolvedType();
                if (i2 <= 0 && type.isVoid()) continue;
                this.myParameterTypes.set(i2, type);
            }
        }
        int argsCnt = functionSymbol.getParameterSymbols().size();
        this.myText = this.myParameterTypes.size() == argsCnt + 1 ? "Add last '" + ((OCType)ContainerUtil.getLastItem(this.myParameterTypes)).getBestNameInContext(psiContext) + "' parameter to " + this.mySymbol.getNameWithKindLowercase(context2) : (this.myParameterTypes.size() == argsCnt - 1 ? "Remove last '" + ((OCDeclaratorSymbol)ContainerUtil.getLastItem(functionSymbol.getParameterSymbols())).getType().getBestNameInContext(psiContext) + "' parameter from " + this.mySymbol.getNameWithKindLowercase(context2) : "Change signature of " + this.mySymbol.getNameWithKindLowercase(context2) + " to '" + new OCFunctionType(newType.getReturnType(), this.myParameterTypes).getName(context2) + "'");
    }

    @Override
    protected String getTextInternal() {
        return this.myText;
    }

    @NotNull
    public String getFamilyName() {
        return OCBundle.message("intentions.change.function.signature", new Object[0]);
    }

    @Override
    public boolean isAvailable() {
        return super.isAvailable() && this.myText != null && !this.mySymbol.isSynthetic() && this.myParameterTypes.stream().allMatch(OCType::isInstanceable);
    }

    @Override
    protected void invoke(@NotNull Project project2, Editor editor) {
        PsiElement declarator = this.mySymbol.locateDefinition(project2);
        if (!(declarator instanceof OCDeclarator) || !(declarator.getParent() instanceof OCFunctionDeclaration)) {
            return;
        }
        OCFunctionDeclaration function = (OCFunctionDeclaration)declarator.getParent();
        OCChangeSignatureHandler handler = OCChangeSignatureActionHandler.getHandler(function, function, false, true, true, false);
        OCParameterList parameterList = ((OCDeclarator)declarator).getParameterList();
        if (parameterList == null) {
            return;
        }
        handler.setReturnType(((OCFunctionDeclaration)declarator.getParent()).getReturnType());
        HashSet<String> createdNames = new HashSet<String>();
        ArrayList<Trinity> newArguments = new ArrayList<Trinity>();
        int paramIndex = 0;
        boolean hasInitializers = false;
        for (OCParameterDeclaration param : parameterList.getParameterDeclarations()) {
            OCDeclarator paramDecl = param.getDeclarator();
            String paramName = paramDecl != null ? paramDecl.getName() : null;
            OCExpression initializer = paramDecl != null ? paramDecl.getInitializer() : null;
            handler.removeParameter(0);
            boolean bl = hasInitializers = initializer != null;
            if (paramName != null) {
                createdNames.add(paramName);
            }
            if (paramIndex >= this.myParameterTypes.size()) continue;
            newArguments.add(Trinity.create((Object)(paramName != null ? paramName : ""), (Object)this.myParameterTypes.get(paramIndex++), (Object)initializer));
        }
        OCResolveContext context2 = OCResolveContext.forPsi(declarator);
        boolean disableInitializers = false;
        while (paramIndex < this.myParameterTypes.size()) {
            Collection<String> suggestedNames;
            OCExpression initializer;
            OCExpression oCExpression = initializer = hasInitializers && paramIndex < this.myArguments.size() ? this.myArguments.get(paramIndex) : null;
            if (initializer != null && !new OCConstantExpressionVisitor().isConstant(initializer)) {
                disableInitializers = true;
            }
            OCType newType = this.myParameterTypes.get(paramIndex++);
            if (hasInitializers && initializer == null) {
                initializer = OCElementFactory.expressionFromText(newType.getDefaultValue(context2), declarator);
            }
            String suggestedName = (suggestedNames = OCNameSuggester.suggestForType(OCSymbolKind.PARAMETER, newType, declarator, "", createdNames, context2)).isEmpty() ? "param" : suggestedNames.iterator().next();
            createdNames.add(suggestedName);
            newArguments.add(Trinity.create((Object)suggestedName, (Object)newType, (Object)initializer));
        }
        String message = "Existing default values for parameters of " + this.mySymbol.getNameWithKindLowercase(context2) + " will be removed. Do you wish to proceed?";
        if (hasInitializers && disableInitializers && !ApplicationManager.getApplication().isUnitTestMode() && Messages.showOkCancelDialog((Project)context2.getProject(), (String)message, (String)CommonBundle.getWarningTitle(), (Icon)Messages.getQuestionIcon()) != 0) {
            return;
        }
        int index = 0;
        for (Trinity argument : newArguments) {
            OCParameterInfo parameterInfo = handler.addParameter((String)argument.getFirst(), (OCType)argument.getSecond(), index++);
            if (disableInitializers) continue;
            parameterInfo.setInitializer((OCExpression)argument.getThird());
        }
        handler.invokeSynchronously();
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }
}

