/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCAddInitializerIntentionAction
extends OCPsiElementQuickFix<OCDeclarator> {
    private OCSymbol mySymbol;

    public OCAddInitializerIntentionAction(@NotNull OCDeclarator declarator, OCSymbol symbol) {
        super(declarator);
        this.mySymbol = symbol;
    }

    @Override
    protected String getTextInternal() {
        return "Initialize " + this.mySymbol.getNameWithKindLowercase(OCCompilationContext.create(this.mySymbol, this.getProject()));
    }

    @NotNull
    public String getFamilyName() {
        return OCBundle.message("intentions.add.initializer", new Object[0]);
    }

    @Override
    protected boolean isAvailable(@NotNull OCDeclarator declarator) {
        if (this.mySymbol != null) {
            OCDeclaratorSymbol declaratorSymbol;
            OCResolveContext context2 = OCResolveContext.forPsi(declarator);
            OCType type = this.mySymbol.getResolvedType(context2);
            if (this.mySymbol instanceof OCDeclaratorSymbol && (declaratorSymbol = (OCDeclaratorSymbol)this.mySymbol).hasInitializer()) {
                return false;
            }
            return !(type instanceof OCStructType) || type.isCppStructType(context2) || ((OCStructType)type).isEnum();
        }
        return false;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        return this.myElementPtr.getElement();
    }

    @Override
    public void invoke(@NotNull Project project2, @Nullable Editor editor, PsiFile file2) throws IncorrectOperationException {
        OCDeclarator declarator = (OCDeclarator)this.myElementPtr.getElement();
        if (declarator != null) {
            this.invoke(file2, declarator, editor);
        }
    }

    protected void invoke(PsiFile file2, @NotNull OCDeclarator declarator, Editor editor) {
        OCResolveContext context2 = OCResolveContext.forPsi(declarator);
        OCType type = this.mySymbol.getResolvedType(context2);
        String declarationText = "int " + declarator.getTextWithMacros() + "=" + type.getDefaultValue(context2);
        OCDeclaration declaration = OCElementFactory.declarationFromText(declarationText, (PsiElement)file2, true);
        OCExpression initializer = (declarator = (OCDeclarator)OCChangeUtil.replaceHandlingMacros(declarator, declaration.getDeclarators().get(0))).getInitializer();
        if (initializer != null) {
            OCAddInitializerIntentionAction.invokeSmartCompletion(initializer, type);
        }
    }

    public static void invokeSmartCompletion(final @NotNull OCExpression expression, @NotNull OCType type) {
        OCFile file2 = expression.getContainingOCFile();
        final boolean deleteOnEsc = type.isPointerToObjectCompatible() && !OCCompilerFeaturesHelper.isArcDisabled(file2);
        TextRange initializerRange = expression.getRangeWithMacros();
        final Editor editor = EditorHelper.openInEditor((PsiElement)expression);
        if (editor == null) {
            return;
        }
        editor.getCaretModel().moveToOffset(initializerRange.getEndOffset());
        editor.getSelectionModel().setSelection(initializerRange.getStartOffset(), initializerRange.getEndOffset());
        ApplicationManager.getApplication().invokeLater(() -> {
            if (file2.getProject().isDisposed() || !file2.isValid()) {
                return;
            }
            CodeCompletionHandlerBase base = new CodeCompletionHandlerBase(CompletionType.SMART, false, false, true);
            base.invokeCompletion(file2.getProject(), editor, 1, true);
            LookupEx lookup = LookupManager.getActiveLookup((Editor)editor);
            if (lookup != null) {
                lookup.addLookupListener(new LookupListener(){

                    public void lookupCanceled(@NotNull LookupEvent event) {
                        if (deleteOnEsc && expression.isValid()) {
                            ApplicationManager.getApplication().runWriteAction(() -> {
                                Document document2 = PsiDocumentManager.getInstance((Project)expression.getProject()).getDocument(expression.getContainingFile());
                                if (document2 != null) {
                                    PsiDocumentManager.getInstance((Project)expression.getProject()).commitDocument(document2);
                                }
                                OCChangeUtil.delete(expression);
                            });
                        } else {
                            editor.getSelectionModel().removeSelection();
                        }
                    }
                });
            }
        }, ModalityState.stateForComponent((Component)editor.getComponent()));
    }
}

