/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl.symbols;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.impl.OCFileImpl;
import com.jetbrains.cidr.lang.psi.impl.symbols.OCFileGlobalSymbolsCache;
import com.jetbrains.cidr.lang.psi.impl.symbols.OCFileSymbolsContainerBase;
import com.jetbrains.cidr.lang.symbols.OCForeignSymbol;
import com.jetbrains.cidr.lang.symbols.OCLazyNamedSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCFileGlobalSymbols
extends OCFileSymbolsContainerBase {
    private final Map<OCSymbol, VirtualFile> mySymbolToImport = new Object2ObjectOpenHashMap();
    private final Map<String, Pair<OCSymbol, VirtualFile>> myUndefinedProtocols = new Object2ObjectOpenHashMap();
    private final Map<String, Pair<OCSymbol, VirtualFile>> myUndefinedClasses = new Object2ObjectOpenHashMap();
    private final Set<VirtualFile> myRequiredImports = new ObjectOpenHashSet();

    public OCFileGlobalSymbols(OCFile file2) {
        super(file2);
    }

    public boolean process(OCSymbol symbol) {
        if (symbol instanceof OCLazyNamedSymbol) {
            this.myLazyNamedSymbols.add((OCLazyNamedSymbol)symbol);
            return true;
        }
        if (symbol instanceof OCClassSymbol) {
            VirtualFile importFile = this.mySymbolToImport.get(symbol);
            OCClassSymbol classSymbol = (OCClassSymbol)symbol;
            if (!(classSymbol instanceof OCForeignSymbol)) {
                this.checkSuperAndProtocolsDefined(classSymbol, importFile);
            }
            this.myNameToSymbol.add((Object)symbol.getName(), (Object)symbol);
        } else if (symbol.getKind() == OCSymbolKind.NAMESPACE_USING_SYMBOL) {
            this.myUsingSymbols.add((OCUsingSymbol)symbol);
        } else {
            this.myNameToSymbol.add((Object)symbol.getName(), (Object)symbol);
            if (symbol.getKind() == OCSymbolKind.NAMESPACE && ((OCNamespaceSymbol)symbol).isInlineNamespace()) {
                this.myInlineNamespaces.add((OCNamespaceSymbol)symbol);
            }
        }
        return true;
    }

    private void checkSuperAndProtocolsDefined(@NotNull OCClassSymbol classSymbol, @Nullable VirtualFile importFile) {
        String superName;
        for (String protocol : classSymbol.getProtocolNames()) {
            if (this.myUndefinedProtocols.containsKey(protocol) || this.findDefinition(protocol, OCSymbolKind.PROTOCOL, importFile)) continue;
            this.myUndefinedProtocols.put(protocol, (Pair<OCSymbol, VirtualFile>)Pair.create((Object)classSymbol, (Object)importFile));
        }
        if (classSymbol instanceof OCInterfaceSymbol && !(superName = classSymbol.getSuperClassName()).isEmpty() && !this.myUndefinedClasses.containsKey(superName) && !this.findDefinition(superName, OCSymbolKind.INTERFACE, importFile)) {
            this.myUndefinedClasses.put(superName, (Pair<OCSymbol, VirtualFile>)Pair.create((Object)classSymbol, (Object)importFile));
        }
    }

    private boolean findDefinition(String name, final OCSymbolKind kind, VirtualFile importFile) {
        VirtualFile definitionImportFile;
        CommonProcessors.FindFirstProcessor<OCSymbol> finder = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol symbol) {
                return symbol.getKind() == kind && !symbol.isPredeclaration();
            }
        };
        this.myNameToSymbol.processForKey((Object)name, (Processor)finder);
        OCSymbol definition = (OCSymbol)finder.getFoundValue();
        if (definition != null && !Comparing.equal((Object)importFile, (Object)(definitionImportFile = this.mySymbolToImport.get(definition)))) {
            this.myRequiredImports.add(definitionImportFile);
        }
        return finder.isFound();
    }

    public Map<OCSymbol, VirtualFile> getSymbolToImport() {
        return this.mySymbolToImport;
    }

    public Map<String, Pair<OCSymbol, VirtualFile>> getUndefinedProtocols() {
        return this.myUndefinedProtocols;
    }

    public Map<String, Pair<OCSymbol, VirtualFile>> getUndefinedClasses() {
        return this.myUndefinedClasses;
    }

    public Set<VirtualFile> getRequiredImports() {
        return this.myRequiredImports;
    }

    public static OCFileGlobalSymbols buildSymbols(OCFileImpl file2) {
        OCFileGlobalSymbols symbols = new OCFileGlobalSymbols(file2);
        OCFileGlobalSymbolsCache.processFile(file2, symbols, symbols.mySymbolToImport);
        return symbols;
    }
}

