/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionWithReferenceBase;
import com.jetbrains.cidr.lang.psi.impl.OCReferenceElementImpl;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCNumericType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCReferenceTypeBuilder;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCUnaryExpressionImpl
extends OCExpressionWithReferenceBase<OCOperatorReference>
implements OCUnaryExpression {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.cidr.lang.psi.impl.OCUnaryExpressionImpl");

    public OCUnaryExpressionImpl(@NotNull ASTNode node2) {
        super(node2);
    }

    @Override
    @Nullable
    protected OCOperatorReference createReference() {
        OCExpression operand = this.getOperand();
        if (operand != null) {
            return new OCOperatorReference((PsiElement)this, this.getOperationName(), OCOperatorReference.OperatorPlacement.PREFIX, this.getOperationSignNode().getPsi(), operand);
        }
        return null;
    }

    @Override
    public OCExpression getOperand() {
        return (OCExpression)this.findChildByType(OCElementTypes.EXPRESSIONS);
    }

    @Override
    @NotNull
    public OCElementType getOperationSign() {
        return (OCElementType)this.getOperationSignNode().getElementType();
    }

    @Override
    @NotNull
    public ASTNode getOperationSignNode() {
        return this.getNode().getFirstChildNode();
    }

    @Override
    @NotNull
    public String getOperationName() {
        return this.getOperationSign().getName();
    }

    @Override
    public boolean isGetAddress() {
        return this.getOperationSign() == OCTokenTypes.AND;
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitUnaryExpression(this);
    }

    @Override
    @NotNull
    public OCType getType(@NotNull OCResolveContext context2) {
        OCReferenceElement referenceElement;
        OCOperatorReference reference = (OCOperatorReference)this.getReference();
        if (reference != null) {
            for (OCSymbol operator : reference.resolveToSymbols(context2)) {
                if (!(operator instanceof OCFunctionSymbol)) continue;
                return ((OCFunctionSymbol)operator).getEffectiveType(this);
            }
        }
        OCElementType sign = this.getOperationSign();
        OCExpression operand = this.getOperand();
        if (operand == null) {
            return OCUnknownType.INSTANCE;
        }
        OCType opType = operand.getResolvedType(context2);
        OCSymbolReference.LocalReference symbolReference = null;
        if (operand instanceof OCReferenceExpression && (referenceElement = ((OCReferenceExpression)operand).getReferenceElement()) != null) {
            symbolReference = OCSymbolReference.getLocalReference(referenceElement, OCSymbolReference.SymbolFilter.NONE);
        }
        return OCUnaryExpressionImpl.getUnaryExprType(sign, opType, symbolReference, context2);
    }

    public static OCType getUnaryExprType(OCElementType sign, OCType opType, @Nullable OCSymbolReference referenceElement, @NotNull OCResolveContext context2) {
        OCType result2;
        if (opType.isUnresolved(context2)) {
            result2 = OCUnknownType.INSTANCE;
        } else if (sign == OCTokenTypes.UDL_SUFFIX || opType.isSubclassOfMagic(context2)) {
            result2 = new OCMagicType(opType);
        } else if (sign == OCTokenTypes.MUL) {
            result2 = opType instanceof OCPointerType ? ((OCPointerType)opType).getRefType() : OCUnaryExpressionImpl.unknownOrMagic(opType, context2);
        } else if (sign == OCTokenTypes.__REAL__KEYWORD || sign == OCTokenTypes.__IMAG__KEYWORD) {
            result2 = opType instanceof OCRealType ? ((OCRealType)opType).cloneWithoutComplexModifier() : opType;
        } else if (sign == OCTokenTypes.AND) {
            OCType type = OCTypeUtils.getCppReferencedType(opType);
            OCType qualifierType = null;
            if (referenceElement != null && referenceElement.getQualifiedName().getQualifier() != null) {
                OCSymbol symbol = OCReferenceElementImpl.findPredeclaration(referenceElement.resolveToSymbols(context2));
                if ((symbol instanceof OCFunctionSymbol || symbol instanceof OCDeclaratorSymbol) && !((OCSymbolWithQualifiedName)symbol).isFriendOrStatic() && ((OCSymbolWithQualifiedName)symbol).getParent() instanceof OCStructSymbol) {
                    qualifierType = new OCReferenceTypeBuilder(referenceElement.getSymbolReferenceToQualifier()).build().resolve(context2);
                } else if (symbol instanceof OCTypeParameterSymbol) {
                    qualifierType = new OCMagicType(referenceElement.getQualifiedName().getQualifier().toString());
                }
            }
            result2 = OCPointerType.to(type, null, qualifierType);
        } else if (sign == OCTokenTypes.TILDE || sign == OCTokenTypes.PLUS) {
            result2 = opType;
        } else if (sign == OCTokenTypes.MINUS) {
            result2 = opType instanceof OCIntType ? ((OCIntType)opType).promoteToSigned(context2) : (opType.isNumberCompatible(context2) ? opType : OCUnaryExpressionImpl.unknownOrMagic(opType, context2));
        } else if (sign == OCTokenTypes.EXCL) {
            OCType type = OCTypeUtils.getCppReferencedType(opType);
            result2 = type.isNumberCompatible(context2) || type.isPointer() ? OCIntType.getAppropriateBool(context2.isObjc()) : OCUnaryExpressionImpl.unknownOrMagic(opType, context2);
        } else {
            LOG.error("Unknown operation sign");
            result2 = OCUnknownType.INSTANCE;
        }
        if (result2 instanceof OCNumericType) {
            result2 = result2.cloneWithoutCVQualifiers(context2.getProject());
        }
        return result2;
    }

    private static OCType unknownOrMagic(OCType type, @NotNull OCResolveContext context2) {
        if (type.isMagicInside(context2)) {
            return new OCMagicType(type);
        }
        return OCUnknownType.INSTANCE;
    }

    @Override
    protected List<OCExpression> getDependentExpressions() {
        return Collections.singletonList(this.getOperand());
    }
}

