/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.impl.OCElementBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.ComplexTextRange;
import com.jetbrains.cidr.lang.symbols.OCBuilderDriver;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCMethodSelectorPartImpl
extends OCElementBase
implements OCMethodSelectorPart {
    public OCMethodSelectorPartImpl(@NotNull ASTNode node2) {
        super(node2);
    }

    @Override
    public String getSelectorPart() {
        StringBuilder builder2 = new StringBuilder();
        ASTNode child = this.getNode().getFirstChildNode();
        if (child != null && child.getElementType() == OCTokenTypes.IDENTIFIER) {
            builder2.append(child.getText());
            child = child.getTreeNext();
        }
        while (child != null && OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(child.getElementType())) {
            child = child.getTreeNext();
        }
        if (child != null && child.getElementType() == OCTokenTypes.COLON) {
            builder2.append(child.getText());
        }
        return builder2.toString();
    }

    @Override
    public String getParameterName() {
        ASTNode id = this.findParameterNode();
        return id != null ? id.getText() : null;
    }

    public String getName() {
        return this.getParameterName();
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        ASTNode parameterNode = this.findParameterNode();
        if (parameterNode != null) {
            OCChangeUtil.replaceChild(this.getNode(), parameterNode, OCElementFactory.createIdentifier(name, this).getNode());
        }
        return this;
    }

    @Override
    @Nullable
    public PsiElement getSelectorIdentifier() {
        ASTNode child = this.getNode().getFirstChildNode();
        if (child != null && child.getElementType() == OCTokenTypes.IDENTIFIER) {
            return child.getPsi();
        }
        return null;
    }

    public PsiElement getNameIdentifier() {
        ASTNode paramNode = this.findParameterNode();
        return paramNode != null ? paramNode.getPsi() : null;
    }

    @Override
    public PsiElement getParameter() {
        PsiElement last;
        PsiElement first = this.getFirstChild();
        if (first != (last = this.findLastChildByType(OCTokenTypes.IDENTIFIER)) && last != null) {
            return last;
        }
        return null;
    }

    @Override
    @Nullable
    public ASTNode findParameterNode() {
        PsiElement parameter = this.getParameter();
        return parameter != null ? parameter.getNode() : null;
    }

    @Override
    public int getTextOffset() {
        ASTNode id = this.findParameterNode();
        return id != null ? id.getStartOffset() : super.getTextOffset();
    }

    @Override
    public long getComplexOffset() {
        PsiElement id = this.getParameter();
        return id != null ? OCSymbolOffsetUtil.getComplexOffset(id) : super.getComplexOffset();
    }

    @Override
    @NotNull
    public OCType getType() {
        OCTypeElement typeElement = this.getTypeElement();
        return typeElement != null ? typeElement.getType() : OCUnknownType.INSTANCE;
    }

    @Override
    @NotNull
    public OCType getRawType() {
        OCTypeElement typeElement = this.getTypeElement();
        return typeElement != null ? typeElement.getRawType() : OCUnknownType.INSTANCE;
    }

    @Override
    @Nullable
    public OCTypeElement getTypeElement() {
        return (OCTypeElement)this.findChildByType(OCElementTypes.TYPE_ELEMENT);
    }

    @Override
    @Nullable
    public OCDeclaratorSymbol getLocalSymbol() {
        OCBuilderDriver<ASTNode> builderDriver;
        OCMethodSymbol.SelectorPartSymbol selector;
        OCFile file2 = this.getContainingOCFile();
        OCMethod method = (OCMethod)PsiTreeUtil.getContextOfType((PsiElement)this, (Class[])new Class[]{OCMethod.class});
        ComplexTextRange scope = null;
        if (method != null) {
            OCBlockStatement body = method.getBody();
            scope = OCSymbolOffsetUtil.getComplexRange(body != null ? body : method);
        }
        if ((selector = (builderDriver = OCBuilderDriver.createForASTNode(this.getNode(), file2)).processSelectorPart(this.getNode(), new StringBuilder(), scope, (Ref<Long>)new Ref(), null, false)) != null) {
            OCDeclaratorSymbol parameter = selector.getParameter();
            if (parameter instanceof OCDeclaratorSymbolImpl && method != null) {
                ((OCDeclaratorSymbolImpl)parameter).setParentMethod((OCMethodSymbol)method.getSymbol());
            }
            return parameter;
        }
        return null;
    }

    @Override
    public OCDeclaratorSymbol getSymbol() {
        return this.getLocalSymbol();
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitMethodSelectorPart(this);
    }
}

