/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCIncludeHelpers;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.psi.impl.OCCppLinkageSpecificationImpl;
import com.jetbrains.cidr.lang.psi.impl.OCDirectiveImpl;
import com.jetbrains.cidr.lang.psi.impl.OCFileReference;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.resolve.OCImportManipulator;
import com.jetbrains.cidr.lang.symbols.OCBuilderDriver;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCIncludeDirectiveImpl
extends OCDirectiveImpl
implements OCIncludeDirective {
    private static final ElementManipulator<OCIncludeDirectiveImpl> ourManipulator = new OCImportManipulator();
    private CachedValue<PsiFile> myImportedFile;

    public OCIncludeDirectiveImpl(@NotNull ASTNode node2) {
        super(node2);
    }

    public PsiReference @NotNull [] getReferences() {
        return this.createRefSet().getAllReferences();
    }

    @NotNull
    private FileReferenceSet createRefSet() {
        final PsiElement headerPathContent = this.findChildByType(OCTokenTypes.HEADER_PATH_LITERAL);
        final TextRange allContent = ((TextRange)this.getContent((boolean)true).second).shiftRight(-this.getTextRange().getStartOffset());
        FileReferenceSet set = headerPathContent instanceof OCMacroForeignLeafElement ? new FileReferenceSet(OCInclusionContext.extractPath(headerPathContent.getText(), true).getPath(), (PsiElement)this, allContent.getStartOffset(), null, true, false) : FileReferenceSet.createSet((PsiElement)this, (boolean)false, (boolean)true, (boolean)false);
        return new FileReferenceSet(set.getPathString(), this, set.getStartInElement(), null, true, true){

            public FileReference createFileReference(TextRange range, int index, String text) {
                return new OCFileReference(this, headerPathContent instanceof OCMacroForeignLeafElement ? allContent : range, index, text, OCIncludeDirectiveImpl.this, OCIncludeDirectiveImpl.this.getProject());
            }

            public boolean isCaseSensitive() {
                return SystemInfo.isFileSystemCaseSensitive;
            }

            protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
                return item -> {
                    OCIncludeHelpers.ShowInCompletion show = OCIncludeHelpers.showInCompletion(item);
                    if (show == OCIncludeHelpers.ShowInCompletion.SHOW) {
                        return true;
                    }
                    if (show == OCIncludeHelpers.ShowInCompletion.DON_NOT_SHOW) {
                        return false;
                    }
                    if (item instanceof OCFile) {
                        return OCInclusionContextUtil.isNeedToFindRoot((PsiFile)item);
                    }
                    if (item instanceof PsiDirectory) {
                        return !".idea".equals(item.getName());
                    }
                    return false;
                };
            }
        };
    }

    private OCSymbol getSymbol() {
        CommonProcessors.FindFirstProcessor<OCSymbol> finder = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol symbol) {
                return symbol instanceof OCIncludeSymbol && symbol.getOffset() == OCIncludeDirectiveImpl.this.getTextOffset();
            }
        };
        OCBuilderDriver<ASTNode> builderDriver = OCBuilderDriver.createForASTNode(this.getNode(), this.getContainingOCFile(), (Processor<OCSymbol>)finder);
        builderDriver.processImportDirective(this.getNode());
        return (OCSymbol)finder.getFoundValue();
    }

    @Override
    @NotNull
    public String getReferenceText() {
        TextRange range = ourManipulator.getRangeInElement((PsiElement)this);
        return range.substring(this.getText());
    }

    @Override
    @NotNull
    public OCIncludeDirective.Delimiters getDelimiters() {
        return this.isAngleBrackets() ? OCIncludeDirective.Delimiters.ANGLE_BRACKETS : OCIncludeDirective.Delimiters.QUOTES;
    }

    @Override
    public boolean isAngleBrackets() {
        int startOffset = ourManipulator.getRangeInElement((PsiElement)this).getStartOffset();
        return startOffset > 0 && this.getText().charAt(startOffset - 1) == '<';
    }

    @Override
    public boolean isTopLevel() {
        return PsiTreeUtil.skipParentsOfType((PsiElement)this, (Class[])new Class[]{OCCppLinkageSpecificationImpl.class}) instanceof OCFile;
    }

    @Override
    public PsiFile getIncludedFile() {
        if (this.myImportedFile == null) {
            Project project2 = this.getProject();
            this.myImportedFile = CachedValuesManager.getManager((Project)project2).createCachedValue(() -> new CachedValueProvider.Result((Object)this.findImportedFile(), new Object[]{FileSymbolTablesCache.getInstance(project2).getOutOfBlockModificationTracker()}), true);
        }
        return (PsiFile)this.myImportedFile.getValue();
    }

    @Nullable
    private PsiFile findImportedFile() {
        PsiFileSystemItem item;
        FileReference fileRef = this.createRefSet().getLastReference();
        if (fileRef != null && (item = fileRef.resolve()) instanceof PsiFile) {
            return (PsiFile)item;
        }
        return null;
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitImportDirective(this);
    }

    @Override
    public boolean isValidDirective() {
        if (this.getReferenceText().isEmpty()) {
            return false;
        }
        for (PsiReference reference : this.getReferences()) {
            if (reference.resolve() != null) continue;
            return false;
        }
        TextRange range = ourManipulator.getRangeInElement((PsiElement)this);
        String text = this.getText();
        char openChar = '\u0000';
        char closeChar = '\u0000';
        if (range.getStartOffset() > 0) {
            openChar = text.charAt(range.getStartOffset() - 1);
        }
        if (range.getEndOffset() < text.length()) {
            closeChar = text.charAt(range.getEndOffset());
        }
        if (openChar == '\"' && closeChar != '\"') {
            return false;
        }
        return openChar != '<' || closeChar == '>';
    }
}

