/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCConditionalExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCThrowExpression;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.resolve.OCExprValueCategory;
import com.jetbrains.cidr.lang.resolve.v2.Conversions;
import com.jetbrains.cidr.lang.resolve.v2.TypeProperties;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityVisitor;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCConditionalExpressionImpl
extends OCExpressionBase
implements OCConditionalExpression {
    public OCConditionalExpressionImpl(@NotNull ASTNode node2) {
        super(node2);
    }

    @Override
    @NotNull
    public OCExpression getCondition() {
        OCExpression cond = this.findExpression(0);
        assert (cond != null);
        return cond;
    }

    @Override
    public OCExpression getPositiveExpression(boolean returnConditionIfNull) {
        OCExpression expression = this.findExpression(1);
        return expression != null || !returnConditionIfNull ? expression : this.getCondition();
    }

    @Override
    public OCExpression getNegativeExpression() {
        return this.findExpression(2);
    }

    @Nullable
    private OCExpression findExpression(int n) {
        int count = 0;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (OCElementTypes.EXPRESSIONS.contains(tt) && count == n) {
                return (OCExpression)child.getPsi();
            }
            if (count == 0 && tt == OCTokenTypes.QUEST) {
                count = 1;
                continue;
            }
            if (count != 1 || tt != OCTokenTypes.COLON) continue;
            count = 2;
        }
        return null;
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitConditionalExpression(this);
    }

    @Override
    @NotNull
    protected OCType getType(@NotNull OCResolveContext context2) {
        OCExpression leftExpr = this.getPositiveExpression(true);
        OCExpression rightExpr = this.getNegativeExpression();
        if (leftExpr != null && rightExpr != null) {
            return OCConditionalExpressionImpl.calcConditionalExprType(leftExpr.getResolvedType(context2), leftExpr, rightExpr.getResolvedType(context2), rightExpr, context2);
        }
        return OCUnknownType.INSTANCE;
    }

    public static OCType calcConditionalExprType(@NotNull OCType lTy, @NotNull OCTypeOwner lhs, @NotNull OCType rTy, @NotNull OCTypeOwner rhs, @NotNull OCResolveContext context2) {
        lTy = OCTypeUtils.getCppReferencedType(lTy);
        rTy = OCTypeUtils.getCppReferencedType(rTy);
        CalcTypeResult result2 = OCConditionalExpressionImpl.calcConditionalExprTypeImpl(lTy, lhs, rTy, rhs, context2);
        return OCType.updateWithCommonGuessedType(lTy, rTy, result2.type, context2);
    }

    private static CalcTypeResult calcConditionalExprTypeImpl(@NotNull OCType lTy, @NotNull OCTypeOwner lhs, @NotNull OCType rTy, @NotNull OCTypeOwner rhs, @NotNull OCResolveContext context2) {
        boolean same;
        if (lTy.isVoid() || rTy.isVoid()) {
            if (OCConditionalExpressionImpl.isThrow(lhs)) {
                return CalcTypeResult.ok(rTy);
            }
            if (OCConditionalExpressionImpl.isThrow(rhs)) {
                return CalcTypeResult.ok(lTy);
            }
            if (!(!context2.isCpp() || lTy.isVoid() && rTy.isVoid())) {
                return CalcTypeResult.fail();
            }
            return CalcTypeResult.ok(OCVoidType.instance());
        }
        if ((lTy.isCppStructType(context2) || rTy.isCppStructType(context2)) && !OCConditionalExpressionImpl.areLeftAndRightEqual(lTy, rTy, context2)) {
            boolean haveR2L = OCConditionalExpressionImpl.hasStructConversion(lTy, rTy, rhs, context2);
            boolean haveL2R = OCConditionalExpressionImpl.hasStructConversion(rTy, lTy, lhs, context2);
            if (haveL2R && haveR2L) {
                return new CalcTypeResult(OCUnknownType.INSTANCE, false);
            }
            if (haveL2R) {
                lTy = rTy;
            } else if (haveR2L) {
                rTy = lTy;
            }
        }
        OCExprValueCategory lvc = OCExprValueCategory.classify(lhs, context2);
        OCExprValueCategory rvc = OCExprValueCategory.classify(rhs, context2);
        if (!OCConditionalExpressionImpl.areLeftAndRightEqual(lTy, rTy, context2) && lvc == rvc && lvc != OCExprValueCategory.PRValue) {
            if (OCConditionalExpressionImpl.areRefCompatible(lTy, rTy, context2)) {
                rTy = lTy;
            } else if (OCConditionalExpressionImpl.areRefCompatible(rTy, lTy, context2)) {
                lTy = rTy;
            }
        }
        if ((same = OCConditionalExpressionImpl.areLeftAndRightEqual(lTy, rTy, context2)) && lvc == rvc && lvc != OCExprValueCategory.PRValue) {
            return CalcTypeResult.ok(lTy.isMagicInside(context2) ? lTy : rTy);
        }
        if ((lTy.isCppStructType(context2) || rTy.isCppStructType(context2)) && !same) {
            return CalcTypeResult.fail();
        }
        if (OCConditionalExpressionImpl.areLeftAndRightEqual(lTy = OCTypeUtils.decayType(lTy, context2.getProject(), false), rTy = OCTypeUtils.decayType(rTy, context2.getProject(), false), context2)) {
            return CalcTypeResult.ok(lTy.isMagicInside(context2) ? lTy : rTy);
        }
        if (TypeProperties.isArithmeticType(lTy) && TypeProperties.isArithmeticType(rTy)) {
            return CalcTypeResult.ok(lTy.getLeastCommonType(rTy, context2));
        }
        if (lTy.isPointer() && OCExpressionEvaluator.isLikeNil(rhs, context2)) {
            return CalcTypeResult.ok(lTy);
        }
        if (rTy.isPointer() && OCExpressionEvaluator.isLikeNil(lhs, context2)) {
            return CalcTypeResult.ok(rTy);
        }
        if (lTy.isPointer() || rTy.isPointer()) {
            return OCConditionalExpressionImpl.getCommonPointerType(lTy, rTy, context2);
        }
        return CalcTypeResult.fail();
    }

    private static boolean hasStructConversion(@NotNull OCType destType, @NotNull OCType sourceType, @NotNull OCTypeOwner sourceExpr, @NotNull OCResolveContext context2) {
        return sourceType.getCVQualifiers().isSuperset(destType.getCVQualifiers()) && !destType.checkCompatible(sourceType, sourceExpr, context2.getElement(), true, context2).getState().isError(context2.getElement());
    }

    private static boolean areRefCompatible(@NotNull OCType LTy, @NotNull OCType RTy, @NotNull OCResolveContext context2) {
        Ref objCLifetimeConversion;
        Ref objCConversion;
        Ref derivedToBase = Ref.create();
        Conversions.ReferenceCompareResult refRel = Conversions.CompareReferenceRelationship(LTy, RTy, (Ref<Boolean>)derivedToBase, (Ref<Boolean>)(objCConversion = Ref.create()), (Ref<Boolean>)(objCLifetimeConversion = Ref.create()), context2);
        return refRel.compareTo(Conversions.ReferenceCompareResult.Ref_Compatible_With_Added_Qualification) >= 0 && (Boolean)derivedToBase.get() == false && (Boolean)objCConversion.get() == false && (Boolean)objCLifetimeConversion.get() == false;
    }

    @NotNull
    private static CalcTypeResult getCommonPointerType(@NotNull OCType lTy, @NotNull OCType rTy, @NotNull OCResolveContext context2) {
        assert (lTy.isPointer() || rTy.isPointer());
        if (lTy.isPointerToObject() && rTy.isPointerToObject()) {
            return new CalcTypeResult(lTy.getLeastCommonType(rTy, context2), true);
        }
        if (lTy.isPointer() && rTy.isPointer()) {
            OCType rPointee;
            OCPointerType lp = (OCPointerType)lTy;
            OCPointerType rp = (OCPointerType)rTy;
            OCType lPointee = lp.getRefType();
            OCType commonUnqualifiedPointee = OCConditionalExpressionImpl.getBaseType(lPointee, rPointee = rp.getRefType(), context2);
            if (commonUnqualifiedPointee != null) {
                CVQualifiers mergedPointeesCV = lPointee.getCVQualifiers().or(rPointee.getCVQualifiers());
                CVQualifiers mergedPointersCV = lp.getCVQualifiers().or(rp.getCVQualifiers());
                OCType commonQualifiedPointee = commonUnqualifiedPointee.cloneWithAddedCVQualifiers(mergedPointeesCV, context2.getProject());
                OCPointerType resultType = OCPointerType.to(commonQualifiedPointee, lp.getARCAttribute(), lp.getClassQualifier(), lp.getNullability(), mergedPointersCV.isConst(), mergedPointersCV.isVolatile());
                return CalcTypeResult.ok(resultType);
            }
        }
        if (!context2.isCpp()) {
            if (lTy.isNumberCompatible(context2)) {
                return new CalcTypeResult(rTy, true);
            }
            if (rTy.isNumberCompatible(context2)) {
                return new CalcTypeResult(lTy, true);
            }
        }
        return CalcTypeResult.fail();
    }

    @Nullable
    private static OCType getBaseType(@NotNull OCType lPointee, @NotNull OCType rPointee, @NotNull OCResolveContext context2) {
        if (TypeProperties.hasSameUnqualifiedType(lPointee, rPointee, context2) || TypeProperties.IsDerivedFrom(rPointee, lPointee, context2)) {
            return lPointee.cloneWithoutCVQualifiers(context2.getProject());
        }
        if (TypeProperties.IsDerivedFrom(lPointee, rPointee, context2)) {
            return rPointee.cloneWithoutCVQualifiers(context2.getProject());
        }
        if (lPointee.isVoid() || rPointee.isVoid()) {
            return OCVoidType.instance();
        }
        return null;
    }

    private static boolean areLeftAndRightEqual(@NotNull OCType LTy, @NotNull OCType RTy, @NotNull OCResolveContext context2) {
        return new OCTypeEqualityVisitor(RTy, true, false, context2).equal(LTy);
    }

    private static boolean isThrow(@NotNull OCTypeOwner expr) {
        OCTypeOwner inner = OCParenthesesUtils.diveIntoParentheses(expr);
        return inner instanceof OCThrowExpression;
    }

    private static class CalcTypeResult {
        public final OCType type;
        public final boolean needToAnnotateIndividualParameters;

        CalcTypeResult(OCType type, boolean needToAnnotateIndividualParameters) {
            this.type = type;
            this.needToAnnotateIndividualParameters = needToAnnotateIndividualParameters;
        }

        public static CalcTypeResult ok(OCType type) {
            return new CalcTypeResult(type, false);
        }

        public static CalcTypeResult fail() {
            return new CalcTypeResult(OCUnknownType.INSTANCE, true);
        }
    }
}

