/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCNoexceptSpecifier;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCCallableKind;
import com.jetbrains.cidr.lang.symbols.OCNamedSymbol;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCBlockExpressionImpl
extends OCExpressionBase
implements OCBlockExpression {
    public OCBlockExpressionImpl(@NotNull ASTNode node2) {
        super(node2);
    }

    @Override
    public OCCallableKind getKind() {
        return OCCallableKind.BLOCK;
    }

    @Override
    @Nullable
    public OCBlockStatement getBody() {
        return (OCBlockStatement)this.findChildByType(OCElementTypes.BLOCK_STATEMENTS);
    }

    @Override
    public OCTypeElement getReturnTypeElement() {
        return (OCTypeElement)this.findChildByType(OCElementTypes.TYPE_ELEMENT);
    }

    @Override
    public OCParameterList getParameterList() {
        return (OCParameterList)this.findChildByType(OCElementTypes.PARAMETER_LIST);
    }

    @Override
    public List<OCDeclarator> getParameters() {
        OCParameterList parameterList = this.getParameterList();
        return parameterList != null ? parameterList.getParameters() : null;
    }

    @Override
    @Nullable
    public OCNoexceptSpecifier getNoexceptSpecifier() {
        return null;
    }

    @Override
    public OCType calcReturnTypeByBody() {
        return OCExpectedTypeUtil.getReturnTypeOfBlock(this.getBody());
    }

    @Override
    public OCSymbol getSymbol() {
        return new OCBlockSymbol(this);
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitBlockExpression(this);
    }

    @Override
    @NotNull
    protected OCType getType(@NotNull OCResolveContext context2) {
        OCParameterList params = this.getParameterList();
        ArrayList<OCType> paramTypes = new ArrayList<OCType>();
        ArrayList<String> paramNames = new ArrayList<String>();
        if (params != null) {
            for (OCParameterDeclaration parameterDeclaration : params.getParameterDeclarations()) {
                OCDeclarator paramDeclarator = parameterDeclaration.getDeclarator();
                if (paramDeclarator == null) continue;
                paramTypes.add(paramDeclarator.getType());
                paramNames.add(paramDeclarator.getName());
            }
        }
        return OCBlockPointerType.blockPtr(new OCFunctionType(this.getReturnType(), paramTypes, paramNames));
    }

    @Override
    @NotNull
    public OCType getReturnType() {
        OCTypeElement returnTypeElement = this.getReturnTypeElement();
        if (returnTypeElement != null) {
            return returnTypeElement.getType();
        }
        return this.calcReturnTypeByBody();
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        throw new UnsupportedOperationException();
    }

    public static class OCBlockSymbol
    extends OCNamedSymbol {
        public OCBlockSymbol() {
        }

        public OCBlockSymbol(OCBlockExpression expr) {
            super(expr.getContainingFile().getVirtualFile(), OCSymbolOffsetUtil.getComplexOffset(expr), expr.getReturnTypeElement() != null ? "^" + expr.getReturnTypeElement().getText() + "{...}" : "^{...}");
        }

        @Override
        @NotNull
        public OCSymbolKind getKind() {
            return OCSymbolKind.BLOCK;
        }
    }
}

