/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.FileContentUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.IndexingDataKeys;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.modulemap.AllowedModules;
import com.jetbrains.cidr.lang.modulemap.ModuleMapUtil;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapManager;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMap;
import com.jetbrains.cidr.lang.preprocessor.OCContextChangeSet;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextImpl;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextListener;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.psi.OCConfigurationOwner;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCParsedLanguageAndConfiguration;
import com.jetbrains.cidr.lang.psi.impl.OCPsiFileBaseImpl;
import com.jetbrains.cidr.lang.settings.OCResolveContextSettings;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.SymbolTableProvider;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import com.jetbrains.cidr.lang.workspace.OCLibraryFileResolveConfigurationProvider;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCVariant;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationTrackers;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceRunConfigurationListener;
import com.jetbrains.cidr.lang.workspace.compiler.ClangClCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.MSVCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.NVCCCompilerKind;
import com.jetbrains.cidr.lang.workspace.headerRoots.AppleFramework;
import com.jetbrains.cidr.lang.workspace.headerRoots.FrameworksSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRootProcessor;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCInclusionContextUtil {
    private static final NotNullLazyKey<CachedValue<OCResolveConfiguration>, PsiFile> FILE_ACTIVE_CONFIGURATION_CACHE = NotNullLazyKey.create((String)"FILE_ACTIVE_CONFIGURATION_CACHE", file2 -> {
        final Project project2 = file2.getProject();
        return CachedValuesManager.getManager((Project)project2).createCachedValue((CachedValueProvider)new CachedValueProvider<OCResolveConfiguration>(){

            public CachedValueProvider.Result<OCResolveConfiguration> compute() {
                if (project2.isDefault()) {
                    return new CachedValueProvider.Result(null, new Object[]{ModificationTracker.NEVER_CHANGED});
                }
                OCWorkspaceModificationTrackers tracker = OCWorkspace.getInstance(project2).getModificationTrackers();
                return new CachedValueProvider.Result((Object)this.inferConfiguration(), new Object[]{FileSymbolTablesCache.getInstance(project2).getOutOfBlockModificationTracker(), tracker.getResolveConfigurationsTracker(), tracker.getSourceFilesTracker(), tracker.getCompilerSettingsTracker(), tracker.getSelectedResolveConfigurationTracker()});
            }

            @Nullable
            private OCResolveConfiguration inferConfiguration() {
                VirtualFile virtualFile = OCInclusionContextUtil.getVirtualFile(file2);
                if (SymbolTableProvider.isSourceFile(file2.getProject(), virtualFile)) {
                    return OCInclusionContextUtil.getResolveRootAndActiveConfiguration(virtualFile, file2.getProject()).getConfiguration();
                }
                return null;
            }
        }, false);
    });
    private static final NotNullLazyKey<Map<VirtualFile, OCResolveRootAndConfiguration>, Project> HEADER_ROOT_AND_CONFIGURATION_KEY = NotNullLazyKey.create((String)"HEADER_ROOT_AND_CONFIGURATION_KEY", p -> new ConcurrentHashMap());
    private static final NotNullLazyKey<Map<VirtualFile, OCImmutableInclusionContext>, Project> HEADER_CONTEXT_KEY = NotNullLazyKey.create((String)"HEADER_CONTEXT_KEY", p -> ContainerUtil.createConcurrentSoftValueMap());
    private static final NotNullLazyKey<Map<VirtualFile, OCContextChangeSet>, Project> CONTEXT_CHANGES_KEY = NotNullLazyKey.create((String)"CONTEXT_CHANGES_KEY", p -> ContainerUtil.createConcurrentSoftValueMap());
    private static boolean ourBuildHeaderSymbolsForAllConfigurations = Boolean.parseBoolean(System.getProperty("cidr.build.header.symbols.for.all.configurations"));

    @Deprecated
    @Nullable
    public static OCResolveConfiguration computePreselectedConfiguration(@NotNull Project project2, @NotNull Collection<OCResolveConfiguration> configs) {
        return (OCResolveConfiguration)OCInclusionContextUtil.findPreselectedOrSuitableConfiguration((Project)project2, configs).first;
    }

    @Nullable
    private static OCResolveConfiguration findPreselectedConfiguration(@NotNull Project project2, @NotNull Collection<OCResolveConfiguration> configs, @Nullable Ref<Integer> scoreRef) {
        OCResolveContextSettings settings = OCResolveContextSettings.getInstance(project2);
        Pair<OCResolveConfiguration, Integer> fromSettings = settings.findPriorityConfiguration(configs);
        OCResolveConfiguration result2 = (OCResolveConfiguration)fromSettings.first;
        int score = (Integer)fromSettings.second;
        if (result2 == null) {
            ++score;
            OCResolveConfiguration selectedByRun = OCWorkspaceRunConfigurationListener.getSelectedResolveConfiguration(project2);
            if (selectedByRun != null) {
                if (configs.contains(selectedByRun)) {
                    result2 = selectedByRun;
                } else {
                    ++score;
                    result2 = OCInclusionContextUtil.findClosestConfigByVariant(selectedByRun, configs);
                }
            }
        }
        if (scoreRef != null) {
            scoreRef.set((Object)score);
        }
        return result2;
    }

    @Nullable
    private static OCResolveConfiguration findClosestConfigByVariant(@NotNull OCResolveConfiguration sample, @NotNull Collection<OCResolveConfiguration> configs) {
        OCVariant variant = sample.getVariant();
        if (variant == null) {
            return null;
        }
        for (OCResolveConfiguration config : configs) {
            if (!variant.equals(config.getVariant())) continue;
            return config;
        }
        return null;
    }

    @NotNull
    private static Pair<OCResolveConfiguration, Boolean> findPreselectedOrSuitableConfiguration(@NotNull Project project2, @NotNull Collection<OCResolveConfiguration> configs) {
        OCResolveConfiguration selectedConfiguration = OCInclusionContextUtil.findPreselectedConfiguration(project2, configs, null);
        if (selectedConfiguration != null) {
            return Pair.create((Object)selectedConfiguration, (Object)true);
        }
        return Pair.create((Object)(configs.isEmpty() ? null : Collections.min(configs)), (Object)false);
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null")
    public static VirtualFile getVirtualFile(@Nullable PsiFile file2) {
        PsiFile prevOriginalFile;
        if (file2 == null) {
            return null;
        }
        PsiFile originalFile = file2;
        do {
            prevOriginalFile = originalFile;
        } while ((originalFile = originalFile.getOriginalFile()) != prevOriginalFile);
        VirtualFile vFile = originalFile.getVirtualFile();
        if (vFile != null) {
            return vFile;
        }
        vFile = (VirtualFile)file2.getUserData(IndexingDataKeys.VIRTUAL_FILE);
        if (vFile != null) {
            return vFile;
        }
        return originalFile.getViewProvider().getVirtualFile();
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isLongLived(@Nullable VirtualFile fileFromGetVirtualFileCall) {
        return fileFromGetVirtualFileCall != null && !(fileFromGetVirtualFileCall instanceof LightVirtualFile);
    }

    @Nullable
    public static PsiFile findCachedPsiFile(@NotNull VirtualFile file2, @NotNull Project project2) {
        if (!file2.isValid()) {
            return null;
        }
        return PsiManagerEx.getInstanceEx((Project)project2).getFileManager().getCachedPsiFile(file2);
    }

    public static boolean isRoot(@NotNull PsiFile file2) {
        if (OCPsiFileBaseImpl.isSourceCodeFile(file2.getName())) {
            return !OCWorkspace.getInstance(file2.getProject()).getConfigurationsForFile(OCInclusionContextUtil.getVirtualFile(file2)).isEmpty();
        }
        return false;
    }

    public static boolean isNeedToFindRoot(@NotNull PsiFile file2) {
        return OCInclusionContextUtil.isNeedToFindRoot(OCInclusionContextUtil.getVirtualFile(file2), file2.getProject());
    }

    public static boolean isNeedToFindRoot(@NotNull VirtualFile file2, @NotNull Project project2) {
        if (!OCInclusionContextUtil.isLongLived(file2)) {
            return false;
        }
        if (OCPsiFileBaseImpl.isSourceCodeFile(file2.getName())) {
            return OCWorkspace.getInstance(project2).getConfigurationsForFile(file2).isEmpty();
        }
        return !OCInclusionContext.isPrecompiledHeader(file2, project2);
    }

    @NotNull
    public static OCResolveRootAndConfiguration getResolveRootAndActiveConfiguration(@NotNull VirtualFile virtualFile, @NotNull Project project2) {
        Map cache = (Map)HEADER_ROOT_AND_CONFIGURATION_KEY.getValue((UserDataHolder)project2);
        OCResolveRootAndConfiguration cached = (OCResolveRootAndConfiguration)cache.get(virtualFile);
        if (cached != null) {
            return cached;
        }
        OCResolveRootAndConfiguration result2 = null;
        if (OCInclusionContextUtil.isNeedToFindRoot(virtualFile, project2)) {
            result2 = OCInclusionContextUtil.getResolveRootAndActiveConfigurationForHeader(virtualFile, project2);
        }
        if (result2 == null) {
            result2 = OCInclusionContextUtil.createResolveRootAndConfiguration(project2, OCInclusionContextUtil.doGetPreselectedConfiguration(virtualFile, project2), virtualFile);
        }
        cache.put(virtualFile, result2);
        ((OCInclusionContextListener)project2.getMessageBus().syncPublisher(OCInclusionContextListener.TOPIC)).resolveRootAndActiveConfigurationChanged(virtualFile, result2);
        return result2;
    }

    @NotNull
    public static OCParsedLanguageAndConfiguration getOrCalculateParsedLanguageAndConfiguration(@NotNull PsiFile file2) {
        OCParsedLanguageAndConfiguration langAndConfig;
        OCParsedLanguageAndConfiguration oCParsedLanguageAndConfiguration = langAndConfig = file2 instanceof OCConfigurationOwner ? ((OCConfigurationOwner)file2).getParsedLanguageAndConfiguration() : null;
        if (langAndConfig != null) {
            return langAndConfig;
        }
        OCImmutableInclusionContext context2 = OCInclusionContextUtil.headerContext(file2);
        return new OCParsedLanguageAndConfiguration(context2.getConfiguration(), context2.getLanguageKind());
    }

    @Nullable
    private static OCResolveRootAndConfiguration getResolveRootAndActiveConfigurationForHeader(@NotNull VirtualFile virtualHeaderFile, @NotNull Project project2) {
        String headerNameWithoutExtension = virtualHeaderFile.getNameWithoutExtension();
        OCImportGraph importGraph = OCImportGraph.getInstance(project2);
        ArrayList<VirtualFile> roots2 = new ArrayList<VirtualFile>(importGraph.getAllHeaderRoots(virtualHeaderFile));
        roots2.sort(new VirtualFileComparator(project2, headerNameWithoutExtension));
        ArrayList<Pair> rootsThatMayMatchSelectedConfiguration = new ArrayList<Pair>();
        for (VirtualFile root : roots2) {
            Ref scoreRef;
            Collection<OCResolveConfiguration> configs = OCInclusionContextUtil.getAllBuildConfigurationsOfTargetsOfFile(root, project2);
            if (OCInclusionContextUtil.findPreselectedConfiguration(project2, configs, (Ref<Integer>)(scoreRef = new Ref((Object)0))) == null) continue;
            rootsThatMayMatchSelectedConfiguration.add(Pair.create((Object)root, (Object)scoreRef.get()));
        }
        rootsThatMayMatchSelectedConfiguration.sort((o1, o2) -> Comparing.compare((Comparable)((Comparable)o1.second), (Comparable)((Comparable)o2.second)));
        OCResolveRootAndConfiguration fallBack = null;
        HashSet<VirtualFile> visitedRoots = new HashSet<VirtualFile>(rootsThatMayMatchSelectedConfiguration.size());
        for (Pair info : rootsThatMayMatchSelectedConfiguration) {
            VirtualFile rootFile = (VirtualFile)info.first;
            visitedRoots.add(rootFile);
            HashSet<OCResolveConfiguration> configurations = new HashSet<OCResolveConfiguration>();
            importGraph.fillHeaderConfigurationsForRoot(virtualHeaderFile, rootFile, configurations, null);
            if (configurations.isEmpty()) continue;
            OCResolveConfiguration configuration = OCInclusionContextUtil.findPreselectedConfiguration(project2, configurations, null);
            if (configuration != null) {
                return OCInclusionContextUtil.createResolveRootAndConfiguration(project2, configuration, rootFile);
            }
            if (fallBack != null) continue;
            Pair<OCResolveConfiguration, Boolean> c = OCInclusionContextUtil.findPreselectedOrSuitableConfiguration(project2, configurations);
            if (c.first == null) continue;
            fallBack = OCInclusionContextUtil.createResolveRootAndConfiguration(project2, (OCResolveConfiguration)c.first, rootFile);
        }
        for (VirtualFile rootFile : roots2) {
            if (visitedRoots.contains(rootFile)) {
                if (fallBack == null || !rootFile.equals(fallBack.getRootFile())) continue;
                return fallBack;
            }
            HashSet<OCResolveConfiguration> configurations = new HashSet<OCResolveConfiguration>();
            importGraph.fillHeaderConfigurationsForRoot(virtualHeaderFile, rootFile, configurations, null);
            Pair<OCResolveConfiguration, Boolean> c = OCInclusionContextUtil.findPreselectedOrSuitableConfiguration(project2, configurations);
            if (c.first == null) continue;
            return OCInclusionContextUtil.createResolveRootAndConfiguration(project2, (OCResolveConfiguration)c.first, rootFile);
        }
        return null;
    }

    @NotNull
    private static OCResolveRootAndConfiguration createResolveRootAndConfiguration(@NotNull Project project2, @Nullable OCResolveConfiguration configuration, @NotNull VirtualFile rootFile) {
        OCLanguageKind kind = OCLanguageKindCalculator.calculateLanguageKind(configuration, rootFile, project2, false);
        return new OCResolveRootAndConfiguration(configuration, kind, rootFile);
    }

    @Nullable
    public static OCResolveConfiguration doGetPreselectedConfiguration(@NotNull VirtualFile virtualFile, @NotNull Project project2) {
        return (OCResolveConfiguration)OCInclusionContextUtil.findPreselectedOrSuitableConfiguration((Project)project2, OCInclusionContextUtil.getAllBuildConfigurationsForIndexing((VirtualFile)virtualFile, (Project)project2)).first;
    }

    public static void invalidateHeaderRootAndActiveConfigurationForAllExcept(@Nullable VirtualFile virtualFile, @NotNull Project project2) {
        OCInclusionContextUtil.removeExcept((Map)HEADER_ROOT_AND_CONFIGURATION_KEY.getValue((UserDataHolder)project2), virtualFile);
        OCInclusionContextUtil.invalidateHeaderContextsExcept(virtualFile, project2);
    }

    public static void invalidateHeaderContextsExcept(@Nullable VirtualFile virtualFile, @NotNull Project project2) {
        OCInclusionContextUtil.removeExcept((Map)HEADER_CONTEXT_KEY.getValue((UserDataHolder)project2), virtualFile);
        OCInclusionContextUtil.invalidateContextChangeCacheExcept(virtualFile, project2);
    }

    public static void invalidateContextChangeCacheExcept(@Nullable VirtualFile virtualFile, @NotNull Project project2) {
        OCInclusionContextUtil.removeExcept((Map)CONTEXT_CHANGES_KEY.getValue((UserDataHolder)project2), virtualFile);
    }

    public static <K, V> void removeExcept(@NotNull Map<K, V> map2, @Nullable K key) {
        if (key == null) {
            map2.clear();
        } else {
            map2.keySet().retainAll(Collections.singleton(key));
        }
    }

    public static void invalidateHeaderRootAndActiveConfigurationFor(@Nullable VirtualFile virtualFileInEditor, @NotNull Project project2) {
        if (virtualFileInEditor == null) {
            return;
        }
        Map cached = (Map)HEADER_ROOT_AND_CONFIGURATION_KEY.getValue((UserDataHolder)project2);
        cached.remove(virtualFileInEditor);
        OCInclusionContextUtil.invalidateHeaderContextsExcept(null, project2);
    }

    @NotNull
    public static OCImmutableInclusionContext headerContext(@NotNull PsiFile file2) {
        OCFile original = OCInclusionContextUtil.getOriginalFile(file2);
        if (original == null) {
            return OCInclusionContextImpl.emptyWithBuiltinMacros(null, file2);
        }
        Project project2 = original.getProject();
        VirtualFile virtualFile = OCInclusionContextUtil.getVirtualFile(original);
        Map cache = (Map)HEADER_CONTEXT_KEY.getValue((UserDataHolder)project2);
        OCImmutableInclusionContext cached = (OCImmutableInclusionContext)cache.get(virtualFile);
        if (cached != null) {
            return cached;
        }
        OCInclusionContext result2 = OCInclusionContextUtil.innerCalculateHeaderContext(original, null);
        cache.put(virtualFile, result2);
        return result2;
    }

    public static OCInclusionContext calculateHeaderContext(@NotNull PsiFile file2, @Nullable OCLanguageKind languageKind) {
        OCFile original = OCInclusionContextUtil.getOriginalFile(file2);
        if (original == null) {
            return OCInclusionContextImpl.emptyWithBuiltinMacros(languageKind, file2);
        }
        return OCInclusionContextUtil.innerCalculateHeaderContext(original, languageKind);
    }

    @Nullable
    public static OCFile getOriginalFile(@Nullable PsiFile file2) {
        OCFile physical;
        if (file2 == null) {
            return null;
        }
        OCFile original = OCLanguageUtils.asOCFile(file2.getOriginalFile());
        if (original == null) {
            return null;
        }
        if (original.isPhysical()) {
            return original;
        }
        for (physical = original; physical != null && !physical.isPhysical(); physical = physical.getContext()) {
        }
        return OCLanguageUtils.asOCFile(physical != null ? physical.getContainingFile() : null);
    }

    @NotNull
    private static OCInclusionContext innerCalculateHeaderContext(@NotNull OCFile original, @Nullable OCLanguageKind kind) {
        Project project2 = original.getProject();
        VirtualFile virtualFile = OCInclusionContextUtil.getVirtualFile(original);
        if (OCInclusionContextUtil.isNeedToFindRoot(virtualFile, project2)) {
            OCResolveConfiguration config;
            OCFile importHolder;
            OCResolveRootAndConfiguration rootAndConfiguration = OCInclusionContextUtil.getResolveRootAndActiveConfiguration(virtualFile, project2);
            VirtualFile rootFile = rootAndConfiguration.getRootFile();
            OCFile oCFile = importHolder = rootFile != null && rootFile.isValid() ? OCLanguageUtils.asOCFile(project2, rootFile) : null;
            if (importHolder != null && !rootFile.equals(virtualFile) && (config = rootAndConfiguration.getConfiguration()) != null) {
                OCImmutableInclusionContext precompiledContext = OCInclusionContext.tryFindInCachedPCHPrecompiledContexts(config, virtualFile, rootFile);
                if (precompiledContext == null) {
                    precompiledContext = OCInclusionContext.initialPCHContextWithoutRoot(config, importHolder.getKind(), importHolder);
                } else {
                    precompiledContext = precompiledContext.getParent();
                    assert (precompiledContext != null && precompiledContext.getParent() == null);
                }
                OCInclusionContext result2 = precompiledContext.derive(importHolder);
                result2.preprocessContextOf(importHolder, virtualFile);
                return result2;
            }
        }
        return OCInclusionContextUtil.sourceFileContext(original, kind);
    }

    @NotNull
    private static OCInclusionContext sourceFileContext(@NotNull OCFile file2, @Nullable OCLanguageKind kindOrNullForDefault) {
        OCResolveConfiguration config;
        if (kindOrNullForDefault == null) {
            kindOrNullForDefault = file2.getKind();
        }
        if ((config = OCInclusionContextUtil.doGetPreselectedConfiguration(OCInclusionContextUtil.getVirtualFile(file2), file2.getProject())) != null) {
            return OCInclusionContext.sourceParsingContext(config, kindOrNullForDefault, file2);
        }
        return OCInclusionContextImpl.emptyWithBuiltinMacros(kindOrNullForDefault, file2);
    }

    public static void resetUserSelectedConfigurations(@NotNull Project project2) {
        OCResolveContextSettings.getInstance(project2).resetConfigurationPriorities();
    }

    public static void setUserSelectedConfiguration(@NotNull PsiFile psiFile, @Nullable OCResolveConfiguration config) {
        PsiFile contextFile;
        Project project2 = psiFile.getProject();
        if (config != null) {
            OCResolveContextSettings.getInstance(project2).setSelectedConfiguration(config);
        }
        if ((contextFile = FileContextUtil.getContextFile((PsiElement)psiFile)) != null) {
            psiFile = contextFile;
        }
        psiFile.putUserData(FILE_ACTIVE_CONFIGURATION_CACHE, null);
        OCInclusionContextUtil.invalidateHeaderRootAndActiveConfigurationFor(OCInclusionContextUtil.getVirtualFile(psiFile), project2);
        VirtualFile file2 = psiFile.getVirtualFile();
        if (file2 != null) {
            FileContentUtil.reparseFiles((Project)project2, Collections.singletonList(file2), (boolean)false);
        }
    }

    @Nullable
    public static OCResolveConfiguration getActiveConfiguration(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiFile contextFile = FileContextUtil.getContextFile((PsiElement)element);
        return contextFile == null ? null : (OCResolveConfiguration)((CachedValue)FILE_ACTIVE_CONFIGURATION_CACHE.getValue((UserDataHolder)contextFile)).getValue();
    }

    @Nullable
    public static OCResolveConfiguration getActiveConfiguration(@Nullable VirtualFile file2, @NotNull Project project2) {
        return OCInclusionContextUtil.getActiveConfiguration(file2 == null ? null : PsiManager.getInstance((Project)project2).findFile(file2));
    }

    @NotNull
    public static Collection<OCResolveConfiguration> getAllBuildConfigurationsForFile(@NotNull PsiFile file2, @Nullable ProgressIndicator progress) {
        if (file2 instanceof OCFile && OCInclusionContextUtil.isNeedToFindRoot(file2)) {
            return OCImportGraph.getInstance(file2.getProject()).getAllHeaderConfigurations((OCFile)file2, progress);
        }
        Collection<OCResolveConfiguration> configurations = OCLibraryFileResolveConfigurationProvider.getConfigurations(file2, progress);
        if (configurations != null) {
            return configurations;
        }
        return OCInclusionContextUtil.getAllBuildConfigurationsOfTargetsOfFile(OCInclusionContextUtil.getVirtualFile(file2), file2.getProject());
    }

    @NotNull
    public static Collection<OCResolveConfiguration> getAllBuildConfigurationsOfTargetsOfFile(@NotNull VirtualFile virtualFile, @NotNull Project project2) {
        Collection<OCResolveConfiguration> configOfPch = OCInclusionContext.getBuildConfigurationByPchFile(virtualFile, project2);
        if (!configOfPch.isEmpty()) {
            return configOfPch;
        }
        return OCWorkspace.getInstance(project2).getConfigurationsForFile(virtualFile);
    }

    @ApiStatus.Internal
    public static void setBuildHeaderSymbolsForAllConfigurations(boolean buildHeaderSymbolsForAllConfigurations) {
        ourBuildHeaderSymbolsForAllConfigurations = buildHeaderSymbolsForAllConfigurations;
    }

    @NotNull
    public static Collection<OCResolveConfiguration> getAllBuildConfigurationsForIndexing(@NotNull VirtualFile virtualFile, @NotNull Project project2) {
        Collection<OCResolveConfiguration> result2 = OCInclusionContextUtil.getAllBuildConfigurationsOfTargetsOfFile(virtualFile, project2);
        if (!result2.isEmpty()) {
            return result2;
        }
        Collection<OCResolveConfiguration> configurations = OCInclusionContextUtil.getConfigurationsToIndexForHeaderFile(project2, virtualFile);
        if (ourBuildHeaderSymbolsForAllConfigurations && !configurations.isEmpty()) {
            return configurations;
        }
        if (ContainerUtil.isEmpty(configurations)) {
            configurations = OCWorkspace.getInstance(project2).getConfigurations();
        }
        OCResolveConfiguration preselected = (OCResolveConfiguration)OCInclusionContextUtil.findPreselectedOrSuitableConfiguration((Project)project2, configurations).first;
        return ContainerUtil.createMaybeSingletonList((Object)preselected);
    }

    @NotNull
    public static Collection<VirtualFile> getHeaderFilesToBuildSymbols(@NotNull Project project2) {
        return HeaderFilesToBuildSymbolsProvider.get(project2).keySet();
    }

    @NotNull
    private static Collection<OCResolveConfiguration> getConfigurationsToIndexForHeaderFile(@NotNull Project project2, @NotNull VirtualFile file2) {
        return HeaderFilesToBuildSymbolsProvider.get(project2).get((Object)file2);
    }

    public static String pragmaOnceId(@NotNull VirtualFile vFile) {
        return OCInclusionContextUtil.fileGuard(vFile, "__CIDR_pragma_once");
    }

    public static String inclusionId(@NotNull VirtualFile vFile) {
        return OCInclusionContextUtil.fileGuard(vFile, "__CIDR_included");
    }

    private static String fileGuard(VirtualFile vFile, String prefix) {
        if (vFile instanceof VirtualFileWithId) {
            return prefix + "_id_" + ((VirtualFileWithId)vFile).getId();
        }
        return prefix + "_path_" + vFile.getPath();
    }

    public static void storeCachedContextChangeSet(@NotNull Project project2, @NotNull VirtualFile virtualFile, @NotNull OCContextChangeSet changeSet) {
        ((Map)CONTEXT_CHANGES_KEY.get((UserDataHolder)project2)).put(virtualFile, changeSet);
    }

    public static OCContextChangeSet cachedContextChangeSet(@NotNull Project project2, @Nullable VirtualFile virtualFile) {
        if (virtualFile == null) {
            return null;
        }
        return (OCContextChangeSet)((Map)CONTEXT_CHANGES_KEY.getValue((UserDataHolder)project2)).get(virtualFile);
    }

    public static class VirtualFileComparator
    implements Comparator<VirtualFile> {
        private final Project myProject;
        private final String myHeaderNameWithoutExtension;

        public VirtualFileComparator(Project project2, String headerNameWithoutExtension) {
            this.myProject = project2;
            this.myHeaderNameWithoutExtension = headerNameWithoutExtension.toUpperCase(Locale.getDefault());
        }

        @Override
        public int compare(@NotNull VirtualFile root1, @NotNull VirtualFile root2) {
            int result2 = Comparing.compare((boolean)OCInclusionContext.isPrecompiledHeader(root1, this.myProject), (boolean)OCInclusionContext.isPrecompiledHeader(root2, this.myProject));
            if (result2 != 0) {
                return -result2;
            }
            result2 = Comparing.compare((boolean)OCFileTypeHelpers.isSourceFile(root1.getName()), (boolean)OCFileTypeHelpers.isSourceFile(root2.getName()));
            if (result2 != 0) {
                return -result2;
            }
            String rootName1 = root1.getNameWithoutExtension().toUpperCase(Locale.getDefault());
            String rootName2 = root2.getNameWithoutExtension().toUpperCase(Locale.getDefault());
            result2 = Comparing.compare((boolean)this.myHeaderNameWithoutExtension.equals(rootName1), (boolean)this.myHeaderNameWithoutExtension.equals(rootName2));
            if (result2 != 0) {
                return -result2;
            }
            result2 = Comparing.compare((Comparable)((Object)rootName1), (Comparable)((Object)rootName2));
            if (result2 != 0) {
                return result2;
            }
            return Comparing.compare((Comparable)((Object)root1.getPath()), (Comparable)((Object)root2.getPath()));
        }
    }

    private static final class HeaderFilesToBuildSymbolsProvider
    implements CachedValueProvider<MultiMap<VirtualFile, OCResolveConfiguration>> {
        @NotNull
        private static final Key<CachedValue<MultiMap<VirtualFile, OCResolveConfiguration>>> KEY = Key.create((String)"LIBRARY_FILES_KEY");
        @NotNull
        private final Project myProject;

        private HeaderFilesToBuildSymbolsProvider(@NotNull Project project2) {
            this.myProject = project2;
        }

        @NotNull
        public CachedValueProvider.Result<MultiMap<VirtualFile, OCResolveConfiguration>> compute() {
            boolean skipFrameworks = !PlatformUtils.isAppCode();
            MultiMap headerConfigs = MultiMap.createSet();
            Object2ObjectOpenHashMap scannedRootHeaders = new Object2ObjectOpenHashMap();
            ModuleMapManager moduleMapManager = ModuleMapManager.getInstance(this.myProject);
            ModuleMapManager.Cache cache = moduleMapManager.getGlobalCache();
            AllowedModules allowedModules = AllowedModules.Companion.getAllowedModules();
            HashSet alreadySeenRootInConfig = new HashSet();
            for (OCResolveConfiguration config : OCWorkspace.getInstance(this.myProject).getConfigurations()) {
                alreadySeenRootInConfig.clear();
                config.getAllCompilerSettings().forEach(arg_0 -> this.lambda$compute$1(alreadySeenRootInConfig, (Map)scannedRootHeaders, headerConfigs, config, skipFrameworks, cache, allowedModules, arg_0));
            }
            OCWorkspaceModificationTrackers trackers = OCWorkspace.getInstance(this.myProject).getModificationTrackers();
            return CachedValueProvider.Result.create((Object)(headerConfigs.isEmpty() ? MultiMap.empty() : headerConfigs), (Object[])new Object[]{trackers.getResolveConfigurationsTracker(), trackers.getSourceFilesTracker(), trackers.getCompilerSettingsTracker()});
        }

        private static void processHeadersInRoot(@NotNull HeadersSearchRoot eachRoot, @NotNull ModuleMapManager.Cache cache, @NotNull AllowedModules allowedModules, final @NotNull Consumer<? super VirtualFile> processor2) {
            eachRoot.processChildren(new HeadersSearchRootProcessor(){

                @Override
                @NotNull
                public HeadersSearchRootProcessor.FrameworkResult processFramework(@NotNull AppleFramework framework) {
                    ProgressManager.checkCanceled();
                    List<VirtualFile> publicHeadersToInclude = ModuleMapUtil.getPublicHeadersToInclude(framework);
                    if (publicHeadersToInclude.isEmpty()) {
                        return HeadersSearchRootProcessor.FrameworkResult.PROCESS_CHILDREN;
                    }
                    publicHeadersToInclude.forEach(processor2);
                    return HeadersSearchRootProcessor.FrameworkResult.SKIP_CHILDREN;
                }

                @Override
                public boolean process(@NotNull VirtualFile file2) {
                    ProgressManager.checkCanceled();
                    if (!file2.isDirectory()) {
                        processor2.accept(file2);
                    }
                    return true;
                }
            });
            ModuleMap moduleMap = cache.getModuleMap(eachRoot);
            if (moduleMap != null) {
                moduleMap.getModules().stream().filter(module2 -> allowedModules.contains(module2.getQualifiedName())).flatMap(module2 -> {
                    ProgressManager.checkCanceled();
                    return module2.getIncludeHeaders().stream();
                }).forEach(processor2);
            }
        }

        @NotNull
        static MultiMap<VirtualFile, OCResolveConfiguration> get(@NotNull Project project2) {
            CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)project2);
            return (MultiMap)cachedValuesManager.getCachedValue((UserDataHolder)project2, KEY, (CachedValueProvider)new HeaderFilesToBuildSymbolsProvider(project2), false);
        }

        private /* synthetic */ void lambda$compute$1(Set alreadySeenRootInConfig, Map scannedRootHeaders, MultiMap headerConfigs, OCResolveConfiguration config, boolean skipFrameworks, ModuleMapManager.Cache cache, AllowedModules allowedModules, OCCompilerSettings settings) {
            if (settings.getCompilerKind() == MSVCCompilerKind.INSTANCE || settings.getCompilerKind() == ClangClCompilerKind.INSTANCE || settings.getCompilerKind() == NVCCCompilerKind.INSTANCE && SystemInfo.isWindows) {
                return;
            }
            List<HeadersSearchRoot> roots2 = settings.getHeadersSearchRoots().getAllRoots();
            for (HeadersSearchRoot eachRoot : roots2) {
                if (!alreadySeenRootInConfig.add(eachRoot)) continue;
                if (scannedRootHeaders.containsKey((Object)eachRoot)) {
                    for (VirtualFile header : (Set)scannedRootHeaders.get((Object)eachRoot)) {
                        headerConfigs.putValue((Object)header, (Object)config);
                    }
                    continue;
                }
                if (skipFrameworks && eachRoot instanceof FrameworksSearchRoot) continue;
                ObjectOpenHashSet headers = new ObjectOpenHashSet();
                HeaderFilesToBuildSymbolsProvider.processHeadersInRoot(eachRoot, cache, allowedModules, arg_0 -> this.lambda$null$0((Set)headers, headerConfigs, config, arg_0));
                scannedRootHeaders.put(eachRoot, headers);
            }
        }

        private /* synthetic */ void lambda$null$0(Set headers, MultiMap headerConfigs, OCResolveConfiguration config, VirtualFile header) {
            if (SymbolTableProvider.isSourceFile(this.myProject, header) && headers.add(header)) {
                headerConfigs.putValue((Object)header, (Object)config);
            }
        }
    }
}

