/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.lang.preprocessor.OCPreprocessingLexer;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCBoostPPHelper {
    public static final String BOOST_PP_PREFIX = "BOOST_PP_";
    private static final Map<String, FastBoostEvaluator> EVALUATORS = OCBoostPPHelper.evaluatorMap();

    private static Map<String, FastBoostEvaluator> evaluatorMap() {
        Object2ObjectOpenHashMap r = new Object2ObjectOpenHashMap();
        r.put((Object)"ADD", OCBoostPPHelper::tryFastAdd);
        r.put((Object)"ADD_D", OCBoostPPHelper::tryFastAddD);
        r.put((Object)"SUB", OCBoostPPHelper::tryFastSub);
        r.put((Object)"SUB_D", OCBoostPPHelper::tryFastSubD);
        r.put((Object)"TUPLE_ELEM", OCBoostPPHelper::tryFastTupleElem);
        r.put((Object)"WHILE_", OCBoostPPHelper::tryFastWhile);
        r.put((Object)"FOR_", OCBoostPPHelper::tryFastFor);
        r.put((Object)"REPEAT_", OCBoostPPHelper::tryFastRepeat);
        r.put((Object)"SEQ_FOLD_LEFT_", OCBoostPPHelper::tryFastSeqFoldLeft);
        r.put((Object)"SEQ_FOLD_RIGHT_", OCBoostPPHelper::tryFastSeqFoldRight);
        r.put((Object)"LIST_FOLD_LEFT_", OCBoostPPHelper::tryFastListFoldLeft);
        r.put((Object)"LIST_FOLD_RIGHT_", OCBoostPPHelper::tryFastListFoldRight);
        r.trim();
        return r;
    }

    public static OCPreprocessingLexer.SubstitutionResult tryFastSubstitution(@NotNull OCPreprocessingLexer pp, @NotNull OCMacroSymbol macro, @NotNull List<String> params, @NotNull Map<String, Integer> paramIndices, @NotNull Map<String, String> paramSubst, @NotNull Map<String, String> substitutionMap) {
        String macroName = macro.getName();
        if (!macroName.startsWith(BOOST_PP_PREFIX)) {
            return null;
        }
        int evalKeyEnd = macroName.length();
        while (Character.isDigit(macroName.charAt(evalKeyEnd - 1))) {
            --evalKeyEnd;
        }
        String evalKey = macroName.substring(BOOST_PP_PREFIX.length(), evalKeyEnd);
        FastBoostEvaluator evaluator = EVALUATORS.get(evalKey);
        if (evaluator == null) {
            return null;
        }
        String numSuffix = evalKeyEnd != macroName.length() ? macroName.substring(evalKeyEnd) : "";
        return evaluator.trySubstitute(pp, params, paramIndices, paramSubst, substitutionMap, numSuffix);
    }

    @Nullable
    private static OCPreprocessingLexer.SubstitutionResult tryFastTupleElem(@NotNull OCPreprocessingLexer pp, @NotNull List<String> params, @NotNull Map<String, Integer> paramIndices, @NotNull Map<String, String> paramSubst, @NotNull Map<String, String> substitutionMap, @NotNull String numSuffix) {
        String tupleText;
        String idxText;
        int paramSize = params.size();
        if (paramSize != 1 && paramSize != 3) {
            return null;
        }
        boolean isVariadic = paramSize == 1;
        int limitTuple = OCBoostPPHelper.tryParseAsBoostInt(pp.preprocess("BOOST_PP_LIMIT_TUPLE", OCPreprocessingLexer.PreprocessingMode.FIRST_MACRO_ARG));
        if (limitTuple < 0) {
            return null;
        }
        int size = -1;
        if (isVariadic) {
            String paramText = paramSubst.get(params.get(0));
            List<String> paramTuple = OCBoostPPHelper.tryParseAsBoostTupleContents(paramText);
            if (paramTuple == null || paramTuple.size() < 2 || paramTuple.size() > 3) {
                return null;
            }
            boolean hasSize = paramTuple.size() == 3;
            idxText = pp.preprocess(paramTuple.get(hasSize ? 1 : 0), OCPreprocessingLexer.PreprocessingMode.FIRST_MACRO_ARG);
            tupleText = pp.preprocess(paramTuple.get(hasSize ? 2 : 1), OCPreprocessingLexer.PreprocessingMode.FIRST_MACRO_ARG);
        } else {
            String sizeText = pp.substituteMacroParam(paramIndices, paramSubst, substitutionMap, params.get(0));
            size = OCBoostPPHelper.tryParseAsBoostInt(sizeText);
            if (size < 0 || size > limitTuple) {
                return null;
            }
            idxText = pp.substituteMacroParam(paramIndices, paramSubst, substitutionMap, params.get(1));
            tupleText = pp.substituteMacroParam(paramIndices, paramSubst, substitutionMap, params.get(2));
        }
        int idx = OCBoostPPHelper.tryParseAsBoostInt(idxText);
        if (idx < 0 || idx >= limitTuple) {
            return null;
        }
        List<String> tuple = OCBoostPPHelper.tryParseAsBoostTuple(tupleText);
        if (tuple == null) {
            return null;
        }
        if (tuple.size() <= idx || !isVariadic && tuple.size() != size) {
            return null;
        }
        OCPreprocessingLexer.SubstitutionResult result2 = new OCPreprocessingLexer.SubstitutionResult();
        result2.append(tuple.get(idx));
        return result2;
    }

    @Nullable
    private static OCPreprocessingLexer.SubstitutionResult tryFastListFoldLeft(@NotNull OCPreprocessingLexer pp, @NotNull List<String> params, @NotNull Map<String, Integer> paramIndices, @NotNull Map<String, String> paramSubst, @NotNull Map<String, String> substitutionMap, @NotNull String numSuffix) {
        return OCBoostPPHelper.tryFastListFold(pp, params, paramIndices, paramSubst, substitutionMap, numSuffix, true);
    }

    @Nullable
    private static OCPreprocessingLexer.SubstitutionResult tryFastListFoldRight(@NotNull OCPreprocessingLexer pp, @NotNull List<String> params, @NotNull Map<String, Integer> paramIndices, @NotNull Map<String, String> paramSubst, @NotNull Map<String, String> substitutionMap, @NotNull String numSuffix) {
        return OCBoostPPHelper.tryFastListFold(pp, params, paramIndices, paramSubst, substitutionMap, numSuffix, false);
    }

    @Nullable
    private static OCPreprocessingLexer.SubstitutionResult tryFastListFold(@NotNull OCPreprocessingLexer pp, @NotNull List<String> params, @NotNull Map<String, Integer> paramIndices, @NotNull Map<String, String> paramSubst, @NotNull Map<String, String> substitutionMap, @NotNull String numSuffix, boolean isLeft) {
        if (params.size() != 3) {
            return null;
        }
        int limitMag = OCBoostPPHelper.tryParseAsBoostInt(pp.preprocess("BOOST_PP_LIMIT_MAG", OCPreprocessingLexer.PreprocessingMode.FIRST_MACRO_ARG));
        if (limitMag < 0) {
            return null;
        }
        int s = OCBoostPPHelper.tryParseAsBoostInt(numSuffix);
        if (s < 1 || s > limitMag) {
            return null;
        }
        String op = pp.substituteMacroParam(paramIndices, paramSubst, substitutionMap, params.get(0));
        String state = pp.substituteMacroParam(paramIndices, paramSubst, substitutionMap, params.get(1));
        String listParam = pp.substituteMacroParam(paramIndices, paramSubst, substitutionMap, params.get(2));
        List<String> list = OCBoostPPHelper.tryParseAsBoostList(listParam);
        if (list == null) {
            return null;
        }
        if (s + list.size() > limitMag) {
            return null;
        }
        return OCBoostPPHelper.foldList(pp, isLeft, s, op, state, list, "BOOST_PP_LIST_FOLD_LEFT_");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static OCPreprocessingLexer.SubstitutionResult foldList(@NotNull OCPreprocessingLexer pp, boolean isLeft, int step, @NotNull String operation, @NotNull String state, @NotNull List<String> list, @NotNull String macroCheckName) {
        ArrayList<Object> undef = new ArrayList<Object>();
        try {
            int n;
            Object undefM = macroCheckName + step;
            undef.add(undefM);
            pp.hideDefinition((String)undefM);
            boolean bl = false;
            while (n < list.size()) {
                undefM = macroCheckName + step;
                undef.add(undefM);
                pp.hideDefinition((String)undefM);
                String elem = list.get(isLeft ? n : list.size() - n - 1);
                String text = operation + "(" + ++step + ", " + state + ", " + elem + ")";
                state = pp.preprocess(text, OCPreprocessingLexer.PreprocessingMode.FIRST_MACRO_ARG);
                ++n;
            }
        }
        finally {
            for (String string : undef) {
                pp.revealDefinition(string);
            }
        }
        OCPreprocessingLexer.SubstitutionResult result2 = new OCPreprocessingLexer.SubstitutionResult();
        result2.append(state);
        return result2;
    }

    @Nullable
    private static OCPreprocessingLexer.SubstitutionResult tryFastSeqFoldLeft(@NotNull OCPreprocessingLexer pp, @NotNull List<String> params, @NotNull Map<String, Integer> paramIndices, @NotNull Map<String, String> paramSubst, @NotNull Map<String, String> substitutionMap, @NotNull String numSuffix) {
        return OCBoostPPHelper.tryFastSeqFold(pp, params, paramIndices, paramSubst, substitutionMap, numSuffix, true);
    }

    @Nullable
    private static OCPreprocessingLexer.SubstitutionResult tryFastSeqFoldRight(@NotNull OCPreprocessingLexer pp, @NotNull List<String> params, @NotNull Map<String, Integer> paramIndices, @NotNull Map<String, String> paramSubst, @NotNull Map<String, String> substitutionMap, @NotNull String numSuffix) {
        return OCBoostPPHelper.tryFastSeqFold(pp, params, paramIndices, paramSubst, substitutionMap, numSuffix, false);
    }

    @Nullable
    private static OCPreprocessingLexer.SubstitutionResult tryFastSeqFold(@NotNull OCPreprocessingLexer pp, @NotNull List<String> params, @NotNull Map<String, Integer> paramIndices, @NotNull Map<String, String> paramSubst, @NotNull Map<String, String> substitutionMap, @NotNull String numSuffix, boolean isLeft) {
        int iterLimit;
        if (params.size() != 3) {
            return null;
        }
        int limitMag = OCBoostPPHelper.tryParseAsBoostInt(pp.preprocess("BOOST_PP_LIMIT_MAG", OCPreprocessingLexer.PreprocessingMode.FIRST_MACRO_ARG));
        if (limitMag < 0) {
            return null;
        }
        int s = OCBoostPPHelper.tryParseAsBoostInt(numSuffix);
        if (s < 1 || s > limitMag) {
            return null;
        }
        String op = pp.substituteMacroParam(paramIndices, paramSubst, substitutionMap, params.get(0));
        String state = pp.substituteMacroParam(paramIndices, paramSubst, substitutionMap, params.get(1));
        String seqParam = pp.substituteMacroParam(paramIndices, paramSubst, substitutionMap, params.get(2));
        List<String> seq = OCBoostPPHelper.tryParseAsBoostSequence(seqParam);
        if (seq == null || seq.isEmpty()) {
            return null;
        }
        int n = iterLimit = isLeft ? limitMag + 1 : limitMag;
        if (s + seq.size() > iterLimit) {
            return null;
        }
        return OCBoostPPHelper.foldList(pp, isLeft, s, op, state, seq, "BOOST_PP_SEQ_FOLD_LEFT_I_");
    }

    @Nullable
    private static OCPreprocessingLexer.SubstitutionResult tryFastFor(@NotNull OCPreprocessingLexer pp, @NotNull List<String> params, @NotNull Map<String, Integer> paramIndices, @NotNull Map<String, String> paramSubst, @NotNull Map<String, String> substitutionMap, @NotNull String numSuffix) {
        if (params.size() != 4) {
            return null;
        }
        int r = OCBoostPPHelper.tryParseAsBoostInt(numSuffix);
        if (r < 1) {
            return null;
        }
        int limitMag = OCBoostPPHelper.tryParseAsBoostInt(pp.preprocess("BOOST_PP_LIMIT_MAG", OCPreprocessingLexer.PreprocessingMode.FIRST_MACRO_ARG));
        if (limitMag < 0) {
            return null;
        }
        int iterLimit = limitMag + 1;
        if (r > iterLimit) {
            return null;
        }
        String state = pp.substituteMacroParam(paramIndices, paramSubst, substitutionMap, params.get(0));
        String pred = pp.substituteMacroParam(paramIndices, paramSubst, substitutionMap, params.get(1));
        String op = pp.substituteMacroParam(paramIndices, paramSubst, substitutionMap, params.get(2));
        String forMacro = pp.substituteMacroParam(paramIndices, paramSubst, substitutionMap, params.get(3));
        OCPreprocessingLexer.SubstitutionResult result2 = new OCPreprocessingLexer.SubstitutionResult();
        String macroCheckBase = "BOOST_PP_FOR_";
        ArrayList<String> hiddenDefs = new ArrayList<String>();
        try {
            while (true) {
                OCPreprocessingLexer.SubstitutionResult substitutionResult;
                String macroCheck = macroCheckBase + r;
                hiddenDefs.add(macroCheck);
                pp.hideDefinition(macroCheck);
                String predCall = pred + "(" + ++r + "," + state + ")";
                String predPP = pp.preprocess(predCall, OCPreprocessingLexer.PreprocessingMode.FIRST_MACRO_ARG);
                int predR = OCBoostPPHelper.tryParseAsBoostInt(predPP);
                if (predR < 0 || predR > limitMag) {
                    substitutionResult = null;
                    return substitutionResult;
                }
                if (predR == 0) {
                    substitutionResult = result2;
                    return substitutionResult;
                }
                if (r > iterLimit) {
                    substitutionResult = null;
                    return substitutionResult;
                }
                String forMacroCall = forMacro + "(" + r + ", " + state + ")";
                String forMacroPP = pp.preprocess(forMacroCall, OCPreprocessingLexer.PreprocessingMode.FIRST_MACRO_ARG);
                result2.append(forMacroPP);
                result2.append(" ");
                String opCall = op + "(" + r + ", " + state + ")";
                state = pp.preprocess(opCall, OCPreprocessingLexer.PreprocessingMode.FIRST_MACRO_ARG);
            }
        }
        finally {
            for (String def : hiddenDefs) {
                pp.revealDefinition(def);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static OCPreprocessingLexer.SubstitutionResult tryFastRepeat(@NotNull OCPreprocessingLexer pp, @NotNull List<String> params, @NotNull Map<String, Integer> paramIndices, @NotNull Map<String, String> paramSubst, @NotNull Map<String, String> substitutionMap, @NotNull String numSuffix) {
        if (params.size() != 3) {
            return null;
        }
        int z = OCBoostPPHelper.tryParseAsBoostInt(numSuffix);
        if (z < 1 || z > 3) {
            return null;
        }
        int limitRepeat = OCBoostPPHelper.tryParseAsBoostInt(pp.preprocess("BOOST_PP_LIMIT_REPEAT", OCPreprocessingLexer.PreprocessingMode.FIRST_MACRO_ARG));
        if (limitRepeat < 0) {
            return null;
        }
        String countText = pp.substituteMacroParam(paramIndices, paramSubst, substitutionMap, params.get(0));
        int count = OCBoostPPHelper.tryParseAsBoostInt(countText);
        if (count < 0 || count > limitRepeat) {
            return null;
        }
        String op = pp.substituteMacroParam(paramIndices, paramSubst, substitutionMap, params.get(1));
        String data = pp.substituteMacroParam(paramIndices, paramSubst, substitutionMap, params.get(2));
        OCPreprocessingLexer.SubstitutionResult result2 = new OCPreprocessingLexer.SubstitutionResult();
        String macroCheckName = "BOOST_PP_REPEAT_" + z;
        pp.hideDefinition(macroCheckName);
        try {
            for (int i2 = 0; i2 < count; ++i2) {
                String callText = op + "(" + (z + 1) + ", " + i2 + ", " + data + ")";
                String callResult = pp.preprocess(callText, OCPreprocessingLexer.PreprocessingMode.FIRST_MACRO_ARG);
                result2.append(callResult);
                result2.append(" ");
            }
        }
        finally {
            pp.revealDefinition(macroCheckName);
        }
        return result2;
    }

    @Nullable
    private static OCPreprocessingLexer.SubstitutionResult tryFastWhile(@NotNull OCPreprocessingLexer pp, @NotNull List<String> params, @NotNull Map<String, Integer> paramIndices, @NotNull Map<String, String> paramSubst, @NotNull Map<String, String> substitutionMap, @NotNull String numSuffix) {
        if (params.size() != 3) {
            return null;
        }
        int limitMag = OCBoostPPHelper.tryParseAsBoostInt(pp.preprocess("BOOST_PP_LIMIT_MAG", OCPreprocessingLexer.PreprocessingMode.FIRST_MACRO_ARG));
        if (limitMag < 0) {
            return null;
        }
        int d = OCBoostPPHelper.tryParseAsBoostInt(numSuffix);
        if (d < 1 || d > limitMag) {
            return null;
        }
        String pred = pp.substituteMacroParam(paramIndices, paramSubst, substitutionMap, params.get(0));
        String op = pp.substituteMacroParam(paramIndices, paramSubst, substitutionMap, params.get(1));
        String state = pp.substituteMacroParam(paramIndices, paramSubst, substitutionMap, params.get(2));
        ArrayList<String> undef = new ArrayList<String>();
        try {
            while (true) {
                String toHide = "BOOST_PP_WHILE_" + d;
                undef.add(toHide);
                pp.hideDefinition(toHide);
                String predExpr = pred + "(" + ++d + "," + state + ")";
                String predPP = pp.preprocess(predExpr, OCPreprocessingLexer.PreprocessingMode.FIRST_MACRO_ARG);
                int pr = OCBoostPPHelper.tryParseAsBoostInt(predPP);
                if (pr < 0 || pr > limitMag) {
                    OCPreprocessingLexer.SubstitutionResult substitutionResult = null;
                    return substitutionResult;
                }
                if (pr == 0) {
                    OCPreprocessingLexer.SubstitutionResult r = new OCPreprocessingLexer.SubstitutionResult();
                    r.append(state);
                    OCPreprocessingLexer.SubstitutionResult substitutionResult = r;
                    return substitutionResult;
                }
                String opExpr = op + "(" + d + ", " + state + ")";
                state = pp.preprocess(opExpr, OCPreprocessingLexer.PreprocessingMode.FIRST_MACRO_ARG);
                if (d <= limitMag) continue;
                OCPreprocessingLexer.SubstitutionResult substitutionResult = null;
                return substitutionResult;
            }
        }
        finally {
            for (String def : undef) {
                pp.revealDefinition(def);
            }
        }
    }

    @Nullable
    private static OCPreprocessingLexer.SubstitutionResult tryFastSub(@NotNull OCPreprocessingLexer pp, @NotNull List<String> params, @NotNull Map<String, Integer> paramIndices, @NotNull Map<String, String> paramSubst, @NotNull Map<String, String> substitutionMap, @NotNull String numSuffix) {
        return OCBoostPPHelper.tryFastSubInt(pp, params, paramIndices, paramSubst, substitutionMap, false);
    }

    @Nullable
    private static OCPreprocessingLexer.SubstitutionResult tryFastSubD(@NotNull OCPreprocessingLexer pp, @NotNull List<String> params, @NotNull Map<String, Integer> paramIndices, @NotNull Map<String, String> paramSubst, @NotNull Map<String, String> substitutionMap, @NotNull String numSuffix) {
        return OCBoostPPHelper.tryFastSubInt(pp, params, paramIndices, paramSubst, substitutionMap, true);
    }

    @Nullable
    private static OCPreprocessingLexer.SubstitutionResult tryFastSubInt(@NotNull OCPreprocessingLexer pp, @NotNull List<String> params, @NotNull Map<String, Integer> paramIndices, @NotNull Map<String, String> paramSubst, @NotNull Map<String, String> substitutionMap, boolean isDVersion) {
        int d;
        if (params.size() != (isDVersion ? 3 : 2)) {
            return null;
        }
        int limit = OCBoostPPHelper.tryParseAsBoostInt(pp.preprocess("BOOST_PP_LIMIT_MAG", OCPreprocessingLexer.PreprocessingMode.FIRST_MACRO_ARG));
        if (limit < 0) {
            return null;
        }
        int n = d = isDVersion ? OCBoostPPHelper.trySubstituteParamAsInt(pp, paramIndices, paramSubst, substitutionMap, params.get(0)) : 1;
        if (d < 1) {
            return null;
        }
        int x = OCBoostPPHelper.trySubstituteParamAsInt(pp, paramIndices, paramSubst, substitutionMap, params.get(isDVersion ? 1 : 0));
        if (x < 0 || x > limit + 1) {
            return null;
        }
        int y = OCBoostPPHelper.trySubstituteParamAsInt(pp, paramIndices, paramSubst, substitutionMap, params.get(isDVersion ? 2 : 1));
        if (y < 0 || y + d > limit) {
            return null;
        }
        OCPreprocessingLexer.SubstitutionResult r = new OCPreprocessingLexer.SubstitutionResult();
        r.append(Integer.toString(Math.max(x - y, 0)));
        return r;
    }

    @Nullable
    private static OCPreprocessingLexer.SubstitutionResult tryFastAddD(@NotNull OCPreprocessingLexer pp, @NotNull List<String> params, @NotNull Map<String, Integer> paramIndices, @NotNull Map<String, String> paramSubst, @NotNull Map<String, String> substitutionMap, @NotNull String numSuffix) {
        return OCBoostPPHelper.tryFastAddInt(pp, params, paramIndices, paramSubst, substitutionMap, true);
    }

    @Nullable
    private static OCPreprocessingLexer.SubstitutionResult tryFastAdd(@NotNull OCPreprocessingLexer pp, @NotNull List<String> params, @NotNull Map<String, Integer> paramIndices, @NotNull Map<String, String> paramSubst, @NotNull Map<String, String> substitutionMap, @NotNull String numSuffix) {
        return OCBoostPPHelper.tryFastAddInt(pp, params, paramIndices, paramSubst, substitutionMap, false);
    }

    @Nullable
    private static OCPreprocessingLexer.SubstitutionResult tryFastAddInt(@NotNull OCPreprocessingLexer pp, @NotNull List<String> params, @NotNull Map<String, Integer> paramIndices, @NotNull Map<String, String> paramSubst, @NotNull Map<String, String> substitutionMap, boolean isDVersion) {
        int d;
        if (params.size() != (isDVersion ? 3 : 2)) {
            return null;
        }
        int limit = OCBoostPPHelper.tryParseAsBoostInt(pp.preprocess("BOOST_PP_LIMIT_MAG", OCPreprocessingLexer.PreprocessingMode.FIRST_MACRO_ARG));
        if (limit < 0) {
            return null;
        }
        int n = d = isDVersion ? OCBoostPPHelper.trySubstituteParamAsInt(pp, paramIndices, paramSubst, substitutionMap, params.get(0)) : 1;
        if (d < 1) {
            return null;
        }
        String xParam = params.get(isDVersion ? 1 : 0);
        int x = OCBoostPPHelper.trySubstituteParamAsInt(pp, paramIndices, paramSubst, substitutionMap, xParam);
        if (x < 0 || x > limit) {
            return null;
        }
        String yParam = params.get(isDVersion ? 2 : 1);
        int y = OCBoostPPHelper.trySubstituteParamAsInt(pp, paramIndices, paramSubst, substitutionMap, yParam);
        if (y < 0 || y + d > limit) {
            return null;
        }
        OCPreprocessingLexer.SubstitutionResult r = new OCPreprocessingLexer.SubstitutionResult();
        r.append(Integer.toString(Math.min(x + y, limit)));
        return r;
    }

    private static List<String> tryParseAsBoostTuple(String tupleText) {
        if (!(tupleText = tupleText.trim()).startsWith("(") || !tupleText.endsWith(")")) {
            return null;
        }
        return OCBoostPPHelper.tryParseAsBoostTupleContents(tupleText.substring(1, tupleText.length() - 1));
    }

    @Nullable
    private static List<String> tryParseAsBoostTupleContents(String tupleContents) {
        ArrayList<String> result2 = new ArrayList<String>();
        int parenDepth = 0;
        int elemStart = 0;
        for (int i2 = 0; i2 < tupleContents.length(); ++i2) {
            char c = tupleContents.charAt(i2);
            if (c == ',') {
                if (parenDepth != 0) continue;
                result2.add(tupleContents.substring(elemStart, i2).trim());
                elemStart = i2 + 1;
                continue;
            }
            if (c == '(') {
                ++parenDepth;
                continue;
            }
            if (c != ')') continue;
            if (parenDepth == 0) {
                return null;
            }
            --parenDepth;
        }
        result2.add(tupleContents.substring(elemStart).trim());
        return result2;
    }

    @Nullable
    private static List<String> tryParseAsBoostList(@NotNull String str) {
        ArrayList<String> result2 = new ArrayList<String>();
        if ("BOOST_PP_NIL".equals(str = str.trim())) {
            return Collections.emptyList();
        }
        int parenDepth = 0;
        int subseqStart = 0;
        boolean atElement = false;
        boolean hasNonWs = false;
        for (int i2 = 0; i2 < str.length(); ++i2) {
            char c = str.charAt(i2);
            if (c == '(') {
                if (parenDepth < result2.size()) {
                    return null;
                }
                if (parenDepth == result2.size()) {
                    if (hasNonWs) {
                        return null;
                    }
                    subseqStart = i2 + 1;
                    atElement = true;
                }
                ++parenDepth;
                continue;
            }
            if (c == ')') {
                if (parenDepth == 0) {
                    return null;
                }
                if (parenDepth == result2.size()) {
                    result2.add(str.substring(subseqStart, i2));
                }
                --parenDepth;
                continue;
            }
            if (c == ',') {
                if (!atElement) {
                    return null;
                }
                if (parenDepth != result2.size() + 1) continue;
                result2.add(str.substring(subseqStart, i2));
                subseqStart = i2 + 1;
                atElement = false;
                hasNonWs = false;
                continue;
            }
            if (Character.isWhitespace(c)) continue;
            if (parenDepth < result2.size()) {
                return null;
            }
            hasNonWs = true;
        }
        if (parenDepth != 0 || result2.isEmpty()) {
            return null;
        }
        String last = ((String)result2.remove(result2.size() - 1)).trim();
        return "BOOST_PP_NIL".equals(last) ? result2 : null;
    }

    private static List<String> tryParseAsBoostSequence(String seqString) {
        ArrayList<String> r = new ArrayList<String>();
        int inElem = 0;
        int elemStart = 0;
        seqString = seqString.trim();
        for (int i2 = 0; i2 < seqString.length(); ++i2) {
            char c = seqString.charAt(i2);
            if (c == '(') {
                if (inElem == 0) {
                    elemStart = i2 + 1;
                }
                ++inElem;
                continue;
            }
            if (c == ')') {
                if (inElem == 0) {
                    return null;
                }
                if (--inElem != 0) continue;
                r.add(seqString.substring(elemStart, i2));
                continue;
            }
            if (inElem != 0 || Character.isWhitespace(c)) continue;
            return null;
        }
        return r;
    }

    private static int trySubstituteParamAsInt(@NotNull OCPreprocessingLexer pp, @NotNull Map<String, Integer> paramIndices, @NotNull Map<String, String> paramSubst, @NotNull Map<String, String> substitutionMap, @NotNull String param) {
        String str = pp.substituteMacroParam(paramIndices, paramSubst, substitutionMap, param);
        return OCBoostPPHelper.tryParseAsBoostInt(str);
    }

    private static int tryParseAsBoostInt(String str) {
        if ((str = str.trim()).length() > 1 && str.startsWith("0")) {
            return -1;
        }
        return StringUtil.parseInt((String)str, (int)-1);
    }

    @FunctionalInterface
    static interface FastBoostEvaluator {
        public OCPreprocessingLexer.SubstitutionResult trySubstitute(@NotNull OCPreprocessingLexer var1, @NotNull List<String> var2, @NotNull Map<String, Integer> var3, @NotNull Map<String, String> var4, @NotNull Map<String, String> var5, @NotNull String var6);
    }
}

