/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.modulemap.serialization;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.modulemap.ModuleMapLog;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapManager;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapManagerImpl;
import com.jetbrains.cidr.lang.modulemap.serialization.DependencyInitializationSession;
import com.jetbrains.cidr.lang.modulemap.serialization.HeadersSearchRootRef;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleInfo;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapSerializationPack;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapSerializationServiceImpl;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleReference;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMap;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapCache;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapPack;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapSignature;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapSymbol;
import com.jetbrains.cidr.lang.modulemap.symbols.impl.ModuleMapSymbolImpl;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J \u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016J\u0018\u0010 \u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010\u00032\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00142\u0006\u0010#\u001a\u00020\u0013H\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010\u00102\u0006\u0010%\u001a\u00020&H\u0002J\b\u0010'\u001a\u00020\u0018H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/jetbrains/cidr/lang/modulemap/serialization/DependencyInitializationSessionImpl;", "Lcom/jetbrains/cidr/lang/modulemap/serialization/DependencyInitializationSession;", "deserializedPacks", "", "Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapSerializationPack;", "serializationService", "Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapSerializationServiceImpl;", "project", "Lcom/intellij/openapi/project/Project;", "(Ljava/util/List;Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapSerializationServiceImpl;Lcom/intellij/openapi/project/Project;)V", "moduleMapCache", "Lcom/jetbrains/cidr/lang/modulemap/symbols/ModuleMapCache;", "moduleMapManager", "Lcom/jetbrains/cidr/lang/modulemap/resolve/ModuleMapManagerImpl;", "moduleToSignature", "", "Lcom/jetbrains/cidr/lang/modulemap/symbols/ModuleMapSymbol;", "Lcom/jetbrains/cidr/lang/modulemap/symbols/ModuleMapSignature;", "refToPack", "Lcom/jetbrains/cidr/lang/modulemap/serialization/HeadersSearchRootRef;", "Lcom/jetbrains/cidr/lang/modulemap/symbols/ModuleMapPack;", "validPacks", "applyBundledPacksOnly", "applyDependencies", "", "pack", "info", "Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleInfo;", "applyHeaders", "rootBaseDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "applyValidPacks", "collectDependencies", "Lcom/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchRoot;", "findPack", "ref", "resolveReference", "reference", "Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleReference;", "setupModuleDependencies", "intellij.c"})
public final class DependencyInitializationSessionImpl
implements DependencyInitializationSession {
    private final ModuleMapCache moduleMapCache;
    private final ModuleMapManagerImpl moduleMapManager;
    private final Map<HeadersSearchRootRef, ModuleMapPack> refToPack;
    private final List<ModuleMapSerializationPack> validPacks;
    private final Map<ModuleMapSymbol, ModuleMapSignature> moduleToSignature;
    private final List<ModuleMapSerializationPack> deserializedPacks;
    private final ModuleMapSerializationServiceImpl serializationService;
    private final Project project;

    @Override
    @NotNull
    public List<ModuleMapSerializationPack> applyValidPacks() {
        for (ModuleMapSerializationPack pack : this.validPacks) {
            this.moduleMapCache.cacheOrGet(pack.getHeaderRoot(), (Function0<? extends ModuleMapPack>)((Function0)new Function0<ModuleMapPack>(pack){
                final /* synthetic */ ModuleMapSerializationPack $pack;

                @NotNull
                public final ModuleMapPack invoke() {
                    return this.$pack.getModuleMapPack();
                }
                {
                    this.$pack = moduleMapSerializationPack;
                    super(0);
                }
            }));
        }
        boolean result2 = this.setupModuleDependencies();
        if (!result2) {
            this.moduleMapCache.reset();
            this.moduleMapManager.clearCache();
            return this.applyBundledPacksOnly();
        }
        return this.validPacks;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ModuleMapSerializationPack> applyBundledPacksOnly() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.validPacks;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ModuleMapSerializationPack it = (ModuleMapSerializationPack)element$iv$iv;
            boolean bl = false;
            if (!it.isBundled()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List bundledPacks = (List)destination$iv$iv;
        if (bundledPacks.size() == this.validPacks.size()) {
            return CollectionsKt.emptyList();
        }
        DependencyInitializationSessionImpl fallbackSession = new DependencyInitializationSessionImpl(bundledPacks, this.serializationService, this.project);
        return fallbackSession.applyValidPacks();
    }

    private final boolean setupModuleDependencies() {
        for (ModuleMapSerializationPack pack : this.validPacks) {
            VirtualFile rootBaseDirectory = this.serializationService.getRootBaseDirectory(pack.getHeaderRoot());
            if (rootBaseDirectory == null) {
                ModuleMapLog.LOG.error("Root Base Directory is null for valid pack " + (Object)((Object)pack.getHeaderRoot()));
                return false;
            }
            for (ModuleInfo info : pack.getModuleInfos()) {
                boolean result2 = this.applyHeaders(pack, rootBaseDirectory, info) && this.applyDependencies(pack, info);
                if (result2) continue;
                return false;
            }
        }
        return true;
    }

    private final boolean applyDependencies(ModuleMapSerializationPack pack, ModuleInfo info) {
        boolean bl = false;
        List dependencies = new ArrayList();
        for (ModuleReference reference : info.getDependencies()) {
            ModuleMapSymbol dependencyModule = this.resolveReference(reference);
            if (dependencyModule == null) {
                boolean $i$f$runReadAction;
                if (pack.isBundled()) {
                    $i$f$runReadAction = false;
                    ApplicationManager.getApplication().runReadAction(new Computable<T>(reference, pack){
                        final /* synthetic */ ModuleReference $reference$inlined;
                        final /* synthetic */ ModuleMapSerializationPack $pack$inlined;
                        {
                            this.$reference$inlined = moduleReference;
                            this.$pack$inlined = moduleMapSerializationPack;
                        }

                        public final T compute() {
                            boolean bl = false;
                            ModuleMapLog.LOG.warn("broken reference " + this.$reference$inlined + " for " + (Object)((Object)this.$pack$inlined.getHeaderRoot()));
                            return (T)Unit.INSTANCE;
                        }
                    });
                    continue;
                }
                $i$f$runReadAction = false;
                ApplicationManager.getApplication().runReadAction(new Computable<T>(reference, pack){
                    final /* synthetic */ ModuleReference $reference$inlined;
                    final /* synthetic */ ModuleMapSerializationPack $pack$inlined;
                    {
                        this.$reference$inlined = moduleReference;
                        this.$pack$inlined = moduleMapSerializationPack;
                    }

                    public final T compute() {
                        boolean bl = false;
                        ModuleMapLog.LOG.error("broken reference " + this.$reference$inlined + " for " + (Object)((Object)this.$pack$inlined.getHeaderRoot()));
                        return (T)Unit.INSTANCE;
                    }
                });
                return false;
            }
            Collection collection = dependencies;
            boolean bl2 = false;
            collection.add(dependencyModule);
        }
        ModuleMapSymbol moduleMapSymbol = info.getModule();
        if (moduleMapSymbol == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.cidr.lang.modulemap.symbols.impl.ModuleMapSymbolImpl");
        }
        ((ModuleMapSymbolImpl)moduleMapSymbol).setDependencies(dependencies);
        return true;
    }

    private final ModuleMapSymbol resolveReference(ModuleReference reference) {
        ModuleMapPack moduleMapPack = this.findPack(reference.getHeaderSearchRootRef());
        if (moduleMapPack == null) {
            return null;
        }
        ModuleMapPack pack = moduleMapPack;
        List<ModuleMap> list = pack.getModuleMapsUnsafe();
        if (list.size() <= reference.getMapIndex()) {
            return null;
        }
        ModuleMap map2 = list.get(reference.getMapIndex());
        return map2.findModule(reference.getQualifiedName());
    }

    private final ModuleMapPack findPack(HeadersSearchRootRef ref) {
        return this.refToPack.get(ref);
    }

    private final boolean applyHeaders(ModuleMapSerializationPack pack, VirtualFile rootBaseDirectory, ModuleInfo info) {
        ModuleMapSymbol module2;
        boolean bl = false;
        List headers = new ArrayList();
        for (String relativePath : info.getHeaders()) {
            VirtualFile header = rootBaseDirectory.findFileByRelativePath(relativePath);
            if (header == null) {
                if (pack.isBundled()) {
                    ModuleMapLog.LOG.warn("Missing file " + relativePath + " in base directory: " + rootBaseDirectory.getCanonicalPath());
                    continue;
                }
                ModuleMapLog.LOG.error("Missing file " + relativePath + " in base directory: " + rootBaseDirectory.getCanonicalPath());
                return false;
            }
            Collection collection = headers;
            boolean bl2 = false;
            collection.add(header);
        }
        ModuleMapSymbol moduleMapSymbol = module2 = info.getModule();
        if (moduleMapSymbol == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.cidr.lang.modulemap.symbols.impl.ModuleMapSymbolImpl");
        }
        ((ModuleMapSymbolImpl)moduleMapSymbol).setIncludeHeaders(headers);
        ModuleMapSignature signature = (ModuleMapSignature)MapsKt.getValue(this.moduleToSignature, (Object)module2);
        this.moduleMapManager.addHeaders(module2, signature, headers);
        return true;
    }

    private final List<HeadersSearchRoot> collectDependencies(ModuleMapSerializationPack pack) {
        boolean bl = false;
        List result2 = new ArrayList();
        List<HeadersSearchRootRef> dependencies = pack.getHeaderSearchRootDependencies();
        for (HeadersSearchRootRef dependencyRef : dependencies) {
            ModuleMapPack dependency = this.findPack(dependencyRef);
            if (dependency == null) {
                boolean $i$f$runReadAction;
                if (pack.isBundled()) {
                    $i$f$runReadAction = false;
                    ApplicationManager.getApplication().runReadAction(new Computable<T>(dependencyRef, pack){
                        final /* synthetic */ HeadersSearchRootRef $dependencyRef$inlined;
                        final /* synthetic */ ModuleMapSerializationPack $pack$inlined;
                        {
                            this.$dependencyRef$inlined = headersSearchRootRef;
                            this.$pack$inlined = moduleMapSerializationPack;
                        }

                        public final T compute() {
                            boolean bl = false;
                            ModuleMapLog.LOG.warn("Missing dependency: " + this.$dependencyRef$inlined + " of root " + (Object)((Object)this.$pack$inlined.getHeaderRoot()));
                            return (T)Unit.INSTANCE;
                        }
                    });
                    continue;
                }
                if (ModuleMapLog.LOG.isTraceEnabled()) {
                    $i$f$runReadAction = false;
                    ApplicationManager.getApplication().runReadAction(new Computable<T>(dependencyRef, pack){
                        final /* synthetic */ HeadersSearchRootRef $dependencyRef$inlined;
                        final /* synthetic */ ModuleMapSerializationPack $pack$inlined;
                        {
                            this.$dependencyRef$inlined = headersSearchRootRef;
                            this.$pack$inlined = moduleMapSerializationPack;
                        }

                        public final T compute() {
                            boolean bl = false;
                            ModuleMapLog.LOG.trace("Missing dependency: " + this.$dependencyRef$inlined + " of root " + (Object)((Object)this.$pack$inlined.getHeaderRoot()));
                            return (T)Unit.INSTANCE;
                        }
                    });
                }
                return null;
            }
            result2.add(dependency.getHeaderRoot());
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    public DependencyInitializationSessionImpl(@NotNull List<ModuleMapSerializationPack> deserializedPacks, @NotNull ModuleMapSerializationServiceImpl serializationService, @NotNull Project project2) {
        List list;
        Object id;
        DependencyInitializationSessionImpl $this$run;
        this.deserializedPacks = deserializedPacks;
        this.serializationService = serializationService;
        this.project = project2;
        this.moduleMapCache = ModuleMapCache.Companion.getInstance(this.project);
        ModuleMapManager moduleMapManager = ModuleMapManager.Companion.getInstance(this.project);
        if (moduleMapManager == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapManagerImpl");
        }
        this.moduleMapManager = (ModuleMapManagerImpl)moduleMapManager;
        DependencyInitializationSessionImpl dependencyInitializationSessionImpl = this;
        boolean bl = false;
        boolean bl2 = false;
        DependencyInitializationSessionImpl dependencyInitializationSessionImpl2 = dependencyInitializationSessionImpl;
        DependencyInitializationSessionImpl dependencyInitializationSessionImpl3 = this;
        boolean bl3 = false;
        boolean bl4 = false;
        Map result22 = new LinkedHashMap();
        for (ModuleMapSerializationPack pack : $this$run.deserializedPacks) {
            id = $this$run.serializationService.getRootID(pack.getHeaderRoot());
            if (id == null) {
                ModuleMapLog.LOG.error("Invalid ID for valid root: " + (Object)((Object)pack.getHeaderRoot()));
                continue;
            }
            HeadersSearchRootRef ref = new HeadersSearchRootRef((String)id, pack.getHash());
            result22.put(ref, pack.getModuleMapPack());
        }
        Object object = result22;
        dependencyInitializationSessionImpl3.refToPack = object;
        dependencyInitializationSessionImpl = this;
        bl = false;
        bl2 = false;
        $this$run = dependencyInitializationSessionImpl;
        dependencyInitializationSessionImpl3 = this;
        boolean bl5 = false;
        MultiMap rootToDependentRootMap22 = new MultiMap();
        boolean result22 = false;
        Set dirtyRoots = new LinkedHashSet();
        for (ModuleMapSerializationPack pack : $this$run.deserializedPacks) {
            List<HeadersSearchRoot> dependencies = $this$run.collectDependencies(pack);
            if (dependencies != null) {
                for (HeadersSearchRoot dependency : dependencies) {
                    rootToDependentRootMap22.putValue((Object)dependency, (Object)pack.getHeaderRoot());
                }
                continue;
            }
            dirtyRoots.add(pack.getHeaderRoot());
        }
        if (dirtyRoots.isEmpty()) {
            list = $this$run.deserializedPacks;
        } else {
            void $this$filterNotTo$iv$iv;
            Object root;
            ArrayDeque<Iterable> workset = new ArrayDeque<Iterable>(dirtyRoots);
            block3: while (true) {
                id = workset;
                boolean dependencies = false;
                if (!(!id.isEmpty())) break;
                HeadersSearchRoot dirtyRoot = (HeadersSearchRoot)((Object)workset.pop());
                Collection dependentRoots = rootToDependentRootMap22.get((Object)dirtyRoot);
                Iterator<Object> iterator2 = dependentRoots.iterator();
                while (true) {
                    if (!iterator2.hasNext()) continue block3;
                    root = iterator2.next();
                    if (!dirtyRoots.add(root)) continue;
                    workset.add((Iterable)root);
                }
                break;
            }
            Iterable $this$filterNot$iv = $this$run.deserializedPacks;
            boolean $i$f$filterNot = false;
            root = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                ModuleMapSerializationPack pack = (ModuleMapSerializationPack)element$iv$iv;
                boolean bl6 = false;
                if (dirtyRoots.contains((Object)pack.getHeaderRoot())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        dependencyInitializationSessionImpl3.validPacks = object = list;
        dependencyInitializationSessionImpl = this;
        bl = false;
        bl2 = false;
        $this$run = dependencyInitializationSessionImpl;
        dependencyInitializationSessionImpl3 = this;
        boolean bl7 = false;
        boolean rootToDependentRootMap22 = false;
        Map result3 = new LinkedHashMap();
        for (ModuleMapSerializationPack pack : $this$run.validPacks) {
            for (ModuleMap moduleMap : pack.getModuleMapPack().getModuleMapsUnsafe()) {
                for (ModuleMapSymbol module2 : moduleMap.getModules()) {
                    result3.put(module2, moduleMap.getSignature());
                }
            }
        }
        dependencyInitializationSessionImpl3.moduleToSignature = object = result3;
    }
}

