/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.light.psi;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.PsiPlainTextFileImpl;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCLightFileViewProvider
extends MultiplePsiFilesPerDocumentFileViewProvider {
    private static final Set<Language> ourLanguages = ContainerUtil.immutableSet((Object[])new Language[]{OCLanguageUtils.getLightLanguage(), OCLanguageUtils.getSlowLanguage()});

    public OCLightFileViewProvider(@NotNull PsiManager manager2, @NotNull VirtualFile virtualFile, boolean eventSystemEnabled) {
        super(manager2, virtualFile, eventSystemEnabled);
    }

    @NotNull
    public Set<Language> getLanguages() {
        return ourLanguages;
    }

    @NotNull
    public Language getBaseLanguage() {
        return OCLanguageUtils.getLightLanguage();
    }

    @Nullable
    protected PsiFileImpl createPsiFileImpl(@NotNull Language language) {
        FileType type = this.getFileType();
        return (PsiFileImpl)this.createFile(this.getVirtualFile(), type, language);
    }

    @Nullable
    protected PsiFile createFile(@NotNull Language lang) {
        if (!this.hasLanguage(lang)) {
            return null;
        }
        if (this.getManager().getProject().getUserData(OCLanguage.LANGUAGE_SUPPORT_DISABLED) == Boolean.TRUE) {
            return new PsiPlainTextFileImpl((FileViewProvider)this);
        }
        ParserDefinition parser = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        if (parser == null) {
            return null;
        }
        return parser.createFile((FileViewProvider)this);
    }

    @Nullable
    public PsiElement findElementAt(int offset) {
        return OCLightFileViewProvider.findElementAt((PsiElement)this.getPsi(OCLanguageUtils.getLightLanguage()), (int)offset);
    }

    @NotNull
    protected MultiplePsiFilesPerDocumentFileViewProvider cloneInner(@NotNull VirtualFile fileCopy) {
        return new OCLightFileViewProvider((PsiManager)this.getManager(), fileCopy, false);
    }
}

