/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.lexer;

import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerBase;
import com.intellij.lexer.StringLiteralLexer;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.lexer.OCLexerSettings;
import com.jetbrains.cidr.lang.lexer.OCLexerWithDirectives;
import com.jetbrains.cidr.lang.lexer.OCPrefixStringLiteralLexer;
import com.jetbrains.cidr.lang.lexer.OCRawStringLexerBase;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class OCHighlightingLexer
extends OCLexerWithDirectives {
    public static final IElementType PREFIX_TYPE = OCTokenTypes.AT;
    public static final char STRING_START = '\"';
    public static final char CHAR_START = '\'';

    @Contract(value="_, _ -> !null")
    public static StringLiteralLexer createStringLiteralLexer(char quoteChar, IElementType originalLiteralToken) {
        return new StringLiteralLexer(quoteChar, originalLiteralToken, false, "\\?\\a\\b\\v", true, true);
    }

    @Contract(value=" -> !null")
    public static OCRawStringLexerBase createRawStringLexer() {
        return new OCRawStringLexerBase(StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN, OCTokenTypes.STRING_LITERAL);
    }

    public OCHighlightingLexer(@NotNull OCLexerSettings settings) {
        super(settings);
        OCPrefixStringLiteralLexer stringLiteralLexer = new OCPrefixStringLiteralLexer('\"', PREFIX_TYPE, (LexerBase)OCHighlightingLexer.createStringLiteralLexer('\"', OCTokenTypes.STRING_LITERAL));
        this.registerSelfStoppingLayer((Lexer)stringLiteralLexer, new IElementType[]{OCTokenTypes.STRING_LITERAL}, IElementType.EMPTY_ARRAY);
        OCPrefixStringLiteralLexer charLiteralLexer = new OCPrefixStringLiteralLexer('\'', PREFIX_TYPE, (LexerBase)OCHighlightingLexer.createStringLiteralLexer('\'', OCTokenTypes.CHARACTER_LITERAL));
        this.registerSelfStoppingLayer((Lexer)charLiteralLexer, new IElementType[]{OCTokenTypes.CHARACTER_LITERAL}, IElementType.EMPTY_ARRAY);
        OCPrefixStringLiteralLexer rawStringLiteralLexer = new OCPrefixStringLiteralLexer('\"', PREFIX_TYPE, OCHighlightingLexer.createRawStringLexer());
        this.registerSelfStoppingLayer((Lexer)rawStringLiteralLexer, new IElementType[]{OCTokenTypes.RAW_STRING_LITERAL, OCTokenTypes.WRONG_RAW_STRING_LITERAL}, IElementType.EMPTY_ARRAY);
    }
}

