/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.lexer;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.lexer.OCLexer;
import com.jetbrains.cidr.lang.lexer.OCLexerSettings;
import com.jetbrains.cidr.lang.parser.OCParsing;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.symbols.symtable.FileContentSnapshot;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCHeaderGuardDetector {
    private static final Key<Info> CACHE = Key.create((String)"OCHeaderGuardDetector cache");

    @Nullable
    public static String getHeaderGuard(@NotNull Project project2, @NotNull VirtualFile file2) {
        Info result2 = (Info)CACHE.get((UserDataHolder)file2);
        if (result2 == null || !result2.stamp.isUpToDate(project2, file2)) {
            FileContentSnapshot snapshot = FileContentSnapshot.get(file2, project2);
            CharSequence text = snapshot.getText();
            String guard = OCHeaderGuardDetector.detectHeaderGuard(text);
            result2 = new Info(guard, snapshot.getStamp());
            CACHE.set((UserDataHolder)file2, (Object)result2);
        }
        return result2.guard;
    }

    @Nullable
    public static String detectHeaderGuard(@NotNull CharSequence text) {
        OCLexerSettings lexerSettings = OCLexerSettings.forPreprocessor().build();
        OCLexer lexer = new OCLexer(lexerSettings);
        lexer.start(text);
        OCHeaderGuardDetector.skipWhitespacesAndDirectiveBodies(lexer);
        IElementType it = lexer.getTokenType();
        if (OCTokenTypes.IFNDEF_DIRECTIVE != it) {
            return null;
        }
        lexer.advance();
        IElementType ct = lexer.getTokenType();
        if (OCTokenTypes.DIRECTIVE_CONTENT != ct) {
            return null;
        }
        String content = lexer.getTokenText();
        lexer.advance();
        OCHeaderGuardDetector.skipWhitespacesAndDirectiveBodies(lexer);
        String headerGuard = OCHeaderGuardDetector.readHeaderGuard(content, lexerSettings);
        if (headerGuard == null) {
            return null;
        }
        int directiveDepth = 1;
        while (directiveDepth > 0) {
            IElementType tt = lexer.getTokenType();
            if (tt == null) {
                return null;
            }
            if (OCTokenTypes.IF_DIRECTIVES.contains(tt)) {
                ++directiveDepth;
            } else if (OCTokenTypes.ENDIF_DIRECTIVE == tt) {
                --directiveDepth;
            } else if (OCTokenTypes.END_IF_DIRECTIVES.contains(tt) && directiveDepth == 1) {
                return null;
            }
            lexer.advance();
        }
        OCHeaderGuardDetector.skipWhitespacesAndDirectiveBodies(lexer);
        return lexer.getTokenType() == null ? headerGuard : null;
    }

    private static void skipWhitespacesAndDirectiveBodies(OCLexer lexer) {
        while (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(lexer.getTokenType()) || OCParsing.isEndOfDirective(lexer.getTokenType())) {
            lexer.advance();
        }
    }

    @Nullable
    private static String readHeaderGuard(String content, OCLexerSettings settings) {
        OCLexer lexer = new OCLexer(settings);
        lexer.start(content);
        OCHeaderGuardDetector.skipWhitespacesAndDirectiveBodies(lexer);
        IElementType tt = lexer.getTokenType();
        if (OCTokenTypes.IDENTIFIER != tt) {
            return null;
        }
        String headerGuard = lexer.getTokenText();
        lexer.advance();
        OCHeaderGuardDetector.skipWhitespacesAndDirectiveBodies(lexer);
        return lexer.getTokenType() != null ? null : headerGuard;
    }

    static class Info {
        @Nullable
        final String guard;
        final FileContentSnapshot.Stamp stamp;

        Info(@Nullable String guard, @NotNull FileContentSnapshot.Stamp stamp) {
            this.guard = guard;
            this.stamp = stamp;
        }
    }
}

