/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.legacy.types.visitors;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.legacy.types.OCTypeCheckResult;
import com.jetbrains.cidr.lang.legacy.types.OCTypeCheckResultBuilder;
import com.jetbrains.cidr.lang.legacy.types.visitors.OCTypeCompatibilityVisitor;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.quickfixes.OCSetSuperclassIntentionAction;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCTollFreeBridges;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeCheckState;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityVisitor;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OCTypeCompatibilityVisitor_OCStructType
extends OCTypeCompatibilityVisitor<OCStructType> {
    protected OCTypeCompatibilityVisitor_OCStructType(@NotNull OCStructType sourceType, @Nullable OCTypeOwner source, @Nullable PsiElement context2, boolean allowImplicitConversions, boolean assumeNullSubstitutionsEquals, @NotNull OCResolveContext resolveContext) {
        super(sourceType, source, context2, allowImplicitConversions, assumeNullSubstitutionsEquals, resolveContext);
    }

    @Override
    public OCTypeCheckResult visitFunctionType(final OCFunctionType type) {
        if (((OCStructType)this.mySourceType).isIntegerCompatible(this.myResolveContext, false)) {
            String message = "Taking pointer from integer without a cast";
            return new OCTypeCheckResult(OCTypeCheckState.ERROR_IF_CPP, "Taking pointer from integer without a cast", OCInspections.ImplicitPointerAndIntegerConversion.class, "ext_typecheck_convert_int_pointer", new IntentionAction[0]);
        }
        if (((OCStructType)this.mySourceType).getKind() == OCSymbolKind.ENUM && !((OCStructType)this.mySourceType).isEnumClass()) {
            return new OCTypeCheckResult(OCTypeCheckState.WARNING, OCInspections.ImplicitIntegerAndEnumConversion.class, "CIDR", new IntentionAction[0]){

                @Override
                public String getMessage() {
                    return "Taking integer from enum type '" + OCTypeCompatibilityVisitor_OCStructType.this.getSourceTypeName() + "'";
                }
            };
        }
        if (((OCStructType)this.mySourceType).isPointerCompatible(this.myResolveContext, false)) {
            return new OCTypeCheckResult(OCTypeCheckState.ERROR_IF_CPP, OCInspections.IncompatiblePointers.class, "ext_typecheck_convert_incompatible_pointer", new IntentionAction[0]){

                @Override
                public String getMessage() {
                    return "Incompatible pointer types '" + type.getName(OCTypeCompatibilityVisitor_OCStructType.this.myResolveContext) + "' and '" + OCTypeCompatibilityVisitor_OCStructType.this.getSourceTypeName() + "'";
                }
            };
        }
        return this.visitType(type);
    }

    @Override
    public OCTypeCheckResult visitObjectType(OCObjectType type) {
        return this.visitType(type);
    }

    @Override
    public OCTypeCheckResult visitPointerType(final OCPointerType type) {
        OCTypeCheckResult result2;
        OCType lTerminalType = type.getTerminalType();
        if (((OCStructType)this.mySourceType).isPointerCompatible(this.myResolveContext, false) && !lTerminalType.isUnknown() && type.isPointerToPointerToObjectCompatible() ^ ((OCStructType)this.mySourceType).isPointerToPointerToObjectCompatible() && OCCompilerFeaturesHelper.isArcEnabled(this.myContext.getContainingFile()) && (result2 = this.checkArcBridgeCast(type, false)) != null) {
            return result2;
        }
        boolean isCpp = this.myResolveContext.isCpp();
        if (((OCStructType)this.mySourceType).isIntegerCompatible(this.myResolveContext, false)) {
            return new OCTypeCheckResult(OCTypeCheckState.ERROR_IF_CPP, "Taking pointer from integer without a cast", OCInspections.ImplicitPointerAndIntegerConversion.class, "ext_typecheck_convert_int_pointer", new IntentionAction[0]);
        }
        if (type.isPointerToVoid() && ((OCStructType)this.mySourceType).isPointerCompatible(this.myResolveContext, this.myAllowImplicitConversions) && !isCpp) {
            return OCTypeCheckResultBuilder.createOK();
        }
        if (((OCStructType)this.mySourceType).isPointerCompatible(this.myResolveContext, false)) {
            return new OCTypeCheckResult(OCTypeCheckState.ERROR_IF_CPP, OCInspections.IncompatiblePointers.class, "ext_typecheck_convert_incompatible_pointer", new IntentionAction[0]){

                @Override
                public String getMessage() {
                    return "Incompatible pointer types '" + type.getName(OCTypeCompatibilityVisitor_OCStructType.this.myResolveContext) + "' and '" + OCTypeCompatibilityVisitor_OCStructType.this.getSourceTypeName() + "'";
                }
            };
        }
        return this.visitType(type);
    }

    @Override
    protected OCTypeCheckResult checkRefType(OCCppReferenceType type) {
        OCTypeCheckResult result2 = super.checkRefType(type);
        if (this.myContext instanceof OCCastExpression && result2.getState().isError(this.myContext) && this.isCppClassType(type.getTerminalType()) && ((OCFile)this.myContext.getContainingFile()).isCpp() && ((OCStructType)this.mySourceType).getKind() == OCSymbolKind.STRUCT) {
            result2.setState(OCTypeCheckState.WARNING);
        }
        return result2;
    }

    @Override
    public OCTypeCheckResult visitStructType(final OCStructType type) {
        OCFunctionDefinition declaringFun;
        if (OCTollFreeBridges.isCompatible(this.mySourceType, type)) {
            return OCTypeCheckResultBuilder.createOK();
        }
        if (type.getKind() == OCSymbolKind.ENUM) {
            if (((OCStructType)this.mySourceType).getKind() == OCSymbolKind.ENUM) {
                if (((OCStructType)this.mySourceType).equals(type, false, this.myResolveContext)) {
                    return OCTypeCheckResultBuilder.createOK();
                }
                return new OCTypeCheckResult(OCTypeCheckState.ERROR_IF_CPP, OCInspections.IncompatibleEnums.class, "warn_impcast_different_enum_types", new IntentionAction[0]){

                    @Override
                    public String getMessage() {
                        return "Incompatible enum types '" + type.getBestNameInContext(OCTypeCompatibilityVisitor_OCStructType.this.myResolveContext) + "' and '" + OCTypeCompatibilityVisitor_OCStructType.this.getSourceTypeName() + "'";
                    }
                };
            }
            Computable message = null;
            if (((OCStructType)this.mySourceType).isIntegerCompatible(this.myResolveContext, false)) {
                message = () -> "Taking enum type '" + type.getBestNameInContext(this.myResolveContext) + "' from integer";
            } else if (!type.isEnumClass() && ((OCStructType)this.mySourceType).isPointerCompatible(this.myResolveContext, false)) {
                message = () -> "Taking enum type '" + type.getBestNameInContext(this.myResolveContext) + "' from pointer";
            }
            if (message != null) {
                return this.checkAssignToEnum(type, (Computable<String>)message);
            }
        }
        OCFunctionSymbol declaringSymbol = (declaringFun = (OCFunctionDefinition)PsiTreeUtil.getParentOfType((PsiElement)this.myContext, OCFunctionDefinition.class)) != null ? declaringFun.getSymbol() : null;
        boolean isFunctionReturnTypeContext = this.myContext.getParent() instanceof OCFunctionDeclaration && ((OCFunctionDeclaration)this.myContext.getParent()).getReturnTypeElement() == this.myContext;
        for (final OCStructSymbol struct : type.getStructs()) {
            OCTypeCheckResult result2 = this.processTransparentUnion(struct, type);
            if (result2 != null) {
                return result2;
            }
            if (this.myIsSecondStepOfCopyInit) {
                if (new OCTypeEqualityVisitor(type, true, true, this.myResolveContext).equal(this.mySourceType)) {
                    return OCTypeCheckResultBuilder.createOK();
                }
            } else if (this.myAllowImplicitConversions) {
                result2 = OCTypeCompatibilityVisitor_OCStructType.processConstructors(struct, this.mySourceType, this.mySource, this.myContext, this.myResolveContext, this.myIsCopyInitWithSameClass);
            }
            if (((OCFile)this.myContext.getContainingFile()).isCpp() && ((OCStructType)this.mySourceType).getKind() == OCSymbolKind.STRUCT && this.isCppClassType(type)) {
                boolean isInsideClass = declaringSymbol != null && declaringSymbol.getResolvedOwner(this.myResolveContext) instanceof OCStructSymbol && struct.isAncestor((OCStructSymbol)declaringSymbol.getResolvedOwner(this.myResolveContext), this.myResolveContext);
                for (final OCStructSymbol symbol : ((OCStructType)this.mySourceType).getStructs()) {
                    final Ref visibilityRef = new Ref();
                    if (!symbol.processAllBaseClasses(OCResolveContext.forPsi(this.myContext), (baseSymbol, visibility) -> {
                        if (baseSymbol instanceof OCStructSymbol && ((OCStructSymbol)baseSymbol).resolvedNamesEqual(this.myResolveContext.getProject(), struct) || baseSymbol instanceof OCTypeParameterSymbol) {
                            visibilityRef.set((Object)visibility);
                            return false;
                        }
                        return true;
                    }, isInsideClass)) {
                        if (!isFunctionReturnTypeContext && (!isInsideClass && visibilityRef.get() != OCVisibility.PUBLIC || visibilityRef.get() == OCVisibility.PRIVATE)) {
                            if (result2 == null) {
                                result2 = new OCTypeCheckResult(OCTypeCheckState.ERROR, OCInspections.MemberVisibility.class, "err_typecheck_convert_incompatible", new IntentionAction[]{new OCSetSuperclassIntentionAction(symbol, struct, OCVisibility.PUBLIC, this.myResolveContext), this.getNewConstructorFix(struct)}){

                                    @Override
                                    public String getMessage() {
                                        return struct.getKindUppercase(OCTypeCompatibilityVisitor_OCStructType.this.myResolveContext) + " '" + type.getBestNameInContext(OCTypeCompatibilityVisitor_OCStructType.this.myResolveContext) + "' is a " + visibilityRef.toString() + " base class of " + symbol.getKindLowercase(OCTypeCompatibilityVisitor_OCStructType.this.myResolveContext) + " '" + OCTypeCompatibilityVisitor_OCStructType.this.getSourceTypeName() + "'";
                                    }
                                };
                            }
                        } else {
                            return result2 != null ? result2 : OCTypeCheckResultBuilder.createOK();
                        }
                    }
                    if (result2 != null) continue;
                    result2 = new OCTypeCheckResult(OCTypeCheckState.ERROR, OCInspections.NotSuperclass.class, "err_ovl_no_viable_oper", new IntentionAction[]{new OCSetSuperclassIntentionAction(symbol, struct, OCVisibility.PUBLIC, this.myResolveContext), this.getNewConstructorFix(struct)}){

                        @Override
                        public String getMessage() {
                            return symbol.getKindUppercase(OCTypeCompatibilityVisitor_OCStructType.this.myResolveContext) + " '" + OCTypeCompatibilityVisitor_OCStructType.this.getSourceTypeName() + "' is not compatible with " + struct.getKindLowercase(OCTypeCompatibilityVisitor_OCStructType.this.myResolveContext) + " '" + type.getBestNameInContext(OCTypeCompatibilityVisitor_OCStructType.this.myResolveContext) + "'";
                        }
                    };
                }
            }
            if (result2 == null) continue;
            return result2;
        }
        OCTypeCheckResult result3 = this.visitType(type);
        if (!result3.getState().isOK() && this.isCppClassType(type)) {
            result3.addQuickFix(this.getNewConstructorFix(type.getSymbol()));
        }
        return result3;
    }
}

