/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.generate.actions.OCCppActionContext;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateConstructorContext;
import com.jetbrains.cidr.lang.generate.handlers.OCClassActionHandlerBase;
import com.jetbrains.cidr.lang.generate.handlers.OCGenerateConstructorHandler;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCConstructorFieldInitializer;
import com.jetbrains.cidr.lang.psi.OCConstructorInitializationList;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.quickfixes.OCAddFieldInitializerFix;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureActionHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCParameterInfo;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCAddParametersToConstructorIntentionAction
extends OCClassActionHandlerBase<OCStructSymbol, OCFunctionSymbol, OCCppActionContext<OCStructSymbol, OCFunctionSymbol>>
implements IntentionAction {
    @NotNull
    public String getText() {
        return OCBundle.message("intentions.add.parameters.to.constructor", "");
    }

    @Override
    @NotNull
    protected String getActionTitle() {
        return "Add Parameter to Constructor";
    }

    @Override
    protected String getMembersChooserTitle() {
        return "Select Constructor to Update";
    }

    @Override
    protected Class<? extends OCSymbolDeclarator> getParentClass() {
        return OCStruct.class;
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (!FileSymbolTablesCache.areSymbolsLoaded(project2)) {
            return false;
        }
        return file2 instanceof OCFile && ((OCFile)file2).isCpp() && this.getField(editor, file2) != null;
    }

    @Nullable
    protected OCDeclaratorSymbol getField(Editor editor, PsiFile file2) {
        OCDeclaration declaration;
        PsiElement element = file2.findElementAt(editor.getCaretModel().getOffset());
        OCDeclarator declarator = OCElementUtil.getAdjacentParentOfType(element, OCDeclarator.class);
        if (declarator == null && (declaration = (OCDeclaration)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{OCDeclaration.class})) != null && declaration.getDeclarators().size() > 0) {
            declarator = declaration.getDeclarators().get(0);
        }
        if (declarator == null) {
            return null;
        }
        OCSymbol symbol = declarator.getSymbol();
        if (symbol instanceof OCDeclaratorSymbol && symbol.getKind() == OCSymbolKind.STRUCT_FIELD) {
            OCDeclaratorSymbol declaratorSymbol = (OCDeclaratorSymbol)symbol;
            if (declaratorSymbol.isStatic()) {
                return null;
            }
            return declaratorSymbol;
        }
        return null;
    }

    @Override
    protected boolean enableChooseDialog(Collection<OCFunctionSymbol> candidates) {
        return candidates.size() > 1;
    }

    @Override
    protected boolean allowMultiSelection(OCCppActionContext<OCStructSymbol, OCFunctionSymbol> context2) {
        return false;
    }

    @Override
    protected boolean allowEmptySelection(OCCppActionContext<OCStructSymbol, OCFunctionSymbol> context2) {
        return true;
    }

    @Override
    @Nullable
    protected OCCppActionContext<OCStructSymbol, OCFunctionSymbol> evaluateActionContext(final Project project2, @Nullable Editor editor, @NotNull PsiFile file2) {
        final OCStructSymbol parent = (OCStructSymbol)this.getParent(project2, editor, file2);
        final OCDeclaratorSymbol field = this.getField(editor, file2);
        if (parent == null || field == null) {
            return null;
        }
        return new OCCppActionContext<OCStructSymbol, OCFunctionSymbol>(parent, field.locateDefinition(project2)){

            @Override
            @NotNull
            public Collection<OCFunctionSymbol> getMemberCandidates() {
                CommonProcessors.CollectProcessor<OCFunctionSymbol> collector = new CommonProcessors.CollectProcessor<OCFunctionSymbol>(){

                    protected boolean accept(OCFunctionSymbol constructor) {
                        OCConstructorInitializationList initializationList;
                        if ((constructor = (OCFunctionSymbol)constructor.getDefinitionSymbol(project2)) == null) {
                            return false;
                        }
                        OCFunctionDefinition function = (OCFunctionDefinition)constructor.locateFunctionDefinition(project2);
                        OCConstructorInitializationList oCConstructorInitializationList = initializationList = function != null ? function.getConstructorInitializationList() : null;
                        if (initializationList != null) {
                            for (OCConstructorFieldInitializer initializer : initializationList.getInitializers()) {
                                OCReferenceElement referenceElement = initializer.getReferenceElement();
                                OCSymbol symbol = referenceElement != null ? referenceElement.resolveToSymbol() : null;
                                if (!field.equals(symbol)) continue;
                                return false;
                            }
                        }
                        return true;
                    }
                };
                parent.processConstructors((Processor<? super OCFunctionSymbol>)collector);
                return collector.getResults();
            }
        };
    }

    @Override
    @Nullable
    protected OCCppActionContext<OCStructSymbol, OCFunctionSymbol> evaluateActionContext(OCStructSymbol parent, @NotNull PsiElement element) {
        return null;
    }

    @Override
    protected void performAction(@NotNull Project project2, Editor editor, @NotNull PsiFile file2, final @NotNull OCCppActionContext<OCStructSymbol, OCFunctionSymbol> context2, @NotNull List<OCFunctionSymbol> chosenCandidates) {
        OCFunctionDefinition constructor;
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        final OCDeclaratorSymbol field = this.getField(editor, file2);
        if (field == null) {
            return;
        }
        if (chosenCandidates.size() == 0) {
            new OCGenerateConstructorHandler(){

                @Override
                @NotNull
                protected OCGenerateConstructorContext evaluateActionContext(OCStructSymbol parent, @NotNull PsiElement context22) {
                    return new OCGenerateConstructorContext(parent, context22){

                        @Override
                        @NotNull
                        public Collection<OCDeclaratorSymbol> getMemberCandidates() {
                            return Collections.singletonList(field);
                        }
                    };
                }

                @Override
                @NotNull
                protected List<? extends OCStructSymbol> getParents(@NotNull PsiElement at) {
                    return Collections.singletonList(context2.getParent());
                }

                @Override
                protected boolean enableChooseDialog(Collection<OCDeclaratorSymbol> candidates) {
                    return false;
                }
            }.invoke(project2, null, file2);
            return;
        }
        assert (chosenCandidates.size() == 1);
        OCFunctionSymbol constructorSymbol = (OCFunctionSymbol)chosenCandidates.get(0).getDefinitionSymbol(project2);
        OCFunctionDefinition oCFunctionDefinition = constructor = constructorSymbol != null ? (OCFunctionDefinition)constructorSymbol.locateFunctionDefinition(project2) : null;
        if (constructor == null) {
            return;
        }
        OCChangeSignatureHandler handler = OCChangeSignatureActionHandler.getHandler((OCCallable)constructor, constructor);
        String baseParamName = OCNameSuggester.suggestUniqueName(OCSymbolKind.PARAMETER, field.getName(), null, ContainerUtil.map(constructorSymbol.getParameterSymbols(), symbol -> symbol.getName()), project2);
        OCParameterInfo parameterInfo = handler.addParameter("", baseParamName, field.getType(), -1, false);
        handler.getGeneratedInfo().runOnSuccess(() -> OCAddFieldInitializerFix.addFieldInitializer(constructor, field, parameterInfo.getName()));
        handler.setTitle(this.getActionTitle());
        handler.invoke();
    }
}

