/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.daemon.OCSuppressionGroup;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCSuppressClangDiagnosticIntentionAction;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNotLocalizedStringInspection
extends OCInspections.GeneralObjC {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return OCInspectionsBundle.message("inspection.non.localized.string", new Object[0]);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (!isOnTheFly) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new OCVisitor(){

            @Override
            public void visitLiteralExpression(OCLiteralExpression expression) {
                String literalText;
                OCMacroCall macroCall;
                if (!(!expression.getUnescapedLiteralText().equals("NLS") || expression.getReferences().length != 0 || OCElementUtil.isPartOfMacroSubstitution(expression) || !expression.getResolvedType().isPointerToStringCompatible() || (macroCall = (OCMacroCall)PsiTreeUtil.getParentOfType((PsiElement)expression, OCMacroCall.class)) != null && macroCall.getMacroReferenceElement() != null && macroCall.getMacroReferenceElement().getName().startsWith("NSLocalizedString") || (literalText = expression.getUnescapedLiteralText()).isEmpty())) {
                    OCNotLocalizedStringInspection.this.registerProblem(holder, null, null, true, expression, "Non-localized string: " + expression.getRawLiteralText(), "CIDR", ProblemHighlightType.INFORMATION, new IntentionAction[0]);
                }
            }
        };
    }

    public boolean isSuppressedFor(@NotNull PsiElement element) {
        return false;
    }

    public SuppressQuickFix @NotNull [] getBatchSuppressActions(@Nullable PsiElement element) {
        String shortName = OCInspectionUtil.getInspectionShortName(((Object)((Object)this)).getClass());
        if (shortName == null) {
            return SuppressQuickFix.EMPTY_ARRAY;
        }
        OCSuppressionGroup suppressionGroup = new OCSuppressionGroup("ide", shortName);
        return new SuppressQuickFix[]{new OCSuppressClangDiagnosticIntentionAction.SuppressFixForStatement(suppressionGroup), new OCSuppressClangDiagnosticIntentionAction.SuppressFixForCallable(suppressionGroup), new OCSuppressClangDiagnosticIntentionAction.SuppressFixForFile(suppressionGroup)};
    }
}

