/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInspection.InspectionToolProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.util.ArrayUtil;
import com.intellij.util.NotNullProducer;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.Stack;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.inspections.NotImplementedFunctions;
import com.jetbrains.cidr.lang.inspections.OCClangBasedInspections;
import com.jetbrains.cidr.lang.inspections.OCDFAInspection;
import com.jetbrains.cidr.lang.inspections.OCInconsistentNamingInspection;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.inspections.OCLegacyObjCLiteralInspection;
import com.jetbrains.cidr.lang.inspections.OCNotLocalizedStringInspection;
import com.jetbrains.cidr.lang.inspections.OCNotReleasedIvarInspection;
import com.jetbrains.cidr.lang.inspections.OCUnusedClassInspection;
import com.jetbrains.cidr.lang.inspections.OCUnusedConceptInspection;
import com.jetbrains.cidr.lang.inspections.OCUnusedGlobalDeclarationInspection;
import com.jetbrains.cidr.lang.inspections.OCUnusedIncludeDirectiveInspection;
import com.jetbrains.cidr.lang.inspections.OCUnusedInstanceVariableInspection;
import com.jetbrains.cidr.lang.inspections.OCUnusedMacroInspection;
import com.jetbrains.cidr.lang.inspections.OCUnusedMethodInspection;
import com.jetbrains.cidr.lang.inspections.OCUnusedPropertyInspection;
import com.jetbrains.cidr.lang.inspections.OCUnusedStructInspection;
import com.jetbrains.cidr.lang.inspections.OCUnusedTemplateParameterInspection;
import com.jetbrains.cidr.lang.inspections.OCUnusedTypeAliasInspection;
import com.jetbrains.cidr.lang.legacy.inspections.OCSimplifyInspectionLegacy;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCInspectionToolProvider
implements InspectionToolProvider {
    private static final ExtensionPointName<NotNullProducer<List<Class<?>>>> STANDALONE_INSPECTIONS_PROVIDER = ExtensionPointName.create((String)"cidr.lang.standaloneInspectionToolProvider");
    private List<Class<?>> myAllInspectionClasses = new ArrayList();
    private Map<String, Class<?>> myNameToInspectionMap = new HashMap();
    private Map<Class<?>, String> myFakeInspectionsToNameMap = new HashMap();
    private Map<String, Class<?>> myNameToFakeInspectionsMap = new HashMap();
    private Stack<Class<?>> myFakeInspectionsPool = new Stack();
    private static OCInspectionToolProvider instance;

    private OCInspectionToolProvider() {
        for (Class<?> clazz : OCInspections.class.getDeclaredClasses()) {
            this.addInspectionClass(clazz);
        }
        if (PlatformUtils.isAppCode()) {
            for (Class<?> clazz : OCClangBasedInspections.class.getDeclaredClasses()) {
                this.addInspectionClass(clazz);
            }
        }
        this.myAllInspectionClasses.addAll(Arrays.asList(this.getStandaloneInspectionClasses()));
    }

    private void addInspectionClass(Class<?> clazz) {
        if (Modifier.isPublic(clazz.getModifiers()) && !Modifier.isAbstract(clazz.getModifiers())) {
            this.myAllInspectionClasses.add(clazz);
            try {
                if (this.isClangAnalyzerInspection(clazz)) {
                    this.myFakeInspectionsPool.add(clazz);
                } else {
                    this.myNameToInspectionMap.put(((OCInspection)((Object)clazz.newInstance())).getDisplayName(), clazz);
                }
            }
            catch (InstantiationException e) {
                OCLog.LOG.error((Throwable)e);
            }
            catch (IllegalAccessException e) {
                OCLog.LOG.error((Throwable)e);
            }
        }
    }

    public static OCInspectionToolProvider getInstance() {
        if (instance == null) {
            instance = new OCInspectionToolProvider();
        }
        return instance;
    }

    public Class @NotNull [] getInspectionClasses() {
        return this.myAllInspectionClasses.toArray(ArrayUtil.EMPTY_CLASS_ARRAY);
    }

    public Class<?>[] getStandaloneInspectionClasses() {
        ArrayList<Class<OCSimplifyInspectionLegacy>> result2 = new ArrayList<Class<OCSimplifyInspectionLegacy>>();
        result2.addAll(Arrays.asList(OCUnusedGlobalDeclarationInspection.class, OCUnusedStructInspection.class, OCUnusedConceptInspection.class, OCUnusedTypeAliasInspection.class, OCUnusedTemplateParameterInspection.class, OCUnusedMacroInspection.class, OCUnusedIncludeDirectiveInspection.class, OCDFAInspection.class, NotImplementedFunctions.class, OCInconsistentNamingInspection.class));
        result2.addAll(Arrays.asList(OCUnusedMethodInspection.class, OCUnusedClassInspection.class, OCUnusedInstanceVariableInspection.class, OCUnusedPropertyInspection.class, OCNotReleasedIvarInspection.class, OCNotLocalizedStringInspection.class, OCLegacyObjCLiteralInspection.class));
        if (PlatformUtils.isAppCode() || ApplicationManager.getApplication().isUnitTestMode()) {
            result2.add(OCSimplifyInspectionLegacy.class);
        }
        for (NotNullProducer each : STANDALONE_INSPECTIONS_PROVIDER.getExtensionList()) {
            result2.addAll((Collection)each.produce());
        }
        return result2.toArray(ArrayUtil.EMPTY_CLASS_ARRAY);
    }

    public boolean isClangCompilerInspection(Class inspectionClass) {
        return OCClangBasedInspections.ClangCompilerIssues.class.equals(inspectionClass.getSuperclass());
    }

    public boolean isClangAnalyzerInspection(Class inspectionClass) {
        return OCClangBasedInspections.ClangAnalyzerIssue.class.equals(inspectionClass.getSuperclass());
    }

    @Nullable
    public Class getInspectionByName(String name) {
        return this.myNameToInspectionMap.get(name);
    }

    @Nullable
    public synchronized Class getFakeInspection(String messageGroup) {
        Class clazz = this.myNameToFakeInspectionsMap.get(messageGroup);
        if (clazz != null) {
            return clazz;
        }
        clazz = (Class)this.myFakeInspectionsPool.pop();
        if (clazz != null) {
            this.myFakeInspectionsToNameMap.put(clazz, messageGroup);
            this.myNameToFakeInspectionsMap.put(messageGroup, clazz);
            return clazz;
        }
        OCLog.LOG.error("Too few fake inspections");
        return null;
    }

    @Nullable
    public synchronized String getFakeInspectionName(Class inspectionClass) {
        return this.myFakeInspectionsToNameMap.get(inspectionClass);
    }
}

