/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.formatting;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.ExternalFormatProcessor;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessor;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.formatting.OCPostFormatVisitor;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import org.jetbrains.annotations.NotNull;

final class OCPostFormatProcessor
implements PostFormatProcessor {
    OCPostFormatProcessor() {
    }

    @NotNull
    public PsiElement processElement(@NotNull PsiElement source, @NotNull CodeStyleSettings settings) {
        PsiElement ocSource;
        PsiFile file2 = source.getContainingFile();
        OCFile ocFile = OCLanguageUtils.asOCFile(file2);
        if (ocFile == null) {
            return source;
        }
        if (ExternalFormatProcessor.useExternalFormatter((PsiFile)file2)) {
            return source;
        }
        if (source instanceof OCElement) {
            ocSource = source;
        } else if (source instanceof PsiFile) {
            ocSource = ocFile;
        } else {
            PsiElement ocElement = ocFile.findElementAt(source.getTextOffset());
            OCLog.LOG.assertTrue(ocElement != null && ocElement.getTextRange().equals((Object)source.getTextRange()));
            ocSource = ocElement;
        }
        return new OCPostFormatVisitor(settings).process(ocSource);
    }

    @NotNull
    public TextRange processText(@NotNull PsiFile source, @NotNull TextRange rangeToReformat, @NotNull CodeStyleSettings settings) {
        OCFile ocFile = OCLanguageUtils.asOCFile(source);
        if (ocFile == null) {
            return rangeToReformat;
        }
        if (ExternalFormatProcessor.useExternalFormatter((PsiFile)source)) {
            TextRange range = ExternalFormatProcessor.formatRangeInFile((PsiFile)source, (TextRange)rangeToReformat, (boolean)false, (boolean)false);
            return range != null ? range : rangeToReformat;
        }
        return new OCPostFormatVisitor(settings).process(ocFile, rangeToReformat);
    }
}

