/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.formatting;

import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.formatting.OCIndentChanger;
import com.jetbrains.cidr.lang.formatting.OCSimpleBlock;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCPunctuatorElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFormatterUtil {
    public static final TokenSet FORMAT_DIRECTIVES = TokenSet.orSet((TokenSet[])new TokenSet[]{OCTokenTypes.DIRECTIVES, OCElementTypes.DIRECTIVES, TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.HASH})});
    public static final TokenSet FORMAT_CONTENTS = TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.DIRECTIVE_CONTENT, OCTokenTypes.PRAGMA_DIRECTIVE_CONTENT, OCTokenTypes.INCLUDE_DIRECTIVE_CONTENT});
    public static final TokenSet FORMAT_DIRECTIVES_AND_NON_COMPILED = TokenSet.orSet((TokenSet[])new TokenSet[]{OCTokenTypes.DIRECTIVES, OCElementTypes.DIRECTIVES, TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.HASH, OCTokenTypes.CONDITIONALLY_NON_COMPILED_COMMENT})});
    public static final TokenSet FORMAT_PROBLEM_LEAFS_IN_NONCOMPILED = TokenSet.orSet((TokenSet[])new TokenSet[]{OCTokenTypes.RAW_STRING_LITERALS, TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.BLOCK_COMMENT})});
    public static final TokenSet FORMAT_DIRECTIVES_INCREASE_INDENT = TokenSet.orSet((TokenSet[])new TokenSet[]{OCTokenTypes.IF_DIRECTIVES, TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.ELSE_DIRECTIVE, OCTokenTypes.ELIF_DIRECTIVE})});
    private static final TokenSet CLASS_CHILDREN = TokenSet.create((IElementType[])new IElementType[]{OCElementTypes.FUNCTION_DEFINITION, OCElementTypes.FUNCTION_DECLARATION});
    private static final TokenSet CLASS_DECL_HEADER_PARTS = TokenSet.create((IElementType[])new IElementType[]{OCElementTypes.INSTANCE_VARIABLES_LIST, OCElementTypes.SUPER_CLASS_REF, OCElementTypes.PROTOCOL_LIST, OCElementTypes.GENERIC_PARAMETERS_LIST, OCElementTypes.CATEGORY_NAME});
    private static final TokenSet CLASS_DECL_KEYWORDS = TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.PROTOCOL_KEYWORD, OCTokenTypes.INTERFACE_KEYWORD, OCTokenTypes.IMPLEMENTATION_KEYWORD});
    public static final TokenSet SPACES_COMMENTS = TokenSet.orSet((TokenSet[])new TokenSet[]{OCTokenTypes.WHITESPACES, OCTokenTypes.COMMENTS});
    public static final TokenSet MACRO_SPACES_COMMENTS = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{OCElementTypes.MACRO_CALL}), SPACES_COMMENTS});

    @Contract(value="null, _->false")
    public static boolean isOrFollows(ASTNode node2, IElementType expectedType) {
        while (node2 != null) {
            if (node2.getElementType() == expectedType) {
                return true;
            }
            node2 = node2.getTreePrev();
        }
        return false;
    }

    public static boolean isNotEmptyAndOneOf(ASTNode node2, PsiElement ... candidates) {
        return OCElementUtil.getElementType(node2) != OCElementTypes.EMPTY_STATEMENT && OCElementUtil.isOneOf(node2, candidates);
    }

    @Contract(value="null->false")
    public static boolean isAnyLBrace(IElementType tokenType) {
        return tokenType == OCTokenTypes.LBRACE || tokenType == OCTokenTypes.LBRACKET || tokenType == OCTokenTypes.LPAR;
    }

    @Contract(value="null->false")
    public static boolean isAnyRBrace(IElementType tokenType) {
        return tokenType == OCTokenTypes.RBRACE || tokenType == OCTokenTypes.RBRACKET || tokenType == OCTokenTypes.RPAR;
    }

    @Contract(value="null->false")
    public static boolean isBlock(IElementType type) {
        return OCElementTypes.BLOCK_STATEMENTS.contains(type);
    }

    @Contract(value="null->false")
    public static boolean isInsideAnyBraces(@Nullable ASTNode node2) {
        if (node2 == null) {
            return false;
        }
        int counter = 0;
        while ((node2 = node2.getTreePrev()) != null) {
            if (OCFormatterUtil.isAnyLBrace(node2.getElementType())) {
                ++counter;
                continue;
            }
            if (!OCFormatterUtil.isAnyRBrace(node2.getElementType())) continue;
            --counter;
        }
        return counter > 0;
    }

    @Contract(value="null->false")
    public static boolean isKeyword(@Nullable ASTNode node2) {
        if (node2 == null) {
            return false;
        }
        IElementType elementType = OCElementUtil.getElementType(node2);
        return OCTokenTypes.KEYWORDS.contains(elementType);
    }

    @Contract(value="null->false")
    public static boolean isClassHeader(@Nullable ASTNode node2) {
        while (node2 != null && OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(node2.getElementType())) {
            node2 = node2.getTreeNext();
        }
        if (node2 == null) {
            return false;
        }
        IElementType et = node2.getElementType();
        if (et == OCElementTypes.OBJC_KEYWORD) {
            ASTNode lc = node2.getLastChildNode();
            return CLASS_DECL_KEYWORDS.contains(OCElementUtil.getElementType(lc)) && OCElementTypes.CLASSES.contains(OCElementUtil.getElementType(node2.getTreeParent()));
        }
        if (et == OCTokenTypes.IDENTIFIER) {
            return OCElementTypes.CLASSES.contains(OCElementUtil.getElementType(node2.getTreeParent()));
        }
        return CLASS_DECL_HEADER_PARTS.contains(et);
    }

    public static boolean isClassMember(ASTNode node2) {
        return !OCFormatterUtil.isClassHeader(node2) && OCTokenTypes.END_KEYWORD != OCElementUtil.getObjCKeywordElementType(node2);
    }

    public static boolean isMessageArgumentValue(@NotNull ASTNode node2) {
        return OCElementUtil.getElementType(node2.getTreeParent()) == OCElementTypes.MESSAGE_ARGUMENT && node2.getElementType() != OCElementTypes.ARGUMENT_SELECTOR;
    }

    @Contract(value="null -> false")
    public static boolean isVarArgArgument(@Nullable ASTNode node2) {
        if (node2 == null) {
            return false;
        }
        if (node2.getElementType() != OCElementTypes.MESSAGE_ARGUMENT) {
            return false;
        }
        ASTNode selector = node2.findChildByType((IElementType)OCElementTypes.ARGUMENT_SELECTOR);
        return selector == null || StringUtil.isEmptyOrSpaces((String)selector.getText());
    }

    @Contract(value="null -> false")
    public static boolean isFollowedByVarArg(@Nullable ASTNode node2) {
        if (node2 == null) {
            return false;
        }
        if (node2.getElementType() != OCElementTypes.MESSAGE_ARGUMENT) {
            return false;
        }
        while ((node2 = FormatterUtil.getNextNonWhitespaceSibling((ASTNode)node2)) != null) {
            if (!OCFormatterUtil.isVarArgArgument(node2)) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static boolean isProtocolListOrReference(IElementType type) {
        return type == OCElementTypes.PROTOCOL_LIST || type == OCElementTypes.REFERENCE_ELEMENT;
    }

    public static boolean isDeclarationOrDefinition(IElementType type) {
        return type == OCElementTypes.DECLARATION_STATEMENT || type == OCElementTypes.DECLARATION || type == OCElementTypes.FUNCTION_DECLARATION || type == OCElementTypes.METHOD || type == OCElementTypes.PROPERTY || type == OCElementTypes.FUNCTION_DEFINITION || type == OCElementTypes.CLASS_PREDEF_LIST || OCElementTypes.CLASSES.contains(type);
    }

    public static boolean isVariablesListOrStructure(IElementType type) {
        return type == OCElementTypes.INSTANCE_VARIABLES_LIST || OCFormatterUtil.isStructure(type);
    }

    public static boolean isCollectionOrStructureInitializer(@Nullable IElementType type) {
        return type == OCElementTypes.COMPOUND_INITIALIZER || OCElementTypes.NS_COLLECTION_LITERALS.contains(type);
    }

    public static boolean isStructure(IElementType type) {
        return OCElementTypes.STRUCTURE_TYPES.contains(type);
    }

    @Contract(pure=true)
    public static boolean isGlobalDeclarationScope(IElementType type) {
        return OCFormatterUtil.isNamespace(type) || type == OCTokenTypes.OC_FILE;
    }

    @Contract(pure=true)
    public static boolean isNamespace(IElementType type) {
        return type == OCElementTypes.CPP_NAMESPACE;
    }

    public static boolean isStructureOrNamespace(IElementType type) {
        return OCFormatterUtil.isStructure(type) || OCFormatterUtil.isNamespace(type);
    }

    @Contract(value="null->null")
    public static ASTNode getNextNonWhitespaceOrCommentSibling(@Nullable ASTNode node2) {
        ASTNode prevNode;
        ASTNode aSTNode = prevNode = node2 == null ? null : node2.getTreeNext();
        while (prevNode != null && OCFormatterUtil.isInessential(prevNode)) {
            prevNode = prevNode.getTreeNext();
        }
        return prevNode;
    }

    @Contract(value="null->null")
    public static ASTNode getPreviousNonWhitespaceOrCommentSibling(@Nullable ASTNode node2) {
        ASTNode prevNode;
        ASTNode aSTNode = prevNode = node2 == null ? null : node2.getTreePrev();
        while (prevNode != null && OCFormatterUtil.isInessential(prevNode)) {
            prevNode = prevNode.getTreePrev();
        }
        return prevNode;
    }

    @Contract(value="null->true")
    public static boolean isInessential(@Nullable ASTNode node2) {
        return node2 == null || FormatterUtil.isWhitespaceOrEmpty((ASTNode)node2) || OCTokenTypes.COMMENTS.contains(node2.getElementType());
    }

    public static boolean isOCVisibilityKeywordOrCPPVisibilityColon(@Nullable ASTNode node2) {
        return OCElementUtil.isOCVisibilityKeyword(node2) || OCElementUtil.getElementType(node2) == OCTokenTypes.COLON && OCElementUtil.isCPPVisibilityKeyword(OCFormatterUtil.getPreviousNonWhitespaceOrCommentSibling(node2));
    }

    @Contract(pure=true)
    public static boolean isForOrForEachStatement(IElementType type) {
        return type == OCElementTypes.FOR_STATEMENT || type == OCElementTypes.FOREACH_STATEMENT;
    }

    @Contract(pure=true)
    public static boolean isLoopStatement(IElementType type) {
        return OCFormatterUtil.isForOrForEachStatement(type) || type == OCElementTypes.WHILE_STATEMENT || type == OCElementTypes.DO_WHILE_STATEMENT;
    }

    @Contract(pure=true)
    public static boolean isControlStatement(IElementType type) {
        return type == OCElementTypes.RETURN_STATEMENT || type == OCElementTypes.IF_STATEMENT || OCFormatterUtil.isLoopStatement(type) || type == OCElementTypes.SWITCH_STATEMENT || type == OCElementTypes.CASE_STATEMENT || type == OCElementTypes.TRY_STATEMENT || type == OCElementTypes.SYNCHRONIZED_STATEMENT || type == OCElementTypes.AUTO_RELEASE_POOL_STATEMENT;
    }

    public static boolean isControlStatementOrSection(IElementType type) {
        return OCFormatterUtil.isControlStatement(type) || OCFormatterUtil.isControlSection(type);
    }

    @Contract(pure=true)
    public static boolean isControlSection(IElementType type) {
        return type == OCElementTypes.CATCH_SECTION || type == OCElementTypes.FINALLY_SECTION;
    }

    public static boolean isInsideDirective(@Nullable ASTNode node2) {
        for (ASTNode each = node2; each != null; each = each.getTreeParent()) {
            if (!OCFormatterUtil.isDirective(each)) continue;
            return true;
        }
        IElementType type = OCElementUtil.getElementType(node2);
        return OCTokenTypes.DIRECTIVES.contains(type) || FORMAT_CONTENTS.contains(type);
    }

    @Contract(value="null -> false")
    public static boolean isDirective(@Nullable ASTNode child) {
        return child != null && FORMAT_DIRECTIVES.contains(child.getElementType());
    }

    @Nullable
    public static <T> T processBraced(@Nullable ASTNode parent, @Nullable IElementType childType, boolean strictStart, @NotNull LeftBracesProcessor<T> processor2) {
        IElementType parentType = OCElementUtil.getElementType(parent);
        if (childType == OCElementTypes.INSTANCE_VARIABLES_LIST) {
            return processor2.processInterfaceOrStructure();
        }
        if (strictStart && OCFormatterUtil.isVariablesListOrStructure(parentType) && childType == OCTokenTypes.LBRACE || !strictStart && OCFormatterUtil.isVariablesListOrStructure(childType)) {
            return processor2.processInterfaceOrStructure();
        }
        if (strictStart && OCFormatterUtil.isNamespace(parentType) && childType == OCTokenTypes.LBRACE || !strictStart && OCFormatterUtil.isNamespace(childType)) {
            return processor2.processNamespace();
        }
        if (childType == OCElementTypes.CPP_REQUIRES_CLAUSE) {
            return processor2.processRequiresClause();
        }
        if (OCFormatterUtil.isBlock(childType)) {
            if (parentType == OCElementTypes.METHOD) {
                return processor2.processMethod();
            }
            if (parentType == OCElementTypes.FUNCTION_DEFINITION) {
                return processor2.processFunction();
            }
            if (parentType == OCElementTypes.BLOCK_EXPRESSION || parentType == OCElementTypes.CPP_LAMBDA_EXPRESSION) {
                return processor2.processBlock();
            }
            if (parentType == OCElementTypes.IF_STATEMENT) {
                return processor2.processIfStatement();
            }
            if (OCFormatterUtil.isForOrForEachStatement(parentType)) {
                return processor2.processForOrForEachStatement();
            }
            if (parentType == OCElementTypes.WHILE_STATEMENT) {
                return processor2.processWhileStatement();
            }
            if (parentType == OCElementTypes.DO_WHILE_STATEMENT) {
                return processor2.processDoWhileStatement();
            }
            if (parentType == OCElementTypes.SWITCH_STATEMENT) {
                return processor2.processSwitchStatement();
            }
            if (parentType == OCElementTypes.CASE_STATEMENT) {
                return processor2.processSwitchStatement();
            }
            if (parentType == OCElementTypes.TRY_STATEMENT) {
                return processor2.processTryStatement();
            }
            if (parentType == OCElementTypes.CATCH_SECTION) {
                return processor2.processCatchStatement();
            }
            if (parentType == OCElementTypes.FINALLY_SECTION) {
                return processor2.processFinallyStatement();
            }
            if (parentType == OCElementTypes.SYNCHRONIZED_STATEMENT) {
                return processor2.processSynchronizedStatement();
            }
            if (parentType == OCElementTypes.AUTO_RELEASE_POOL_STATEMENT) {
                return processor2.processAutoreleasePoolStatement();
            }
        }
        return null;
    }

    static boolean isObjCKeywordWithDog(IElementType elementType, ASTNode node2, OCElementType requiredType) {
        return elementType == OCElementTypes.OBJC_KEYWORD && OCElementUtil.getObjCKeywordElementType(node2) == requiredType;
    }

    public static boolean isCPPClassDeclaration(@Nullable ASTNode node2) {
        if (OCElementUtil.getElementType(node2) != OCElementTypes.DECLARATION) {
            return false;
        }
        ASTNode typeElement = node2.findChildByType((IElementType)OCElementTypes.TYPE_ELEMENT);
        return typeElement != null && OCFormatterUtil.isCPPClass(typeElement.getFirstChildNode());
    }

    public static boolean isCPPClass(@Nullable ASTNode node2) {
        return OCFormatterUtil.isClassStructUnion(node2) && (node2.getFirstChildNode().getElementType() == OCTokenTypes.CLASS_KEYWORD || node2.findChildByType(CLASS_CHILDREN) != null);
    }

    public static boolean isClassStructUnion(@Nullable ASTNode node2) {
        return OCElementUtil.getElementType(node2) == OCElementTypes.STRUCT || OCElementUtil.getElementType(node2) == OCElementTypes.UNION;
    }

    @Nullable
    public static ASTNode nextLeafInOwner(@NotNull ASTNode current, @NotNull ASTNode owner) {
        for (ASTNode nextSibling = current.getTreeNext(); nextSibling != null; nextSibling = nextSibling.getTreeNext()) {
            ASTNode first = OCFormatterUtil.firstLeaf(nextSibling);
            if (first == null) continue;
            return first;
        }
        ASTNode parent = current.getTreeParent();
        if (parent == owner || parent instanceof OCFile || parent == null) {
            return null;
        }
        return OCFormatterUtil.nextLeafInOwner(parent, owner);
    }

    @Nullable
    public static ASTNode prevLeafInOwner(@NotNull ASTNode current, @NotNull ASTNode owner) {
        for (ASTNode prevSibling = current.getTreePrev(); prevSibling != null; prevSibling = prevSibling.getTreePrev()) {
            ASTNode last = OCFormatterUtil.lastLeaf(prevSibling);
            if (last == null) continue;
            return last;
        }
        ASTNode parent = current.getTreeParent();
        if (parent == owner || parent instanceof OCFile || parent == null) {
            return null;
        }
        return OCFormatterUtil.prevLeafInOwner(parent, owner);
    }

    @Nullable
    public static ASTNode lastLeaf(@NotNull ASTNode element) {
        return TreeUtil.findLastLeaf((ASTNode)element);
    }

    @Nullable
    public static ASTNode firstLeaf(@NotNull ASTNode element) {
        return TreeUtil.findFirstLeaf((ASTNode)element);
    }

    @Contract(value="null, _ -> false")
    public static boolean isAncestorOrSelf(@Nullable ASTNode ancestor, @NotNull ASTNode element) {
        if (ancestor == null) {
            return false;
        }
        if (ancestor == element) {
            return true;
        }
        ASTNode parent = element.getTreeParent();
        while (parent != null) {
            if (parent == ancestor) {
                return true;
            }
            parent = parent.getTreeParent();
        }
        return false;
    }

    @NotNull
    static ASTNode getBestCommonOwner(@NotNull ASTNode defaultOwner, @NotNull ASTNode node1, @NotNull ASTNode node2) {
        PsiElement p1 = node1.getPsi();
        PsiElement p2 = node2.getPsi();
        if (p1 != null && p2 != null) {
            PsiElement owner = PsiTreeUtil.findCommonParent((PsiElement)p1, (PsiElement)p2);
            if (owner instanceof LeafElement) {
                owner = owner.getParent();
            }
            if (owner != null && owner.getNode() != null) {
                return owner.getNode();
            }
        }
        return defaultOwner;
    }

    public static boolean isInBlockEnclosed(@Nullable ASTNode child, @NotNull ASTNode parent) {
        boolean isInlineEnclosed = false;
        boolean afterLBrace = false;
        for (ASTNode node2 = parent.getFirstChildNode(); node2 != null; node2 = node2.getTreeNext()) {
            IElementType type = node2.getElementType();
            boolean whitespace = OCElementUtil.isWhitespace(node2.getPsi());
            if (child != null && child == node2 || child == null && !whitespace && type != OCTokenTypes.LBRACE && type != OCTokenTypes.RBRACE) {
                isInlineEnclosed = true;
                continue;
            }
            if (type == OCTokenTypes.LBRACE) {
                afterLBrace = true;
                continue;
            }
            if (!afterLBrace || (isInlineEnclosed || !node2.textContains('\n')) && (type == OCTokenTypes.RBRACE || whitespace)) continue;
            return false;
        }
        return isInlineEnclosed || child == null;
    }

    @Contract(value="null -> false")
    public static boolean isDirectlyInsideSwitch(@Nullable ASTNode node2) {
        if (node2 == null) {
            return false;
        }
        ASTNode parent = node2.getTreeParent();
        IElementType parentType = OCElementUtil.getElementType(parent);
        if (OCElementTypes.BLOCK_STATEMENTS.contains(parentType)) {
            parentType = OCElementUtil.getElementType(parent.getTreeParent());
        }
        return parentType == OCElementTypes.SWITCH_STATEMENT;
    }

    public static LABEL_TYPE getLabelType(@Nullable ASTNode node2) {
        LABEL_TYPE ret = LABEL_TYPE.OTHER;
        while (node2 != null) {
            IElementType nodeType = node2.getElementType();
            if (nodeType == OCElementTypes.LABELED_STATEMENT) {
                ret = LABEL_TYPE.LABEL_LIKE;
            } else {
                if (nodeType != OCElementTypes.CASE_STATEMENT) break;
                ret = LABEL_TYPE.CASE_LIKE;
            }
            if (OCFormatterUtil.isDirectlyInsideSwitch(node2)) {
                return LABEL_TYPE.CASE_LIKE;
            }
            node2 = node2.getTreeParent();
        }
        return ret;
    }

    private static ASTNode getPrev(@Nullable ASTNode node2) {
        IElementType prevType;
        ASTNode prevNode;
        ASTNode aSTNode = prevNode = node2 == null ? null : node2.getTreePrev();
        while (prevNode != null && MACRO_SPACES_COMMENTS.contains(prevType = prevNode.getElementType())) {
            prevNode = prevNode.getTreePrev();
        }
        return prevNode;
    }

    @Contract(value="null,_->false")
    public static boolean isPrecededBy(@Nullable ASTNode node2, @NotNull IElementType expectedType) {
        return OCElementUtil.getElementType(OCFormatterUtil.getPrev(node2)) == expectedType;
    }

    @Contract(value="null,_->false")
    public static boolean isPrecededBy(@Nullable ASTNode node2, @NotNull TokenSet expectedTypes) {
        return expectedTypes.contains(OCElementUtil.getElementType(OCFormatterUtil.getPrev(node2)));
    }

    public static boolean isFirstEssentialChild(@NotNull ASTNode child) {
        IElementType nextType;
        ASTNode nextNode;
        ASTNode parent = child.getTreeParent();
        if (parent == null) {
            return true;
        }
        for (nextNode = parent.getFirstChildNode(); nextNode != null && ((nextType = nextNode.getElementType()) instanceof OCPunctuatorElementType || MACRO_SPACES_COMMENTS.contains(nextType)); nextNode = nextNode.getTreeNext()) {
        }
        return nextNode == child;
    }

    public static void applyIndentCorrection(boolean useSmartIndent, List<? extends Block> collector, int wrapType, boolean keepLineBreak, Condition<? super ASTNode> isReindentedNode) {
        if (wrapType == 0 && !keepLineBreak) {
            return;
        }
        boolean needEnforceIndent = useSmartIndent;
        if (!needEnforceIndent) {
            int count = 0;
            for (Block block : collector) {
                PsiElement psi;
                ASTNode beforeFirstNode;
                ASTNode firstNode = OCSimpleBlock.extractFirstNode(block);
                if (!isReindentedNode.value((Object)firstNode) || ++count <= 1) continue;
                boolean bl = needEnforceIndent = wrapType == 2;
                if (!needEnforceIndent && ((beforeFirstNode = FormatterUtil.getPreviousLeaf((ASTNode)firstNode, (IElementType[])new IElementType[0])) == null || !(needEnforceIndent = (psi = beforeFirstNode.getPsi()) instanceof PsiWhiteSpace && psi.textContains('\n')))) continue;
                break;
            }
        }
        if (needEnforceIndent) {
            Indent indent = useSmartIndent ? Indent.getSmartIndent((Indent.Type)Indent.Type.CONTINUATION) : Indent.getIndent((Indent.Type)Indent.Type.CONTINUATION, (boolean)false, (boolean)true);
            for (Block block : collector) {
                if (!(block instanceof OCIndentChanger) || !isReindentedNode.value((Object)OCSimpleBlock.extractFirstNode(block))) continue;
                ((OCIndentChanger)block).putIndent(indent);
            }
        }
    }

    @Contract(value="null -> false")
    private static boolean isNestedNamespacePart(@Nullable ASTNode node2) {
        if (node2 != null && node2.getElementType() == OCElementTypes.CPP_NAMESPACE) {
            ASTNode first = node2.getFirstChildNode();
            return first != null && first.getElementType() == OCTokenTypes.COLON2X;
        }
        return false;
    }

    public static boolean isNestedInlineBlock(@NotNull OCCodeStyleSettings ocSettings, @Nullable ASTNode node2) {
        return ocSettings.KEEP_NESTED_NAMESPACES_IN_ONE_LINE && OCElementUtil.getElementType(node2) == OCElementTypes.CPP_NAMESPACE && OCElementUtil.getElementType(node2.getTreeParent()) == OCElementTypes.CPP_NAMESPACE && OCFormatterUtil.isInBlockEnclosed(node2, node2.getTreeParent()) || OCFormatterUtil.isNestedNamespacePart(node2);
    }

    @Contract(value="null -> false")
    public static boolean isSynthetic(@Nullable ASTNode node2) {
        if (node2 == null) {
            return false;
        }
        return OCFormatterUtil.hasSyntheticLeaf(node2, true) && OCFormatterUtil.hasSyntheticLeaf(node2, false);
    }

    public static boolean hasSyntheticLeaf(@Nullable ASTNode node2, boolean first) {
        LeafElement leaf = node2 instanceof LeafElement ? (LeafElement)node2 : (first ? TreeUtil.findFirstLeaf((ASTNode)node2) : TreeUtil.findLastLeaf((ASTNode)node2));
        return leaf instanceof PsiElement && OCElementUtil.isSynthetic((PsiElement)leaf);
    }

    public static boolean isNestedBlockOwner(@NotNull OCCodeStyleSettings ocSettings, @NotNull ASTNode owner) {
        ASTNode child = owner.findChildByType((IElementType)OCElementTypes.CPP_NAMESPACE);
        return ocSettings.KEEP_NESTED_NAMESPACES_IN_ONE_LINE && OCElementUtil.getElementType(owner) == OCElementTypes.CPP_NAMESPACE && OCFormatterUtil.isNestedInlineBlock(ocSettings, child) || OCFormatterUtil.isNestedNamespacePart(child);
    }

    @Contract(value="null -> false")
    public static boolean isNamespaceWithKeyword(@Nullable ASTNode node2) {
        return node2 != null && node2.getElementType() == OCElementTypes.CPP_NAMESPACE && !OCFormatterUtil.isNestedNamespacePart(node2);
    }

    public static abstract class LeftBracesProcessor<T> {
        public T processNamespace() {
            return this.processGeneral();
        }

        public T processInterfaceOrStructure() {
            return this.processGeneral();
        }

        public T processMethod() {
            return this.processGeneral();
        }

        public T processFunction() {
            return this.processGeneral();
        }

        public T processRequiresClause() {
            return this.processGeneral();
        }

        public T processBlock() {
            return this.processFunction();
        }

        public T processIfStatement() {
            return this.processGeneral();
        }

        public T processForOrForEachStatement() {
            return this.processGeneral();
        }

        public T processWhileStatement() {
            return this.processGeneral();
        }

        public T processDoWhileStatement() {
            return this.processGeneral();
        }

        public T processSwitchStatement() {
            return this.processGeneral();
        }

        public T processTryStatement() {
            return this.processGeneral();
        }

        public T processCatchStatement() {
            return this.processGeneral();
        }

        public T processFinallyStatement() {
            return this.processGeneral();
        }

        public T processSynchronizedStatement() {
            return this.processGeneral();
        }

        public T processAutoreleasePoolStatement() {
            return this.processGeneral();
        }

        public T processGeneral() {
            return null;
        }
    }

    static enum LABEL_TYPE {
        CASE_LIKE,
        LABEL_LIKE,
        OTHER;

    }
}

