/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import org.jetbrains.annotations.NotNull;

public class TemplateInsertHandler
implements InsertHandler<LookupElement> {
    private final String myInsertion;

    protected TemplateInsertHandler(String insertion) {
        this.myInsertion = insertion;
    }

    public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
        char currentChar;
        Document document2 = context2.getDocument();
        Editor editor = context2.getEditor();
        String insertion = TemplateInsertHandler.preprocessInsertion(context2, this.myInsertion);
        char c = currentChar = context2.getTailOffset() < document2.getTextLength() ? document2.getCharsSequence().charAt(context2.getTailOffset()) : (char)'\u0000';
        if (insertion.endsWith(" ") && context2.getCompletionChar() != ' ' && (currentChar == ')' || currentChar == ' ' || currentChar == '\t')) {
            insertion = insertion.trim();
        }
        int tailOffset = context2.getStartOffset() + insertion.length();
        String caretToken = "<caret>";
        int caretOffset = insertion.indexOf(caretToken);
        if (caretOffset != -1) {
            insertion = insertion.substring(0, caretOffset) + insertion.substring(caretOffset + caretToken.length());
            tailOffset = context2.getStartOffset() + caretOffset;
        } else if (!Character.isWhitespace(currentChar) && !Character.isUnicodeIdentifierPart(currentChar) && insertion.endsWith(Character.toString(currentChar))) {
            insertion = insertion.substring(0, insertion.length() - 1);
        }
        document2.replaceString(context2.getStartOffset(), context2.getTailOffset(), (CharSequence)insertion);
        context2.setTailOffset(tailOffset);
        CodeFoldingManager foldManager = CodeFoldingManager.getInstance((Project)context2.getProject());
        foldManager.updateFoldRegions(editor);
        String documentText = document2.getText();
        int firstParamStart = documentText.indexOf("<#", context2.getStartOffset());
        int firstParamEnd = documentText.indexOf("#>", firstParamStart);
        SelectionModel selectionModel = editor.getSelectionModel();
        if (firstParamStart >= 0 && firstParamEnd >= 0 && firstParamStart < context2.getTailOffset()) {
            selectionModel.setSelection(firstParamStart, firstParamEnd + 2);
        }
        this.reformatAfterInsertion(context2, insertion);
        if (firstParamStart >= 0 && firstParamEnd >= 0 && selectionModel.hasSelection()) {
            editor.getCaretModel().moveToOffset(selectionModel.getSelectionStart());
        } else if (context2.getOffsetMap().containsOffset(InsertionContext.TAIL_OFFSET)) {
            int toOffset = context2.getTailOffset();
            editor.getCaretModel().moveToOffset(toOffset);
            if (toOffset > 0 && editor.getDocument().getCharsSequence().charAt(toOffset - 1) == '\n') {
                CodeStyleManager.getInstance((Project)context2.getProject()).adjustLineIndent(editor.getDocument(), toOffset);
            }
        }
        if (context2.getCompletionChar() == ' ') {
            context2.setAddCompletionChar(false);
        }
    }

    protected void reformatAfterInsertion(@NotNull InsertionContext context2, @NotNull String insertion) {
        if (!insertion.endsWith(" ")) {
            OCChangeUtil.reformatTextIfNotInjected(context2.getFile(), context2.getStartOffset(), context2.getStartOffset() + insertion.length());
        }
    }

    private static String preprocessInsertion(InsertionContext context2, String insertion) {
        CodeStyleSettings settings = CodeStyle.getSettings((PsiFile)context2.getFile());
        CommonCodeStyleSettings common = settings.getCommonSettings(OCLanguageUtils.getConfigLanguage());
        OCCodeStyleSettings custom = (OCCodeStyleSettings)settings.getCustomSettings(OCCodeStyleSettings.class);
        insertion = TemplateInsertHandler.checkKeyword(insertion, OCTokenTypes.FOR_KEYWORD, common.SPACE_BEFORE_FOR_PARENTHESES);
        insertion = TemplateInsertHandler.checkKeyword(insertion, OCTokenTypes.IF_KEYWORD, common.SPACE_BEFORE_IF_PARENTHESES);
        insertion = TemplateInsertHandler.checkKeyword(insertion, OCTokenTypes.WHILE_KEYWORD, common.SPACE_BEFORE_WHILE_PARENTHESES);
        insertion = TemplateInsertHandler.checkKeyword(insertion, OCTokenTypes.SWITCH_KEYWORD, common.SPACE_BEFORE_SWITCH_PARENTHESES);
        insertion = TemplateInsertHandler.checkKeyword(insertion, OCTokenTypes.CATCH_KEYWORD, common.SPACE_BEFORE_CATCH_PARENTHESES);
        insertion = TemplateInsertHandler.checkKeyword(insertion, OCTokenTypes.FINALLY_KEYWORD, common.SPACE_BEFORE_FINALLY_KEYWORD);
        insertion = TemplateInsertHandler.checkKeyword(insertion, OCTokenTypes.SYNCHRONIZED_KEYWORD, common.SPACE_BEFORE_SYNCHRONIZED_PARENTHESES);
        insertion = TemplateInsertHandler.checkKeyword(insertion, OCTokenTypes.PROPERTY_KEYWORD, custom.SPACE_BEFORE_PROPERTY_ATTRIBUTES_PARENTHESES);
        return insertion;
    }

    private static String checkKeyword(String insertion, OCElementType keyword, boolean space) {
        if (insertion.equals(keyword.getName())) {
            return space ? keyword.getName() + " " : keyword.getName();
        }
        return insertion;
    }

    public static LookupElementBuilder lookup(String template) {
        String data = template.replaceAll("\\n|(<caret>)|(<#(.*)#>)", "").trim();
        return TemplateInsertHandler.lookup(data, template);
    }

    public static LookupElementBuilder lookup(String userString, String template) {
        return LookupElementBuilder.create((Object)new TemplateObject(userString), (String)userString).withInsertHandler((InsertHandler)new TemplateInsertHandler(template));
    }

    public static class TemplateObject {
        @NotNull
        private final String myData;

        public TemplateObject(@NotNull String data) {
            this.myData = data;
        }

        public String toString() {
            return this.myData;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TemplateObject object = (TemplateObject)o;
            return this.myData.equals(object.myData);
        }

        public int hashCode() {
            return this.myData.hashCode();
        }
    }
}

